/* sane - Scanner Access Now Easy.
   Copyright (C) 1997 Jeffrey S. Freedman
   This file is part of the SANE package.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA.

   As a special exception, the authors of SANE give permission for
   additional uses of the libraries contained in this release of SANE.

   The exception is that, if you link a SANE library with other files
   to produce an executable, this does not by itself cause the
   resulting executable to be covered by the GNU General Public
   License.  Your use of that executable is in no way restricted on
   account of linking the SANE library code into it.

   This exception does not, however, invalidate any other reasons why
   the executable file might be covered by the GNU General Public
   License.

   If you submit changes to SANE to the maintainers to be included in
   a subsequent release, you agree by submitting the changes that
   those changes may be distributed with this exception intact.

   If you write modifications of your own for SANE, it is your choice
   whether to permit this exception to apply to your modifications.
   If you do not wish that, delete this exception notice.

   This file provides generic configuration support.  */

#include <sys/param.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sane/sanei.h>

/*
 *	Open a given path and file.
 */

static FILE *sanei_open_path_to
	(
	char *dir,			/* Directory. */
	char *nm			/* Filename. */
	)
	{
	char path[MAXPATHLEN];
	strcpy(path, dir);
	strcat(path, "/");
	strcat(path, nm);
	return (fopen(path, "r"));
	}

/*
 *	Open a SANE configuration (.conf) file by looking in the following
 *	directories:
 *		1st:	SANE_CONFIG_DIR environment variable.
 *		2nd:	PATH_SANE_CONFIG_DIR set during configuration.
 *		3rd:	Current directory.
 *
 *	Output:	File pointer, or NULL if not found.
 */

FILE *sanei_open_config
	(
	char *nm			/* Base name; i.e., "mustek.conf". */
	)
	{
	FILE *fp;
	char *dir;
					/* Start with env. var.	*/
	if ((dir = getenv("SANE_CONFIG_DIR")) != 0 &&
	    (fp = sanei_open_path_to(dir, nm)) != 0)
		return (fp);
	if ((fp = sanei_open_path_to(STRINGIFY(PATH_SANE_CONFIG_DIR), nm)) 
						!= 0)
		return (fp);
	return (fopen(nm, "r"));
	}

