.TH saned 1 "21 April 1997"
.IX saned
.SH NAME
saned - SANE network daemon
.SH SYNOPSIS
.B saned
.RB [ -d
.RI [ n ]]
.SH DESCRIPTION
.B saned
is the SANE (Scanner Access Now Easy) daemon that allows remote clients
to access image acquisition devices available on the local host.
.SH OPTIONS
.PP
The
.B -d
flag request that
.B saned
run in debug mode (as opposed to
.BR inetd (8)
mode).  In this mode,
.B saned
explicitly waits for a connection request.  When compiled with
debugging enabled, this flag may be followed by a number to request
debug info.  The larger the number, the more verbose the debug output.
E.g., -d128 will request printing of all debug info.
.SH CONFIGURATION
First and foremost: please do
.I not
install
.B saned
as setuid root without due consideration.  Especially when using
dynamic linking, there is a potential for introducing security holes
when running this program as root.
.PP
The
.B saned
configuration file resides in
.IR @CONFIGDIR@/saned.conf .
Its contents is a list of host names that are permitted to use local
SANE devices.  Empty lines and lines starting with a hash mark (#) are
ignored.  A sample configuration file is shown below:
.PP
.RS
scan-client.somedomain.firm
.br
# this is a comment
.br
localhost
.RE
.PP
The case of the host names is significant.  They must be spelled
exactly the way they are returned by the
.BR nslookup (8)
command.

For
.B saned
to work properly, it is also necessary to add a configuration line to
.IR /etc/inetd.conf .
The configuration line normally looks like this:
.PP
.RS
sane stream tcp nowait saned.saned @SBINDIR@/saned saned
.RE
.PP
However, if your system uses
.BR tcpd (8)
for additional security screening, you may want to use a line of the
following form instead:
.PP
.RS
sane stream tcp nowait saned.saned /usr/sbin/tcpd saned
.RE
.PP
(Note that both examples assume that there is a
.B saned
group and a
.B saned
user.)
.PP
Finally, it is also necessary to add a line of the following form to
.IR /etc/services :
.PP
.RS
sane 6566/tcp # SANE network scanner daemon
.RE
.PP
Note that port number 6566 has not been officially assigned to the
SANE network protocol and may thus change in the future.
.PP
.SH FILES
.TP
.I /etc/hosts.equiv
The hosts listed in this file are permitted to access all local SANE
devices.  Caveat: this file imposes serious security risks and its use
is not recommended.
.TP
.I @CONFIGDIR@/saned.conf
Contains a list of hosts permitted to access local SANE devices.
.SH "SEE ALSO"
scanimage(1), xscanimage(1), xcam(1), sane-dll(5), sane-hp(5),
sane-mustek(5), sane-net (5), sane-pnm(5), sane-pint(5), sane-qcam(5),
sane-umax(5)
.SH AUTHOR
David Mosberger
