.TH sane-umax 5 "5 July 1997"
.IX sane-umax
.SH NAME
sane-umax - SANE backend for Umax scanners
.SH DESCRIPTION
The
.B sane-umax
library implements a SANE (Scanner Access Now Easy) backend that
provides access to some Umax scanners.  At present, the following
scanners are known positively to work with this backend, at least a bit:
.PP
.RS
Product id:     Remark:
.br
--------------  -----------
.br
Vista-S6         all modes ok
.br
Vista-S6E        RGB only in preview-mode
.br
UMAX S-6E        RGB only in preview-mode
.br
UMAX S-6EG       RGB only in preview-mode
.br
Vista-S8         don't know, please mail
.br
UMAX S-12        all modes ok
.br
UMAX S-12G       all modes ok
.br
SuperVista S-12  all modes ok
.br
PSD              all modes ok
.br
PL-II            don't know, please mail
.br
Astra 600S       rgb-mode doesn't work (?)
.br
Astra 1200S      all modes ok
.br
UC630            all modes ok, halftone?
.br
UC840            all modes ok, halftone?
.br
UG630            lineart and greyscale ok, halftone?
.RE
.PP
If you own a Umax scanner other than the ones
listed above, it will not work with SANE! Please try the command-line
version of the umax-driver -  you can download it from
.br
tsx-11.mit.edu /pub/linux/ALPHA/scanner
.br
and if that works mail us so that it will be supported for SANE.

.SH "FRONTEND OPTIONS"
This backend dynamically enabeles the options for the frontend,
that are supported by the scanner in dependence of the scanning-mode
and other options. Not supported options are disabled.
.br
The following otions are supported by the Umax-driver:
.br
analog gamma, highlight, shadow, contrast, brightness,
threshold, digital gamma curve,
quality calibration (WARNING: hangs driver and scsi-bus),
scan-speed (advanced), smearing (advanced), negative scan,
transparency adapter (UTA), automatic document feeder (ADF)

.SH "DEVICE NAMES"
This backend expects device names of the form:
.PP
.RS
.IR special
.RE
.PP
Where
.I special
is the UNIX path-name for the special device that corresponds to the
scanner.  The special device name must be a generic SCSI device or a
symlink to such a device.  Under Linux, such a device name could be
.IR /dev/sga
or
.IR /dev/sge ,
for example.
.SH CONFIGURATION
The configuration file for this backend resides in
.IR @CONFIGDIR@/umax.conf .
Its contents is a list of device names that correspond to UMAX
scanners.  Empty lines and lines starting with a hash mark (#) are
ignored.  A sample configuration file is shown below:
.PP
.RS
/dev/scanner
.br
# this is a comment
.br
/dev/sge
.RE
.SH SCSI ADAPTER TIPS
The SCSI-adapters that are shipped with some Umax-scanner are not
supported by Linux and most other platforms, so you typically need to
purchase another SCSI-adapter that is supported by your platform.  See
the relevant hardware FAQs and HOWTOs for your platform for more
information.
.PP
Also, we recommend to connect Umax scanners to their own SCSI
controller since otherwise, the devices on the same SCSI bus as the
scanner cannot be accessed while a scan is in progress.
.SH FILES
.TP
.I @CONFIGDIR@/umax.conf
The backend configuration file.
.TP
.I @LIBDIR@/libsane-umax.a
The static library implementing this backend.
.TP
.I @LIBDIR@/libsane-umax.so
The shared library implementing this backend (present on systems that
support dynamic loading).
.SH ENVIRONMENT
.TP
.B SANE_DEBUG_UMAX
If the library was compiled with debug support enabled, this
environment variable controls the debug level for this backend.  E.g.,
a value of 128 requests all debug output to be printed.  Smaller
levels reduce verbosity. E.g. just say:
.br
export SANE_DEBUG_UMAX=128
.SH "SEE ALSO"
sane-scsi(5)
.SH AUTHOR
Oliver Rauch, parts of the low-level-driver by Michael K. Johnson,
parts of this texts by others
.SH BUGS
May be a lot ;-(
.br
quality calibration will hang the scanner and the SCSI-bus
.br
some scanners only work in color-mode, if preview-bit is set,
for these scanners (at least the known ones) the preview bit is set
by the scanner-driver
