.TH sane-pint 5 "25 April 1997"
.IX sane-pint
.SH NAME
sane-pint - SANE backend for scanners that use the PINT device driver
.SH DESCRIPTION
The
.B sane-pint
library implements a SANE (Scanner Access Now Easy) backend that
provides generic access to hand-held and flatbed scanners using the
PINT (PINT Is Not Twain) device driver.  The PINT driver is being
actively developed on the OpenBSD platform, and has been ported to a
few other *nix-like operating systems.
.PP
PINT is designed to provide an
.BR ioctl (2)
interface to many different scanner types.  However, this backend has
only been tested with flatbed single-pass scanners, and more work will
probably be required to get it to use other scanner types
successfully.
.PP
If have successfully used the PINT driver with your scanner, but it
does not work using this SANE backend, please let us know.  To do
this, send a mail with the relevant information for your scanner to
.IR sane-devel@listserv.azstarnet.com .

.SH "DEVICE NAMES"
This backend expects device names of the form:
.PP
.RS
.IR special
.RE
.PP
Where
.I special
is the UNIX path-name for the special device that corresponds to the
scanner.  The special device name must be a PINT device or a symlink
to such a device.  For example, under NetBSD or OpenBSD, such a device
name could be
.IR /dev/ss0
or
.IR /dev/scan0 .
.SH CONFIGURATION
The configuration file for this backend resides in
.IR @CONFIGDIR@/pint.conf .
Its contents are a list of device names that correspond to PINT
scanners.  Empty lines and lines starting with a hash mark (#) are
ignored.  A sample configuration file is shown below:
.PP
.RS
/dev/scanner
.br
# this is a comment
.br
/dev/ss1
.RE
.SH FILES
.TP
.I @CONFIGDIR@/pint.conf
The backend configuration file.
.TP
.I @LIBDIR@/libsane-pint.a
The static library implementing this backend.
.TP
.I @LIBDIR@/libsane-pint.so
The shared library implementing this backend (present on systems that
support dynamic loading).
.SH ENVIRONMENT
.TP
.B SANE_DEBUG_PINT
If the library was compiled with debug support enabled, this
environment variable controls the debug level for this backend.  E.g.,
a value of 128 requests all debug output to be printed.  Smaller
levels reduce verbosity.
.SH AUTHOR
Gordon Matzigkeit, adapted from existing backends written by David
Mosberger.
.SH BUGS

There are minor roundoff errors when adjusting the ranges, since
PINT uses units of 1/1200 of an inch, and SANE normally uses
millimeters.  Symptoms of these errors are skewed images.  This should
really be fixed (no pun intended) as soon as possible, but I just
don't know/care enough about fixed-point representation and roundoff
errors to do this correctly.  Workaround: use inches as the scanning
unit, and everything usually works fine.

The PINT 0.5e interface does not provide a way to determine valid
ranges for DPI, modes, and scan sizes.  So, the SANE backend queries
the PINT device, and dynamically discovers valid ranges by doing a
binary search.  This means that the driver takes longer to initialize
than seems necessary.

Resetting the scanner does not seem to work (at least not on my HP
ScanJet 4p).  For that reason, the driver sends a SCIOCRESTART, then
gobbles up any remaining input until it hits EOF.

Not all of the scanners have been identified (i.e. whether they are
flatbed or handheld).

X and Y resolutions are assumed to be the same.

No testing has been done on three-pass or handheld scanners, or with
Automatic Document Feeder support.
