.TH sane-mustek 5 "14 October 1997"
.IX sane-mustek
.SH NAME
sane-mustek - SANE backend for Mustek flatbed scanners
.SH DESCRIPTION
The
.B sane-mustek
library implements a SANE (Scanner Access Now Easy) backend that
provides access to Mustek flatbed scanners.  At present, the following
scanners are known positively to work with this backend:
.PP
.RS
Model:      Product id:    Firmware revision: Type:
.br
----------- ----------- ------------------ -----
.br
MFC-600S    MFC-06000CZ v1.01 (and higher) 1-pass
.br
MFC-600CD   MFC-06000CZ v2.03 (and higher) 1-pass
.br
MFS-6000CX  MSF-06000CX v2.71 (and higher) 3-pass
.br
MSF-6000SP  MSF-06000SP v3.12 (and higher) 1-pass
.br
MFS-8000SP  MFS-08000SP v2.05 (lineart has dropped lines?) 1-pass
.br
MFS-1200SP  MSF-12000SP v1.00 (and higher) 1-pass
.br
MFS-1200SP  MFS-12000SP v1.02 [color fails?] 1-pass
.br
MFS-12000CX MFS-12000CX v2.71 (and higher) 3-pass
.RE
.PP
Note that this list includes both single- and three-pass scanners, so
in all likelihood, pretty much any Mustek flatbed scanner should work
with this backend.  If you own a Mustek scanner other than the ones
listed above, please let us know if your model works with this
backend.  To do this, send a mail with the relevant information for
your scanner to
.IR sane-devel@listserv.azstarnet.com .

.SH "DEVICE NAMES"
This backend expects device names of the form:
.PP
.RS
.IR special
.RE
.PP
Where
.I special
is the UNIX path-name for the special device that corresponds to the
scanner.  The special device name must be a generic SCSI device or a
symlink to such a device.  Under Linux, such a device name could be
.IR /dev/sga
or
.IR /dev/sge ,
for example.
.SH CONFIGURATION
The configuration file for this backend resides in
.IR @CONFIGDIR@/mustek.conf .
Its contents is a list of options and device names that correspond to
Mustek scanners.  Empty lines and lines starting with a hash mark (#)
are ignored.
.PP
The three options supported are
.BR linedistance-fix ,
.BR lineart-fix ,
and
.BR strip-height .
Options come in two flavors: global and positional ones.  Global
options apply to all devices managed by the backend whereas positional
options apply just to the most recently mentioned device.  Note that
this means that the order in which the options appear matters!
Option
.B linedistance-fix
is positional and works around a problem that occurs with some SCSI
controllers (notably the ncr810 controller under Linux).  If color
scans have horizontal stripes and/or the colors are off, then it's
likely that your controller suffers from this problem.  Turning on
this option usually fixes the problem.

Option
.B lineart-fix
is positional and works around a timing problem that seems to exist
with certain MFS-12000SP scanners.  The problem manifests itself in
dropped lines when scanning in lineart mode.  Turning on this option
should fix the problem but may slow down scanning a bit.

Finally,
.B strip-height
is a global option limits the maximum height of the strip scanned with
a single SCSI read command.  The height is specified in inches and may
contain a fractional part (e.g., 1.5).  Setting the strip-height to a
small value (one inch, for example) reduces the likelihood of
encountering problems with SCSI driver timeouts and/or timeouts with
other devices on the same SCSI bus.  Unfortunately, it also increases
scan times.  Thus, if the scanner is the only device on the SCSI bus
it is connected to and if it is known that the SCSI driver does not
suffer from premature timeouts, it is recommended to increase the
strip-height or remove the option completely, which corresponds to an
infinite strip height.  See sane-scsi(5) on how to avoid problems with
SCSI timeouts.
.PP
A sample configuration file is shown below:
.PP
.RS
# limit strip height of /dev/scanner to 1.5 inches:
.br
option strip-height 1.5
.br

.br
/dev/scanner    # first Mustek scanner

.br
/dev/sge        # second Mustek scanner
.br
  # turn on fixes for /dev/sge:
.br
  option lineart-fix
.br
  option linedistance-fix
.RE

.SH SCSI ADAPTER TIPS
Mustek SCSI scanners are typically delivered with an ISA SCSI adapter.
Unfortunately, that adapter is not worth much since it is not
interrupt driven.  It is (sometimes) possible to get the supplied card
to work, but without interrupt line, scanning will put so much load on
the system, that it becomes almost unusable for other tasks.
.PP
If you already have a working SCSI controller in your system, you
should consider that Mustek scanners do not support the SCSI-2
disconnect/reconnect protocol and hence tie up the SCSI bus while a
scan is in progress.  This means that no other SCSI device on the same
bus can be accessed while a scan is in progress.
.PP
Because the Mustek-supplied adapter is not worth much and because
Mustek scanners do not support the SCSI-2 disconnect/reconnect
protocol, it is recommended to install a separate (cheap) SCSI
controller for Mustek scanners.  For example, ncr810 based cards are
known to work fine and cost as little as fifty US dollars.
.PP
For Mustek scanners, it is typically necessary to configure the
low-level SCSI driver to disable synchronous transfers, tagged command
queuing, and target disconnects.  See sane-scsi(5) for driver and
platform-specific information.
.SH FILES
.TP
.I @CONFIGDIR@/mustek.conf
The backend configuration file.
.TP
.I @LIBDIR@/libsane-mustek.a
The static library implementing this backend.
.TP
.I @LIBDIR@/libsane-mustek.so
The shared library implementing this backend (present on systems that
support dynamic loading).
.SH ENVIRONMENT
.TP
.B SANE_DEBUG_MUSTEK
If the library was compiled with debug support enabled, this
environment variable controls the debug level for this backend.  E.g.,
a value of 128 requests all debug output to be printed.  Smaller
levels reduce verbosity.
.SH "SEE ALSO"
sane-scsi(5)
.SH AUTHOR
David Mosberger
.SH BUGS
Transparency adapter and automatic document feeder support is severly
lacking (due to absence of equipment to test this with).

There seems to be a performance bug that makes scanning on (some)
three-pass scanner slower than necessary.
