/* --------------------------------------------------------------------- */

/* umax.h - headerfile for SANE-backend for umax scanners
  
   (C) 1997 Oliver Rauch (for this file!)
   (other files have other copyrights, see each file!)

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA.

   As a special exception, the authors of SANE give permission for
   additional uses of the libraries contained in this release of SANE.

   The exception is that, if you link a SANE library with other files
   to produce an executable, this does not by itself cause the
   resulting executable to be covered by the GNU General Public
   License.  Your use of that executable is in no way restricted on
   account of linking the SANE library code into it.

   This exception does not, however, invalidate any other reasons why
   the executable file might be covered by the GNU General Public
   License.

   If you submit changes to SANE to the maintainers to be included in
   a subsequent release, you agree by submitting the changes that
   those changes may be distributed with this exception intact.

   If you write modifications of your own for SANE, it is your choice
   whether to permit this exception to apply to your modifications.
   If you do not wish that, delete this exception notice.
  
 */

/* --------------------------------------------------------------------- */

#ifndef umax_h
#define umax_h

#include "sys/types.h"
#include "umax-struct.h"


enum Umax_Option
{
    OPT_NUM_OPTS = 0,

    OPT_MODE_GROUP,
    OPT_MODE,
    OPT_SOURCE,
    OPT_X_RESOLUTION,
    OPT_Y_RESOLUTION,
    OPT_RESOLUTION_BIND,
    OPT_TEN_BIT_MODE,
    OPT_NEGATIVE,
    OPT_QUALITY,
    OPT_WARMUP,

    OPT_GEOMETRY_GROUP,
    OPT_TL_X,			/* top-left x */
    OPT_TL_Y,			/* top-left y */
    OPT_BR_X,			/* bottom-right x */
    OPT_BR_Y,			/* bottom-right y */

    OPT_ENHANCEMENT_GROUP,
    OPT_BRIGHTNESS,
    OPT_CONTRAST,
    OPT_THRESHOLD,

    OPT_HIGHLIGHT,
    OPT_HIGHLIGHT_R,
    OPT_HIGHLIGHT_G,
    OPT_HIGHLIGHT_B,

    OPT_SHADOW,
    OPT_SHADOW_R,
    OPT_SHADOW_G,
    OPT_SHADOW_B,

    OPT_ANALOG_GAMMA,
    OPT_ANALOG_GAMMA_R,
    OPT_ANALOG_GAMMA_G,
    OPT_ANALOG_GAMMA_B,

    OPT_HIGHLIGHT_BIND,
    OPT_SHADOW_BIND,
    OPT_ANALOG_GAMMA_BIND,

    OPT_CUSTOM_GAMMA,		/* use custom gamma tables? */
    /* The gamma vectors MUST appear in the order gray, red, green,
       blue.  */
    OPT_GAMMA_VECTOR,
    OPT_GAMMA_VECTOR_R,
    OPT_GAMMA_VECTOR_G,
    OPT_GAMMA_VECTOR_B,
    OPT_HALFTONE_DIMENSION,
    OPT_HALFTONE_PATTERN,

    OPT_ADVANCED_GROUP,
    OPT_SLOW,
    OPT_SMEAR,
    OPT_CALIB_MODE,
    OPT_RGB_PREVIEW_PATCH,
    OPT_START_SCAN_PATCH,
    OPT_PREVIEW,		/* preview */

    /* must come last: */
    NUM_OPTIONS
};


typedef union
{
    SANE_Word   w;
    SANE_Word   *wa;		/* word array */
    SANE_String s;
}
Option_Value;


typedef struct Umax_Device
{
    struct Umax_Device *next;
    SANE_Device sane;
    SANE_Range  x_dpi_range;
    SANE_Range  y_dpi_range;
    SANE_Range  x_range;
    SANE_Range  y_range;
    SANE_Range  analog_gamma_range;
    unsigned    flags;
    US          us;
}
Umax_Device;


typedef struct Umax_Scanner
{
    struct Umax_Scanner *next;
    Umax_Device         *device;

    SANE_Option_Descriptor  opt[NUM_OPTIONS];
    Option_Value        val[NUM_OPTIONS];
    SANE_Int            gamma_table[4][1024];
    SANE_Int            halftone_pattern[64];
    int			gamma_length;
    int			output_bytes;

    int                 scanning;
    SANE_Parameters     params;

    pid_t               reader_pid;
    int                 pipe;
}
Umax_Scanner;

#endif /* umax-sane_h */
