/***************************************************************************
 * SANE - Scanner Access Now Easy.

   microtek.h 

   This file (C) 1997 Matthew Marjanovic

   This file is part of the SANE package.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA.

   As a special exception, the authors of SANE give permission for
   additional uses of the libraries contained in this release of SANE.

   The exception is that, if you link a SANE library with other files
   to produce an executable, this does not by itself cause the
   resulting executable to be covered by the GNU General Public
   License.  Your use of that executable is in no way restricted on
   account of linking the SANE library code into it.

   This exception does not, however, invalidate any other reasons why
   the executable file might be covered by the GNU General Public
   License.

   If you submit changes to SANE to the maintainers to be included in
   a subsequent release, you agree by submitting the changes that
   those changes may be distributed with this exception intact.

   If you write modifications of your own for SANE, it is your choice
   whether to permit this exception to apply to your modifications.
   If you do not wish that, delete this exception notice.

 ***************************************************************************

   This file implements a SANE backend for Microtek scanners.

   (feedback to:  mtek-bugs@mir.com)

 ***************************************************************************/


#ifndef microtek_h
#define microtek_h

#include <sys/types.h>


/*******************************************************************/
/***** enumeration of Option Descriptors                       *****/ 

enum Mtek_Option
  {
    OPT_NUM_OPTS = 0,

    OPT_MODE_GROUP,
    OPT_MODE,             /* -a,b,c,g */
    OPT_RESOLUTION,       /* -r */
    OPT_NEGATIVE,         /* -n */
    OPT_SPEED,            /* -v */
    /*6*/    OPT_PREVIEW,

    OPT_GEOMETRY_GROUP,     /* -f .... */
    OPT_TL_X,			/* top-left x */
    OPT_TL_Y,			/* top-left y */
    OPT_BR_X,			/* bottom-right x */
    OPT_BR_Y,			/* bottom-right y */ 
    /*12*/
    OPT_ENHANCEMENT_GROUP,
    OPT_BRIGHTNESS,       /* -d */
    OPT_CONTRAST,         /* -k */
    OPT_HIGHLIGHT,        /* -l */
    OPT_SHADOW,           /* -s */
    OPT_MIDTONE,          /* -m */

    OPT_HALFTONE_PATTERN,   /* -H */
    /*19*/
    OPT_CUSTOM_GAMMA,
    /* "The gamma vectors MUST appear in the order gray, red, green, blue." */
    OPT_GAMMA_VECTOR,
    OPT_GAMMA_VECTOR_R,
    OPT_GAMMA_VECTOR_G,
    OPT_GAMMA_VECTOR_B,
    OPT_GAMMA_BIND,

    NUM_OPTIONS,
    



    OPT_SOURCE,           /* -t */
    OPT_BACKTRACK,        /* -B */

    /*.    OPT_THRESHOLD,*/


    /*
*/
    /*.    OPT_HALFTONE_DIMENSION,*/

    /*
.    OPT_ADVANCED_GROUP,
.    OPT_SLOW,
.    OPT_SMEAR,
.    OPT_CALIB_MODE,
.    OPT_PREVIEW,	       
*/

    /* must come last: */
    RNUM_OPTIONS
  };


/*******************************************************************/
/***** value structure for scanner options                     *****/ 

typedef union {
  SANE_Word w;
  SANE_Word *wa;		/* word array */
  SANE_String s;
} Microtek_Option_Value;


/*******************************************************************/
/***** scanner hardware information (as discovered by INQUIRY) *****/ 

typedef struct Microtek_Info {
  char vendor_id[9];
  char model_name[17];
  char revision_num[5];
  SANE_Byte device_type;
  SANE_Byte SCSI_firmware_ver_major;
  SANE_Byte SCSI_firmware_ver_minor;
  SANE_Byte scanner_firmware_ver_major;
  SANE_Byte scanner_firmware_ver_minor;
  SANE_Byte response_data_format;
#define MI_RESSTEP_1PER 0x01
#define MI_RESSTEP_5PER 0x02
  SANE_Byte res_step; 
#define MI_MODES_LINEART  0x01
#define MI_MODES_HALFTONE 0x02
#define MI_MODES_GRAY     0x04  /* ??????? or "MultiBit"??? XXXXX*/
#define MI_MODES_COLOR    0x08
#define MI_MODES_TRANSMSV 0x20
#define MI_MODES_ONEPASS  0x40
#define MI_MODES_NEGATIVE 0x80
  SANE_Byte modes; 
  SANE_Int pattern_count; 
  SANE_Byte pattern_dwnld; 
#define MI_FEED_FLATBED  0x01
#define MI_FEED_EDGEFEED 0x02
#define MI_FEED_AUTOSUPP 0x04
  SANE_Byte feed_type;
#define MI_COMPRSS_HUFF  0x10
#define MI_COMPRSS_RD    0x20
  SANE_Byte compress_type;
#define MI_UNIT_8TH_INCH 0x40
#define MI_UNIT_PIXELS   0x80
  SANE_Byte unit_type;
  SANE_Byte doc_size_code;
  SANE_Fixed max_x; /* inches */
  SANE_Fixed max_y; /* inches */
  SANE_Int cont_settings;
  SANE_Int exp_settings;
  SANE_Byte model_code;
  SANE_Int base_resolution; /* dpi */
#define MI_SRC_FEED_SUPP 0x01 /* support for feeder                    */
#define MI_SRC_FEED_BT   0x02 /* support for feed backtracking control */
#define MI_SRC_HAS_FEED  0x04 /* feeder installed                      */
#define MI_SRC_FEED_RDY  0x08 /* feeder ready                          */
#define MI_SRC_GET_FEED  0x10 /* if opaque:  get from feeder           */
#define MI_SRC_GET_TRANS 0x20 /* get transparency (not opaque)         */
#define MI_SRC_HAS_TRANS 0x40 /* transparency adapter installed        */
  SANE_Byte source_options;
  SANE_Byte expanded_resolution;
#define MI_ENH_CAP_SHADOW  0x01  /* can adjust shadow/highlight */
#define MI_ENH_CAP_MIDTONE 0x02  /* can adjust midtone          */
  SANE_Byte enhance_cap;
  SANE_Int max_lookup_size;     /* max. size of gamma LUT            */
  SANE_Int max_gamma_val;       /* max. value of a gamma LUT element */
  SANE_Int gamma_size;          /* size (bytes) of each LUT element  */
  SANE_Byte fast_color_preview; /* allows fast color preview?        */
  SANE_Byte xfer_format_select; /* allows select of transfer format? */
#define MI_COLSEQ_PLANE  0x00
#define MI_COLSEQ_PIXEL  0x01
#define MI_COLSEQ_RGB    0x02
#define MI_COLSEQ_NONRGB 0x03
  SANE_Byte color_sequence;     /* color sequence spec. code         */
  SANE_Byte does_3pass;         /* allows 3-pass scanning?           */
  SANE_Byte does_mode1;         /* allows MODE1 sense/select comm's? */
#define MI_FMT_CAP_4BPP  0x01
#define MI_FMT_CAP_10BPP 0x02
#define MI_FMT_CAP_12BPP 0x04
#define MI_FMT_CAP_16BPP 0x08
  SANE_Byte bit_formats;        /* output bit formats capabilities   */
#define MI_EXCAP_OFF_CTL   0x01 
#define MI_EXCAP_DIS_LNTBL 0x02
#define MI_EXCAP_DIS_RECAL 0x04
  SANE_Byte extra_cap;
  SANE_Int contrast_vals;
  SANE_Int min_contrast;
  SANE_Int max_contrast;
  SANE_Int exposure_vals;
  SANE_Int min_exposure;
  SANE_Int max_exposure;
} Microtek_Info;



/*******************************************************************/
/***** device structure (one for each device discovered)       *****/

typedef struct Microtek_Device {
  struct Microtek_Device *next; /* next, for linked list     */
  SANE_Device sane;             /* SANE generic device block */
  Microtek_Info info;           /* detailed scanner spec     */
} Microtek_Device;

/*******************************************************************/
/***** scanner structure (one for each device in use)          *****/
/*****       ....all the state needed to define a scan request *****/

typedef struct Microtek_Scanner {
  struct Microtek_Scanner *next;  /* for linked list */
  Microtek_Device *dev;           /* raw device info */
  
  SANE_Option_Descriptor sod[RNUM_OPTIONS]; /* option list for session   */
  Microtek_Option_Value val[RNUM_OPTIONS];  /* option values for session */
  SANE_Int gamma_table[4][256];

  /* scan parameters, ready to toss to SCSI */

  /* ...fixed by sane_open: */
#define MS_UNIT_PIXELS 0
#define MS_UNIT_18INCH 1
  SANE_Byte unit_type;  /* pixels or 1/8" */
#define MS_RES_1PER 0
#define MS_RES_5PER 1
  SANE_Byte res_type; /* 1% or 5% */
  SANE_Bool midtone_support;
  SANE_Int paper_length; /* whatever unit */

  SANE_Byte bright_r, bright_g, bright_b; /* ??? XXXXXXXX signed char */
  SANE_Bool allow_calibrate;
  SANE_Bool onepass;
  SANE_Bool useADF, prescan, transparency, allowbacktrack;
  SANE_Bool reversecolors, onepasscolor, expandedresolution;
  SANE_Bool fastprescan;
#define MS_FILT_CLEAR 0
#define MS_FILT_RED 1
#define MS_FILT_GREEN 2
#define MS_FILT_BLUE 3
  SANE_Byte filter;
  SANE_Int bits_per_color;

  /* ...set by sane_get_parameters: */
  SANE_Parameters params;   /* format, lastframe, lines, depth, ppl, bpl */
  SANE_Int x1;  /* in 'units' */
  SANE_Int y1;
  SANE_Int x2;
  SANE_Int y2;
#define MS_MODE_LINEART 0
#define MS_MODE_HALFTONE 1
#define MS_MODE_GRAY 2
#define MS_MODE_COLOR 3
  SANE_Int mode;
  SANE_Int resolution;
  SANE_Byte resolution_code;
  SANE_Byte exposure, contrast;
  SANE_Byte pattern;
  SANE_Byte velocity;
  SANE_Byte shadow, highlight, midtone;
  SANE_Bool multibit;
  /*
  SANE_Int bytes_per_line;
  SANE_Int image_width;
  SANE_Int header_bytes;
  SANE_Int planes;
  SANE_Int lines;
  */
  SANE_Int pixel_bpl;   /* bytes per line, pixels  */
  SANE_Int header_bpl;  /* bytes per line, headers */
  SANE_Int ppl;         /* pixels per line         */
  SANE_Int lines;       /* lines, left to scan     */
  SANE_Int planes;      /* color planes            */

  u_int8_t *buffer;
  /*  u_int8_t *holding;
  SANE_Int holding_lines;*/

  u_int8_t *pre_hold;
  u_int8_t *post_hold;
  SANE_Int pre_lines;
  SANE_Int post_lines;

  SANE_Int extra_r_seg;
  SANE_Int extra_g_seg;
  SANE_Int extra_b_seg;

  int scanning;
  int cancel;
  int pass;			/* pass number */
  int line;			/* current line number */

  int sfd;			/* SCSI filedescriptor */

} Microtek_Scanner;

#endif /* microtek_h */
