/****************************************************************************
*                   f_expr.h
*
*  This module contains all defines, typedefs, and prototypes for f_expr.c.
****************************************************************************/
#ifndef F_EXPR_H
#define F_EXPR_H
                             /* some useless constans, which effect hole code */

#define FUNC_MAX_STACK_LEN  256



enum IsoFunctions{    /*  and now some usefull ones (I hope)    */
	FE_X =0, /*   for functions, implicit functions,.. */
	FE_Y ,
	FE_Z,          
	FE_R,                /*  reserved :)                           */
	FE_S,          
	FE_T,         
	FE_U,             /*   parametric surfaces                  */
	FE_V,       
                        
	FE_CONSTANT,    
                             /*   unary operator & functions           */
	FE_UNARYMINUS , 
                             /*   goniom. functions                    */
	FE_sin,
	FE_asin,
	FE_cos,
	FE_acos,
	FE_tan,
	FE_atan,
                             /*  exps. and so on                      */
	FE_sinh,
	FE_asinh,
	FE_cosh,
	FE_acosh,
	FE_tanh,
	FE_atanh,    

	FE_ln,              /*  ln|x|, natural logarithm, ln(e)=1    */
	FE_exp,          /*  e^x                                  */
	FE_exp_xy,     /*  |x|^y, respective e^(log|y|)         */

	FE_sqrt,      /*  |x|^(1/2)                            */
	FE_sqr,      /*  x^2                                  */
	FE_cub,      /*  x^3                                  */
	FE_cube,     /*  x^3                                  */
	FE_noise3d,     /*  not implemented yet                  */
	FE_func3d,     /*  not implemented yet                  */

	FE_abs,

/*  R.S. July 8, 96, Fri 09-27-1996 0. */
	FE_B_OR,     
	FE_B_AND,
	FE_B_MOD,
/*-----------*/

	FE_B_PLUS   ,     /*  basic binary ops                     */
	FE_B_MINUS,
	FE_B_MULT,
	FE_B_DIV,

	FE_LEFT_PAR,
	FE_RIGHT_PAR,

/* Fri 09-27-1996 0. */
	FE_min,
	FE_max,
	FE_COMMA,
/* 0 */

#ifdef IsoBlobPatch
/* Lummox JR, June 1999 */
/* FE_LAST was 44 (42+2) before these values were added */
	FE_ceil,
	FE_floor,
	FE_PI,
	FE_RADIANS,
	FE_DEGREES,
/* if(condition,value if >0,value if <=0) --sort of like C's ?: operator */
/* Most languages call this iif, not if; "if" is used because the token
   already exists; why waste it? */
	FE_IF,
	FE_ATAN2,
	FE_CLOCK,
/* End Lummox JR's additions */
#endif

	FE_LAST         /* this is whatever - I use it for flush stack */

};
                           
                             /*   function flags                      */ 
#define OK_X            1
#define OK_Y            2
#define OK_Z            4
#define OK_R            8
#define OK_S           16
#define OK_T           32
#define OK_U           64
#define OK_V          128

extern struct Function_Info_Struct FuncInfo[];

                         /*  Function's flags                           *\
                              0  unary
                              1  binary
                              2  expect parenthesis like sin(
                              3  no arguments - like x,y,z, float,...
                              4  don't insert to stack - "(",",",")",..
                              5  \
                              6   > number of parametrs of function - 1
                              7  /
                         \*                                             */

#define  FI_UNARY         1
#define  FI_BINARY        2
#define  FI_EXPECT_PAR    4
#define  FI_NOARG         8              
#define  FI_DONT_INS     16   /* do not insert op. to op. stack - (,) */

#define  FI_NUMBER        (FI_NOARG | FI_UNARY)
#define  FI_FUNC          (FI_EXPECT_PAR | FI_UNARY)
#define  FI_XNARY_MASK    (FI_UNARY|FI_BINARY)
#define  FI_PAR           FI_DONT_INS           

#define  FI_TWOPARAMS     32
#define  FI_3PARAMS       64
#define  FI_4PARAMS      128
#define  FI_NUMARGS(x)    (((x)>>5) & 7)

                         /*  Priority                                  */

#define  FP_HIGHEST      45        /* x,y,z, ...                       */
#define  FP_HIGH         40        /* unary -, sin, cos,....           */
#define  FP_MEDIUM       30        /* ^ */
#define  FP_LOW          20        /* * / */
#define  FP_LOWEST       10        /* + - */

#define  FP_ADD          (FP_HIGH+10)


                        /* these functions operate only with stacks,   */
                        /*          no standard arguments              */
                          
void func_x(void);
void func_y(void);
void func_z(void);
void func_r(void);
void func_s(void);
void func_t(void);
void func_u(void);
void func_v(void);
void func_const(void);
void func_uminus(void);
void func_sin(void);
void func_asin(void);
void func_cos(void);
void func_acos(void);
void func_tan(void);
void func_atan(void);
void func_sinh(void);
void func_asinh(void);
void func_cosh(void);
void func_acosh(void);
void func_tanh(void);
void func_atanh(void);
void func_ln(void);
void func_exp(void);
void func_exp_xy(void);
void func_sqrt(void);
void func_sqr(void);
void func_cub(void);
void func_noise3d(void);
void func_func3d(void);
void func_abs(void);

/* R.S.  July 8, 96 */
void func_b_max(void);
void func_b_min(void);
void func_b_or(void);
void func_b_and(void);
void func_b_mod(void);
/*----------*/

void func_b_plus(void);
void func_b_minus(void);
void func_b_mult(void);
void func_b_div(void);

#ifdef IsoBlobPatch
/* Lummox JR, June 1999 */
void func_ceil(void);
void func_floor(void);
void func_pi(void);
void func_radians(void);
void func_degrees(void);
void func_if(void);
void func_atan2(void);
void func_clock(void);
/* End Lummox JR's additions */
#endif
                        /*     same rules as for func_*, but these     */
                        /*      compute with interval arithmetic       */

void int_x(void);
void int_y(void);
void int_z(void);
void int_r(void);
void int_s(void);
void int_t(void);
void int_u(void);
void int_v(void);
void int_const(void);
void int_uminus(void);
void int_sin(void);
void int_asin(void);
void int_cos(void);
void int_acos(void);
void int_tan(void);
void int_atan(void);
void int_sinh(void);
void int_asinh(void);
void int_cosh(void);
void int_acosh(void);
void int_tanh(void);
void int_atanh(void);
void int_ln(void);
void int_exp(void);
void int_exp_xy(void);
void int_sqrt(void);
void int_sqr(void);
void int_cub(void);
void int_noise3d(void);
void int_func3d(void);
void int_abs(void);

/*  R.S.  July 8, 96 */
void int_b_max(void);
void int_b_min(void);
void int_b_or(void);
void int_b_and(void);
void int_b_mod(void);
/*-------*/

void int_b_plus(void);
void int_b_minus(void);
void int_b_mult(void);
void int_b_div(void);

#ifdef IsoBlobPatch
/* Lummox JR, June 1999 */
void int_ceil(void);
void int_floor(void);
void int_pi(void);
void int_radians(void);
void int_degrees(void);
void int_if(void);
void int_atan2(void);
void int_clock(void);
/* End Lummox JR's additions */

/* Added by Lummox JR, July 1999 */
void norm_x(void);
void norm_y(void);
void norm_z(void);
void norm_r(void);
void norm_s(void);
void norm_t(void);
void norm_u(void);
void norm_v(void);
void norm_const(void);
void norm_uminus(void);
void norm_sin(void);
void norm_asin(void);
void norm_cos(void);
void norm_acos(void);
void norm_tan(void);
void norm_atan(void);
void norm_sinh(void);
void norm_asinh(void);
void norm_cosh(void);
void norm_acosh(void);
void norm_tanh(void);
void norm_atanh(void);
void norm_ln(void);
void norm_exp(void);
void norm_exp_xy(void);
void norm_sqrt(void);
void norm_sqr(void);
void norm_cub(void);
void norm_noise3d(void);
void norm_func3d(void);
void norm_abs(void);
void norm_b_max(void);
void norm_b_min(void);
void norm_b_or(void);
void norm_b_and(void);
void norm_b_mod(void);
void norm_b_plus(void);
void norm_b_minus(void);
void norm_b_mult(void);
void norm_b_div(void);
void norm_ceil(void);
void norm_floor(void);
void norm_pi(void);
void norm_radians(void);
void norm_degrees(void);
void norm_if(void);
void norm_atan2(void);
void norm_clock(void);

/* End Lummox JR's normal calculation functions */
#endif
                         /* stack and variables for computing func. values */

#ifdef IsoBlobPatch
/* Added by Lummox JR, July 1999 */
typedef struct {DBL x,y,z,r,s,t,u,v;} ISOFUNC_NORMALVEC;
#define ISOFUNC_NORMAL_X(vec) ((vec).x)
#define ISOFUNC_NORMAL_Y(vec) ((vec).y)
#define ISOFUNC_NORMAL_Z(vec) ((vec).z)
#define ISOFUNC_NORMAL_R(vec) ((vec).r)
#define ISOFUNC_NORMAL_S(vec) ((vec).s)
#define ISOFUNC_NORMAL_T(vec) ((vec).t)
#define ISOFUNC_NORMAL_U(vec) ((vec).u)
#define ISOFUNC_NORMAL_V(vec) ((vec).v)

extern ISOFUNC_NORMALVEC norm_stack_d[];
extern ISOFUNC_NORMALVEC *norm_stack;
extern ISOFUNC_NORMALVEC *norm_stack_top;
/* End Lummox JR's additions */
#endif
extern DBL    func_U, func_V, func_R, func_S, func_T;
extern VECTOR func_XYZ;  /* for implicit functions                         */
extern DBL calc_stack_d[];
extern DBL *calc_stack;
extern DBL *calc_stack_top;   /* pointer to top of the stack               */


                         /* ... and for interval arithmetix                */

extern DBL func_U_hi, func_V_hi, func_R_hi, func_S_hi, func_T_hi;
extern DBL func_U_low, func_V_low, func_R_low, func_S_low, func_T_low;
extern VECTOR func_XYZ_hi, func_XYZ_low;

extern DBL cs_int_hi[], cs_int_low[];        
extern DBL *cs_hi_top, *cs_low_top;


extern char *cur_fun_queue;
extern DBL  *cur_num_queue;

void evaluate_function( FUNCTION *func );
void evaluate_interval( FUNCTION *func, DBL length);
#ifdef IsoBlobPatch
void evaluate_normal( FUNCTION *func, DBL accuracy);    /* Lummox JR, July 1999 */
#endif
#endif


