/*
     Programme REXX pour

     1/ Crer un objet PMView sur le bureau,
     2/ dcompacter les filtres,
     3/ crer NouvVars.Cmd et/ou ajouter les SETs au CONFIG.SYS.

     (version customise pour la version franaise de PMView)

     Note : le programme ne contrle pas l'ventuelle existance des
     lignes qu'il ajoute au fichier CONFIG.SYS.

*/

'cls'

say "Bienvenue dans le programme d'installation de PMView."
say "Ce programme va effectuer les tches suivantes :"
say ""

say "1) Cration d'une icne PMView sur le bureau (y compris les associations,"
Say "   pour que PMView soit lanc automatiquement quand vous cliquez deux"
Say "   fois sur l'icne d'un fichier graphique). L'objet sera nomm PMView92,"
Say "   pour ne pas craser une ventuelle icne personnalise prsente sur le"
Say "   bureau."
say ""
say "2) Dcompression des filtres de transformation."
say ""
say "3) Ajout de trois commandes SET  votre fichier CONFIG.SYS."
say ""
Say "Il vous demandera l'autorisation avant d'effectuer chacune de ces trois"
Say "actions. Si vous prfrez effectuer ces tches vous-mme, veuillez"
Say "consulter le fichier FLVM.TXT."
say ""

Reponse = DemandeOuiNon("Avez-vous dj dcompact le fichier ZIP de PMView")
if \Reponse then do
   say ""
   say "Veuillez dcompacter le fichier ZIP dans le rpertoire courant puis"
   say "relancer ce programme."
   say ""
   say "A bientt."
   exit
   end

Call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
Call sysloadfuncs

CheminComplet=Directory()
if right(CheminComplet, 1) \= "\" then do
   CheminComplet = CheminComplet || "\"
   end
say
say "Bon. " CheminComplet
Reponse = DemandeOuiNon("est-il le rpertoire o vous voulez installer PMView")
if \Reponse then do
   say "Veuillez crer un rpertoire pour PMView, dcompacter le fichier ZIP"
   say "dans ce rpertoire, puis lancer ce programme, toujours dans ce rpertoire."
   say ""
   say "A tout de suite."
   exit
   end

say
say "Ok. Dois-je crer une icne sur le bureau,"
Reponse = DemandeOuiNon("associations comprises")
if Reponse then do
   drop res.
   call SysFileTree CheminComplet || "PMVIEW.EXE", res, "OF"
   if res.1 = "RES.1" then do
      say "Hmm, je ne vois pas de PMVIEW.EXE ici..."
      say "Je ne peux pas continuer dans ces conditions."
      say
      say "Assurez-vous de dcompacter PMView dans ce rpertoire puis"
      say "lancez  nouveau ce programme."
      exit
      end
   else do
      assoc = '*.BMP,*.EPS,*.GIF,*.JPG,*.PBM,*.PCD,*.PCX,*.PIC,*.PGM,' ||,
              '*.PPM,*.SHW,*.TGA,*.TIF,'
      Call SysCreateObject 'WPProgram','PMView92','<WP_DESKTOP>','CCVIEW=YES;EXENAME='||CheminComplet||'\PMVIEW.EXE;PROGTYPE=PM;PARAMETERS=%*;STARTUPDIR='||CheminComplet||';ASSOCFILTER='||assoc,'R'
      Say "C'est bon, j'ai cr une icne sur le bureau pour PMView."
      end
   end

drop CheminFiltres
say ""
Reponse = DemandeOuiNon("Le programme unzip.exe d'InfoZip est il disponible dans votre PATH")
if \Reponse then do
   say "Ah, j'ai bien peur de ne pas pouvoir installer les filtres."
   say "Consultez FLVM.TXT pour les installer vous mme."
   end
else do
   Reponse = DemandeOuiNon("D'accord, dois-je installer les filtres de transformation")
   if Reponse then do
      drop res.
      CheminFiltres = CheminComplet || "Filtres"
      call SysFileTree CheminFiltres, res, "OD"
      if res.1 = "RES.1" then do
         'md Filtres'
         drop res.
         call SysFileTree CheminFiltres, res, "OD"
         if res.1 = "RES.1" then do
            say
            say "Dsol, mais je ne parviens pas  crer le rpertoire"
            say CheminFiltres
            say "Je vais devoir m'arrter ici."
            say "Veuillez crer ce rpertoire  ma place, puis relancer"
            say "ce programme."
            say
            say "A tout de suite."
            exit
            end
         end
      'cd Filtres&&unzip -o -qq ../filtres&&cd ..'
      end
   end

'@if exist NouvVars.Cmd del NouvVars.Cmd'
call lineout "NouvVars.Cmd", "Set PMView_Ini=" || CheminComplet || "PMView.Ini"
call lineout "NouvVars.Cmd", "Set PMView_Aide=" || CheminComplet
if CheminFiltres = "CHEMINFILTRES" then do
   CheminFiltres = CheminComplet
   end
call lineout "NouvVars.Cmd", "Set PMView_Filtres=" || CheminFiltres
say
say "Avant de lancer PMView, vous devez dfinir trois variables d'environnement."
Reponse = DemandeOuiNon("Puis-je les ajouter  votre fichier CONFIG.SYS")
if Reponse then do
   NomConfig = "\CONFIG.SYS"
   LongConfig = length(NomConfig)
   Reponse = DemandeOuiNon("Votre fichier CONFIG.SYS est il situ sur l'unit C:")
   if Reponse then do
      CheminConfig = "c:"
      end
   else do
      CheminConfig = "inconnu"
      end
   do until res.1 \= "RES.1"
      if right(CheminConfig, LongConfig) \= NomConfig then do
         CheminConfig = CheminConfig || NomConfig
         end
      drop res.
      call SysFileTree CheminConfig, res, "OF"
      if res.1 = "RES.1" then do
         say "Je ne trouve pas" || ' "' || CheminConfig || '".'
         call charout, "O OS/2 trouve-t-il CONFIG.SYS quand il s'initialise ? "
         Pull CheminConfig
         drop res.
         call SysFileTree CheminConfig, res, "OF"
         if res.1 = "RES.1" then do
            say "Argh ! Impossible de trouver ce fichier !"
            say ""
            end
         end
      end /* boucle Until */
   CfgAnc = left(CheminConfig, length(CheminConfig) - 3) || "Anc"
   drop res.
   call SysFileTree CfgAnc, res, "OF"
   if res.1 \= "RES.1" then do
      call ErrSauvCfg
      end
   else do
      'copy' CheminConfig CfgAnc
      drop res.
      call SysFileTree CfgAnc, res, "OF"
      if res.1 = "RES.1" then do
         call ErrSauvCfg
         end
      else do
         call lineout CheminConfig, "Rem *** Dfinition de trois variables " ||,
                                  " d'environnement pour PMView"
         call lineout CheminConfig, "Set PMView_Ini=" || CheminComplet || "PMView.Ini"
         call lineout CheminConfig, "Set PMView_Aide=" || CheminComplet
         call lineout CheminConfig, "Set PMView_Filtres=" || CheminFiltres
         call lineout CheminConfig
         say
         say "a y est, j'ai mis le fichier CONFIG.SYS  jour."
         say "Une copie de l'ancienne version est sauvegarde dans CONFIG.ANC"
         say "dans votre rpertoire d'initialisation."
         say "Veuillez arrter le systme puis rinitialiser OS/2 aprs la"
         say "fin de l'excution de ce programme d'installation."
         end
      end
   end
else do
   say ""
   say "Vous pouvez lancer 'NouvVars' sur la ligne de commande d'OS/2 pour"
   Say "dfinir les variables -ceci ne fonctionnera que pour la session"
   Say "considre."
   say ""
   say "Pour que les variables soient dfinies dfinitivement, dans toutes"
   Say "les sessions OS/2, veuillez ajouter le contenu de NouvVars.Cmd "
   Say "votre fichier CONFIG.SYS."
   end

say ""
say "Si vous avez ajout l'icne au bureau, je vous recommande de supprimer"
Say "toute autre association que ces types de fichiers peuvent avoir."
Say "En gros : si vous cliquez deux fois sur une image, et qu'un programme"
Say "autre que PMView est lanc (et que vous vouliez lancer PMView),"
Say "veuillez supprimer l'association de l'autre programme."
say ""
say "(Par exemple, les fichiers *.BMP/bitmap sont par dfaut associs par OS/2"
Say " l'diteur d'icnes, et Warp les associe aussi  Windows Paintbrush)."
say ""
say "Ouf ! C'est termin ! Merci pour votre patience, et pour votre intrt"
Say "pour PMView !"

exit

DemandeOuiNon: procedure
ok = 0
do until ok
   call charout, arg(1) || "? "
   pull Reponse
   Reponse = left(Reponse, 1)
   ok = (Reponse = "O") | (Reponse = "N")
   if \ok then do
      say
      say "Allo ? Veuillez rpondre par 'O' ou 'N'."
      end
   end /* loop */
return (Reponse = "O")

ErrSauvCfg: procedure
say d2c(7) d2c(7)
say "Ae ! Je ne peux pas sauvegarder le fichier CONFIG.SYS."
say "Pour plus de scurite, je vais m'abstenir de le modifier."
say "Veuillez diter votre fichier CONFIG.SYS  la main, et ajouter les"
say "trois lignes de NouvVars.Cmd."

return
