/* Rexx program to install PicWin */
'echo off'

call rxfuncadd 'sysloadfuncs','rexxutil','sysloadfuncs'
call sysloadfuncs

parse arg parms

if parms = ""
    Then
        Do
            'CLS'
            Say ''
            Say ''
            Say 'ERROR!'
            Say 'Incorrect or missing parameters'
            Say 'Correct syntax is:  '
            Say '     PicWin PicWin_directory'
            Return
        End

parse var parms PicWinDir

if right(PicWinDir,1) <> '\'
    Then PicWinDir = PicWinDir||'\'

/* Let's do the disclaimer stuff */
'CLS'
Say ''
Say ''
Say 'By using this program, you are agreeing to accept'
Say 'all risk for use of this program.'
Say ''
Say 'This means that YOU and YOU ALONE are responsible for'
Say 'any and all problems that may arise from use of this software.'
Say ''
Say 'Do you agree to these terms? (Y/N):'
pull agree

if agree <> 'Y'
    Then Exit


Say 'Do you really want to install PicWin into 'PicWinDir' (Y/N) ?'
pull response

if response = 'Y'
    Then
        Do
            'echo y|xcopy *.* '||PicWinDir||'>NUL'

           call SysCreateObject 'WPProgram', 'Picture^Window', '<WP_DESKTOP>',';EXENAME='||PicWinDir||'\PicWin.Exe;STARTUPDIR='||PicWinDir||';PROGTYPE=PM;OBJECTID=<PicWin>',REPLACE
        End

Say 'Installation completed successfully.'

Say 'Do you wish to read the ReadMe.Doc file now?'
pull response

if response = 'Y'
    Then
        'type PicWin.Doc|more'

Say 'Do you wish to print the PicWin.Doc file now?'
pull response

if response = 'Y'
    Then
        'print PicWin.doc'
