/****************************************************************************
*
*  ========================================================================
*
*    The contents of this file are subject to the SciTech MGL Public
*    License Version 1.0 (the "License"); you may not use this file
*    except in compliance with the License. You may obtain a copy of
*    the License at http://www.scitechsoft.com/mgl-license.txt
*
*    Software distributed under the License is distributed on an
*    "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
*    implied. See the License for the specific language governing
*    rights and limitations under the License.
*
*    The Original Code is Copyright (C) 1991-1998 SciTech Software, Inc.
*
*    The Initial Developer of the Original Code is SciTech Software, Inc.
*    All Rights Reserved.
*
*  ========================================================================
*
* Language:     ANSI C
* Environment:  Any
*
* Description:  Simple program to process the response file for the Watcom
*               linker wlink, to remove the empty 'LIBR' statement that
*               our makefiles generate (cant seem to find a way to get
*               DMAKE to automatically remove this if there are no libraries
*               to be linked with the executable file).
*
*               Note that we can also optionally import a REF file containing
*               all info necessay to add the EXPORT directives to the linker
*               script to export the functions with the proper names.
*
****************************************************************************/

#include "scitech.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

// TODO: Add support for IMPORT directives as well as EXPORT directives.
//       We will also need to handle translating entire DEF files including
//       the segment options in order to get complex stuff like OS/2 DLL's
//       building correctly.

int main(int argc, char *argv[])
{
    int     foundExports,ordinal;
    char    buf[255],name[255],stdcallName[255];
    char    *p,*q;
    FILE    *infile,*outfile,*reffile;

    if (argc != 3 && argc != 4) {
        fprintf(stderr, "Usage: trimlib <infile> <outfile> [reffile]\n");
        return -1;
        }

    if ((infile = fopen(argv[1], "r")) == NULL) {
        printf("Unable to open input file!\n");
        exit(1);
        }
    if ((outfile = fopen(argv[2], "w")) == NULL) {
        printf("Unable to open output file!\n");
        exit(1);
        }
    if (argc == 4) {
        /* Exports directives can all be added at the start of the
         * linker script, so we do that first. The directives need
         * to be of the following form:
         *
         *   EXP InitReg.1='_InitReg'
         *
         * for __cdecl functions and:
         *
         *   EXP InitReg.1='_InitReg@0'
         *
         * for __stdcall functions. Note that the leading underscore
         * is always removed from the function names, as that is how
         * the latest Visual C++ compilers work. We do this to maintain
         * compatibility with that compiler, even though I hate it
         * passionately!
         */
        if ((reffile = fopen(argv[3], "r")) == NULL) {
            printf("Unable to open ref file!\n");
            exit(1);
            }
        foundExports = false;
        while (fgets(buf,255,reffile)) {
            if (strncmp(buf,"EXPORTS", 7) == 0) {
                foundExports = true;
                break;
                }
            }
        if (!foundExports) {
            printf("Did not find EXPORTS keyword!\n");
            exit(1);
            }
        ordinal = 1;
        while (fgets(buf,255,reffile)) {
            p = buf;
            while (isspace(*p) && *p != '\n' && *p != '\0')
                p++;
            if (*p == '\n' || *p == '\0')
                continue;
            q = stdcallName;
            while (!isspace(*p) && *p != '\n' && *p != '\0')
                *q++ = *p++;
            *q = '\0';
            strcpy(name,stdcallName);
            if ((p = strchr(name,'@')) != NULL)
                *p = '\0';
            fprintf(outfile,"EXP %s.%d='_%s'\n", name,ordinal,stdcallName);
            ordinal++;
            }
        fclose(reffile);
        }

    while (fgets(buf,255,infile)) {
        if (strncmp(buf,"LIBR", 4) == 0) {
            p = &buf[4];
            while (isspace(*p) && *p != '\n' && *p != '\0')
                p++;
            if (*p == '\n' || *p == '\0')
                continue;
            }
        fputs(buf,outfile);
        }

    fclose(infile);
    fclose(outfile);
    return 0;
}

