/****************************************************************************
*
*  ========================================================================
*
*    The contents of this file are subject to the SciTech MGL Public
*    License Version 1.0 (the "License"); you may not use this file
*    except in compliance with the License. You may obtain a copy of
*    the License at http://www.scitechsoft.com/mgl-license.txt
*
*    Software distributed under the License is distributed on an
*    "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
*    implied. See the License for the specific language governing
*    rights and limitations under the License.
*
*    The Original Code is Copyright (C) 1991-1998 SciTech Software, Inc.
*
*    The Initial Developer of the Original Code is SciTech Software, Inc.
*    All Rights Reserved.
*
*  ========================================================================
*
* Language:     ANSI C
* Environment:  MSDOS
*
* Description:  Simple program to process an input list of files to
*               be added to a ZIP file, first stripping out comments
*               before passing the result on to InfoZIP.
*
****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

char    buf[2048];

char *skipwhite(char *s)
{
    while (*s && isspace(*s))
        s++;
    return *s ? s : NULL;
}

int main(int argc, char *argv[])
{
    char    *p;
    FILE    *in;

    /* Display usage information */
    if (argc != 2) {
        fprintf(stderr, "Usage: comstrip <file>\n");
        return -1;
        }

    /* Read all lines from input file and copy non-comment lines
     * to output file.
     */
    if ((in = fopen(argv[1], "r")) == NULL) {
        printf("Unable to open input file!\n");
        return -1;
        }
    while (fgets(buf,sizeof(buf),in)) {
        /* Skip comment and blank lines */
        p = skipwhite(buf);
        if (p == NULL || *p == '#')
            continue;
        fputs(buf,stdout);
        }
    fclose(in);
    return 0;
}

