/****************************************************************************
*
*  ========================================================================
*
*    The contents of this file are subject to the SciTech MGL Public
*    License Version 1.0 (the "License"); you may not use this file
*    except in compliance with the License. You may obtain a copy of
*    the License at http://www.scitechsoft.com/mgl-license.txt
*
*    Software distributed under the License is distributed on an
*    "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
*    implied. See the License for the specific language governing
*    rights and limitations under the License.
*
*    The Original Code is Copyright (C) 1991-1998 SciTech Software, Inc.
*
*    The Initial Developer of the Original Code is SciTech Software, Inc.
*    All Rights Reserved.
*
*  ========================================================================
*
* Language:     ANSI C
* Environment:  Any
*
* Description:  Simple program to convert a binary file to C code as an
*               array of unsigned characters. The name of the structure
*               is based on the original file name.
*
****************************************************************************/

#include "pmapi.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/*------------------------- Global variables ------------------------------*/

#define LINE_SIZE   14

/*-------------------------- Implementation -------------------------------*/

void help(void)
/****************************************************************************
*
* Function:     help
*
* Description:  Help provides usage information about our program if the
*               options do make any sense.
*
****************************************************************************/
{
    printf("Usage: bin2c <filename>\n");
    exit(1);
}

void main(int argc,char *argv[])
{
    FILE    *f;
    char    structName[PM_MAX_PATH],*p,*q;
    uchar   buf[LINE_SIZE];
    int     size,i;

    if (argc < 2)
        help();
    if ((f = fopen(argv[1],"rb")) == NULL)
        PM_fatalError("Unable to open input file!");
    for (p = structName, q = argv[1]; *q != 0; p++,q++) {
        if (*q == '.')
            *p = '_';
        else
            *p = *q;
        }
    printf("unsigned char %s[] = {\n", structName);
    while (!feof(f)) {
        size = fread(buf,1,sizeof(buf),f);
        printf("    ");
        for (i = 0; i < size; i++)
            printf("0x%02X,", buf[i]);
        printf("\n");
        }
    printf("    };\n");
    fclose(f);
}
