/****************************************************************************
*
*					SciTech Multi-platform Graphics Library
*
*  ========================================================================
*
*    The contents of this file are subject to the SciTech MGL Public
*    License Version 1.0 (the "License"); you may not use this file
*    except in compliance with the License. You may obtain a copy of
*    the License at http://www.scitechsoft.com/mgl-license.txt
*
*    Software distributed under the License is distributed on an
*    "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
*    implied. See the License for the specific language governing
*    rights and limitations under the License.
*
*    The Original Code is Copyright (C) 1991-1998 SciTech Software, Inc.
*
*    The Initial Developer of the Original Code is SciTech Software, Inc.
*    All Rights Reserved.
*
*  ========================================================================
*
* Language:		ANSI C
* Environment:	Any
*
* Description:	This file contains the code specific to initialising the
*				SciTech MGL Binary Portable DLL.
*
****************************************************************************/

#include "mgl/mmesap.h"
#pragma hdrstop
#include "GL/mglmesa.h"
#include <stdio.h>
#include <string.h>

/*------------------------- Global Variables ------------------------------*/

PM_imports _VARAPI 		_PM_imports;
MESA_imports _VARAPI	_MESA_imports;

/*-------------------------- Implementation -------------------------------*/

/****************************************************************************
REMARKS:
Fatal error handler called when a non-imported function is called by the
driver. We leave this to a runtime error so that older applications and
shell drivers will work with newer bpd drivers provided no newer functions
are required by the driver itself. If they are, the application or shell
driver needs to be recompiled.
****************************************************************************/
static void _PM_fatalErrorHandler(void)
{
	_PM_imports.PM_fatalError("Unsupported PM_imports import function called! Please re-compile!\n");
}

/****************************************************************************
REMARKS:
Fatal error handler called when a non-imported function is called by the
driver. We leave this to a runtime error so that older applications and
shell drivers will work with newer bpd drivers provided no newer functions
are required by the driver itself. If they are, the application or shell
driver needs to be recompiled.
****************************************************************************/
static void _MESA_fatalErrorHandler(void)
{
	_PM_imports.PM_fatalError("Unsupported MESA_imports import function called! Please re-compile!\n");
}

/****************************************************************************
PARAMETERS:

RETURNS:
Pointer to exported function list

REMARKS:
This function initialises the GL image library and returns the list of
loader library exported functions.
{secret}
****************************************************************************/
MGL_glFuncs * _CEXPORT MESA_initLibrary(
	PM_imports *pmImp,
	MESA_imports *glImp,
	MESA_exports *glExp)
{
	static MGL_glFuncs _MGL_glFuncs = {
		sizeof(MGL_glFuncs),
		glAccum,
		glAlphaFunc,
		glAreTexturesResident,
		glArrayElement,
		glBegin,
		glBindTexture,
		glBitmap,
		glBlendFunc,
		glCallList,
		glCallLists,
		glClear,
		glClearAccum,
		glClearColor,
		glClearDepth,
		glClearIndex,
		glClearStencil,
		glClipPlane,
		glColor3b,
		glColor3bv,
		glColor3d,
		glColor3dv,
		glColor3f,
		glColor3fv,
		glColor3i,
		glColor3iv,
		glColor3s,
		glColor3sv,
		glColor3ub,
		glColor3ubv,
		glColor3ui,
		glColor3uiv,
		glColor3us,
		glColor3usv,
		glColor4b,
		glColor4bv,
		glColor4d,
		glColor4dv,
		glColor4f,
		glColor4fv,
		glColor4i,
		glColor4iv,
		glColor4s,
		glColor4sv,
		glColor4ub,
		glColor4ubv,
		glColor4ui,
		glColor4uiv,
		glColor4us,
		glColor4usv,
		glColorMask,
		glColorMaterial,
		glColorPointer,
		glCopyPixels,
		glCopyTexImage1D,
		glCopyTexImage2D,
		glCopyTexSubImage1D,
		glCopyTexSubImage2D,
		glCullFace,
		glDeleteLists,
		glDeleteTextures,
		glDepthFunc,
		glDepthMask,
		glDepthRange,
		glDisable,
		glDisableClientState,
		glDrawArrays,
		glDrawBuffer,
		glDrawElements,
		glDrawPixels,
		glEdgeFlag,
		glEdgeFlagPointer,
		glEdgeFlagv,
		glEnable,
		glEnableClientState,
		glEnd,
		glEndList,
		glEvalCoord1d,
		glEvalCoord1dv,
		glEvalCoord1f,
		glEvalCoord1fv,
		glEvalCoord2d,
		glEvalCoord2dv,
		glEvalCoord2f,
		glEvalCoord2fv,
		glEvalMesh1,
		glEvalMesh2,
		glEvalPoint1,
		glEvalPoint2,
		glFeedbackBuffer,
		glFinish,
		glFlush,
		glFogf,
		glFogfv,
		glFogi,
		glFogiv,
		glFrontFace,
		glFrustum,
		glGenLists,
		glGenTextures,
		glGetBooleanv,
		glGetClipPlane,
		glGetDoublev,
		glGetError,
		glGetFloatv,
		glGetIntegerv,
		glGetLightfv,
		glGetLightiv,
		glGetMapdv,
		glGetMapfv,
		glGetMapiv,
		glGetMaterialfv,
		glGetMaterialiv,
		glGetPixelMapfv,
		glGetPixelMapuiv,
		glGetPixelMapusv,
		glGetPointerv,
		glGetPolygonStipple,
		glGetString,
		glGetTexEnvfv,
		glGetTexEnviv,
		glGetTexGendv,
		glGetTexGenfv,
		glGetTexGeniv,
		glGetTexImage,
		glGetTexLevelParameterfv,
		glGetTexLevelParameteriv,
		glGetTexParameterfv,
		glGetTexParameteriv,
		glHint,
		glIndexMask,
		glIndexPointer,
		glIndexd,
		glIndexdv,
		glIndexf,
		glIndexfv,
		glIndexi,
		glIndexiv,
		glIndexs,
		glIndexsv,
		glIndexub,
		glIndexubv,
		glInitNames,
		glInterleavedArrays,
		glIsEnabled,
		glIsList,
		glIsTexture,
		glLightModelf,
		glLightModelfv,
		glLightModeli,
		glLightModeliv,
		glLightf,
		glLightfv,
		glLighti,
		glLightiv,
		glLineStipple,
		glLineWidth,
		glListBase,
		glLoadIdentity,
		glLoadMatrixd,
		glLoadMatrixf,
		glLoadName,
		glLogicOp,
		glMap1d,
		glMap1f,
		glMap2d,
		glMap2f,
		glMapGrid1d,
		glMapGrid1f,
		glMapGrid2d,
		glMapGrid2f,
		glMaterialf,
		glMaterialfv,
		glMateriali,
		glMaterialiv,
		glMatrixMode,
		glMultMatrixd,
		glMultMatrixf,
		glNewList,
		glNormal3b,
		glNormal3bv,
		glNormal3d,
		glNormal3dv,
		glNormal3f,
		glNormal3fv,
		glNormal3i,
		glNormal3iv,
		glNormal3s,
		glNormal3sv,
		glNormalPointer,
		glOrtho,
		glPassThrough,
		glPixelMapfv,
		glPixelMapuiv,
		glPixelMapusv,
		glPixelStoref,
		glPixelStorei,
		glPixelTransferf,
		glPixelTransferi,
		glPixelZoom,
		glPointSize,
		glPolygonMode,
		glPolygonOffset,
		glPolygonStipple,
		glPopAttrib,
		glPopClientAttrib,
		glPopMatrix,
		glPopName,
		glPrioritizeTextures,
		glPushAttrib,
		glPushClientAttrib,
		glPushMatrix,
		glPushName,
		glRasterPos2d,
		glRasterPos2dv,
		glRasterPos2f,
		glRasterPos2fv,
		glRasterPos2i,
		glRasterPos2iv,
		glRasterPos2s,
		glRasterPos2sv,
		glRasterPos3d,
		glRasterPos3dv,
		glRasterPos3f,
		glRasterPos3fv,
		glRasterPos3i,
		glRasterPos3iv,
		glRasterPos3s,
		glRasterPos3sv,
		glRasterPos4d,
		glRasterPos4dv,
		glRasterPos4f,
		glRasterPos4fv,
		glRasterPos4i,
		glRasterPos4iv,
		glRasterPos4s,
		glRasterPos4sv,
		glReadBuffer,
		glReadPixels,
		glRectd,
		glRectdv,
		glRectf,
		glRectfv,
		glRecti,
		glRectiv,
		glRects,
		glRectsv,
		glRenderMode,
		glRotated,
		glRotatef,
		glScaled,
		glScalef,
		glScissor,
		glSelectBuffer,
		glShadeModel,
		glStencilFunc,
		glStencilMask,
		glStencilOp,
		glTexCoord1d,
		glTexCoord1dv,
		glTexCoord1f,
		glTexCoord1fv,
		glTexCoord1i,
		glTexCoord1iv,
		glTexCoord1s,
		glTexCoord1sv,
		glTexCoord2d,
		glTexCoord2dv,
		glTexCoord2f,
		glTexCoord2fv,
		glTexCoord2i,
		glTexCoord2iv,
		glTexCoord2s,
		glTexCoord2sv,
		glTexCoord3d,
		glTexCoord3dv,
		glTexCoord3f,
		glTexCoord3fv,
		glTexCoord3i,
		glTexCoord3iv,
		glTexCoord3s,
		glTexCoord3sv,
		glTexCoord4d,
		glTexCoord4dv,
		glTexCoord4f,
		glTexCoord4fv,
		glTexCoord4i,
		glTexCoord4iv,
		glTexCoord4s,
		glTexCoord4sv,
		glTexCoordPointer,
		glTexEnvf,
		glTexEnvfv,
		glTexEnvi,
		glTexEnviv,
		glTexGend,
		glTexGendv,
		glTexGenf,
		glTexGenfv,
		glTexGeni,
		glTexGeniv,
		glTexImage1D,
		glTexImage2D,
		glTexParameterf,
		glTexParameterfv,
		glTexParameteri,
		glTexParameteriv,
		glTexSubImage1D,
		glTexSubImage2D,
		glTranslated,
		glTranslatef,
		glVertex2d,
		glVertex2dv,
		glVertex2f,
		glVertex2fv,
		glVertex2i,
		glVertex2iv,
		glVertex2s,
		glVertex2sv,
		glVertex3d,
		glVertex3dv,
		glVertex3f,
		glVertex3fv,
		glVertex3i,
		glVertex3iv,
		glVertex3s,
		glVertex3sv,
		glVertex4d,
		glVertex4dv,
		glVertex4f,
		glVertex4fv,
		glVertex4i,
		glVertex4iv,
		glVertex4s,
		glVertex4sv,
		glVertexPointer,
		glViewport,
		glDrawRangeElements,
		glTexImage3D,
		glTexSubImage3D,
		glCopyTexSubImage3D,
		};
	static MESA_exports _MESA_exports = {
		sizeof(MESA_exports),
		MGLMesaChooseVisual,
		MGLMesaSetVisual,
		MGLMesaCreateContext,
		MGLMesaDestroyContext,
		MGLMesaMakeCurrent,
		MGLMesaSwapBuffers,
		MGLMesaSetPaletteEntry,
		MGLMesaSetPalette,
		MGLMesaRealizePalette,
		MGLMesaResizeBuffers,
		MGLMesaGetProcAddress,
		};
	int		i,max;
	ulong 	*p;

	// Initialize all default imports to point to fatal error handler
	// for upwards compatibility.
	max = sizeof(_PM_imports)/sizeof(MESA_initLibrary_t);
	for (i = 0,p = (ulong*)&_PM_imports; i < max; i++)
		*p++ = (ulong)_PM_fatalErrorHandler;
	max = sizeof(_MESA_imports)/sizeof(MESA_initLibrary_t);
	for (i = 0,p = (ulong*)&_MESA_imports; i < max; i++)
		*p++ = (ulong)_MESA_fatalErrorHandler;

	// Now copy all our imported functions
	memcpy(&_PM_imports,pmImp,MIN(sizeof(_PM_imports),pmImp->dwSize));
	memcpy(&_MESA_imports,glImp,MIN(sizeof(_MESA_imports),glImp->dwSize));

	// Now copy out exported functions
	memcpy(glExp,&_MESA_exports,MIN(sizeof(_MESA_exports),glExp->dwSize));
	return &_MGL_glFuncs;
}
