/****************************************************************************
*
*                 High Speed Fixed/Floating Point Library
*
*  ========================================================================
*
*    The contents of this file are subject to the SciTech MGL Public
*    License Version 1.0 (the "License"); you may not use this file
*    except in compliance with the License. You may obtain a copy of
*    the License at http://www.scitechsoft.com/mgl-license.txt
*
*    Software distributed under the License is distributed on an
*    "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
*    implied. See the License for the specific language governing
*    rights and limitations under the License.
*
*    The Original Code is Copyright (C) 1991-1998 SciTech Software, Inc.
*
*    The Initial Developer of the Original Code is SciTech Software, Inc.
*    All Rights Reserved.
*
*  ========================================================================
*
*
* Language:     C++ 3.0
* Environment:  any
*
* Description:  Lookup tables used by low level assembler routines.
*
*
****************************************************************************/

/* Table of normalised fixed point square root values */

unsigned long FXsqrt_table[] = {
    0x00800000L, 0x00807FC0L, 0x0080FF02L, 0x00817DC7L, 
    0x0081FC10L, 0x008279DFL, 0x0082F734L, 0x00837413L, 
    0x0083F07BL, 0x00846C6FL, 0x0084E7EEL, 0x008562FCL, 
    0x0085DD98L, 0x008657C5L, 0x0086D182L, 0x00874AD3L, 
    0x0087C3B6L, 0x00883C2FL, 0x0088B43DL, 0x00892BE3L, 
    0x0089A320L, 0x008A19F6L, 0x008A9067L, 0x008B0672L, 
    0x008B7C1AL, 0x008BF15EL, 0x008C6641L, 0x008CDAC3L, 
    0x008D4EE4L, 0x008DC2A7L, 0x008E360BL, 0x008EA912L, 
    0x008F1BBDL, 0x008F8E0CL, 0x00900000L, 0x0090719AL, 
    0x0090E2DCL, 0x009153C4L, 0x0091C456L, 0x00923491L, 
    0x0092A476L, 0x00931406L, 0x00938341L, 0x0093F229L, 
    0x009460BEL, 0x0094CF01L, 0x00953CF2L, 0x0095AA92L, 
    0x009617E3L, 0x009684E4L, 0x0096F196L, 0x00975DFAL, 
    0x0097CA11L, 0x009835DCL, 0x0098A15AL, 0x00990C8CL, 
    0x00997774L, 0x0099E211L, 0x009A4C65L, 0x009AB66FL, 
    0x009B2032L, 0x009B89ACL, 0x009BF2DFL, 0x009C5BCBL, 
    0x009CC471L, 0x009D2CD1L, 0x009D94ECL, 0x009DFCC2L, 
    0x009E6455L, 0x009ECBA4L, 0x009F32AFL, 0x009F9979L, 
    0x00A00000L, 0x00A06646L, 0x00A0CC4AL, 0x00A1320EL, 
    0x00A19792L, 0x00A1FCD7L, 0x00A261DCL, 0x00A2C6A3L, 
    0x00A32B2BL, 0x00A38F75L, 0x00A3F383L, 0x00A45753L, 
    0x00A4BAE7L, 0x00A51E3EL, 0x00A5815AL, 0x00A5E43BL, 
    0x00A646E1L, 0x00A6A94DL, 0x00A70B7FL, 0x00A76D77L, 
    0x00A7CF36L, 0x00A830BCL, 0x00A8920AL, 0x00A8F31FL, 
    0x00A953FDL, 0x00A9B4A4L, 0x00AA1514L, 0x00AA754DL, 
    0x00AAD550L, 0x00AB351DL, 0x00AB94B5L, 0x00ABF417L, 
    0x00AC5345L, 0x00ACB23EL, 0x00AD1104L, 0x00AD6F95L, 
    0x00ADCDF3L, 0x00AE2C1EL, 0x00AE8A16L, 0x00AEE7DBL, 
    0x00AF456FL, 0x00AFA2D0L, 0x00B00000L, 0x00B05CFFL, 
    0x00B0B9CCL, 0x00B1166AL, 0x00B172D6L, 0x00B1CF13L, 
    0x00B22B20L, 0x00B286FEL, 0x00B2E2ACL, 0x00B33E2CL, 
    0x00B3997CL, 0x00B3F49FL, 0x00B44F93L, 0x00B4AA5AL, 

    0x00B504F3L, 0x00B5B99EL, 0x00B66D96L, 0x00B720DDL, 
    0x00B7D375L, 0x00B88560L, 0x00B936A1L, 0x00B9E738L, 
    0x00BA9728L, 0x00BB4673L, 0x00BBF51BL, 0x00BCA321L, 
    0x00BD5087L, 0x00BDFD4EL, 0x00BEA979L, 0x00BF5509L, 
    0x00C00000L, 0x00C0AA5FL, 0x00C15428L, 0x00C1FD5CL, 
    0x00C2A5FEL, 0x00C34E0DL, 0x00C3F58DL, 0x00C49C7EL, 
    0x00C542E1L, 0x00C5E8B9L, 0x00C68E06L, 0x00C732CAL, 
    0x00C7D706L, 0x00C87ABCL, 0x00C91DECL, 0x00C9C098L, 
    0x00CA62C2L, 0x00CB046AL, 0x00CBA592L, 0x00CC463AL, 
    0x00CCE665L, 0x00CD8613L, 0x00CE2545L, 0x00CEC3FCL, 
    0x00CF623AL, 0x00D00000L, 0x00D09D4EL, 0x00D13A26L, 
    0x00D1D689L, 0x00D27278L, 0x00D30DF3L, 0x00D3A8FDL, 
    0x00D44395L, 0x00D4DDBCL, 0x00D57775L, 0x00D610BFL, 
    0x00D6A99BL, 0x00D7420BL, 0x00D7DA10L, 0x00D871A9L, 
    0x00D908D9L, 0x00D99FA0L, 0x00DA35FEL, 0x00DACBF5L, 
    0x00DB6186L, 0x00DBF6B1L, 0x00DC8B77L, 0x00DD1FD9L, 
    0x00DDB3D7L, 0x00DE4773L, 0x00DEDAAEL, 0x00DF6D87L, 
    0x00E00000L, 0x00E09219L, 0x00E123D4L, 0x00E1B531L, 
    0x00E24630L, 0x00E2D6D3L, 0x00E36719L, 0x00E3F704L, 
    0x00E48695L, 0x00E515CCL, 0x00E5A4A9L, 0x00E6332EL, 
    0x00E6C15AL, 0x00E74F2FL, 0x00E7DCAEL, 0x00E869D6L, 
    0x00E8F6A9L, 0x00E98327L, 0x00EA0F50L, 0x00EA9B26L, 
    0x00EB26A9L, 0x00EBB1D9L, 0x00EC3CB7L, 0x00ECC744L, 
    0x00ED517FL, 0x00EDDB6BL, 0x00EE6507L, 0x00EEEE53L, 
    0x00EF7751L, 0x00F00000L, 0x00F08862L, 0x00F11076L, 
    0x00F1983EL, 0x00F21FBAL, 0x00F2A6EAL, 0x00F32DCFL, 
    0x00F3B46AL, 0x00F43ABAL, 0x00F4C0C0L, 0x00F5467EL, 
    0x00F5CBF2L, 0x00F6511EL, 0x00F6D603L, 0x00F75AA0L, 
    0x00F7DEF6L, 0x00F86305L, 0x00F8E6CEL, 0x00F96A52L, 
    0x00F9ED91L, 0x00FA708BL, 0x00FAF340L, 0x00FB75B1L, 
    0x00FBF7DFL, 0x00FC79CAL, 0x00FCFB72L, 0x00FD7CD8L, 
    0x00FDFDFCL, 0x00FE7EDEL, 0x00FEFF7FL, 0x00FF7FE0L, 
    0x00FFFFFF};

/* Table of normalised fixed point common logarithms */

unsigned short FXlog10_table[] = {
    0x0000, 0x00DD, 0x01B9, 0x0293, 0x036B, 0x0442, 0x0517, 0x05EB, 
    0x06BD, 0x078E, 0x085D, 0x092A, 0x09F6, 0x0AC1, 0x0B8A, 0x0C51, 
    0x0D18, 0x0DDD, 0x0EA0, 0x0F63, 0x1024, 0x10E3, 0x11A2, 0x125F, 
    0x131B, 0x13D5, 0x148F, 0x1547, 0x15FE, 0x16B4, 0x1769, 0x181C, 
    0x18CF, 0x1980, 0x1A30, 0x1ADF, 0x1B8D, 0x1C3A, 0x1CE6, 0x1D91, 
    0x1E3B, 0x1EE4, 0x1F8C, 0x2033, 0x20D9, 0x217E, 0x2222, 0x22C5, 
    0x2367, 0x2409, 0x24A9, 0x2548, 0x25E7, 0x2685, 0x2721, 0x27BD, 
    0x2858, 0x28F3, 0x298C, 0x2A25, 0x2ABD, 0x2B54, 0x2BEA, 0x2C7F, 
    0x2D14, 0x2DA8, 0x2E3B, 0x2ECD, 0x2F5F, 0x2FF0, 0x3080, 0x310F, 
    0x319E, 0x322C, 0x32B9, 0x3345, 0x33D1, 0x345C, 0x34E7, 0x3571, 
    0x35FA, 0x3682, 0x370A, 0x3792, 0x3818, 0x389E, 0x3923, 0x39A8, 
    0x3A2C, 0x3AB0, 0x3B32, 0x3BB5, 0x3C36, 0x3CB7, 0x3D38, 0x3DB8, 
    0x3E37, 0x3EB6, 0x3F34, 0x3FB2, 0x402F, 0x40AC, 0x4128, 0x41A3, 
    0x421E, 0x4298, 0x4312, 0x438C, 0x4405, 0x447D, 0x44F5, 0x456C, 
    0x45E3, 0x4659, 0x46CF, 0x4744, 0x47B9, 0x482E, 0x48A2, 0x4915, 
    0x4988, 0x49FB, 0x4A6D, 0x4ADE, 0x4B50, 0x4BC0, 0x4C31, 0x4CA0, 
    0x4D10, 
    };

/* Table of fixed point common logarithms for the powers of 2 */

unsigned long FXlog2_table[] = {
    0x00000000L, 0x00004D10L, 0x00009A20L, 0x0000E730L, 
    0x00013441L, 0x00018151L, 0x0001CE61L, 0x00021B72L, 
    0x00026882L, 0x0002B592L, 0x000302A3L, 0x00034FB3L, 
    0x00039CC3L, 0x0003E9D3L, 0x000436E4L, 0x000483F4L, 
    };

/* Table of fixed point sines between 0-90 degrees */

unsigned long FXsin_table[] = {
    0x0000, 0x0192, 0x0324, 0x04B6, 0x0648, 0x07DA, 0x096C, 0x0AFE, 
    0x0C8F, 0x0E21, 0x0FB2, 0x1144, 0x12D5, 0x1466, 0x15F6, 0x1787, 
    0x1917, 0x1AA7, 0x1C37, 0x1DC7, 0x1F56, 0x20E5, 0x2273, 0x2402, 
    0x2590, 0x271D, 0x28AA, 0x2A37, 0x2BC4, 0x2D50, 0x2EDB, 0x3066, 
    0x31F1, 0x337B, 0x3505, 0x368E, 0x3817, 0x399F, 0x3B26, 0x3CAD, 
    0x3E33, 0x3FB9, 0x413E, 0x42C3, 0x4447, 0x45CA, 0x474D, 0x48CE, 
    0x4A50, 0x4BD0, 0x4D50, 0x4ECF, 0x504D, 0x51CA, 0x5347, 0x54C3, 
    0x563E, 0x57B8, 0x5931, 0x5AAA, 0x5C22, 0x5D98, 0x5F0E, 0x6083, 
    0x61F7, 0x636A, 0x64DC, 0x664D, 0x67BD, 0x692D, 0x6A9B, 0x6C08, 
    0x6D74, 0x6EDF, 0x7049, 0x71B1, 0x7319, 0x7480, 0x75E5, 0x774A, 
    0x78AD, 0x7A0F, 0x7B70, 0x7CD0, 0x7E2E, 0x7F8B, 0x80E7, 0x8242, 
    0x839C, 0x84F4, 0x864B, 0x87A1, 0x88F5, 0x8A48, 0x8B9A, 0x8CEA, 
    0x8E39, 0x8F87, 0x90D3, 0x921E, 0x9368, 0x94B0, 0x95F6, 0x973C, 
    0x987F, 0x99C2, 0x9B02, 0x9C42, 0x9D7F, 0x9EBC, 0x9FF6, 0xA12F, 
    0xA267, 0xA39D, 0xA4D2, 0xA605, 0xA736, 0xA866, 0xA994, 0xAAC0, 
    0xABEB, 0xAD14, 0xAE3B, 0xAF61, 0xB085, 0xB1A8, 0xB2C8, 0xB3E7, 
    0xB504, 0xB620, 0xB73A, 0xB852, 0xB968, 0xBA7C, 0xBB8F, 0xBCA0, 
    0xBDAE, 0xBEBC, 0xBFC7, 0xC0D0, 0xC1D8, 0xC2DE, 0xC3E2, 0xC4E3, 
    0xC5E4, 0xC6E2, 0xC7DE, 0xC8D8, 0xC9D1, 0xCAC7, 0xCBBB, 0xCCAE, 
    0xCD9F, 0xCE8D, 0xCF7A, 0xD064, 0xD14D, 0xD233, 0xD318, 0xD3FA, 
    0xD4DB, 0xD5B9, 0xD695, 0xD770, 0xD848, 0xD91E, 0xD9F2, 0xDAC4, 
    0xDB94, 0xDC61, 0xDD2D, 0xDDF6, 0xDEBE, 0xDF83, 0xE046, 0xE106, 
    0xE1C5, 0xE282, 0xE33C, 0xE3F4, 0xE4AA, 0xE55E, 0xE60F, 0xE6BE, 
    0xE76B, 0xE816, 0xE8BF, 0xE965, 0xEA09, 0xEAAB, 0xEB4B, 0xEBE8, 
    0xEC83, 0xED1C, 0xEDB2, 0xEE46, 0xEED8, 0xEF68, 0xEFF5, 0xF080, 
    0xF109, 0xF18F, 0xF213, 0xF294, 0xF314, 0xF391, 0xF40B, 0xF484, 
    0xF4FA, 0xF56D, 0xF5DE, 0xF64D, 0xF6BA, 0xF724, 0xF78B, 0xF7F1, 
    0xF853, 0xF8B4, 0xF912, 0xF96E, 0xF9C7, 0xFA1E, 0xFA73, 0xFAC5, 
    0xFB14, 0xFB61, 0xFBAC, 0xFBF5, 0xFC3B, 0xFC7E, 0xFCBF, 0xFCFE, 
    0xFD3A, 0xFD74, 0xFDAB, 0xFDE0, 0xFE13, 0xFE43, 0xFE70, 0xFE9B, 
    0xFEC4, 0xFEEA, 0xFF0E, 0xFF2F, 0xFF4E, 0xFF6A, 0xFF84, 0xFF9C, 
    0xFFB1, 0xFFC3, 0xFFD3, 0xFFE1, 0xFFEC, 0xFFF4, 0xFFFB, 0xFFFE, 
    0x10000L, 0x10000L};

/* Table of fixed point arc tangents between 0-90 degrees */

unsigned long FXatan_table[] = {
    0x00000000L, 0x0000394BL, 0x00007296L, 0x0000ABE1L, 
    0x0000E52AL, 0x00011E71L, 0x000157B6L, 0x000190F8L, 
    0x0001CA37L, 0x00020373L, 0x00023CAAL, 0x000275DDL, 
    0x0002AF0BL, 0x0002E834L, 0x00032157L, 0x00035A74L, 
    0x0003938AL, 0x0003CC99L, 0x000405A1L, 0x00043EA0L, 
    0x00047797L, 0x0004B085L, 0x0004E96AL, 0x00052246L, 
    0x00055B17L, 0x000593DDL, 0x0005CC99L, 0x00060549L, 
    0x00063DEEL, 0x00067686L, 0x0006AF11L, 0x0006E790L, 
    0x00072001L, 0x00075864L, 0x000790B8L, 0x0007C8FEL, 
    0x00080135L, 0x0008395DL, 0x00087174L, 0x0008A97CL, 
    0x0008E172L, 0x00091958L, 0x0009512CL, 0x000988EEL, 
    0x0009C09EL, 0x0009F83CL, 0x000A2FC6L, 0x000A673EL, 
    0x000A9EA1L, 0x000AD5F1L, 0x000B0D2CL, 0x000B4452L, 
    0x000B7B63L, 0x000BB25FL, 0x000BE945L, 0x000C2015L, 
    0x000C56CEL, 0x000C8D70L, 0x000CC3FCL, 0x000CFA6FL, 
    0x000D30CBL, 0x000D670FL, 0x000D9D3BL, 0x000DD34DL, 
    0x000E0947L, 0x000E3F27L, 0x000E74EDL, 0x000EAA9AL, 
    0x000EE02CL, 0x000F15A4L, 0x000F4B01L, 0x000F8042L, 
    0x000FB569L, 0x000FEA73L, 0x00101F62L, 0x00105435L, 
    0x001088EBL, 0x0010BD84L, 0x0010F200L, 0x0011265FL, 
    0x00115AA1L, 0x00118EC5L, 0x0011C2CBL, 0x0011F6B2L, 
    0x00122A7CL, 0x00125E26L, 0x001291B2L, 0x0012C51FL, 
    0x0012F86CL, 0x00132B9AL, 0x00135EA8L, 0x00139196L, 
    0x0013C465L, 0x0013F713L, 0x001429A0L, 0x00145C0DL, 
    0x00148E58L, 0x0014C083L, 0x0014F28DL, 0x00152475L, 
    0x0015563CL, 0x001587E1L, 0x0015B964L, 0x0015EAC5L, 
    0x00161C04L, 0x00164D21L, 0x00167E1BL, 0x0016AEF3L, 
    0x0016DFA8L, 0x0017103AL, 0x001740A9L, 0x001770F5L, 
    0x0017A11EL, 0x0017D124L, 0x00180106L, 0x001830C5L, 
    0x00186060L, 0x00188FD7L, 0x0018BF2AL, 0x0018EE5AL, 
    0x00191D65L, 0x00194C4DL, 0x00197B10L, 0x0019A9AFL, 
    0x0019D829L, 0x001A067FL, 0x001A34B1L, 0x001A62BEL, 
    0x001A90A7L, 0x001ABE6BL, 0x001AEC0AL, 0x001B1984L, 
    0x001B46D9L, 0x001B740AL, 0x001BA116L, 0x001BCDFDL, 
    0x001BFABEL, 0x001C275BL, 0x001C53D3L, 0x001C8025L, 
    0x001CAC53L, 0x001CD85BL, 0x001D043EL, 0x001D2FFCL, 
    0x001D5B95L, 0x001D8709L, 0x001DB257L, 0x001DDD81L, 
    0x001E0885L, 0x001E3363L, 0x001E5E1DL, 0x001E88B1L, 
    0x001EB321L, 0x001EDD6BL, 0x001F078FL, 0x001F318FL, 
    0x001F5B69L, 0x001F851FL, 0x001FAEAFL, 0x001FD81AL, 
    0x00200160L, 0x00202A81L, 0x0020537DL, 0x00207C54L, 
    0x0020A507L, 0x0020CD94L, 0x0020F5FCL, 0x00211E40L, 
    0x0021465FL, 0x00216E59L, 0x0021962EL, 0x0021BDDFL, 
    0x0021E56BL, 0x00220CD2L, 0x00223415L, 0x00225B34L, 
    0x0022822EL, 0x0022A904L, 0x0022CFB6L, 0x0022F643L, 
    0x00231CACL, 0x002342F1L, 0x00236913L, 0x00238F10L, 
    0x0023B4E9L, 0x0023DA9FL, 0x00240031L, 0x0024259FL, 
    0x00244AE9L, 0x00247010L, 0x00249514L, 0x0024B9F4L, 
    0x0024DEB1L, 0x0025034BL, 0x002527C1L, 0x00254C15L, 
    0x00257046L, 0x00259453L, 0x0025B83EL, 0x0025DC07L, 
    0x0025FFACL, 0x00262330L, 0x00264690L, 0x002669CFL, 
    0x00268CEBL, 0x0026AFE5L, 0x0026D2BDL, 0x0026F573L, 
    0x00271807L, 0x00273A79L, 0x00275CC9L, 0x00277EF8L, 
    0x0027A106L, 0x0027C2F2L, 0x0027E4BDL, 0x00280667L, 
    0x002827EFL, 0x00284957L, 0x00286A9DL, 0x00288BC3L, 
    0x0028ACC8L, 0x0028CDADL, 0x0028EE71L, 0x00290F15L, 
    0x00292F98L, 0x00294FFCL, 0x0029703FL, 0x00299062L, 
    0x0029B066L, 0x0029D049L, 0x0029F00DL, 0x002A0FB2L, 
    0x002A2F37L, 0x002A4E9DL, 0x002A6DE4L, 0x002A8D0BL, 
    0x002AAC14L, 0x002ACAFEL, 0x002AE9C8L, 0x002B0875L, 
    0x002B2703L, 0x002B4572L, 0x002B63C3L, 0x002B81F6L, 
    0x002BA00AL, 0x002BBE01L, 0x002BDBDAL, 0x002BF995L, 
    0x002C1732L, 0x002C34B2L, 0x002C5215L, 0x002C6F5AL, 
    0x002C8C82L, 0x002CA98DL, 0x002CC67AL, 0x002CE34BL, 
    0x002D0000L, 0x002D0000L};
