/****************************************************************************
*
*                          Console Output Library
*
*  ========================================================================
*
*    The contents of this file are subject to the SciTech MGL Public
*    License Version 1.0 (the "License"); you may not use this file
*    except in compliance with the License. You may obtain a copy of
*    the License at http://www.scitechsoft.com/mgl-license.txt
*
*    Software distributed under the License is distributed on an
*    "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
*    implied. See the License for the specific language governing
*    rights and limitations under the License.
*
*    The Original Code is Copyright (C) 1991-1998 SciTech Software, Inc.
*
*    The Initial Developer of the Original Code is SciTech Software, Inc.
*    All Rights Reserved.
*
*  ========================================================================
*
* Language:     ANSI C
* Environment:  Any
*
* Description:  Main module for console manipulation module. This is a
*               small module for fast, compiler independant console
*               output routines. It has been modified to for use with
*               32 bit flat model compilers and the code is being made
*               freely available for use in the POVRay Ray Tracer.
*
*               Has also been completely re-written to only use direct
*               video output code, and to directly re-program the the VGA
*               graphics hardware rather than make use of the BIOS. Hence
*               this code is portable and will run on any system with
*               VGA compatible hardware.
*
****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <ctype.h>
#include "console.h"
#include "pmapi.h"

/*---------------------------- Global variables ---------------------------*/



/*---------------------------- Implementation -----------------------------*/

/****************************************************************************
PARAMETERS:
port    - I/O port to read value from

RETURNS:
Byte read from 'port'
****************************************************************************/
uchar PM_inpb(int port)
{
	int	retval;
	_asm
	{
		xor		eax,eax
		mov		edx,[port]
		in		al,dx
		mov		retval, eax
	}
	return retval;
}


/****************************************************************************
PARAMETERS:
port    - I/O port to write to
value   - Byte to write to port

REMARKS:
Writes a byte value to the 'port'
****************************************************************************/
void PM_outpb(int port,uchar value)
{
	_asm
	{
		mov		edx,[port]
		mov		al,[value]
		out		dx,al
	}
}


