/****************************************************************************
*
*                   SciTech Nucleus Graphics Architecture
*
*               Copyright (C) 1991-1998 SciTech Software, Inc.
*                            All rights reserved.
*
*  ======================================================================
*  |REMOVAL OR MODIFICATION OF THIS HEADER IS STRICTLY PROHIBITED BY LAW|
*  |                                                                    |
*  |This copyrighted computer code contains proprietary technology      |
*  |owned by SciTech Software, Inc., located at 505 Wall Street,        |
*  |Chico, CA 95928 USA (http://www.scitechsoft.com).                   |
*  |                                                                    |
*  |The contents of this file are subject to the SciTech Nucleus        |
*  |License; you may *not* use this file or related software except in  |
*  |compliance with the License. You may obtain a copy of the License   |
*  |at http://www.scitechsoft.com/nucleus-license.txt                   |
*  |                                                                    |
*  |Software distributed under the License is distributed on an         |
*  |"AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or      |
*  |implied. See the License for the specific language governing        |
*  |rights and limitations under the License.                           |
*  |                                                                    |
*  |REMOVAL OR MODIFICATION OF THIS HEADER IS STRICTLY PROHIBITED BY LAW|
*  ======================================================================
*
* Language:     ANSI C
* Environment:  Any 32-bit protected mode environment
*
* Description:  Simple module to directly load the GA_options structure
*               from disk to avoid loading Nucleus directly.
*
****************************************************************************/

#include "nucleus/graphics.h"
#if defined(__WIN32_VXD__) || defined(__NT_DRIVER__)
#include "sdd/sddhelp.h"
#else
#include <stdio.h>
#include <stdlib.h>
#endif

/*----------------------------- Implementation ----------------------------*/

#define DLL_NAME        "graphics.bpd"
#define OPTIONS_NAME    "options.dat"

/****************************************************************************
DESCRIPTION:
Reads the global options file directly from disk.

HEADER:
nucleus/graphics.h

PARAMETERS:
options - Place to store the returned options information

RETURNS:
False if no options file found.

REMARKS:
This function is similar to GA_getGlobalOptions, but it does not require
Nucleus to be loaded at all in order to read the global options file. This
is useful for situations where the memory footprint of loading Nucleus
needs to be avoided.

Note:   The dwSize member of the profile structure is intended for future
        compatibility, and must be set to the size of the structure before
        calling this function. Only the number of bytes set in the
        dwSize member will be copied into the callers structure.

SEE ALSO:
GA_getGlobalOptions, GA_setGlobalOptions, GA_saveGlobalOptions
****************************************************************************/
ibool NAPI GA_readGlobalOptions(
    GA_globalOptions *options)
{
    FILE    *f;
    char    filename[PM_MAX_PATH];
    int     size;

    // Find the Nucleus config path
    if (!PM_findBPD(DLL_NAME,filename))
        return false;
    filename[strlen(filename)-1] = 0;
    if (strcmp(filename,PM_getNucleusPath()) == 0)
        strcpy(filename,PM_getNucleusConfigPath());
    else {
        PM_backslash(filename);
        strcat(filename,"config");
        }
    PM_backslash(filename);

    // Read existing saved options from disk
    strcat(filename,OPTIONS_NAME);
    if ((f = fopen(filename,"rb")) != NULL) {
        size = MIN(sizeof(*options),options->dwSize);
        fread((void *) options,1,size,f);
        fclose(f);
        if (options->dwSize >= size)
            options->dwSize = size;
        return true;
        }
    return false;
}

