/*
 *	C4 -- CVS like front end to the Perforce p4 SCM tool.
 *
 * Copyright (c) 1998 - 2000, Neil Russell.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Neil Russell.
 * 4. The name Neil Russell may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY NEIL RUSSELL ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL NEIL RUSSELL BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 *	Main.
 */

#include	"defs.h"
#include	"version.h"

/**************************************************/
/*
 *	Support.
 */

void
Error(int flag, char * msg, ...)
{
	va_list		ap;

	va_start(ap, msg);
	fprintf(stderr, "c4: ");
	vfprintf(stderr, msg, ap);
	fprintf(stderr, "\n");
	va_end(ap);

	if (flag)
		perror("c4");

	exit(1);
}


void *
Alloc(unsigned int sz)
{
	void *		p;
	extern void *	malloc(unsigned int);

	p = malloc(sz);
	if (!p)
		Error(0, "Can't allocate memory");
	return p;
}


void *
ReAlloc(void * xp, unsigned int sz)
{
	void *		p;
	extern void *	realloc(void *, unsigned int);

	p = realloc(xp, sz);
	if (!p)
		Error(0, "Can't allocate memory");
	return p;
}

/**************************************************/

int
main(int argc, char ** argv)
{
	int		i;

	/*
	 *	Find the root directory of this client.
	 */
	FindRoot();

	/*
	 *	If we were given a command, see if it's one of ours.
	 */
	if (argv[1])
	{
		if (strcmp(argv[1], "-V") == 0)
		{
			printf("C4 version %s.", VERSIONSTR);
			printf("  Copyright (c) 1998-2000 Neil Russell.\n");
			exit(0);
		}
		else if (strcmp(argv[1], "-D") == 0)
			Debug++;
		else if (strcmp(argv[1], "scan") == 0)
			Scan(&argv[2]);
		else if (strcmp(argv[1], "import") == 0)
			Import(&argv[2]);
		else if (strcmp(argv[1], "update") == 0)
			Update(&argv[2]);
#if 0
		else if (strcmp(argv[1], "browse") == 0)
			Browse(&argv[2]);
		else if (strcmp(argv[1], "mkws") == 0)
			MakeWorkspace(&argv[2]);
#endif
	}

	/*
	 *	Not our command; pass it on to p4 itself.
	 */
	execvp(CmdP4, argv);
	Error(1, "execvp of p4 failed");
	/* NOTREACHED */
	return 9;
}
