/*
 *	C4 -- CVS like front end to the Perforce p4 SCM tool.
 *
 * Copyright (c) 1998 - 2000, Neil Russell.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Neil Russell.
 * 4. The name Neil Russell may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY NEIL RUSSELL ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL NEIL RUSSELL BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 *	Global information assimilation.
 */

#include	"defs.h"

/**************************************************/
/*
 *	Path name of the client root, the current directory path according
 *	to p4, and the length of the current directory path, excluding any
 *	'/' at the end (info given by "p4 info").
 */
char		ClientPath[1024];
int		ClientPathLen;
char		CurDir[1024];
int		CurDirLen;
int		UseDiffSC;		/* Use "p4 diff -sc" (97.3 and later) */


static void
client_path_func(char * l)
{
	if (strncmp(l, "Client root: ", 13) == 0)
	{
		strcpy(ClientPath, &l[13]);
		ClientPathLen = strlen(ClientPath);
		if (ClientPath[ClientPathLen - 1] == '/')
			ClientPath[--ClientPathLen] = '\0';
	}
	else if (strncmp(l, "Current directory: ", 19) == 0)
	{
		strcpy(CurDir, &l[19]);
		CurDirLen = strlen(CurDir);
		if (CurDir[CurDirLen - 1] == '/')
			CurDir[--CurDirLen] = '\0';
	}
	else if (strncmp(l, "Server version: ", 16) == 0)
	{
		int		y;
		int		c;

		/*
		 *	If we have a 97.3 or later server, we have
		 *	a "p4 diff -sc" command available, that combines
		 *	a "p4 diff -sa" with a "p4 diff -se".  We can
		 *	run one less command, speeding things a little.
		 */
#if 0	/* p4 diff -sc bug */
	/*
	 *	"p4 diff -sc" is incorrectly reporting differences on files
	 *	that not different but are out-of-date with respect to the
	 *	depot.
	 */
		if (sscanf(&l[16], "%*[^/]/%*[^/]/%d.%d/%*d", &y, &c) == 2 &&
		    (y >= 98 || c >= 3))
			UseDiffSC = 1;
#endif
	}
}


/*
 *	Get the client root path using "p4 info".  This is used to
 *	trim names given by the various p4 commands to get paths
 *	relative to the current directory.  The server version is
 *	also checked to see if we can use newer features of p4.
 */
void
GetClientPath(void)
{
	if (ClientPath[0])
		return;		/* Already have it */

	Command("info", client_path_func, 0);
	CommandDone();

	if (!ClientPath[0])
		Error(0, "Client path not defined");
}
