/*
 *	C4 -- CVS like front end to the Perforce p4 SCM tool.
 *
 * Copyright (c) 1998 - 2000, Neil Russell.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Neil Russell.
 * 4. The name Neil Russell may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY NEIL RUSSELL ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL NEIL RUSSELL BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 *		GLOBBING
 */

#include	"defs.h"
#include	<errno.h>

/**************************************************/
/*
 *	Return true if the given file name matches a spec on the
 *	given spec list.  If the given name has path components,
 *	match only the last component.  Shell like globbing is
 *	used.
 *
 *	This code was lifted from the FreeBSD /bin/sh file expand.c,
 *	and slightly modified (CTLESC and collation removed --
 *	ASCII only and no escaped control characters).
 */
/*
 * Copyright (c) 1985, 1987, 1988, 1993
 *      The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the University of
 *      California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

int
Glob(char * spec, char * name)
{
	char		c;

	for (;;)
	{
		switch (c = *spec++)
		{
		case '\0':
			goto breakloop;

		case '?':
			if (*name++ == '\0')
				return 0;
			break;

		case '*':
			c = *spec;
			if (c != '?' && c != '*' && c != '[')
			{
				while (*name != c)
				{
					if (*name == '\0')
						return 0;
					name++;
				}
			}
			do
			{
				if (Glob(spec, name))
					return 1;
			} while (*name++ != '\0');
			return 0;

		case '[': 
			{
				char *		endp;
				int		invert;
				int		found;
				char		chr;

				endp = spec;
				if (*endp == '!')
					endp++;
				for (;;)
				{
					if (*endp == '\0')
					{
						/* no matching ] */
						goto dft;
					}
					if (*++endp == ']')
						break;
				}
				invert = 0;
				if (*spec == '!')
				{
					invert++;
					spec++;
				}
				found = 0;
				chr = *name++;
				if (chr == '\0')
					return 0;
				c = *spec++;
				do
				{
				    if (*spec == '-' && spec[1] != ']')
				    {
					spec++;
					if (chr >= c && chr <= *spec)
						found = 1;
					spec++;
				    }
				    else
				    {
					if (chr == c)
						found = 1;
				    }
				} while ((c = *spec++) != ']');
				if (found == invert)
					return 0;
				break;
			}
		default:
		dft:            
			if (*name++ != c)
				return 0;
			break;
		}
	}
breakloop:
	if (*name != '\0')
		return 0;
	return 1;
}
