/****************************************************************************
*
*                   SciTech OS Portability Manager Library
*
*  ========================================================================
*
*    The contents of this file are subject to the SciTech MGL Public
*    License Version 1.0 (the "License"); you may not use this file
*    except in compliance with the License. You may obtain a copy of
*    the License at http://www.scitechsoft.com/mgl-license.txt
*
*    Software distributed under the License is distributed on an
*    "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
*    implied. See the License for the specific language governing
*    rights and limitations under the License.
*
*    The Original Code is Copyright (C) 1991-1998 SciTech Software, Inc.
*
*    The Initial Developer of the Original Code is SciTech Software, Inc.
*    All Rights Reserved.
*
*  ========================================================================
*
* Language:     ANSI C
* Environment:  Any
*
* Description:  Header file for the Zen Timer library. Provides a number
*               of routines to accurately time segments of code. A long
*               period timer is provided to time code that takes up to
*               one hour to execute, with microsecond precision, and an
*               ultra long period timer for timing code that takes up to
*               24 hours to execute (raytracing etc).
*
****************************************************************************/

#ifndef __ZTIMERC_H
#define __ZTIMERC_H

#include "cpuinfo.h"

/*--------------------- Macros and type definitions -----------------------*/

/****************************************************************************
REMARKS:
Defines the structure for an LZTimerObject which contains the starting and
ending timestamps for the timer. By putting the timer information into a
structure the Zen Timer can be used for multiple timers running
simultaneously.

HEADER:
ztimer.h

MEMBERS:
start   - Starting 64-bit timer count
end     - Ending 64-bit timer count
****************************************************************************/
typedef struct {
    CPU_largeInteger    start;
    CPU_largeInteger    end;
    } LZTimerObject;

/*-------------------------- Function Prototypes --------------------------*/

#define LZTIMER_RES     1e-6            /* Seconds in a tick            */

#ifdef  __cplusplus
extern "C" {            /* Use "C" linkage when in C++ mode */
#endif

/* Routine to initialise the library - you MUST call this first! */

void    ZAPI ZTimerInit(void);
void    ZAPI ZTimerInitExt(ibool accurate);

/* Long period timing routines (times up to 1 hour) */

void    ZAPI LZTimerOn(void);
ulong   ZAPI LZTimerLap(void);
void    ZAPI LZTimerOff(void);
ulong   ZAPI LZTimerCount(void);

/* Long period timing routines with passed in timer object */

void    ZAPI LZTimerOnExt(LZTimerObject *tm);
ulong   ZAPI LZTimerLapExt(LZTimerObject *tm);
void    ZAPI LZTimerOffExt(LZTimerObject *tm);
ulong   ZAPI LZTimerCountExt(LZTimerObject *tm);

/* Ultra long period timing routines (times up to 65,000 hours) */

void    ZAPI ULZTimerOn(void);
ulong   ZAPI ULZTimerLap(void);
void    ZAPI ULZTimerOff(void);
ulong   ZAPI ULZTimerCount(void);
ulong   ZAPI ULZReadTime(void);
ulong   ZAPI ULZElapsedTime(ulong start,ulong finish);
void    ZAPI ULZTimerResolution(ulong *resolution);

#ifdef  __cplusplus
}                       /* End of "C" linkage for C++   */
#endif

#endif  /* __ZTIMERC_H */

