/****************************************************************************
*
*                   SciTech OS Portability Manager Library
*
*  ========================================================================
*
*    The contents of this file are subject to the SciTech MGL Public
*    License Version 1.0 (the "License"); you may not use this file
*    except in compliance with the License. You may obtain a copy of
*    the License at http://www.scitechsoft.com/mgl-license.txt
*
*    Software distributed under the License is distributed on an
*    "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
*    implied. See the License for the specific language governing
*    rights and limitations under the License.
*
*    The Original Code is Copyright (C) 1991-1998 SciTech Software, Inc.
*
*    The Initial Developer of the Original Code is SciTech Software, Inc.
*    All Rights Reserved.
*
*  ========================================================================
*
* Language:     ANSI C
* Environment:  32-bit OS/2 VDD
*
* Description:  C library compatible I/O functions for use within a VDD.
*
****************************************************************************/

#ifndef __VDDFILE_H
#define __VDDFILE_H

/*---------------------- Macros and type definitions ----------------------*/

typedef struct {
    int     handle;
    int     writemode;
    int     text;
    int     unputc;
    long    offset;
    long    filesize;
    char    buf[2048];
    char    *startp;
    char    *curp;
    char    *endp;
    } FILE;

/*------------------------- Function Prototypes ---------------------------*/

FILE *  fopen( const char *__filename, const char *__mode );
size_t  fread( void *__ptr, size_t __size, size_t __n, FILE *__fp );
size_t  fwrite( const void *__ptr, size_t __size, size_t __n, FILE *__fp );
int     fflush( FILE *__fp );
int     fseek( FILE *__fp, long int __offset, int __whence );
long    ftell( FILE *__fp );
int     feof( FILE *__fp );
int     fclose( FILE *__fp );
char *  fgets( char *__s, int __n, FILE *__fp );
int     fputs( const char *__s, FILE *__fp );

#endif  /* __VDDFILE_H */
