/****************************************************************************
*
*                   SciTech Nucleus Graphics Architecture
*
*               Copyright (C) 1991-1998 SciTech Software, Inc.
*                            All rights reserved.
*
*  ======================================================================
*  |REMOVAL OR MODIFICATION OF THIS HEADER IS STRICTLY PROHIBITED BY LAW|
*  |                                                                    |
*  |This copyrighted computer code contains proprietary technology      |
*  |owned by SciTech Software, Inc., located at 505 Wall Street,        |
*  |Chico, CA 95928 USA (http://www.scitechsoft.com).                   |
*  |                                                                    |
*  |The contents of this file are subject to the SciTech Nucleus        |
*  |License; you may *not* use this file or related software except in  |
*  |compliance with the License. You may obtain a copy of the License   |
*  |at http://www.scitechsoft.com/nucleus-license.txt                   |
*  |                                                                    |
*  |Software distributed under the License is distributed on an         |
*  |"AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or      |
*  |implied. See the License for the specific language governing        |
*  |rights and limitations under the License.                           |
*  |                                                                    |
*  |REMOVAL OR MODIFICATION OF THIS HEADER IS STRICTLY PROHIBITED BY LAW|
*  ======================================================================
*
* Language:     ANSI C
* Environment:  Any 32-bit protected mode environment
*
* Description:  Header file for the SciTech Nucleus Graphics Architecture
*               device driver Hardware Abstraction Layer.
*
*               Note that the Nucleus Graphics Architecture provides
*               support for multiple independant controllers and full plug
*               and play support. This allows for multiple drivers to
*               be present in a single system, and the proper driver will be
*               matched to the card's found in the system given the PCI
*               configuration ID's for the cards.
*
*               ISA and VLB devices are only supported in single controller
*               mode.
*
****************************************************************************/

#ifndef __NUCLEUS_GRAPHICS_H
#define __NUCLEUS_GRAPHICS_H

#include "nucleus/monitor.h"
#include "drvlib/peloader.h"
#include "ztimerc.h"

/*---------------------- Macros and type definitions ----------------------*/

#pragma pack(1)

/* Signature for the graphics driver file */

#define GA_SIGNATURE            "GRAPHICS"

/* Define the interface version */

#define GA_VERSION              0x109

/* Define the maximum number of chained filter drivers */

#define GA_MAX_FILTERS          8

/* Define the maximum number of virtual displays */

#define GA_MAX_VIRTUAL_DISPLAYS 16

/* Define the maximum number of multiple heads supported */

#define GA_MAX_HEADS            4

/* Define the flag to enable mixed mode for GA_setActiveDevice */

#define GA_DEVICE_MIXED_MODE    0x80

/****************************************************************************
REMARKS:
This enumeration defines the identifiers used to obtain the device context
function group pointer structures. As new features and capabilities are
added to the future versions of the specification, new identifiers will
be added to extract new function pointers from the drivers.

The GA_GET_FIRST_OEM defines the first identifier for OEM extensions. OEM's
are free to added their own private functional extensions to the drivers
as desired. Note that OEM's must verify the presence of their OEM drivers
via the the OemVendorName string before attempting to use OEM extension
functions.

HEADER:
nucleus/graphics.h

MEMBERS:
GA_GET_RESERVED             - Reserved value
GA_GET_INITFUNCS            - Get GA_initFuncs structure
GA_GET_DRIVERFUNCS          - Get GA_driverFuncs structure
GA_GET_CURSORFUNCS          - Get GA_cursorFuncs structure
GA_GET_VIDEOFUNCS           - Get GA_videoFuncs strucure
GA_GET_DPMSFUNCS            - Get GA_DPMSFuncs structure
GA_GET_SCIFUNCS             - Get GA_SCIFuncs structure
GA_GET_2DSTATEFUNCS         - Get GA_2DStateFuncs structure
GA_GET_2DRENDERFUNCS        - Get GA_2DRenderFuncs structure
GA_GET_3DSETUPFUNCS         - Get GA_3DSetupFuncs structure
GA_GET_3DSTATEFUNCS         - Get GA_3DStateFuncs structure
GA_GET_3DRENDERFUNCS        - Get GA_3DRenderFuncs structure
GA_GET_D3DRENDERFUNCS       - Get GA_D3DRenderFuncs structure
GA_GET_VBEFUNCS             - Get GA_VBEFuncs structure
GA_GET_REGIONFUNCS          - Get GA_regionFuncs structure
GA_GET_BUFFERFUNCS          - Get GA_bufferFuncs structure
GA_GET_CLIPPERFUNCS         - Get GA_clipperFuncs structure
GA_GET_FIRST_OEM            - ID of first OEM extension function
****************************************************************************/
typedef enum {
    GA_GET_RESERVED,
    GA_GET_INITFUNCS,
    GA_GET_DRIVERFUNCS,
    GA_GET_CURSORFUNCS,
    GA_GET_VIDEOFUNCS,
    GA_GET_DPMSFUNCS,
    GA_GET_SCIFUNCS,
    GA_GET_2DSTATEFUNCS,
    GA_GET_2DRENDERFUNCS,
    GA_GET_3DSETUPFUNCS,
    GA_GET_3DSTATEFUNCS,
    GA_GET_3DRENDERFUNCS,
    GA_GET_D3DRENDERFUNCS,
    GA_GET_VBEFUNCS,
    GA_GET_REGIONFUNCS,
    GA_GET_BUFFERFUNCS,
    GA_GET_CLIPPERFUNCS,
    GA_GET_FIRST_OEM                = 0x00010000
    } GA_funcGroupsType;

/****************************************************************************
REMARKS:
This enumeration defines the values stored in the BusType field of the
GA_devCtx structure.

HEADER:
nucleus/graphics.h

MEMBERS:
gaUnknownBus    - Bus type is not known
gaISABus        - Device is an ISA bus device
gaMCABus        - Device is a Micro-Channel bus device
gaVLBBus        - Device is a VESA Local Bus device
gaPCIBus        - Device is a PCI bus device
gaAGPBus        - Device is an AGP bus device
****************************************************************************/
typedef enum {
    gaUnknownBus                    = 0,
    gaISABus                        = 1,
    gaMCABus                        = 2,
    gaVLBBus                        = 3,
    gaPCIBus                        = 4,
    gaAGPBus                        = 5
    } GA_busType;

/****************************************************************************
REMARKS:
This enumeration defines the flags for combining with graphics mode numbers
to be passed to the SetVideoMode function.

HEADER:
nucleus/graphics.h

MEMBERS:
gaDontClear         - Don't clear display memory
gaLinearBuffer      - Enable linear framebuffer mode
ga6BitDAC           - Set the mode with a 6-bit RAMDAC instead of 8
gaNoAccel           - Set the mode without any acceleration support
gaRefreshCtrl       - Enable refresh rate control
gaWindowedMode      - Initialise for use in the current desktop mode
gaInitOnly          - Initialise the driver internals, but don't program hardware
gaModeMask          - Mask to remove flags and extract VBE mode number
****************************************************************************/
typedef enum {
    gaDontClear                     = 0x8000,
    gaLinearBuffer                  = 0x4000,
    ga6BitDAC                       = 0x2000,
    gaNoAccel                       = 0x1000,
    gaRefreshCtrl                   = 0x0800,
    gaWindowedMode                  = 0x0400,
    gaInitOnly                      = 0x0200,
    gaModeMask                      = 0x01FF
    } GA_modeFlagsType;

/****************************************************************************
REMARKS:
Logical mix operation codes for accelerated rendering functions that
support mixes. The set of mix codes is the standard Microsoft Raster
Operation (ROP2) codes between two values. We define our ROP2 codes as being
between the source and destination pixels for blt's, between the foreground
or background color and the destination pixels for solid and mono pattern
fills and between the pattern pixels and the destination pixels for color
pattern fills. It is up to the driver to do any necessary translation
between these generic ROP2 codes and each different type of hardware mix
code internally. Next to each code is the equivalent Microsoft defined ROP3
code between source and destination pixels.

Note:   Some graphics controllers may not support all mix codes, so you must
        use the GetMixTable function to determine the set of mix codes that
        the controller supports. Setting a mix code that is not listed in
        the returned mix table will result in undefined behaviour.

HEADER:
nucleus/graphics.h

MEMBERS:
GA_R2_BLACK         - 0
GA_R2_NOTMERGESRC   - DSon
GA_R2_MASKNOTSRC    - DSna
GA_R2_NOTCOPYSRC    - Sn
GA_R2_MASKSRCNOT    - SDna
GA_R2_NOT           - Dn
GA_R2_XORSRC        - DSx
GA_R2_NOTMASKSRC    - DSan
GA_R2_MASKSRC       - DSa
GA_R2_NOTXORSRC     - DSxn
GA_R2_NOP           - D
GA_R2_MERGENOTSRC   - DSno
GA_R2_COPYSRC       - S
GA_R2_MERGESRCNOT   - SDno
GA_R2_MERGESRC      - DSo
GA_R2_WHITE         - 1
GA_REPLACE_MIX      - Replace mode
GA_AND_MIX          - AND mode
GA_OR_MIX           - OR mode
GA_XOR_MIX          - XOR mode
GA_NOP_MIX          - Destination pixel unchanged
****************************************************************************/
typedef enum {
    GA_R2_BLACK,
    GA_R2_NOTMERGESRC,
    GA_R2_MASKNOTSRC,
    GA_R2_NOTCOPYSRC,
    GA_R2_MASKSRCNOT,
    GA_R2_NOT,
    GA_R2_XORSRC,
    GA_R2_NOTMASKSRC,
    GA_R2_MASKSRC,
    GA_R2_NOTXORSRC,
    GA_R2_NOP,
    GA_R2_MERGENOTSRC,
    GA_R2_COPYSRC,
    GA_R2_MERGESRCNOT,
    GA_R2_MERGESRC,
    GA_R2_WHITE,
    GA_REPLACE_MIX = GA_R2_COPYSRC,
    GA_AND_MIX     = GA_R2_MASKSRC,
    GA_OR_MIX      = GA_R2_MERGESRC,
    GA_XOR_MIX     = GA_R2_XORSRC,
    GA_NOP_MIX     = GA_R2_NOP
    } GA_mixCodesType;

/****************************************************************************
REMARKS:
Raster Operation codes for accelerated rendering functions that support
ternary operations. The set of mix codes is the standard Microsoft ternary
Raster Operation (ROP3) codes between three values, a source, pattern and
destination. Note that we don't list the codes here for brevity.

Note:   Some graphics controllers may not support all ROP3 codes due to
        hardware bugs, so you must use the GetROP3ExceptionTable function to
        determine the set of ROP3 codes that the hardware does not properly
        handle.

HEADER:
nucleus/graphics.h
****************************************************************************/
typedef enum {
    GA_R3_0,
    GA_R3_DPSoon,
    GA_R3_DPSona,
    GA_R3_PSon,
    GA_R3_SDPona,
    GA_R3_DPon,
    GA_R3_PDSxnon,
    GA_R3_PDSaon,
    GA_R3_SDPnaa,
    GA_R3_PDSxon,
    GA_R3_DPna,
    GA_R3_PSDnaon,
    GA_R3_SPna,
    GA_R3_PDSnaon,
    GA_R3_PDSonon,
    GA_R3_Pn,
    GA_R3_PDSona,
    GA_R3_DSon,
    GA_R3_SDPxnon,
    GA_R3_SDPaon,
    GA_R3_DPSxnon,
    GA_R3_DPSaon,
    GA_R3_PSDPSanaxx,
    GA_R3_SSPxDSxaxn,
    GA_R3_SPxPDxa,
    GA_R3_SDPSanaxn,
    GA_R3_PDSPaox,
    GA_R3_SDPSxaxn,
    GA_R3_PSDPaox,
    GA_R3_DSPDxaxn,
    GA_R3_PDSox,
    GA_R3_PDSoan,
    GA_R3_DPSnaa,
    GA_R3_SDPxon,
    GA_R3_DSna,
    GA_R3_SPDnaon,
    GA_R3_SPxDSxa,
    GA_R3_PDSPanaxn,
    GA_R3_SDPSaox,
    GA_R3_SDPSxnox,
    GA_R3_DPSxa,
    GA_R3_PSDPSaox,
    GA_R3_DPSana,
    GA_R3_SSPxPDxaxn,
    GA_R3_SPDSoax,
    GA_R3_PSDnox,
    GA_R3_PSDPxox,
    GA_R3_PSDnoan,
    GA_R3_PSna,
    GA_R3_SDPnaon,
    GA_R3_SDPSoox,
    GA_R3_Sn,
    GA_R3_SPDSaox,
    GA_R3_SPDSxnox,
    GA_R3_SDPox,
    GA_R3_SDPoan,
    GA_R3_PSDPoax,
    GA_R3_SPDnox,
    GA_R3_SPDSxox,
    GA_R3_SPDnoan,
    GA_R3_PSx,
    GA_R3_SPDSonox,
    GA_R3_SPDSnaox,
    GA_R3_PSan,
    GA_R3_PSDnaa,
    GA_R3_DPSxon,
    GA_R3_SDxPDxa,
    GA_R3_SPDSanaxn,
    GA_R3_SDna,
    GA_R3_DPSnaon,
    GA_R3_DSPDaox,
    GA_R3_PSDPxaxn,
    GA_R3_SDPxa,
    GA_R3_PDSPDaoxxn,
    GA_R3_DPSDoax,
    GA_R3_PDSnox,
    GA_R3_SDPana,
    GA_R3_SSPxDSxoxn,
    GA_R3_PDSPxox,
    GA_R3_PDSnoan,
    GA_R3_PDna,
    GA_R3_DSPnaon,
    GA_R3_DPSDaox,
    GA_R3_SPDSxaxn,
    GA_R3_DPSonon,
    GA_R3_Dn,
    GA_R3_DPSox,
    GA_R3_DPSoan,
    GA_R3_PDSPoax,
    GA_R3_DPSnox,
    GA_R3_DPx,
    GA_R3_DPSDonox,
    GA_R3_DPSDxox,
    GA_R3_DPSnoan,
    GA_R3_DPSDnaox,
    GA_R3_DPan,
    GA_R3_PDSxa,
    GA_R3_DSPDSaoxxn,
    GA_R3_DSPDoax,
    GA_R3_SDPnox,
    GA_R3_SDPSoax,
    GA_R3_DSPnox,
    GA_R3_DSx,
    GA_R3_SDPSonox,
    GA_R3_DSPDSonoxxn,
    GA_R3_PDSxxn,
    GA_R3_DPSax,
    GA_R3_PSDPSoaxxn,
    GA_R3_SDPax,
    GA_R3_PDSPDoaxxn,
    GA_R3_SDPSnoax,
    GA_R3_PDSxnan,
    GA_R3_PDSana,
    GA_R3_SSDxPDxaxn,
    GA_R3_SDPSxox,
    GA_R3_SDPnoan,
    GA_R3_DSPDxox,
    GA_R3_DSPnoan,
    GA_R3_SDPSnaox,
    GA_R3_DSan,
    GA_R3_PDSax,
    GA_R3_DSPDSoaxxn,
    GA_R3_DPSDnoax,
    GA_R3_SDPxnan,
    GA_R3_SPDSnoax,
    GA_R3_DPSxnan,
    GA_R3_SPxDSxo,
    GA_R3_DPSaan,
    GA_R3_DPSaa,
    GA_R3_SPxDSxon,
    GA_R3_DPSxna,
    GA_R3_SPDSnoaxn,
    GA_R3_SDPxna,
    GA_R3_PDSPnoaxn,
    GA_R3_DSPDSoaxx,
    GA_R3_PDSaxn,
    GA_R3_DSa,
    GA_R3_SDPSnaoxn,
    GA_R3_DSPnoa,
    GA_R3_DSPDxoxn,
    GA_R3_SDPnoa,
    GA_R3_SDPSxoxn,
    GA_R3_SSDxPDxax,
    GA_R3_PDSanan,
    GA_R3_PDSxna,
    GA_R3_SDPSnoaxn,
    GA_R3_DPSDPoaxx,
    GA_R3_SPDaxn,
    GA_R3_PSDPSoaxx,
    GA_R3_DPSaxn,
    GA_R3_DPSxx,
    GA_R3_PSDPSonoxx,
    GA_R3_SDPSonoxn,
    GA_R3_DSxn,
    GA_R3_DPSnax,
    GA_R3_SDPSoaxn,
    GA_R3_SPDnax,
    GA_R3_DSPDoaxn,
    GA_R3_DSPDSaoxx,
    GA_R3_PDSxan,
    GA_R3_DPa,
    GA_R3_PDSPnaoxn,
    GA_R3_DPSnoa,
    GA_R3_DPSDxoxn,
    GA_R3_PDSPonoxn,
    GA_R3_PDxn,
    GA_R3_DSPnax,
    GA_R3_PDSPoaxn,
    GA_R3_DPSoa,
    GA_R3_DPSoxn,
    GA_R3_D,
    GA_R3_DPSono,
    GA_R3_SPDSxax,
    GA_R3_DPSDaoxn,
    GA_R3_DSPnao,
    GA_R3_DPno,
    GA_R3_PDSnoa,
    GA_R3_PDSPxoxn,
    GA_R3_SSPxDSxox,
    GA_R3_SDPanan,
    GA_R3_PSDnax,
    GA_R3_DPSDoaxn,
    GA_R3_DPSDPaoxx,
    GA_R3_SDPxan,
    GA_R3_PSDPxax,
    GA_R3_DSPDaoxn,
    GA_R3_DPSnao,
    GA_R3_DSno,
    GA_R3_SPDSanax,
    GA_R3_SDxPDxan,
    GA_R3_DPSxo,
    GA_R3_DPSano,
    GA_R3_PSa,
    GA_R3_SPDSnaoxn,
    GA_R3_SPDSonoxn,
    GA_R3_PSxn,
    GA_R3_SPDnoa,
    GA_R3_SPDSxoxn,
    GA_R3_SDPnax,
    GA_R3_PSDPoaxn,
    GA_R3_SDPoa,
    GA_R3_SPDoxn,
    GA_R3_DPSDxax,
    GA_R3_SPDSaoxn,
    GA_R3_S,
    GA_R3_SDPono,
    GA_R3_SDPnao,
    GA_R3_SPno,
    GA_R3_PSDnoa,
    GA_R3_PSDPxoxn,
    GA_R3_PDSnax,
    GA_R3_SPDSoaxn,
    GA_R3_SSPxPDxax,
    GA_R3_DPSanan,
    GA_R3_PSDPSaoxx,
    GA_R3_DPSxan,
    GA_R3_PDSPxax,
    GA_R3_SDPSaoxn,
    GA_R3_DPSDanax,
    GA_R3_SPxDSxan,
    GA_R3_SPDnao,
    GA_R3_SDno,
    GA_R3_SDPxo,
    GA_R3_SDPano,
    GA_R3_PDSoa,
    GA_R3_PDSoxn,
    GA_R3_DSPDxax,
    GA_R3_PSDPaoxn,
    GA_R3_SDPSxax,
    GA_R3_PDSPaoxn,
    GA_R3_SDPSanax,
    GA_R3_SPxPDxan,
    GA_R3_SSPxDSxax,
    GA_R3_DSPDSanaxxn,
    GA_R3_DPSao,
    GA_R3_DPSxno,
    GA_R3_SDPao,
    GA_R3_SDPxno,
    GA_R3_DSo,
    GA_R3_SDPnoo,
    GA_R3_P,
    GA_R3_PDSono,
    GA_R3_PDSnao,
    GA_R3_PSno,
    GA_R3_PSDnao,
    GA_R3_PDno,
    GA_R3_PDSxo,
    GA_R3_PDSano,
    GA_R3_PDSao,
    GA_R3_PDSxno,
    GA_R3_DPo,
    GA_R3_DPSnoo,
    GA_R3_PSo,
    GA_R3_PSDnoo,
    GA_R3_DPSoo,
    GA_R3_1
    } GA_rop3CodesType;

/****************************************************************************
REMARKS:
Flags for 2D alpha blending functions supported by the nucleus drivers.
The values in here define the the alpha blending functions passed to
the srcBlendFunc and dstBlendFunc parameters ofo the SetBlendFunc function.
Essentially the blend function defines how to combine the source and
destination pixel color together to get the resulting destination color
during rendering. The formula used for this is defined as:

    DstColor = SrcColor * SrcFunc + DstColor * DstFunc;

If the source alpha blending function is set to gaBlendConstantAlpha, the
/SrcFunc/ above becomes:

    SrcFunc = ConstAlpha

If the destination alpha blending function is set to gaBlendOneMinusDstAlpha
then /DstFunc/ above becomes:

    DstFunc = (1-DstAlpha)

and the final equation becomes (note that each color channel is multiplied
individually):

    DstColor = SrcColor * ConstAlpha + DstColor * (1-DstAlpha)

Although the above is a completely contrived example, it does illustrate
how the functions defined below combine to allow you to build complex and
interesting blending functions. For simple source alpha transparency, the
following formula would usually be used:

    DstColor = SrcColor * SrcAlpha + DstColor * (1-SrcAlpha)

If you wish to use this type of blending and you do not care about the
resulting alpha channel information, you can set the optimised
gaBlendSrcAlphaFast blending mode. If you set both the source and
destination blending modes to this value, the above formula will
be used but an optimised fast path will be taken internally to make
this run as fast as possible. For normal blending operations this will
be much faster than setting the above formula manually. If however you need
the destination alpha to be preserved, you will need to use the slower
method instead.

For simple constant alpha transparency, the following formula would usually
be used:

    DstColor = SrcColor * ConstantAlpha + DstColor * (1-ConstantAlpha)

If you wish to use this type of blending and you do not care about the
resulting alpha channel information, you can set the optimised
gaBlendConstantAlphaFast blending mode. If you set both the source and
destination blending modes to this value, the above formula will
be used but an optimised fast path will be taken internally to make
this run as fast as possible. For normal blending operations this will
be much faster than setting the above formula manually. If however you need
the destination alpha to be preserved, you will need to use the slower
method instead.

Note:   All the above equations assume the color values and alpha values
        are in the range of 0 through 1 in floating point. In reality all
        blending is done with integer color and alpha components in the
        range of 0 to 255, when a value of 255 corresponds to a value of 1.0
        in the above equations.

Note:   The constant color value set by a call to SetForeColor, and the
        constant alpha value set by a call to SetAlphaValue.

Note:   Setting a blending function that uses the destination alpha
        components is only supported if the framebuffer currently supports
        destination alpha. Likewise setting a blending function that
        uses source alpha components is only supported if the framebuffer
        or incoming bitmap data contains an alpha channel. The results
        are undefined if these conditiions are not met.

Note:   Enabling source or destination alpha blending overrides the
        setting of the current mix mode. Logical mix modes and blending
        cannot be used at the same time.

HEADER:
nucleus/graphics.h

MEMBERS:
gaBlendNone                     - No alpha blending
gaBlendZero                     - Blend factor is always zero
gaBlendOne                      - Blend factor is always one
gaBlendSrcColor                 - Blend factor is source color
gaBlendOneMinusSrcColor         - Blend factor is 1-source color
gaBlendSrcAlpha                 - Blend factor is source alpha
gaBlendOneMinusSrcAlpha         - Blend factor is 1-source alpha
gaBlendDstAlpha                 - Blend factor is destination alpha
gaBlendOneMinusDstAlpha         - Blend factor is 1-destination alpha
gaBlendDstColor                 - Blend factor is destination color
gaBlendOneMinusDstColor         - Blend factor is 1-destination color
gaBlendSrcAlphaSaturate         - Blend factor is src alpha saturation
gaBlendConstantColor            - Blend factor is a constant color
gaBlendOneMinusConstantColor    - Blend factor is 1-constant color
gaBlendConstantAlpha            - Blend factor is constant alpha
gaBlendOneMinusConstantAlpha    - Blend factor is 1-constant alpha
gaBlendSrcAlphaFast             - Common case of optimised src alpha
gaBlendConstantAlphaFast        - Common case of optimised constant alpha
****************************************************************************/
typedef enum {
    gaBlendNone,
    gaBlendZero,
    gaBlendOne,
    gaBlendSrcColor,
    gaBlendOneMinusSrcColor,
    gaBlendSrcAlpha,
    gaBlendOneMinusSrcAlpha,
    gaBlendDstAlpha,
    gaBlendOneMinusDstAlpha,
    gaBlendDstColor,
    gaBlendOneMinusDstColor,
    gaBlendSrcAlphaSaturate,
    gaBlendConstantColor,
    gaBlendOneMinusConstantColor,
    gaBlendConstantAlpha,
    gaBlendOneMinusConstantAlpha,
    gaBlendSrcAlphaFast,
    gaBlendConstantAlphaFast
    } GA_blendFuncType;

/****************************************************************************
REMARKS:
Flags for the Attributes member of the GA_modeInfo structure and in the
Attributes member of the main GA_devCtx device context block structure. These
flags define the hardware capabilities of the particular device or graphics
mode.

The gaHaveDisplayStart flag is used to determine whether the graphics mode
supports changing the CRTC display start address. This is used to implement
hardware virtual scrolliong and multi-buffering for flicker free animation.
If this bit is 0, then the application cannot change the display start
address after initialising a display mode.

The gaHaveBankedBuffer flag is used to determine if the graphics mode
supports the banked framebuffer access modes. If this bit is 0, then the
application cannot use the banked framebuffer style access. Some controllers
may not support a banked framebuffer mode in some modes. In this case a
linear framebuffer mode will be provided (either a banked buffer or linear
buffer must be available for the mode to be valid).

The gaHaveLinearBuffer flag is used to determine if the graphics mode
supports the linear framebuffer access modes. If this bit is 0, then the
application cannot start the linear framebuffer graphics mode.

The gaHaveAccel2D flag is used to determine if the graphics mode supports 2D
accelerator functions. If this bit is 0, then the application can only use
direct framebuffer access in this video mode, and the 2D acceleration
functions are not available. The cases where this might crop up are more
common than you might think. This bit may be 0 for very low resolution
graphics modes on some controllers, and on older controllers for the 24 bit
and above graphics modes.

The gaHaveHWCursor flag is used to determine if the controller supports a
hardware cursor for the specified graphics mode. You must check this flag
for each graphics mode before attempting to use the hardware cursor functions
as some graphics modes will not be able to support the hardware cursor (but
may still support 2D acceleration).

The gaHave8BitDAC flag is used to determine if the controller will be using
the 8 bit wide palette DAC modes when runing in 256 color index modes. The 8
bit DAC modes allow the palette to be selected from a range of 16.7 million
colors rather than the usual 256k colors available in 6 bit DAC mode. The 8
bit DAC mode allows the 256 color modes to display a full range of 256
grayscales, while the 6 bit mode only allows a selection of 64 grayscales.
Note that the 8 bit DAC mode is not selectable. If the hardware supports an
8 bit DAC, it will always be used by default.

The gaHaveNonVGAMode flag is used to determine if the mode is a VGA compatible
mode or a NonVGA mode. If this flag is set, the application software must
ensure that no attempts are made to directly program any of the standard VGA
compatible registers such as the RAMDAC control registers and inpus status
registers while the NonVGA graphics mode is used. Attempting to use these
registers in NonVGA modes generally results in the application program
hanging the system.

The gaHaveDoubleScan flag is used to determine if the mode requires double
scanning. If this bit is set, the double scan bit must be set for the
graphics mode if it is initialised with generic refresh control turned on.

The gaHaveTripleScan flag is used to determine if the mode requires triple
scanning. If this bit is set, the triple scan bit must be set for the
graphics mode if it is initialised with generic refresh control turned on.

The gaHaveInterlaced flag is used to determine if the mode supports
interlaced operation or not. If this bit is set, the mode may be initialized
for interlaced operation when using the refresh rate control to initialise
the mode.

The gaHaveTripleBuffer flag is used to determine if the mode supports
hardware triple buffering.

The gaHaveStereo flag is used to determine if the mode supports hardware
support for stereo LC shutter glasses.

The gaHaveHWStereoSync flag is used to determine if the controller supports
the hardware stereo LC shutter glasses sync signal via the VESA EVC Enhanced
Video Connector. The gaHaveEVCStereoSync flag is used to determine if the
controller supports the hardware stereo LC shutter glasses sync signal via
the VESA mini-DIN3 stereo connector. If either of these values are set, the
application can disable all software stero sync mechanisms and rely on the
the hardware stereo sync for maximum performance.

The gaHaveAccelVideo flag is used to determine if the mode supports
hardware video acceleration. If this bit is not 0, then the application
can use the hardware video functions for video overlay windows.

The gaHaveAccel3D flag is used to determine if the mode supports hardware
3D acceleration. If this bit is not 0, then the application can use the
hardware 3D accleration functions for high performance 3D graphics.

The gaHave8bppRGBCursor flag is used to determine if the color values for
the hardware cursor in 8bpp modes are defined as a color index or as
a TrueColor RGB tuple. Most cards require a color index in 8bpp modes,
but some new hardware uses a TrueColor cursor in 8bpp display modes and
this flag will be set if this is the case.

The gaHaveAccelIOPL flag indicates that the accelerated drawing functions
require IOPL access to be enabled. If this flag is not set, then the 2D
and 3D drawing functions use only memory mapped registers and hence can
be executed entirely in ring-3 without needing IOPL to be enabled. Note
that this does not include hardware cursor functions or hardware video
overlay functions, only 2D and 3D drawing functions. It is assumed that
all initialisation and driver functions require IOPL to be enabled.

The gaIsVirtualMode flag indicates that the mode is a special
multi-controller virtual display mode that spans multiple display devices.
This is an informational flag so that any high level OS drivers can know
when one of these modes is in use.

The gaHaveMultiHead flag is used to determine if the controller is capable
of supporting dual head operation via two separate CRTC connector output.
This flag is generally only included the GA_devCtx Attribute member and
not in the Attributes member of the GA_modeInfo structure.

The gaHaveDFPOutput flag is used to determine if a mode can be displayed
on an LCD flat panel monitor using the DFP or DVI connectors. This flag is
generally only available for graphics cards that have DVI or DFP
connector and indicates display modes can support output to the LCD
flat panel monitor monitor as well as simulatenous output to both displays
at the same time.

The gaHaveLCDOutput flag is used to determine if a mode can be displayed
on an LCD flat panel. This flag is generally only available for laptop
chipsets, and indicates display modes can support output to the LCD
panel as well as simulatenous output to both displays at the same time.

The gaHaveTVOutput flag is used to determine if a mode can be displayed
via the TVOut connector for the graphics card. If the graphics card does
not support TVOut capabilities this flag will never be set. Otherwise it
will be set for those display modes that can be displayed on the TV. Note
that both PAL and NTSC output may be supported, or only one or the other
depending on the underlying hardware.

The gaIsTextMode flag is used to determine if the mode is a graphics mode
or a text mode. If this flag is set to 1, then the mode is a hardware text
mode and not a graphics mode.

HEADER:
nucleus/graphics.h

MEMBERS:
gaHaveDisplayStart      - Mode supports changing the display start address
gaHaveBankedBuffer      - Mode supports banked framebuffer access
gaHaveLinearBuffer      - Mode supports linear framebuffer access
gaHaveAccel2D           - Mode supports 2D acceleration
gaHaveHWCursor          - Mode supports a hardware cursor
gaHave8BitDAC           - Mode uses an 8 bit palette DAC
gaHaveNonVGAMode        - Mode is a NonVGA mode
gaHaveDoubleScan        - Mode is double scanned
gaHaveTripleScan        - Mode is triple scanned
gaHaveInterlaced        - Mode supports interlacing
gaHaveTripleBuffer      - Mode supports triple buffering
gaHaveStereo            - Mode supports stereo LCD glasses
gaHaveHWStereoSync      - Mode supports stereo signalling
gaHaveEVCStereoSync     - Mode supports stereo sync via EVC connector
gaHaveAccelVideo        - Mode supports video playback acceleration
gaHaveAccel3D           - Mode supports 3D acceleration
gaHave8bppRGBCursor     - Mode requires RGB colors for 8bpp hardware cursor
gaHaveAccelIOPL         - Mode needs IOPL for drawing functions
gaHaveEngineClock       - Display adapter supports programmable engine clock
gaIsGUIDesktop          - The mode is the original GUI desktop mode
gaIsVirtualMode         - Mode is a multi-head or multi-controller virtual mode
gaHaveMultiHead         - Display adapter supports multi head operation
gaHaveDFPOutput         - Mode supports output to DFP digital flat panel
gaHaveLCDOutput         - Mode supports output to LCD laptop display
gaHaveTVOutput          - Mode supports output to TV connector
gaIsTextMode            - Mode is a text mode rather than a graphics mode
****************************************************************************/
typedef enum {
    gaHaveDisplayStart              = 0x00000001,
    gaHaveBankedBuffer              = 0x00000002,
    gaHaveLinearBuffer              = 0x00000004,
    gaHaveAccel2D                   = 0x00000008,
    gaHaveHWCursor                  = 0x00000010,
    gaHave8BitDAC                   = 0x00000020,
    gaHaveNonVGAMode                = 0x00000040,
    gaHaveDoubleScan                = 0x00000080,
    gaHaveTripleScan                = 0x00000100,
    gaHaveInterlaced                = 0x00000200,
    gaHaveTripleBuffer              = 0x00000400,
    gaHaveStereo                    = 0x00000800,
    gaHaveHWStereoSync              = 0x00001000,
    gaHaveEVCStereoSync             = 0x00002000,
    gaHaveAccelVideo                = 0x00004000,
    gaHaveAccel3D                   = 0x00008000,
    gaHave8bppRGBCursor             = 0x00010000,
    gaHaveAccelIOPL                 = 0x00040000,
    gaHaveEngineClock               = 0x00200000,
    gaIsGUIDesktop                  = 0x01000000,
    gaIsVirtualMode                 = 0x08000000,
    gaHaveMultiHead                 = 0x02000000,
    gaHaveDFPOutput                 = 0x04000000,
    gaHaveLCDOutput                 = 0x10000000,
    gaHaveTVOutput                  = 0x20000000,
    gaIsTextMode                    = 0x40000000
    } GA_AttributeFlagsType;

/****************************************************************************
REMARKS:
Flags for the AttributesExt member of the GA_modeInfo structure and in the
AttributesExt member of the main GA_devCtx device context block structure.
These flags define the hardware capabilities of the particular device or
graphics mode.

The gaIsPannedMode flag is used to determine if the mode is a virtual
hardware panned display mode or if the mode is a non-panned display mode.
This flag is only ever set if you call the GetVideoModeInfoExt or
GetCustomVideoModeInfoExt functions, as the original versions of these
functions assume non panning modes will be reported. If the mode is
a hardware panned mode for the requested output device, it means that
if the mode is set while that output device is active hardware panning
will be enabled. It is then up to the shell driver to interface with
the mouse driver to implement the actual hardware panning.

The gaNoRefreshCtrl flag indicates that the device has no refresh
control. This will only be reported in the GA_devCtx variable, and is
only so that the VBE/Core fallback driver can indicate whether refresh
control is available or not.

HEADER:
nucleus/graphics.h

MEMBERS:
gaIsPanningMode         - Mode is a virtual hardware panning display mode
gaNoRefreshCtrl         - Device has no refresh rate control
****************************************************************************/
typedef enum {
    gaIsPanningMode                 = 0x00000001,
    gaNoRefreshCtrl                 = 0x00000002
    } GA_AttributeExtFlagsType;

/****************************************************************************
REMARKS:
Flags for the WorkArounds member of the GA_devCtx structure. These flags
define conditions for uncommon hardware bugs that can't easily be handled
via the generic Nucleus information reporting mechanism. Any code that
calls the Nucleus hardware drivers directly must be aware of these
workarounds and how to deal with them. However the Nucleus Software Reference
Rasteriser knows how to deal with all currently known bugs, so application
developers should use the reference rasteriser at all times for maximum
compatibility with new hardware drivers.

The gaSlowBltSys flag indicates that the hardware BitBltSys function is
faster than a direct linear framebuffer software blit. Most modern hardware
can do a software blit as fast or faster than using the hardware, but some
hardware can be faster than a pure software blit. This is only true when the
mix mode is GA_REPLACE_MIX, since software reads from the framebuffer over
the PCI bus are terribly slow.

The gaHWCursor32x32 flag indicates that the hardware only supports a 32x32
hardware cursor, while the Nucleus specification implements an interface
for 64x64 hardware cursors. Nucleus drivers will still implement hardware
cursor support for hardware that only supports a 32x32 cursor, however this
flag will be set. If the high level operating system drivers require a
cursor larger than 32x32, then this flag should be checked and a software
cursor used in it's place when this is the case.

The gaSlow24bpp flag indicates that although the 24bpp display modes are
accelerated, they are only partically accelerated. Hence if there is an
equiavlent 32bpp display mode, that most should be used in preference to
the 24bpp display mode if possible.

The gaSlow32bpp flag indicates that although the 32bpp display modes are
accelerated, they are only partically accelerated. Hence if there is an
equiavlent 24bpp display mode, that most should be used in preference to
the 32bpp display mode if possible.

The gaBrokenLines flag indicates that the hardware line drawing produces
slightly different pixels than the software reference rasterizer and
cannot be made to produce correct pixels. For this reason, conformance
testing for line drawing will be skipped on this hardware.

The gaNoDDCBIOS flag is an internal flag to indicate that the card does
not have DDC BIOS support, and hence we should not attempt to use the
DDC BIOS functions to read the EDID for legacy devices.

The gaNoWriteCombine flag is an internal flag to indicate that the graphics
chipset does not work properly when write combining is enabled for
later processors. If write combining is used, it may cause the system
to lock or hang.

The gaNoInterlacedCursor flag is an internal flag to indicate that the
graphics chipset does not properly handle hardware cursors in interlaced
display modes. Hence a software cursor should be used instead for these
modes.

The gaNoLCDSwitching flag is set if the SetOptions function does not
properly implement LCD/CRT switching. This is usually set for situations
where the BIOS is not working properly, and it will be up to the user
to use the function keys on the laptop to do the switching.

The gaNoLCDExpandCursor flag is set if the hardware does not support the
hardware cursor correctly in LCD panel expansion modes. Hence a software
mouse cursor should be used instead.

The gaUsesBIOS flag is set if the driver internally uses the BIOS for
mode sets. This is mostly a flag to let the OS/2 driver know that it does
not need to implement BIOS specific hacks that can slow down mode switching
as the BIOS is already being used internally in the drivers. The BIOS is
generally only used for laptop support and for legacy drivers where there
is not enough information available to work without the BIOS.

HEADER:
nucleus/graphics.h

MEMBERS:
gaSlowBltSys                - Software is slower than hardware for GA_REPLACE_MODE
gaHWCursor32x32             - The hardware cursor is only 32x32 in size
gaHWCursorBlackBackground   - The hardware cursor requires that the
                              background color always be black (0's)
gaSlow24bpp                 - The 24bpp modes are only partially accelerated
gaSlow32bpp                 - The 32bpp modes are only partially accelerated
gaBrokenLines               - The hardware line drawing is not conformant
gaNoDDCBIOS                 - Card does not have DDC BIOS support
gaNoWriteCombine            - Card does not support write combining
gaNoInterlacedCursor        - HW cursor in interlaced modes is broken
gaHWCursorBlackAndWhite8bpp - The hardware cursor in 8bpp is always black
                              and white and cannot be changed.
gaNoLCDSwitching            - This flag is set if LCD switching does not work
gaNoLCDExpandCursor         - This flag is set to disable cursor in LCD expand modes
gaUsesBIOS                  - Internally this driver uses the BIOS
gaNeedFullBIOS              - This driver needs a full BIOS implementation
                              on OS/2 in order to function
gaNeedContiguousFlipBuffers - Contiguous flip buffers needed for Win32 DirectDraw
gaNeed3DTiledAddressing     - 3D tiled addressing needed for Win32 DirectDraw
gaNoWHQLTransparentBlit     - Chipset does not support WHQL style transparent
                              blits.
****************************************************************************/
typedef enum {
    gaSlowBltSys                    = 0x00000001,
    gaHWCursor32x32                 = 0x00000002,
    gaHWCursorBlackBackground       = 0x00000004,
    gaSlow24bpp                     = 0x00000008,
    gaSlow32bpp                     = 0x00000010,
    gaBrokenLines                   = 0x00000020,
    gaNoDDCBIOS                     = 0x00000040,
    gaNoWriteCombine                = 0x00000080,
    gaNoInterlacedCursor            = 0x00000100,
    gaHWCursorBlackAndWhite8bpp     = 0x00000200,
    gaNoLCDSwitching                = 0x00000400,
    gaNoLCDExpandCursor             = 0x00000800,
    gaUsesBIOS                      = 0x00001000,
    gaNeedFullBIOS                  = 0x00002000,
    gaNeedContiguousFlipBuffers     = 0x00004000,
    gaNeed3DTiledAddressing         = 0x00008000,
    gaNoWHQLTransparentBlit         = 0x00010000
    } GA_WorkAroundsFlagsType;

/****************************************************************************
REMARKS:
Flags for the different output displays supported by the driver. These
flags are passed to the SetDisplayOutput function to change the currently
active display device and the GetDisplayDevice function to determine what
devices are currenlty being used to display output.

NOTE:   The color format for TV modes may be specified, or it may not. In
        the case where the color format is not specified, the currently
        active color format will be used. In some cases the color format
        is set in hardware and cannot be changed.

HEADER:
nucleus/graphics.h

MEMBERS:
gaOUTPUT_CRT            - Indicates output is sent to CRT display
gaOUTPUT_LCD            - Indicates output is sent to LCD panel
gaOUTPUT_DFP            - Indicates output is sent to external DFP connector
gaOUTPUT_TV             - Indicates output is sent to TV connector
gaOUTPUT_SELECTMASK     - Mask to mask out just the output selection
gaOUTPUT_TVNTSC         - Set TVOut connector color format to NTSC
gaOUTPUT_TVNTSC_J       - Set TVOut connector color format to NTSC-J
gaOUTPUT_TVPAL          - Set TVOut connector color format to PAL
gaOUTPUT_TVPAL_M        - Set TVOut connector color format to PAL-M
gaOUTPUT_TVPAL_60       - Set TVOut connector color format to PAL-60
gaOUTPUT_TVPAL_CN       - Set TVOut connector color format to PAL-CN
gaOUTPUT_TVSCART_PAL    - Set TVOut connector color format to SCART-PAL
gaOUTPUT_TVUNDERSCAN    - Indicates TV output should be underscanned
gaOUTPUT_TVOVERSCAN     - Indicates TV output should be overscanned
gaOUTPUT_TVCOLORMASK    - Mask to mask out TV color format
****************************************************************************/
typedef enum {
    gaOUTPUT_CRT            = 0x0001,
    gaOUTPUT_LCD            = 0x0002,
    gaOUTPUT_DFP            = 0x0400,
    gaOUTPUT_TV             = 0x0004,
    gaOUTPUT_SELECTMASK     = 0x0407,
    gaOUTPUT_TVNTSC         = 0x0008,
    gaOUTPUT_TVNTSC_J       = 0x0010,
    gaOUTPUT_TVPAL          = 0x0020,
    gaOUTPUT_TVPAL_M        = 0x0040,
    gaOUTPUT_TVPAL_60       = 0x0080,
    gaOUTPUT_TVPAL_CN       = 0x0100,
    gaOUTPUT_TVSCART_PAL    = 0x0200,
    gaOUTPUT_TVUNDERSCAN    = 0x0000,
    gaOUTPUT_TVOVERSCAN     = 0x8000,
    gaOUTPUT_TVCOLORMASK    = 0x03F8
    } GA_OutputFlagsType;

/****************************************************************************
REMARKS:
Flags for buffer flags passed to the AllocBuffer function. The flags
define how the buffer is allocated, and the type of buffer.

The gaBufferSysMem flag indicates that the buffer is currently located in
system memory only. It is possible for a buffer that was allocated with the
gaBufferPageable and gaBufferCached flags to initially be in video memory
but then get paged out to system memory to make space for higher priority
buffers. You can also set this flag when you allocate a buffer to cause the
buffer to be allocated in system memory instead of video memory.

The gaBufferCached flag indicates that the buffer should have a system
memory cache allocated for it, so that it can be swapped in and out of
video memory as necessary. Sometimes it may be useful to have buffers
cached in system memory, but not have them pageable. Thus the system
memory cache can be used to refresh the video memory as necessary if the
video memory contents were lost (ie: on a focus switch etc). Note that
the system memory cache is /not/ maintained automaticaly by Nucleus, but
rather it is up to the application code to maintain the contents of the
system memory cache if they need to be kept in sync. You can use the
UpdateCache and UpdateFromCache functions to keep the system memory cache
in sync as necessary.

The gaBufferMoveable flag indicates that the buffer should be allocated
on the moveable buffer heap, so that the buffer can be moved around as
necessary to compact the heap if it becomes fragmented. For buffers that
should never move in video memory, this flag should not be set and the
buffers will be allocated in the non-moveable or fixed heap.

The gaBufferPageable flag indicates that the buffer is a low priority
buffer and can be paged to system memory in order to make room for higher
priority buffers. Setting gaBufferPageable flag will automatically set the
gaBufferCached flag so that there is a system memory cache for the buffer.
Pageable buffers will be paged back into video memory when the heap becomes
free of all non-pageable buffers. Hence shell drivers using the buffer
manager to cache bitmaps etc should make those bitmaps all pageable, so that
they will get pages to system memory if applications need more offscreen
memory (ie: 2D or 3D graphics intensive apps). When the graphics intensive
app exits, the pageable buffers will get pages back into video memory as all
non-pageable buffers will have been free.

The gaBufferPriority flag indicates that the buffer is a high priority
buffer. As long as there are any high priority buffers still allocated,
the buffer manager will not attempt to page back in pageable buffers from
system memory. Hence DirectDraw application buffers etc should be marked
as priority buffers, so that pageable buffers will not be brought back into
video memory until the DirectDraw app exits.

The gaBufferNoSysMem flag is used to indicate that the surface being created
should only ever be allocated in video memory. If there is no video memory
available, the buffer allocation function will fail (normally it will
attempt to allocate the buffer in system memory if the gaBufferCached
or gaBufferPageable flags are set).

The gaBuffer3D flag is used to indicate that the surface being created
should be capable for being the destination for 3D hardware rendering. If
you need hardware 3D capabilities for the primary and flippable buffers,
you should pass this flag to the InitBuffers function when you initialise
the buffer manager.

The gaBufferFlippable flag is used to indicate whether the buffer is a
flippable buffer that can be viewed and made visible via the
MakeVisibleBuffer function. All flippable buffers must be the same dimensions
as the primary display mode, and are allocated when you first call
the InitBuffers function to initialise the buffer manager.

The gaBufferVideo flag is an internal flag used to indicate that the buffer
is a video overlay window buffer.

The gaBufferDepth flag is an internal flag used to indicate that the buffer
is a hardware depth buffer.

The gaBufferTexture flag is an internal flag used to indicate that the buffer
is a hardware texture map.

The gaBufferStencil flag is an internal flag used to indicate that the buffer
is a hardware stencil bufer.

Note:   These flags are also passed to the AllocBuffer function to
        determine how the buffer should be allocated. Some of the flags
        are internal and should /never/ be passed to AllocBuffer
        as they are used internally. Flags above or equal to gaVideo
        are used internally to indicate what type of buffer is in use
        (since all buffers are internally allocated from the same heap).

HEADER:
nucleus/graphics.h

MEMBERS:
gaBufferSysMem      - Buffer is currently located in system memory
gaBufferCached      - Buffer is cached in system memory
gaBufferMoveable    - Buffer can be moved around to compact buffer heap
gaBufferPageable    - Buffer can be paged to system memory
gaBufferPriority    - Buffer is a high priority bitmap
gaBufferNoSysMem    - Buffer should never be in system memory
gaBufferFlippable   - Buffer is a viewable, flippable surface
gaBuffer3D          - Buffer is a hardware 3D capable surface
gaBufferVideo       - Buffer is a video overlay window surface
gaBufferDepth       - Buffer is a hardware depth buffer
gaBufferTexture     - Buffer is a hardware texture map
gaBufferStencil     - Buffer is a hardware stencil buffer
gaBufferSpecial     - Mask to determine if buffer is special buffer
****************************************************************************/
typedef enum {
    gaBufferSysMem                  = 0x00000001,
    gaBufferCached                  = 0x00000002,
    gaBufferMoveable                = 0x00000004,
    gaBufferPageable                = 0x00000008,
    gaBufferPriority                = 0x00000010,
    gaBufferNoSysMem                = 0x00000020,
    gaBuffer3D                      = 0x00000040,
    gaBufferFlippable               = 0x00010000,
    gaBufferVideo                   = 0x00020000,
    gaBufferDepth                   = 0x00040000,
    gaBufferTexture                 = 0x00080000,
    gaBufferStencil                 = 0x00100000,
    gaBufferSpecial                 = 0x7FFF0000
    } GA_BufferFlagsType;

/****************************************************************************
REMARKS:
Flags passed to the MakeVisibleBuffer function for the waitVRT parameter.

The gaTripleBuffer flag is used to indicate that the visible buffers should
be flipped using hardware or software triple buffering where available.
This may not be available on all platforms, and if not available gaDontWait
is used instead. Hence you may get tearing using this value if the hardware
or software triple buffering is not supported and the frame rate of your
application is faster than the vertical refresh rate of the display.

The gaWaitVRT flag is used to indicate that the visible buffers should be
flipped and that the code should wait for the vertical retrace period
before returning. This is necessary to avoid any tearing on the screen
if you are doing double buffering, and is the most common value passed
to the MakeVisibleBuffer function.

The gaDontWait flag is used to indicate that the visible buffers should be
flipped but the code should exit immediately and not wait for the vertical
retrace period.

NOTE:   If there are only two flippable buffers allocated, the gaTripleBuffer
        flag will be converted to the gaWaitVRT parameter.

HEADER:
nucleus/graphics.h

MEMBERS:
gaTripleBuffer  - Flip the buffers with triple buffering if available
gaWaitVRT       - Flip the buffers and wait for vertical retrace
gaDontWait      - Flip the buffers and don't wait for retrace
****************************************************************************/
typedef enum {
    gaTripleBuffer                  = 0,
    gaWaitVRT                       = 1,
    gaDontWait                      = 2
    } GA_MakeActiveBufferFlagsType;

/****************************************************************************
REMARKS:
Flags for hardware video input formats defined in the VideoInputFormats
member of the GA_videoInf structure. These flags define the hardware
video capabilities of the particular video overlay window, and are only valid
if the gaHaveAccelVideo flag is defined in the Attributes member of the
GA_modeInfo structure.

The gaVideoRGB332 flag is used to determine whether the video overlay window can
support hardware video playback of frames stored in the RGB 3:3:2 format
(8 bits per pixel).

The gaVideoRGB555 flag is used to determine whether the video overlay window can
support hardware video playback of frames stored in the RGB 5:5:5 format
(16 bits per pixel, 1 ignored).

The gaVideoRGB565 flag is used to determine whether the video overlay window can
support hardware video playback of frames stored in the RGB 5:6:5 format
(16 bits per pixel).

The gaVideoRGB888 flag is used to determine whether the video overlay window can
support hardware video playback of frames stored in the RGB 8:8:8 format
(24 bits per pixel). Only one RGB format is supported, and the Blue byte is
always stored first in memory (ie: B:G:R).

The gaVideoRGB8888 flag is used to determine whether the video overlay window can
support hardware video playback of frames stored in the RGB 8:8:8:8 format
(32 bits per pixel). Only one RGB format is supported, and the Blue byte is
always stored first in memory (ie: B:G:R:A).

The gaVideoYUV9 flag is used to determine whether the video overlay window can
support hardware video playback of frames stored in the YUV9 format. For
more information on different YUV formats and how they are actually stored
in the framebuffer, see the section titled 'Overview of YUV pixels'.

The gaVideoYUV12 flag is used to determine whether the video overlay window can
support hardware video playback of frames stored in the YUV12 format. For
more information on different YUV formats and how they are actually stored
in the framebuffer, see the section titled 'Overview of YUV pixels'.

The gaVideoYUV411 flag is used to determine whether the video overlay window can
support hardware video playback of frames stored in the YUV 4:1:1 format.
The YUV 4:1:1 data can be stored with the YUV values in varying formats, and
you should check the gaVideoYUYV etc flags to determine which formats are
supported by this controller. For more information on different YUV formats
and how they are actually stored in the framebuffer, see the section titled
'Overview of YUV pixels'.

The gaVideoYUV422 flag is used to determine whether the video overlay window can
support hardware video playback of frames stored in the YUV 4:2:2 format.
The YUV 4:2:2 data can be stored with the YUV values in varying formats, and
you should check the gaVideoYUYV etc flags to determine which formats are
supported by this controller. For more information on different YUV formats
and how they are actually stored in the framebuffer, see the section titled
'Overview of YUV pixels'.

The gaVideoYUV444 flag is used to determine whether the video overlay window can
support hardware video playback of frames stored in the YUV 4:4:4 format.
The YUV 4:4:4 data can be stored with the YUV values in varying formats, and
you should check the gaVideoYUYV etc flags to determine which formats are
supported by this controller. For more information on different YUV formats
and how they are actually stored in the framebuffer, see the section titled
'Overview of YUV pixels'.

The gaVideoYCrCb422 flag is used to determine whether the video overlay window can
support hardware video playback of frames stored in the YCrCb 4:2:2 format.
The YCrCb 4:2:2 data can be stored with the YUV values in varying formats,
and you should check the gaVideoYUYV etc flags to determine which formats are
supported by this controller. For more information on different YUV formats
and how they are actually stored in the framebuffer, see the section titled
'Overview of YUV pixels'.

The gaVideoYUYV, gaVideoYVYU, gaVideoUYVY and gaVideoVYUY flags are used to
determine what YUV pixel layouts is supported for the above suppored YUV
pixel formats.

Note:   These flags are also passed to the AllocVideoBuffer function to
        determine the video input data type being displayed for the
        video window.

Note:   The gaVideoYUYV and related flags define the YUV pixel layouts that
        are supported by the hardware for the YUV input format it supports.
        For instance the hardware may report gaVideoYUV422 and the
        gaVideoYUYV flags, which means it supports the YUV422 format with
        the format 4:2:4:2 (Y:U:Y:V) in video memory. See the section titled
        'Overview of YUV Pixels' for more information.

HEADER:
nucleus/graphics.h

MEMBERS:
gaVideoRGB332               - Supports RGB 3:3:2 input format
gaVideoRGB555               - Supports RGB 5:5:5 input format
gaVideoRGB565               - Supports RGB 5:6:5 input format
gaVideoRGB888               - Supports RGB 8:8:8 input format
gaVideoRGB8888              - Supports RGB 8:8:8:8 input format
gaVideoYUV9                 - Supports YUV9 input format
gaVideoYUV12                - Supports YUV12 input format
gaVideoYUV411               - Supports YUV411 input format
gaVideoYUV422               - Supports YUV422 input format
gaVideoYUV444               - Supports YUV444 input format
gaVideoYCrCb422             - Supports YCrCb422 input format
gaVideoYUYV                 - Supports the YUYV pixel layout (for the above YUV formats)
gaVideoYVYU                 - Supports the YVYU pixel layout (for the above YUV formats)
gaVideoUYVY                 - Supports the UYVY pixel layout (for the above YUV formats)
gaVideoVYUY                 - Supports the VYUY pixel layout (for the above YUV formats)
****************************************************************************/
typedef enum {
    gaVideoRGB332                   = 0x00000001,
    gaVideoRGB555                   = 0x00000002,
    gaVideoRGB565                   = 0x00000004,
    gaVideoRGB888                   = 0x00000008,
    gaVideoRGB8888                  = 0x00000010,
    gaVideoYUV9                     = 0x00000020,
    gaVideoYUV12                    = 0x00000040,
    gaVideoYUV411                   = 0x00000080,
    gaVideoYUV422                   = 0x00000100,
    gaVideoYUV444                   = 0x00000200,
    gaVideoYCrCb422                 = 0x00000400,
    gaVideoYUYV                     = 0x08000000,
    gaVideoYVYU                     = 0x10000000,
    gaVideoUYVY                     = 0x20000000,
    gaVideoVYUY                     = 0x40000000
    } GA_VideoBufferFormatsType;

/****************************************************************************
REMARKS:
Flags for hardware video output capabilities defined in the VideoOutputFlags
member of the GA_videoInf structure. These flags define the hardware
video capabilities of the particular graphics mode, and are only valid
if the gaHaveAccelVideo flag is defined in the Attributes member of the
GA_modeInfo structure.

The gaVideoXInterp flag is used to determine whether the video overlay
window can support hardware interpolation or filtering in the X axis when
scaling the input image to the display. If this bit is 1, then the hardware
can support filtering of values in the X direction resulting in better
looking images when scaled from a smaller input frame.

The gaVideoYInterp flag is used to determine whether the video overlay
window can support hardware interpolation or filtering in the Y axis when
scaling the input image to the display. If this bit is 1, then the hardware
can support filtering of values in the Y direction resulting in better
looking images when scaled from a smaller input frame.

The gaVideoColorKeySrcSingle flag is used to determine whether the video
overlay window can support hardware source color keying with a single source
color key value. When hardware source color keying is enabled, any pixel
data in the incoming source video that matches the currently set video
color key will be ignored and not displayed on the screen, essentially
allowing the display data under the video overlay window to show through.

The gaVideoColorKeySrcRange flag is used to determine whether the video
overlay window can support hardware source color keying with a range of
color key values. This is the same as single source color keying, but
the color key values may be allows to fall within a range of available
colors (useful if data has been filtered causing the colors to change).

The gaVideoColorKeyDstSingle flag is used to determine whether the video
overlay window can support hardware destination color keying with a single
destination color key value. When hardware detination color keying is
enabled (sometimes called blue-screening), any destination pixels that the
overlay window overlaps that match the currently set video color key,
will cause the source input pixels to be ignored, essentially
allowing the display data under the video overlay window to show through.

The gaVideoColorKeyDstRange flag is used to determine whether the video
overlay window can support hardware destination color keying with a range of
color key values. This is the same as single destination color keying, but
the color key values may be allows to fall within a range of available
colors.

Note:   These flags are also passed to the SetVideoOutput function to
        determine what features are enabled for the output window.

HEADER:
nucleus/graphics.h

MEMBERS:
gaVideoXInterp              - Supports X interpolation
gaVideoYInterp              - Supports Y interpolation
gaVideoColorKeySrcSingle    - Supports source color keying, single color
gaVideoColorKeySrcRange     - Supports source color keying, range of colors
gaVideoColorKeyDstSingle    - Support destination color keying, single color
gaVideoColorKeyDstRange     - Support destination color keying, range of colors
****************************************************************************/
typedef enum {
    gaVideoXInterp                  = 0x00000001,
    gaVideoYInterp                  = 0x00000002,
    gaVideoColorKeySrcSingle        = 0x00000004,
    gaVideoColorKeySrcRange         = 0x00000008,
    gaVideoColorKeyDstSingle        = 0x00000010,
    gaVideoColorKeyDstRange         = 0x00000020
    } GA_VideoOutputFlagsType;

/****************************************************************************
REMARKS:
Flags for hardware line drawing using the bresenham engine line draw
function.

HEADER:
nucleus/graphics.h

MEMBERS:
gaLineXMajor        - Line is X major (ie: longer in the X direction)
gaLineXPositive     - Direction of line is positive in X
gaLineYPositive     - Direction of line is positive in Y
gaLineDoLastPel     - Draw the last pixel in the line
****************************************************************************/
typedef enum {
    gaLineXMajor                    = 0x00000001,
    gaLineXPositive                 = 0x00000002,
    gaLineYPositive                 = 0x00000004,
    gaLineDoLastPel                 = 0x00000008,
    gaLineDoFirstPel                = 0x00000010
    } GA_BresenhamLineFlagsType;

/* Applications can adjust the bias for the bresenham line drawing
 * functions by applying a small bias to the initial error terms. The bias
 * parameter is an OR'ing of the appropriate octant constants defined
 * below to indicate which octants to bias a line to prefer an axial step
 * when the Bresenham error term is exactly zero. By default Nucleus uses
 * a line bias of 0 for all octants, so you may need to adjust as necesary
 * to compensate for different rasterisation rules. The octants are mapped
 * as follows:
 *
 *   \    |    /
 *    \ 3 | 2 /
 *     \  |  /
 *    4 \ | / 1
 *       \|/
 *   -----------
 *       /|\
 *    5 / | \ 8
 *     /  |  \
 *    / 6 | 7 \
 *   /    |    \
 *
 * For more information, see "Ambiguities in Incremental Line Rastering,"
 * Jack E. Bresenham, IEEE CG&A, May 1987.
 */

#define gaLineOctant1   (1 << (gaLineXPositive | gaLineXMajor))
#define gaLineOctant2   (1 << (gaLineXPositive))
#define gaLineOctant3   (1 << (0))
#define gaLineOctant4   (1 << (gaLineXMajor))
#define gaLineOctant5   (1 << (gaLineYPositive | gaLineXMajor))
#define gaLineOctant6   (1 << (gaLineYPositive))
#define gaLineOctant7   (1 << (gaLineXPositive | gaLineYPositive))
#define gaLineOctant8   (1 << (gaLineXPositive | gaLineYPositive | gaLineXMajor))

#define gaLineOctantMask \
    (gaLineXMajor | gaLineXPositive | gaLineYPositive)

/****************************************************************************
REMARKS:
Flags for hardware blitting with special effects, passed to the BltBltFx
family of functions. This family of functions exposes a wide variety of
special effects blitting if the hardware is capable of these functions.
You can determine what special effects are supported by the hardware by
examining the BitBltCaps member of the GA_modeInfo structure. However to
check whether a set of combined effects are supported, set the desired
effects flags in the GA_bltFx structure and call the BitBltFxTest function.
The driver will examine the passed in flags and return true if the
combination is supported, and false if not. Calling a BltBltFx function with
a combination of flags not supported by the hardware will produce undefined
results.

The gaBltMixEnable flag determines if the graphics mode supports arbitrary
mix modes for extended BitBlt functions.

The gaBltStretchNearest flag determines if the graphics mode supports
hardware stretch blitting, with nearest pixel filtering.

The gaBltStretchXInterp flag determines if the graphics mode supports
hardware stretch blitting, with linear interpolated filtering in the
X direction.

The gaBltStretchYInterp flag determines if the graphics mode supports
hardware stretch blitting, with linear interpolated filtering in the
Y direction.

The gaBltColorKeySrcSingle flag determines whether the graphics mode
supports hardware source transparent blitting with single source color key.
When hardware source color keying is enabled, any pixel data in the incoming
bitmap that matches the currently set color key will be ignored and not
displayed on the screen, essentially making those source pixels transparent.

The gaBltColorKeySrcRange flag determines whether the graphics mode
supports hardware source transparent blitting with a range of color keys.
This is the same as single source color keying, but the color key values may
be allows to fall within a range of available colors (useful if data has
been filtered causing the colors to shift slightly).

The gaBltColorKeyDstSingle flag determines whether the graphics mode
supports hardware destination transparent blitting with single destination color key.
When hardware detination color keying is enabled (sometimes called
blue-screening), any destination pixels in the framebuffer that match the
currently set color key, will cause the source input pixels to be ignored.

The gaBltColorKeyDstRange flag determines whether the graphics mode
supports hardware destination transparent blitting with a range of color keys.
This is the same as single destination color keying, but the color key values
may be allows to fall within a range of available colors (useful if data has
been filtered causing the colors to shift slightly).

The gaBltFlipX flag determines whether the graphics mode supports hardware
blitting with data flipped in the X axis. This is useful for 2D sprite
based games and animation where the same sprite data can be reused for
characters going left or right on the screen by flipping the data during
the blit operation.

The gaBltFlipY flag determines whether the graphics mode supports hardware
blitting with data flipped in the Y axis. This is useful for 2D sprite
based games and animation where the same sprite data can be reused for
characters going up or down on the screen by flipping the data during
the blit operation.

The gaBltBlend flag determines whether the hardware can support alpha
blended blit operations.

The gaBltConvert flag determines whether the hardware can support pixel
format conversion.

The gaBltClip flag determines whether the hardware can support clipping
while blitting is in effect. This is usually only used to implement
proper clipping for stretching operations, where software clipping can get
complicated.

The gaBltDither flag determines whether the closest color is selected, or
if dithering is used when blitting an RGB bitmap where the destination is
an 8bpp, 15bpp or 16bpp device context. Dithering slows things down somewhat
for 15/16bpp modes, but produces better quality. Dithering in 8bpp looks
best if a halftone palette is used, and in fact is a lot faster than
using the closest color method. Dithering in 8bpp will however map to any
palette, but the quality is best if a halftone palette is used.

The gaBltTranslateVec is used to indicate that the color translation
vector supplied in the TranslateVec member. This is used in situations
where the calling code has already computed a color translation vector
for the source and destination bitmaps, and will then avoid the overhead
of computing the translation vector dynamically for each blit operation.
This is only useful when color conversting between 4bpp and 8bpp bitmaps
where the destination is also 4bpp or 8bpp (potentially with a different
palette).

Note:   These flags are also passed to the BitBltFx family of functions to
        define the type of extended Blt that should be performed, as well
        as reporting the available capabilities via the GA_bltFx structure
        stored in the GA_modeInfo structure.

Note:   Availabiliy of some features may be mututally exclusive on other
        features. Hence you /must/ call BitBltFxTest first to find out if
        the set of features that you require are all supported at the same
        time before attempting to perform an extended BitBlt operation.

Note:   In many cases stretching with X filtering is relatively cheap,
        while Y filtering is more expensive. Hence it may be faster on
        some hardware to enable only X filtering and not Y filteringto get
        improved performance.

HEADER:
nucleus/graphics.h

MEMBERS:
gaBltMixEnable          - Mix code enabled, defined in GA_bltFx structure
gaBltStretchNearest     - Enable stretching, nearest pixel
gaBltStretchXInterp     - Enable X axis filtering for stretch blit
gaBltStretchYInterp     - Enable Y axis filtering for stretch blit
gaBltColorKeySrcSingle  - Source color keying enabled, single color
gaBltColorKeySrcRange   - Source color keying enabled, range of colors
gaBltColorKeyDstSingle  - Destination color keying enabled, single color
gaBltColorKeyDstRange   - Destination color keying enabled, range of colors
gaBltFlipX              - Enable flip in X axis
gaBltFlipY              - Enable flip in Y axis
gaBltBlend              - Enable alpha blending
gaBltConvert            - Enable pixel format/palette conversion
gaBltClip               - Clip to destination clip rectangle for stretching
gaBltDither             - Dither if an 8/15/16bpp destination
gaBltTranslateVec       - Color translation vector supplied in TranslateVec
****************************************************************************/
typedef enum {
    gaBltMixEnable                  = 0x00000001,
    gaBltStretchNearest             = 0x00000002,
    gaBltStretchXInterp             = 0x00000004,
    gaBltStretchYInterp             = 0x00000008,
    gaBltColorKeySrcSingle          = 0x00000010,
    gaBltColorKeySrcRange           = 0x00000020,
    gaBltColorKeyDstSingle          = 0x00000040,
    gaBltColorKeyDstRange           = 0x00000080,
    gaBltFlipX                      = 0x00000100,
    gaBltFlipY                      = 0x00000200,
    gaBltBlend                      = 0x00000400,
    gaBltConvert                    = 0x00000800,
    gaBltClip                       = 0x00001000,
    gaBltDither                     = 0x00002000,
    gaBltTranslateVec               = 0x00004000
    } GA_BitBltFxFlagsType;

/* Convenience macros for BitBltFx flags */

#define gaBltAnyStretch         (gaBltStretchNearest | gaBltStretchXInterp | gaBltStretchYInterp)
#define gaBltAnyColorKey        (gaBltColorKeySrcSingle | gaBltColorKeySrcRange | gaBltColorKeyDstSingle | gaBltColorKeyDstRange)
#define gaBltAnySingleColorKey  (gaBltColorKeySrcSingle | gaBltColorKeyDstSingle)
#define gaBltAnyRangeColorKey   (gaBltColorKeySrcRange | gaBltColorKeyDstRange)

/****************************************************************************
REMARKS:
Definitions for flags member of the GA_CRTCInfo structure. These flags
define the different flags required to complete a mode set with refresh
rate control enabled.

The gaInterlaced flag is used to determine whether the mode programmed into
the hardware is interlaced or non-interlaced. The CRTC timings passed in
will be identical for both interlaced and non-interlaced modes, and it is up
to the graphics driver to perform any necessary scaling between the hardware
values and the normalized CRTC values in interlaced modes. Note that you must
check the gaHaveInterlaced bit in the GA_modeInfo structure to determine if
interlaced mode is supported before attempting to initialise an interlaced
mode.

The gaDoubleScan flag is used to determine whether the mode programmed into
the hardware is double scanned or not. When double scanning is specified,
the vertical CRTC values passed in will be double what the real vertical
resolution will be. Double scanning is used to implement the 200, 240 and
300 line graphics modes on modern controllers. Note that you must check the
gaHaveDoubleScan bit in the GA_modeInfo structure to determine if double scan
mode is supported by the hardware in that display mode. Note also that all
modes with vertical resolutions below 300 scanline modes require the double
scanning to be enabled, and modes between 300 and 400 scanlines can usually
look better if it is enabled.

The gaHSyncNeg flag is used to determine if the horizontal sync polority
should be set to a negative sync (gaHSyncNeg is set) or positive sync
(gaHSyncNeg is not set).

The gaVSyncNeg flag is used to determine if the vertical sync polority
should be set to a negative sync (gaVSyncNeg is set) or positive sync
(gaVSyncNeg is not set).

HEADER:
nucleus/graphics.h

MEMBERS:
gaInterlaced    - Enable interlaced mode
gaDoubleScan    - Enable double scanned mode
gaTripleScan    - Enable triple scanned mode
gaHSyncNeg      - Horizontal sync is negative
gaVSyncNeg      - Vertical sync is negative
****************************************************************************/
typedef enum {
    gaInterlaced    = 0x01,
    gaDoubleScan    = 0x02,
    gaTripleScan    = 0x04,
    gaHSyncNeg      = 0x08,
    gaVSyncNeg      = 0x10
    } GA_CRTCInfoFlagsType;

/* Flags for common sync polarity combinations */

#define ga350Line       gaSyncVNeg
#define ga400Line       gaSyncHNeg
#define ga480Line       (gaSyncHNeg | gaSyncVNeg)

/****************************************************************************
REMARKS:
Definitions for values stored in the bLCDUseBIOS member of the
GA_globalOptions structure. These flags define the different values for this
particular option which is multi-state and not just an on/off option.

The gaLCDUseBIOS_Off value indicates that the the BIOS should not be used
for LCD panel modes unless the user has manually switched the driver to
run in LCD only or Simultaneous mode. In this mode some laptops will not
be able to switch into LCD mode from CRT only mode if the user uses the
laptop hot-key switching (the Nucleus API can always be used for correct
switching).

The gaLCDUseBIOS_Auto value will auto select the best option at driver load
time. If the system boots up in either LCD only mode or in Simultaneous
mode, the driver will always use the BIOS even if the user switches to CRT
only mode (ie: equivalent to gaLCDUseBIOS_On). If the system boot up
in CRT only mode, the driver will not use the BIOS unless the user manually
switches to LCD panel mode using the Nucleus API (ie: equivalent to
gaLCDUseBIOS_Off).

gaLCDUseBIOS_On value indicates that the BIOS should always be used
for drivers with LCD panel support. This means that even when the user uses
the Nucleus API to switch to CRT only mode, the BIOS will be used to
set the mode (with restricted modes and features). This mode is useful if
the user switches to and from LCD panel and CRT only modes and needs the
hot key switching provided in the BIOS to function correctly.

HEADER:
nucleus/graphics.h

MEMBERS:
gaLCDUseBIOS_Auto   - Auto select the best option at driver load time
gaLCDUseBIOS_Off    - Only use the BIOS modes when running on the LCD
gaLCDUseBIOS_On     - Always use the BIOS for drivers with LCD panel support
****************************************************************************/
typedef enum {
    gaLCDUseBIOS_Auto   = 0,
    gaLCDUseBIOS_Off    = 1,
    gaLCDUseBIOS_On     = 2
    } GA_LCDUseBIOSFlagsType;

/****************************************************************************
REMARKS:
Definitions for values stored in the accelType member of the GA_Options
structure. These flags define the different values for this particular
option which is multi-state and not just an on/off option. This option is
designed to be used as a fallback measure in the field to disable
problem functions in a driver that an end user might be experiencing.

The gaAccelType_Custom value indicates that the user has manually overridden
specific hardware acceleration options rather than using the four pre-defined
settings.

The gaAccelType_Full value indicates that full hardware acceleration should
be used, and is always the default option for all drivers.

The gaAccelType_Most value indicates that most acceleration functions should
be used in the driver. This basically disables support for hardware mouse
cursor and hardware video overlays functionality.

The gaAccelType_Basic value indicates that only basic acceleration functions
should be used in the driver. Basic acceleration includes solid fills,
mono and color pattern fills and screen to screen blits. All other functions
are disabled.

gaAccelType_None value indicats that no hardware acceleration functions
should be used in the driver.

HEADER:
nucleus/graphics.h

MEMBERS:
gaAccelType_Custom  - Custom hardware acceleration
gaAccelType_Full    - Full hardware acceleration (default)
gaAccelType_Most    - Most hardware acceleration
gaAccelType_Basic   - Basic hardware acceleration
gaAccelType_None    - No hardware acceleration
****************************************************************************/
typedef enum {
    gaAccelType_Custom  = 0,
    gaAccelType_Full    = 1,
    gaAccelType_Most    = 2,
    gaAccelType_Basic   = 3,
    gaAccelType_None    = 4
    } GA_AccelFlagsType;

/****************************************************************************
REMARKS:
Definitions for values stored in the CertifyFlags member of the
GA_certifyChipInfo and structure. These flags define what certification tests
have been run on the included drivers.

The gaCertified value indicates that the driver has been certified to have
passed all the base certification tests, and is usually the only important
flag for most situations.

The gaCertifiedDDC value indicates that the driver has also passed all
Windows DDC certification tests, running on the IHV Windows drivers. These
tests are indepedant of the base certification tests as they are dependant
on proper testing with the IHV Windows drivers as well as the base
certification tests. The gaCertifiedDDC_NT flag is equivalent but
indicates that the chipset driver is also certified for DDC on the
Windows NT platform.

The gaCertifiedStereo value indicates that the driver has also passed all
Windows Stereo certification tests, running on the IHV Windows drivers. These
tests are indepedant of the base certification tests as they are dependant
on proper testing with the IHV Windows drivers as well as the base
certification tests. The gaCertifiedStereo_NT flag is equivalent but
indicates that the chipset driver is also certified for stereo on the
Windows NT platform.

The gaCertifiedDFPOutput value indicates that the driver has also passed all
the external digital flat panel tests such that attaching an external
digital flat panel to the graphics card will function correctly.

The gaCertifiedTVOutput value indicates that the driver has also passed all
the external TV output tests such that attaching an external television
to either the composite or S-Video connectors of the graphics card
will function correctly.

HEADER:
nucleus/graphics.h

MEMBERS:
gaCertified             - Driver has passed all base certification tests
gaCertifiedDDC          - Driver has passed all Windows DDC tests
gaCertifiedStereo       - Driver has passed all Windows stereo tests
gaCertifiedDDC_NT       - Driver has passed all Windows NT DDC tests
gaCertifiedStereo_NT    - Driver has passed all Windows NT stereo tests
****************************************************************************/
typedef enum {
    gaCertified             = 0x01,
    gaCertifiedDDC          = 0x02,
    gaCertifiedStereo       = 0x04,
    gaCertifiedDDC_NT       = 0x08,
    gaCertifiedStereo_NT    = 0x10
    } GA_CertifyFlagsType;

/****************************************************************************
REMARKS:
This enumeration defines the flags stored in the bMultiDisplay field of
the GA_options structure.

HEADER:
nucleus/graphics.h

MEMBERS:
gaActiveHeadClone       - Active head is cloned across all displays (default)
gaActiveHeadPrimary     - Active head is primary display
gaActiveHeadSecondary   - Active head is secondary display
gaActiveHeadTernary     - Active head is third display
****************************************************************************/
typedef enum {
    gaActiveHeadClone       = -1,
    gaActiveHeadPrimary     = 0,
    gaActiveHeadSecondary   = 1,
    gaActiveHeadTernary     = 2
    } GA_multiHeadType;

/****************************************************************************
REMARKS:
Fundamental type definition for an array element of an 8x8 monochrome
pattern. Each line in the pattern is represented as a single byte, with 8
bytes in total for the entire pattern.

HEADER:
nucleus/graphics.h

MEMBERS:
p   - 8 bytes of pattern data
****************************************************************************/
typedef struct {
    N_uint8     p[8];
    } GA_pattern;

/****************************************************************************
REMARKS:
Fundamental type definition for an array element of an 8x8 color bitmap
pattern data for 1bpp modes.

HEADER:
nucleus/graphics.h

MEMBERS:
p   - 8x8 bytes of pattern data
****************************************************************************/
typedef struct {
    N_uint8     p[8];
    } GA_colorPattern_1;

/****************************************************************************
REMARKS:
Fundamental type definition for an array element of an 8x8 color bitmap
pattern data for 4bpp modes.

HEADER:
nucleus/graphics.h

MEMBERS:
p   - 8x8 bytes of pattern data
****************************************************************************/
typedef struct {
    N_uint8     p[8][4];
    } GA_colorPattern_4;

/****************************************************************************
REMARKS:
Fundamental type definition for an array element of an 8x8 color bitmap
pattern data for 8bpp modes.

HEADER:
nucleus/graphics.h

MEMBERS:
p   - 8x8 bytes of pattern data
****************************************************************************/
typedef struct {
    N_uint8     p[8][8];
    } GA_colorPattern_8;

/****************************************************************************
REMARKS:
Fundamental type definition for an array element of an 8x8 color bitmap
pattern data for 16bpp modes.

HEADER:
nucleus/graphics.h

MEMBERS:
p   - 8x8 words of pattern data
****************************************************************************/
typedef struct {
    N_uint16    p[8][8];
    } GA_colorPattern_16;

/****************************************************************************
REMARKS:
Fundamental type definition for an array element of an 8x8 color bitmap
pattern data for 24bpp modes.

HEADER:
nucleus/graphics.h

MEMBERS:
p   - 8x8x3 bytes of pattern data
****************************************************************************/
typedef struct {
    N_uint8     p[8][8][3];
    } GA_colorPattern_24;

/****************************************************************************
REMARKS:
Fundamental type definition for an array element of an 8x8 color bitmap
pattern data for 32pp modes.

HEADER:
nucleus/graphics.h

MEMBERS:
p   - 8x8 dwords of pattern data
****************************************************************************/
typedef struct {
    N_uint32    p[8][8];
    } GA_colorPattern_32;

/****************************************************************************
REMARKS:
Fundamental type definition for an array element of an 8x8 color bitmap
pattern. Each line in the pattern is represented as an array of packed
pixel data. In 8bpp modes there is 8 bytes per line, for 16bpp modes
there are 16bytes per line, for 24bpp modes there are 24bytes per line
and for 32bpp modes there are 32 bytes per line. Hence the size of the
pattern data is different depending on the color depth currently active.

HEADER:
nucleus/graphics.h
****************************************************************************/
typedef union {
    GA_colorPattern_1   b1;
    GA_colorPattern_4   b4;
    GA_colorPattern_8   b8;
    GA_colorPattern_16  b16;
    GA_colorPattern_24  b24;
    GA_colorPattern_32  b32;
    } GA_colorPattern;

/****************************************************************************
REMARKS:
Fundamental type definition for a 16-bit line stipple pattern. Note that
we define it as a 32-bit value so it will be passed as a 32-bit argument
on the stack correctly when calling 32-bit code from a 16-bit segment.

HEADER:
nucleus/graphics.h
****************************************************************************/
typedef N_uint32 GA_stipple;

/****************************************************************************
REMARKS:
Fundamental type definition for a 32-bit color value. The color value is
intepreted differently depending on what graphics mode the system is in,
and in 15-bit and above modes will have the color values packed according
to the pixel format information stored in the GA_modeInfo structure.

HEADER:
nucleus/graphics.h
****************************************************************************/
typedef N_uint32 GA_color;

/****************************************************************************
REMARKS:
Fundamental type definition for an integer rectangle. Note that Nucleus
defines and uses rectangles such that the bottom and right coordinates are
not actually included in the pixels that define a raster coordinate
rectangle. This allows for correct handling of overlapping rectangles
without drawing any pixels twice.

HEADER:
nucleus/graphics.h

MEMBERS:
left    - Left coordinate of the rectangle
top     - Top coordinate of the rectangle
right   - Right coordinate of the rectangle
bottom  - Bottom coordinate of the rectangle
****************************************************************************/
typedef struct {
    N_int32 left;
    N_int32 top;
    N_int32 right;
    N_int32 bottom;
    } GA_rect;

/****************************************************************************
REMARKS:
Fundamental type definition representing a segment within a span that forms
a complex region. The segments define the X coordinates of the segments
that make up the span. Segments are always in groups of two (start and end
segment).

HEADER:
nucleus/graphics.h

MEMBERS:
next    - Next segment in span
x       - X coordinates of this segment
****************************************************************************/
typedef struct GA_segment {
    struct GA_segment   *next;
    N_int32             x;
    } GA_segment;

/****************************************************************************
REMARKS:
Fundamental type definition representing a span within a complex region. A
span is represented as a list of segments that are included in the span.

HEADER:
nucleus/graphics.h

MEMBERS:
next    - Next span in region
seg     - Index of first segment in span
y       - Y coordinate of this span
****************************************************************************/
typedef struct GA_span {
    struct GA_span  *next;
    GA_segment      *seg;
    N_int32         y;
    } GA_span;

/****************************************************************************
REMARKS:
Fundamental type definition representing a complex region. Complex regions
are used to represent non-rectangular areas as unions of smaller rectangles
(the smallest being a single pixel). You can use complex regions to build
complex clipping regions for user interface library development.

If the Spans field for the region is NULL, then the region is a simple
region and is composed of only a single rectangle. Note however that you
can have a simple region that consists of only single rectangle in the
span structure (usually after complex region arithmetic). You can use the
GA_IsSimpleRegion macro to determine if the region contains only a single
rectangle.

HEADER:
nucleus/graphics.h

MEMBERS:
Rect    - Bounding rectangle for the region
spans   - Pointer to the internal region span structure.
****************************************************************************/
typedef struct {
    GA_rect rect;
    GA_span *spans;
    } GA_region;

/****************************************************************************
REMARKS:
Hardware video window information. There is a single structure for each
available hardware video window, and defines the capabilities of that
hardware video window. The VideoMinXScale and VideoMinYScale members defines
the inverse of minimum scale ratio supported by the hardware in the each
direction. For instance if the value is 4, the hardware can only scale video
down to a window that is 1/4 the size of the source input video.
The VideoMaxXScale and VideoMaxYScale define the maxium scale ratio supported
by the hardware. For instance if the value is 4, the hardware can only scale
video data up to a window that 4 times the size of the source input video.

HEADER:
nucleus/graphics.h

MEMBERS:
dwSize              - Set to size of structure in bytes
VideoInputFormats   - Hardware video input format flags
VideoOutputFlags    - Hardware video output format capabilities
VideoMinXScale      - Minimum X scale factor (1/value)
VideoMinYScale      - Minimum Y scale factor (1/value)
VideoMaxXScale      - Maximum X scale factor
VideoMaxYScale      - Maximum Y scale factor
****************************************************************************/
typedef struct {
    N_uint32    dwSize;
    N_uint32    VideoInputFormats;
    N_uint32    VideoOutputFlags;
    N_uint16    VideoMinXScale;
    N_uint16    VideoMinYScale;
    N_uint16    VideoMaxXScale;
    N_uint16    VideoMaxYScale;
    } GA_videoInf;

/****************************************************************************
REMARKS:
Palette entry structure, which defines a single entry in the hardware
color lookup table or gamma correction table.

HEADER:
nucleus/graphics.h

MEMBERS:
blue    - Blue component of palette entry, range [0-255]
green   - Green component of palette entry, range [0-255]
red     - Blue component of palette entry, range [0-255]
alpha   - Alpha or alignment byte
****************************************************************************/
typedef struct {
    N_uint8     Blue;
    N_uint8     Green;
    N_uint8     Red;
    N_uint8     Alpha;
    } GA_palette;

/****************************************************************************
REMARKS:
Extended palette entry structure, which defines a single entry in the
hardware color lookup table or gamma correction table.

HEADER:
nucleus/graphics.h

MEMBERS:
blue    - Blue component of palette entry, range [0-65535]
green   - Green component of palette entry, range [0-65535]
red     - Blue component of palette entry, range [0-65535]
****************************************************************************/
typedef struct {
    N_uint16    Blue;
    N_uint16    Green;
    N_uint16    Red;
    } GA_paletteExt;

/****************************************************************************
REMARKS:
Structure representing the format of an RGB pixel. This structure is used
to describe the RGB pixel format for Nucleus graphics modes, as well as the
pixel format for system memory buffers converted on the fly by Nucleus to
the destination pixel format. RGB pixel formats are required for pixel
depths greater than or equal to 15-bits per pixel. The pixel formats for 15
and 16-bit modes are constant and never change, however there are 2 possible
pixel formats for 24 bit RGB modes and 4 possible formats for 32 bit RGB
modes that are supported by the MGL. The possible modes for 24-bits per
pixel are:

24-bit  - Description
RGB     - Values are packed with Red in byte 2, Green in byte 1 and Blue
          in byte 0. This is the standard format used by all 24 bit
          Windows BMP files, and the native display format for most
          graphics hardware on the PC.
BGR     - Values are packed with Blue in byte 2, Green in byte 1 and Red
          in byte 0. This format is the native display format for some
          graphics hardware on the PC.

The possible modes for 32-bits per pixel are:

32-bit  - Description
ARGB    - Values are packed with Red in byte 2, Green in byte 1 and Blue
          in byte 0 and alpha in byte 3.
ABGR    - Values are packed with Blue in byte 2, Green in byte 1 and Red
          in byte 0 and alpha in byte 3.
RGBA    - Values are packed with Red in byte 3, Green in byte 2 and Blue
          in byte 1 and alpha in byte 0.
BGRA    - Values are packed with Blue in byte 3, Green in byte 2 and Red
          in byte 1 and alpha in byte 0.

If you intend to write your own direct rendering code for RGB graphics modes,
you will need to write your code so that it will adapt to the underlying
pixel format used by the hardware to display the correct colors on the
screen. Nucleus has the ability to perform pixel format translation on the
fly using the ConvertBlt family of functions, but this can be time consuming
so directly rendering in the native pixel format can be more efficient.
The formula for packing the pixel data into the proper positions given three
8-bit RGB values is as follows:

    color = ((GA_color)((R >> RedAdjust) & RedMask)
            << RedPosition)
          | ((GA_color)((G >> GreenAdjust) & GreenMask)
            << GreenPosition)
          | ((GA_color)((B >> BlueAdjust) & BlueMask)
            << BluePosition);

Alternatively you can unpack the color values from the framebuffer with the
following code (note that you lose precision when unpacking values from the
framebuffer since the bottom bits always get set to 0):

    R = (((color) >> RedPosition) & RedMask)
        << RedAdjust;
    G = (((color) >> GreenPosition) & GreenMask)
        << GreenAdjust;
    B = (((color) >> BluePosition) & BlueMask)
        << BlueAdjust;

If you wish to create your own pixel formats (such as to create memory
custom bitmaps), the following list defines all the pixel formats that the
Nucleus knows how to deal with:

    {0x1F,0x0A,3, 0x1F,0x05,3, 0x1F,0x00,3, 0x01,0x0F,7}, // 555 15bpp
    {0x1F,0x0B,3, 0x3F,0x05,2, 0x1F,0x00,3, 0x00,0x00,0}, // 565 16bpp
    {0xFF,0x10,0, 0xFF,0x08,0, 0xFF,0x00,0, 0x00,0x00,0}, // RGB 24bpp
    {0xFF,0x00,0, 0xFF,0x08,0, 0xFF,0x10,0, 0x00,0x00,0}, // BGR 24bpp
    {0xFF,0x10,0, 0xFF,0x08,0, 0xFF,0x00,0, 0xFF,0x18,0}, // ARGB 32bpp
    {0xFF,0x00,0, 0xFF,0x08,0, 0xFF,0x10,0, 0xFF,0x18,0}, // ABGR 32bpp
    {0xFF,0x18,0, 0xFF,0x10,0, 0xFF,0x08,0, 0xFF,0x00,0}, // RGBA 32bpp
    {0xFF,0x08,0, 0xFF,0x10,0, 0xFF,0x18,0, 0xFF,0x00,0}, // BGRA 32bpp

One special cased pixel format is used to represent and 8bpp color index
bitmap with an alpha channel. This pixel format is a 16-bit wide pixel
format, but the red channel is considered to contain the 8-bit color
index values. The pixel format structure for this type of bitmap looks
like the following:

    {0xFF,0x00,0, 0x00,0x00,0, 0x00,0x00,0, 0xFF,0x08,0}, // A8CI 8bpp + Alpha

HEADER:
nucleus/graphics.h

MEMBERS:
RedMask         - Unshifted 8-bit mask for the red color channel
RedPosition     - Bit position for bit 0 of the red color channel information
RedAdjust       - Number of bits to shift the 8-bit red value right
GreenMask       - Unshifted 8-bit mask for the green color channel
GreenPosition   - Bit position for bit 0 of the green color channel information
GreenAdjust     - Number of bits to shift the 8-bit green value right
BlueMask        - Unshifted 8-bit mask for the blue color channel
BluePosition    - Bit position for bit 0 of the blue color channel information
BlueAdjust      - Number of bits to shift the 8-bit blue value right
AlphaMask       - Unshifted 8-bit mask for the alpha channel
AlphaPosition   - Bit position for bit 0 of the alpha channel information
AlphaAdjust     - Number of bits to shift the 8-bit alpha value right
****************************************************************************/
typedef struct {
    N_uint8 RedMask;
    N_uint8 RedPosition;
    N_uint8 RedAdjust;
    N_uint8 GreenMask;
    N_uint8 GreenPosition;
    N_uint8 GreenAdjust;
    N_uint8 BlueMask;
    N_uint8 BluePosition;
    N_uint8 BlueAdjust;
    N_uint8 AlphaMask;
    N_uint8 AlphaPosition;
    N_uint8 AlphaAdjust;
    } GA_pixelFormat;

/****************************************************************************
REMARKS:
Hardware 2D BitBltFx information structure. This structure defines the type
of BitBlt operation that is performed by the BitBltFx family of functions.
The Flags member defines the type of BitBlt operation to be performed, and
can be any combination of the supported flags (be sure to call BitBltFxTest
first to determine if that combination of effects is supported).

If mixes are enabled, the Mix member is used to determine the mix operation
to apply. If mixes are not enabled, GA_REPLACE_MIX is assumed (some hardware
may not support mix operations for effects blits).

The ColorKeyLo and ColorKeyHi members define the color key ranges if range
based color keying is selected. If only a single color key is enabled,
the ColorKeyLo value is the value used as the color key. The ColorKeyHi
value is inclusive in that it is included in the color range.

If blending is enabled, the SrcBlendFunc, DstBlendFunc and Alpha values
are used to implement the blending operation.

If clipping is enabled, the destination clip rectangle is passed in the
ClipLeft, ClipTop, ClipRight and ClipBottom members. Clipping is most
useful for stretching operations, where clipping in software is problematic.

If color conversion is enabled and you are color converting between color
index pixel formats and other pixel formats (including palette remapping),
you can optionally pass in a pre-computed translation vector in the TranslateVec
member. This will be used in place of dynamically computing the color
translation vector on the fly during the blit operation, so it is faster
in cases where the translation vector is known in advance for a number
of blit operations.

Note:   The dwSize member is intended for future compatibility, and
        should be set to the size of the structure as defined in this
        header file. Future drivers will be compatible with older software
        by examiming this value.


Note:   The ColorKeyLo and ColorKeyHi values are always color values
        in the format of the destination surface color depth and pixel
        format. Ie: if you are color converting an 8bpp bitmap to a 32bpp
        destination surface, the color key values will be 32bpp color
        key values, not 8bpp color key values.

HEADER:
nucleus/graphics.h

MEMBERS:
dwSize          - Set to size of structure in bytes
Flags           - BitBltFx flags to define the type of BitBlt operation (GA_BitBltFxFlagsType)
Mix             - Logical mix operation (if mixes enabled)
ColorKeyLo      - Color key low value of range (if color keying enabled)
ColorKeyHi      - Color key high value of range (if color keying enabled)
SrcBlendFunc    - Src blend function (GA_blendFuncType)
DstBlendFunc    - Dst blend function (GA_blendFuncType)
ConstColor      - Constant color value for blending if blending enabled
ConstAlpha      - Constant alpha blend factor (0-255 if blending enabled)
BitsPerPixel    - Color depth for the source bitmap
PixelFormat     - Pixel format for the source bitmap
DstPalette      - Color index palette for destination (if destination color index)
SrcPalette      - Color index palette for source bitmap (if source color index)
TranslateVec    - Pre-computed color translation vector for color conversion
ClipLeft        - Left coordinate for destination clip rectangle
ClipTop         - Top coordinate for destination clip rectangle
ClipRight       - Right coordinate for destination clip rectangle
ClipBottom      - Bottom coordinate for destination clip rectangle
****************************************************************************/
typedef struct {
    N_uint32        dwSize;
    N_uint32        Flags;
    N_int32         Mix;
    GA_color        ColorKeyLo;
    GA_color        ColorKeyHi;
    N_int32         SrcBlendFunc;
    N_int32         DstBlendFunc;
    GA_color        ConstColor;
    N_uint32        ConstAlpha;
    N_int32         BitsPerPixel;
    GA_pixelFormat  *PixelFormat;
    GA_palette      *DstPalette;
    GA_palette      *SrcPalette;
    GA_color        *TranslateVec;
    N_int32         ClipLeft;
    N_int32         ClipTop;
    N_int32         ClipRight;
    N_int32         ClipBottom;
    } GA_bltFx;

/* {secret} */
struct _GA_3DState;

/****************************************************************************
REMARKS:
Graphics mode information block. This structure contains detailed information
about the capabilities and layout of a specific graphic mode.

The Attributes member contains a number of flags that describes certain
important characteristics of the graphics mode, and the values this member
contains are defined in the GA_AttributeFlagsType.

The XResolution and YResolution specify the logical width and height in pixel
elements for this display mode. The logical resolution is the resolution of
all available pixels in the display which may be larger than the physical
resolution if the mode has hardware panning enabled. Hardware panning is
enabled if the maximum physical resolution of the display device does not
support the specific mode, such as when hot switching between a CRT monitor
and an LCD panel or TV output device.

The BytesPerScanLine member specifies how many full bytes are in each logical
scanline. The logical scanline could be equal to or larger than the displayed
scanline, and can be changed when the display mode is first initialized.

The MaxBytesPerScanLine and MaxScanLineWidth members define the maximum
virtual framebuffer coordinates that can be initialised for the mode, in
both bytes and pixels respectively. If an attempt is made to initialize a
graphics mode with values larger than these values, the mode set will fail.

The MaxScanLines member holds the total number of scanlines available in
that graphics mode when initialised with the default scanline width. This
field combined with BytesPerScanLine can be used to determine the maximum
addressable display memory for drawing operations. This can also be used to
determine how large a virtual screen image can be before initialising a
graphics mode. This field also determines the addressable limit for
X/Y based drawing functions in offscreen video memory.

The LinearHeapStart member determines the start of the linear only heap,
if one is available. Some hardware has restrictions on the addressable memory
for the (x,y) coordinates passed to the 2D drawing functions. If the
hardware supports DrawRectLin and the BitBltLin family of functions, the
memory past the (x,y) coordinate restriction can be accessed using those
functions. Hence this member determines the start of this linear only
heap as a byte offset from the beginning of display memory. Memory in the
linear only heap can only be accessed directly via the linear framebuffer,
or using DrawRectLin or the BitBitLin family of blitting functions. None of
the X/Y based drawing functions can be used to draw to the linear only heap.

The MaxLinearOffset member hold the maximum addressable display memory
offset for linear drawing functions (DrawRectLin, BitBltLin etc). If the
hardware has restrictions on the addressable memory for the X/Y drawing
functions, the linear only heap resides between LinearHeapStart and
MaxLinearOffset. If the maximum addressable scanline value for a display
mode is past the end of display memory (common for high resolution modes),
then LinearHeapStart = MaxLinearOffset which indicates that there is no
linear only heap for that display mode.

NOTE:   There may well be some memory used by the graphics hardware
        for caching the hardware cursor, patterns and other data between
        the end of (MaxScanLines * BytesPerScanLine) and LinearHeapStart.
        Hence the application software must /never/ write to the memory
        between (MaxScanLines * BytesPerScanLine) and LinearHeapStart.

The BitsPerPixel member specifies the number of bits per pixel for this
display mode. For 5:5:5 format RGB modes this should contain a value of 15,
and for 5:6:5 format RGB modes this should contain a value of 16. For 8:8:8
bit RGB modes this should contain a value of 24 and for 8:8:8:8 RGBA modes
this should contain a value of 32. For 24 and 32bpp modes, the application
should look at the pixel format mask values (see below) to determine the
actual format of the pixels within the display buffer.

The MaxBuffers member specified the maximum number of display buffers that
can be allocated in video memory for page flipping. This value is a
convenience function only, and can be computed manually from the value
of MaxScanLines / YResolution.

The MaxPixelClock member specifies the maximum possible pixel dot clock that
can be selected in this display mode when a refresh controlled mode is
selected. Any attempt to select a higher pixel clock will cause the mode set
to fail. This member can be used to determine what the maximum available
refresh rate for the display mode will be.

The RedMaskSize, GreenMaskSize, BlueMaskSize and RsvdMaskSize members define
the size, in bits, of the red, green, and blue components of an RGB pixel
respectively. A bit mask can be constructed from the MaskSize members using
simple shift arithmetic. For example, the MaskSize values for an RGB 5:6:5
mode would be 5, 6, 5, and 0, for the red, green, blue, and reserved members
respectively.

The RedFieldPosition, GreenFieldPosition, BlueFieldPosition and
RsvdFieldPosition members define the bit position within the RGB pixel of
the least significant bit of the respective color component. A color value
can be aligned with its pixel member by shifting the value left by the
FieldPosition. For example, the FieldPosition values for an RGB 5:6:5 mode
would be 11, 5, 0, and 0, for the red, green, blue, and reserved members
respectively.

The BitmapStartAlign member defines the alignment requirements in bytes for
offscreen memory bitmaps for this graphics mode. If the value in here is
set to 8 for instance, then the start for all offscreen bitmaps must be
aligned to an 8 byte boundary in order to be used for offscreen bitmap
blitting. Note that the BitmapStartAlign member also defines the alignment
requirements for all buffers passed to the SetDrawBuffer function.

The BitmapStridePad member defines the alignment requirements in bytes for
the stride of offscreen memory bitmaps (the number of bytes to move from
one line of the bitmap to the next). If the value in here is set to 8 for
instance, then the number of bytes for each scanline in the offscreen
bitmap must be padded out to a multiple of 8 (inserting zeros if necessary
when downloading a source bitmap to offscreen memory). Note that the
BitmapStridePad member also defines the padding requirements for all
buffers passed to the SetDrawBuffer function.

The MonoBitmapStartAlign member defines the alignment requirements in bytes
for monochrome offscreen memory bitmaps for this graphics mode, which are
used by the PutMonoImageMSBLin and PutMonoImageLSBLin functions. If the
value in here is set to 8 for instance, then the start for all monochrome
offscreen bitmaps must be aligned to an 8 byte boundary in order to be used
by the PutMonoImageMSBLin and PutMonoImageLSBLin functions.

The MonoBitmapStridePad member defines the alignment requirements in bytes
for the stride of monochrome offscreen memory bitmaps (the number of bytes
to move from one line of the bitmap to the next). If the value in here is
set to 8 for instance, then the number of bytes for each scanline in the
monochrome offscreen bitmap must be padded out to a multiple of 8 (inserting
zeros if necessary when downloading a source bitmap to offscreen memory).

The RefreshRateList member contains a list of all valid refresh rates
supported by the display mode which can be passed to the SetVideoMode
function. Interlaced modes are indicated by a negative refresh rate
(ie: 48Hz Interlaced is -48). The current default refresh rate is stored
in the DefaultRefreshRate member, and except for special circumstances the
default refresh rate set by the user should be used rather than overriding
the refresh rate.

The BitBltCaps member defines the extended hardware BitBlt capabilities
for the graphics mode, and points to a static GA_bltFx structure. Refer
to the documentation of GA_bltFx to determine what this structure contains.

The VideoWindows member defines the hardware video capabilities for each of
up to a maximum number of hardware video overlay windows. The list of
hardware video overlay window capabilities is terminated with a NULL pointer.
For instance if only 2 hardware video windwos are supported, the first two
entries in this array would point to valid GA_videoInf structures, while the
third would contain a NULL terminating the list. Refer to the documentation
of GA_videoInf to determine what these structures contains.

The HW3DCaps member defined the hardware 3D capabilities for the graphics
mode, and points to a static GA_3DState structure. Refer to the
documentation of GA_3DState to determine what this structure contains.

The LinearSize member is the 32-bit length of the linear frame buffer memory
in bytes. In can be any length up to the size of the available video memory.
The LinearBasePtr member is the 32-bit physical address of the start of frame
buffer memory when the controller is in linear frame buffer memory mode for
this particular graphics mode. If the linear framebuffer is not available,
then this member will be zero.

The AttributesExt member contains a number of extended flags that describes
certain important characteristics of the graphics mode, and the values this
member contains are defined in the GA_AttributeExtFlagsType.

The PhysicalXResolution and PhysicalYResolution specify the physical width and
height in pixel elements for this display mode. The physical resolution is the
resolution of all visible pixels on the display, and may be smaller than the
logical resolution if the mode has hardware panning enabled.

Note:   The LinearSize and LinearBasePtr members are duplicated in the mode
        information block because they may possibly change locations in
        memory depending on the display mode. Normally applications will
        always use the value stored in the the GA_devCtx LinearMem pointer
        to directly access the framebuffer (which is automatically adjusted
        for you), however if the information about the framebuffer starting
        address needed to be reported to other applications directly, the
        values stored in this mode information block should be used.

Note:   The memory pointed to by the RefreshRateList, BitBltCaps,
        VideoWindows and HW3DCaps fields will be reused the next time
        GetVideoModeInfo is called, so do not rely on the information in
        these fields to remain the same across calls to this function.

Note:   The dwSize member is intended for future compatibility, and
        should be set to the size of the structure as defined in this
        header file. Future drivers will be compatible with older software
        by examiming this value.

HEADER:
nucleus/graphics.h

MEMBERS:
dwSize              - Set to size of structure in bytes
Attributes          - Mode attributes
XResolution         - Logical horizontal resolution in pixels
YResolution         - Logical vertical resolution in lines
XCharSize           - Character cell X dimension for text modes
YCharSize           - Character cell Y dimension for text modes
BytesPerScanLine    - Bytes per horizontal scan line
MaxBytesPerScanLine - Maximum bytes per scan line
MaxScanLineWidth    - Maximum pixels per scan line
MaxScanLines        - Maximum number of scanlines for default scanline width
LinearHeapStart     - Start of linear only heap (if any)
MaxLinearOffset     - Maximum display memory offset for linear drawing
BitsPerPixel        - Bits per pixel
PixelFormat         - Pixel format for the display mode
MaxBuffers          - Maximum number of display buffers
MaxPixelClock       - Maximum pixel clock for mode
DefaultRefreshRate  - Currently active default refresh rate
RefreshRateList     - List of all valid refresh rates terminated with -1.
BitmapStartAlign    - Linear bitmap start alignment in bytes
BitmapStridePad     - Linear bitmap stride pad in bytes
MonoBitmapStartAlign - Linear bitmap start alignment in bytes
MonoBitmapStridePad - Linear bitmap stride pad in bytes
BitBltCaps          - Hardware 2D BitBltFx capabilities
VideoWindows        - Up to 8 hardware video overlays
HW3DCaps            - Hardware 3D capabilities
MaxOOZ              - Maximum ooz coordinate value in floating point
MaxOOW              - Maximum oow coordinate value in floating point
MaxOOS              - Maximum one over s coordinate value in floating point
MaxOOT              - Maximum one over t coordinate value in floating point
DepthFormats        - Depth buffer formats flags
DepthStartAlign     - Depth buffer start alignment in bytes
DepthStridePad      - Depth buffer stride pad in bytes
TextureFormats      - Texture formats flags
TextureStartAlign   - Texture start alignment in bytes
TextureStridePad    - Texture stride pad in bytes
TextureMaxX         - Maximum texture X dimension
TextureMaxY         - Maximum texture Y dimension
TextureMaxAspect    - Maximum texture aspect ratio (1:x)
StencilFormats      - Stencil buffer formats flags
StencilStartAlign   - Stencil buffer start alignment in bytes
StencilStridePad    - Stencil buffer stride pad in bytes
LinearSize          - Linear buffer size in bytes
LinearBasePtr       - Physical addr of linear buffer
AttributesExt       - Extended mode attributes flags
PhysicalXResolution - Physical horizontal resolution in pixels
PhysicalYResolution - Physical vertical resolution in lines
****************************************************************************/
typedef struct {
    N_uint32        dwSize;
    N_uint32        Attributes;
    N_uint16        XResolution;
    N_uint16        YResolution;
    N_uint8         XCharSize;
    N_uint8         YCharSize;
    N_uint32        BytesPerScanLine;
    N_uint32        MaxBytesPerScanLine;
    N_uint32        MaxScanLineWidth;
    N_uint32        MaxScanLines;
    N_uint32        LinearHeapStart;
    N_uint32        MaxLinearOffset;
    N_uint16        BitsPerPixel;
    GA_pixelFormat  PixelFormat;
    N_uint16        MaxBuffers;
    N_uint32        MaxPixelClock;
    N_int32         DefaultRefreshRate;
    N_int32         _FAR_ *RefreshRateList;
    N_uint32        BitmapStartAlign;
    N_uint32        BitmapStridePad;
    N_uint32        MonoBitmapStartAlign;
    N_uint32        MonoBitmapStridePad;
    GA_bltFx        _FAR_ *BitBltCaps;
    GA_videoInf     _FAR_ * _FAR_ *VideoWindows;
    struct _GA_3DState  _FAR_ *HW3DCaps;
    N_flt32         MaxOOZ;
    N_flt32         MaxOOW;
    N_flt32         MaxOOS;
    N_flt32         MaxOOT;
    N_uint32        DepthFormats;
    N_uint32        DepthStartAlign;
    N_uint32        DepthStridePad;
    N_uint32        TextureFormats;
    N_uint32        TextureStartAlign;
    N_uint32        TextureStridePad;
    N_uint32        TextureMaxX;
    N_uint32        TextureMaxY;
    N_uint16        TextureMaxAspect;
    N_uint32        StencilFormats;
    N_uint32        StencilStartAlign;
    N_uint32        StencilStridePad;
    N_uint32        LinearSize;
    N_uint32        LinearBasePtr;
    N_uint32        AttributesExt;
    N_uint16        PhysicalXResolution;
    N_uint16        PhysicalYResolution;
    } GA_modeInfo;

/****************************************************************************
REMARKS:
CRTC information block for refresh rate control, passed in to the
SetVideoMode function.

The HorizontalTotal, HorizontalSyncStart, HorizontalSyncEnd, VerticalTotal,
VerticalSyncStart and VerticalSyncEnd members define the default normalized
CRTC values that will be programmed if the gaRefreshCtl flag is passed to
SetVideoMode. The CRTC values for a particular resolution will always be the
same regardless of color depth. Note also that the CRTC table does not
contain any information about the horizontal and vertical blank timing
positions. It is up the the driver implementation to determine the correct
blank timings to use for the mode when it is initialized depending on the
constraints of the underlying hardware (some hardware does not require this
information, and most VGA compatible hardware can be very picky about the
values programmed for the blank timings).

The Flags member defines the flags that modify the operation of the mode,
and the values for this member are defined in the GA_CRTCInfoFlagsType
enumeration.

The PixelClock member defines the normalized pixel clock that will be
programmed into the hardware. This value is represented in a 32 bit unsigned
integer in units of Hz. For example to represent a pixel clock of 25.18Mhz
one would code a value of 25,180,000. From the pixel clock and the horizontal
and vertical totals, you can calculate the refresh rate for the specific
graphics mode using the following formula:

    refresh rate = (PixelClock * 10,000) /
                   (HorizontalTotal * VerticalTotal)

For example a 1024x768 mode with a HTotal of 1360, VTotal of 802, a pixel
clock of 130Mhz might be computed as follows:

    refresh rate = (130 * 10,000) / (1360 * 802)
                 = 59.59 Hz

The RefreshRate field defines the refresh rate that the CRTC information
values define. This value may not actually be used by the driver but must be
calculated by the application program using the above formulas before
initializing the mode. This entry may be used by the driver to identify any
special cases that may need to be handled when setting the mode for specific
refresh rates.  The value in this field should be represented in units if
0.01 Hz (ie: a value 7200 represents a refresh rate of 72.00Hz).

Note:   The dwSize member is intended for future compatibility, and
        should be set to the size of the structure as defined in this
        header file. Future drivers will be compatible with older software
        by examiming this value.

HEADER:
nucleus/graphics.h

MEMBERS:
HorizontalTotal     - Horizontal total (pixels)
HorizontalSyncStart - Horizontal sync start position
HorizontalSyncEnd   - Horizontal sync end position
VerticalTotal       - Vertical Total (lines)
VerticalSyncStart   - Vertical sync start position
VerticalSyncEnd     - Vertical sync end position
PixelClock          - Pixel clock in units of Hz
RefreshRate         - Expected refresh rate in .01Hz
Flags               - Initialisation flags for mode
****************************************************************************/
typedef struct {
    N_uint16    HorizontalTotal;
    N_uint16    HorizontalSyncStart;
    N_uint16    HorizontalSyncEnd;
    N_uint16    VerticalTotal;
    N_uint16    VerticalSyncStart;
    N_uint16    VerticalSyncEnd;
    N_uint32    PixelClock;
    N_uint16    RefreshRate;
    N_uint8     Flags;
    } GA_CRTCInfo;

/****************************************************************************
REMARKS:
Structure to maintain the information about the current display mode. This
structure is used internally by Nucleus drivers, and is only defined here
so that we can manage the shared state structure in shared environments.

HEADER:
nucleus/graphics.h

MEMBERS:
bytesPerLine    - Bytes per logical scanline
xRes            - Horizontal pixel resolution
yRes            - Vertical pixel resolution
bits            - Color depth per pixel (0 = text mode)
flags           - Mode flags defining the mode capabilities
{secret}
****************************************************************************/
typedef struct {
    short       bytesPerLine;
    short       xRes;
    short       yRes;
    uchar       bits;
    ulong       flags;
    } GA_modeEntry;

/****************************************************************************
REMARKS:
Structure to maintain global state information shared between instances
of Nucleus drivers when running in shared environments. This allows the
separate Nucleus driver instances to keep in sync with each other. This
information is not used externally by Nucleus applications, but only
internally by the Nucleus drivers.

HEADER:
nucleus/graphics.h

MEMBERS:
reloadCRTC  - True if the CRTC tables should be reloaded on the next mode set
cntModeNum  - Currently active Nucleus mode number
cntMode     - Entry containing information about the current display mode
cntModeInfo - Full GA_modeInfo structure for the display mode
cntCRTC     - Copy of the current CRTC timings in use
{secret}
****************************************************************************/
typedef struct {
    N_int32         reloadCRTC;
    N_int32         cntModeNum;
    GA_modeEntry    cntMode;
    GA_modeInfo     cntModeInfo;
    GA_CRTCInfo     cntCRTC;
    } GA_sharedInfo;

/****************************************************************************
REMARKS:
Generic graphics buffer parameter block. This structure defines a generic
buffer in offscreen video memory, and is passed to the driver to make
such buffers active rendering operations. The Offset member is the offset
of the start of the buffer in video memory. The Stride member defines the
stride of the buffer in bytes, while the Width and Height members define the
dimensions of the buffer in logical pixel units.

Note:   All buffers are in packed pixel format, and the values of the Offset
        and Stride members must adhere to the format restrictions defined in
        the GA_modeInfo structure for the buffer type being enabled.

Note:   The dwSize member is intended for future compatibility, and
        should be set to the size of the structure as defined in this
        header file. Future drivers will be compatible with older software
        by examiming this value.

HEADER:
nucleus/graphics.h

MEMBERS:
dwSize          - Set to size of structure in bytes
Offset          - Buffer starting address in bytes
Stride          - Stride of the buffer in bytes (bytes for a line of data)
Width           - Width of buffer in pixels
Height          - Height of the buffer in pixels
****************************************************************************/
typedef struct {
    N_uint32        dwSize;
    N_int32         Offset;
    N_int32         Stride;
    N_int32         Width;
    N_int32         Height;
    } GA_buffer;

/****************************************************************************
REMARKS:
Generic offscreen managed buffer structure, which is used to describe
offscreen managed buffers, and is allocated using the AllocBuffer function.
Offscreen managed buffers are used to allocate and manage offscreen video
memory and system memory buffers.

Note:   If the buffer is linear based, the StartX and StartY members will
        contain a value of -1.

Note:   The dwSize member is intended for future compatibility, and
        should be set to the size of the structure as defined in this
        header file. Future drivers will be compatible with older software
        by examiming this value.

HEADER:
nucleus/graphics.h

MEMBERS:
dwSize          - Set to size of structure in bytes
Width           - Width of buffer in pixels
Height          - Height of the buffer in pixels
Stride          - Stride of the buffer in bytes (bytes for a line of data)
CacheStride     - Stride of the buffer in system memory buffer cache
StartX          - Starting X coordinate in framebuffer for buffer (if x,y based)
StartY          - Starting Y coordinate in framebuffer for buffer (if x,y based)
Offset          - Linear buffer starting address in bytes
Flags           - Flags for the buffer (GA_BufferFlagsType)
Format          - Internal format indicator for the buffer
UseageCount     - Useage count for tracking pageable buffers
Surface         - Pointer to start of the buffer surface
SurfaceCache    - Pointer to surface cache in system memory (NULL if uncached)
AppInfo         - Pointer to application data if necessary
****************************************************************************/
typedef struct {
    N_uint32        dwSize;
    N_int32         Width;
    N_int32         Height;
    N_int32         Stride;
    N_int32         CacheStride;
    N_int32         StartX;
    N_int32         StartY;
    N_int32         Offset;
    N_int32         Flags;
    N_int32         Format;
    N_int32         UseageCount;
    void            *Surface;
    void            *SurfaceCache;
    void            *AppInfo;
    } GA_buf;

/****************************************************************************
REMARKS:
Defines the fundamental type for a Nucleus clipper object. The internals
of this object are completely implementation dependant so we simply define
this type as a void pointer as the application code should never care
about the internals of a GA_clipper object.

HEADER:
nucleus/graphics.h
****************************************************************************/
typedef void GA_clipper;

/****************************************************************************
REMARKS:
Hardware monochrome cursor structure. This structure defines a monochrome hardware
cursor that is downloaded to the hardware. The cursor is defined as a 64x64
image with an AND and XOR mask. The definition of the AND mask, XOR mask and
the pixels that will appear on the screen is as follows (same as the
Microsoft Windows cursor format):

    AND XOR Result
    0   0   Transparent (color from screen memory)
    0   1   Invert (complement of color from screen memory)
    1   0   Cursor background color
    1   1   Cursor foreground color

The HotX and HotY members define the /hot spot/ for the cursor, which is
the location where the logical mouse pointer is located in the cursor
image. When you click the mouse, the pixel under the hot-spot is the pixel
selected.

HEADER:
nucleus/graphics.h

MEMBERS:
XORMask     - Cursor XOR mask
ANDMask     - Cursor AND mask
HotX        - Cursor X coordinate hot spot
HotY        - Cursor Y coordinate hot spot
****************************************************************************/
typedef struct {
    N_uint8     XORMask[512];
    N_uint8     ANDMask[512];
    N_uint32    HotX;
    N_uint32    HotY;
    } GA_monoCursor;

/****************************************************************************
REMARKS:
Hardware 16-color cursor structure. This structure defines a color hardware
cursor that is downloaded to the hardware. The cursor is defined as a 64x64
image with an AND mask and color data. The definition of the AND mask,
cursor data and the pixels that will appear on the screen is as follows:

    AND Color   Result
    0   0       Transparent (color from screen memory)
    0   not 0   Invert (complement of color from screen memory)
    1   xx      Cursor color data

Hence if the AND mask is a zero the color data should be either 00 to make
the pixel transparent or not 0 to make it the inversion of the screen pixel.

The color data is passed down to the driver as 4-bit packed color index
values, along with a 16-color lookup table containing the real 24-bit RGB
color values for the cursor image. It is up to the calling application to
translate and quantise cursor images of higher color depths down to the
format supported by the hardware.

The HotX and HotY members define the /hot spot/ for the cursor, which is
the location where the logical mouse pointer is located in the cursor
image. When you click the mouse, the pixel under the hot-spot is the pixel
selected.

HEADER:
nucleus/graphics.h

MEMBERS:
ColorData   - Cursor color data as a 64x64 array of packed 4-bit pixels
ANDMask     - Cursor AND mask
Palette     - 16-color palette for cursor image
HotX        - Cursor X coordinate hot spot
HotY        - Cursor Y coordinate hot spot
****************************************************************************/
typedef struct {
    N_uint8     ColorData[2048];
    N_uint8     ANDMask[512];
    GA_palette  Palette[16];
    N_uint32    HotX;
    N_uint32    HotY;
    } GA_colorCursor;

/****************************************************************************
REMARKS:
Hardware 256-color cursor structure. This structure defines a color hardware
cursor that is downloaded to the hardware. The cursor is defined as a 64x64
image with an AND mask and color data. The definition of the AND mask,
cursor data and the pixels that will appear on the screen is as follows:

    AND Color   Result
    0   0       Transparent (color from screen memory)
    0   not 0   Invert (complement of color from screen memory)
    1   xx      Cursor color data

Hence if the AND mask is a zero the color data should be either 00 to make
the pixel transparent or not 0 to make it the inversion of the screen pixel.

The color data is passed down to the driver as 8-bit packed color index
values, along with a 256-color lookup table containing the real 24-bit RGB
color values for the cursor image. It is up to the calling application to
translate and quantise cursor images of higher color depths down to the
format supported by the hardware.

The HotX and HotY members define the /hot spot/ for the cursor, which is
the location where the logical mouse pointer is located in the cursor
image. When you click the mouse, the pixel under the hot-spot is the pixel
selected.

HEADER:
nucleus/graphics.h

MEMBERS:
ColorData   - Cursor color data as a 64x64 array of packed 8-bit pixels
ANDMask     - Cursor AND mask
Palette     - 256-color palette for cursor image
HotX        - Cursor X coordinate hot spot
HotY        - Cursor Y coordinate hot spot
****************************************************************************/
typedef struct {
    N_uint8     ColorData[4096];
    N_uint8     ANDMask[512];
    GA_palette  Palette[256];
    N_uint32    HotX;
    N_uint32    HotY;
    } GA_colorCursor256;

/****************************************************************************
REMARKS:
Hardware 24-bit cursor structure. This structure defines a color hardware
cursor that is downloaded to the hardware. The cursor is defined as a 64x64
image with an AND mask and color data. The definition of the AND mask,
cursor data and the pixels that will appear on the screen is as follows:

    AND Color   Result
    0   0       Transparent (color from screen memory)
    0   not 0   Invert (complement of color from screen memory)
    1   xx      Cursor color data

Hence if the AND mask is a zero the color data should be either 00 to make
the pixel transparent or not 0 to make it the inversion of the screen pixel.

The color data is passed down to the driver as 24-bit packed RGB color
values. It is up to the calling application to translate cursor images of
lower color depths to the format supported by the hardware.

The HotX and HotY members define the /hot spot/ for the cursor, which is
the location where the logical mouse pointer is located in the cursor
image. When you click the mouse, the pixel under the hot-spot is the pixel
selected.

HEADER:
nucleus/graphics.h

MEMBERS:
ColorData   - Cursor color data as a 64x64 array of packed 24-bit RGB pixels
ANDMask     - Cursor AND mask
HotX        - Cursor X coordinate hot spot
HotY        - Cursor Y coordinate hot spot
****************************************************************************/
typedef struct {
    N_uint8     ColorData[12288];
    N_uint8     ANDMask[512];
    N_uint32    HotX;
    N_uint32    HotY;
    } GA_colorCursorRGB;

/****************************************************************************
REMARKS:
Hardware 24-bit RGBA alpha blended cursor structure. This structure defines
a color hardware cursor that is downloaded to the hardware. The cursor is
defined as a 64x64 24-bit RGBA image with alpha channel. The alpha channel
data is used to define the transparency level for the bitmap, with 0 being
fully transparent and 255 being full opaque. Since the color bitmap data
is alpha blended, the is no AND mask for the cursor image.

The HotX and HotY members define the /hot spot/ for the cursor, which is
the location where the logical mouse pointer is located in the cursor
image. When you click the mouse, the pixel under the hot-spot is the pixel
selected.

HEADER:
nucleus/graphics.h

MEMBERS:
ColorData   - Cursor color data as a 64x64 array of packed 24-bit RGBA pixels
HotX        - Cursor X coordinate hot spot
HotY        - Cursor Y coordinate hot spot
****************************************************************************/
typedef struct {
    N_uint8     ColorData[16384];
    N_uint32    HotX;
    N_uint32    HotY;
    } GA_colorCursorRGBA;

/****************************************************************************
REMARKS:
Parameter block for the 2D DrawTrap function. This structure is used to pass
in the information about a trapezoid to be rendered by the hardware to the
driver DrawTrap function.

HEADER:
nucleus/graphics.h

MEMBERS:
y       - Starting Y coordinate
count   - Number of scanlines to draw
x1      - Starting X1 coordinate in 16.16 fixed point
x2      - Starting X2 coordinate in 16.16 fixed point
slope1  - First edge slope in 16.16 fixed point format
slope2  - Second edge slope in 16.16 fixed point format
****************************************************************************/
typedef struct {
    N_uint32    y;
    N_uint32    count;
    N_fix32     x1;
    N_fix32     x2;
    N_fix32     slope1;
    N_fix32     slope2;
    } GA_trap;

/****************************************************************************
REMARKS:
Structure pointed to be the GA_certifyInfo structure, which contains
certification information about the specific chipsets in the device driver.

Note:   The dwSize member is intended for future compatibility, and
        should be set to the size of the structure as defined in this
        header file. Future drivers will be compatible with older software
        by examiming this value.

HEADER:
nucleus/graphics.h

MEMBERS:
dwSize              - Set to size of structure in bytes
ChipsetName         - Name of graphics chipset name
CertifyVersion      - Version of certification program used
CertifiedDate       - Date that the card was certified
CertifyFlags        - Flags for certification information
****************************************************************************/
typedef struct {
    N_uint32    dwSize;
    char        ChipsetName[30];
    N_uint16    CertifyVersion;
    char        CertifiedDate[19];
    N_uint8     CertifyFlags;
    } GA_certifyChipInfo;

/****************************************************************************
REMARKS:
Structure returned by GetCertifyInfo, which contains configuration
information about the certification status of the drivers.

Note:   The dwSize member is intended for future compatibility, and
        should be set to the size of the structure as defined in this
        header file. Future drivers will be compatible with older software
        by examiming this value.

HEADER:
nucleus/graphics.h

MEMBERS:
dwSize              - Set to size of structure in bytes
Signature           - Signature to identify certification information
BuildDate           - String representation of the build date for driver
MaxCertifiedCards   - Maximum number of certified chipsets in driver
NumCertifiedCards   - Number of certified chipsets
CertifiedCards      - List of all certified cards in the driver
****************************************************************************/
typedef struct {
    N_uint32            dwSize;
    char                Signature[20];
    char                BuildDate[30];
    char                MaxCertifiedChips;
    char                NumCertifiedChips;
    GA_certifyChipInfo  *CertifiedCards;
    } GA_certifyInfo;

/****************************************************************************
REMARKS:
Structure returned by GetConfigInfo, which contains configuration
information about the installed graphics hardware.

Note:   The dwSize member is intended for future compatibility, and
        should be set to the size of the structure as defined in this
        header file. Future drivers will be compatible with older software
        by examiming this value.

HEADER:
nucleus/graphics.h

MEMBERS:
dwSize              - Set to size of structure in bytes
ManufacturerName    - Name of graphics chipset manufacturer
ChipsetName         - Name of graphics chipset name
DACName             - Name of DAC on graphics card
ClockName           - Name of clock on graphics card
VersionInfo         - String representation of version and build for driver
BuildDate           - String representation of the build date for driver
Certified           - True if the installed device is certified
CertifiedDate       - Date when the device was certified
CertifyVersion      - Version of certification program used
****************************************************************************/
typedef struct {
    N_uint32        dwSize;
    char            ManufacturerName[80];
    char            ChipsetName[80];
    char            DACName[80];
    char            ClockName[80];
    char            VersionInfo[80];
    char            BuildDate[80];
    char            Certified;
    char            CertifiedDate[20];
    N_uint16        CertifyVersion;
    } GA_configInfo;

/****************************************************************************
REMARKS:
Structure used to describe the available display modes in the Nucleus
options structure. This allows the end user to add and delete available
display modes from the Nucleus drivers easily using our generic Nucleus
driver interface.

HEADER:
nucleus/graphics.h

MEMBERS:
xRes    - Horizontal pixel resolution
yRes    - Vertical pixel resolution
bits    - Color depth per pixel (0 = text mode)
****************************************************************************/
typedef struct {
    short       xRes;
    short       yRes;
    uchar       bits;
    } GA_mode;

/****************************************************************************
REMARKS:
Structure used to describe the TV parameters specific to a particular TV
output mode. We store these values independently in the options structure
for different TV modes (ie: 640x480, 800x600, PAL, NTSC etc).

HEADER:
nucleus/graphics.h

MEMBERS:
hPos        - Horizontal position value (+-)
vPos        - Vertical position value (+-)
brightness  - Brightness control value
contrast    - Contrast control value
****************************************************************************/
typedef struct {
    N_int16     hPos;
    N_int16     vPos;
    N_uint16    brightness;
    N_uint16    contrast;
    } GA_TVParams;

/****************************************************************************
REMARKS:
Structure used to determine the layout in multi-controller modes. The
layout is defined as adajacent rectangles for each device, and should
be set up using the multi-controller setup program.

HEADER:
nucleus/graphics.h

MEMBERS:
left            - Left coordinate for layout rectangle
top             - Top coordinate for layout rectangle
right           - Right coordinate for layout rectangle
bottom          - Bottom coordinate for layout rectangle
****************************************************************************/
typedef struct {
    N_uint32    left;
    N_uint32    top;
    N_uint32    right;
    N_uint32    bottom;
    } GA_layout;

#define GA_MAX_RESOLUTIONS  20
#define GA_MAX_COLORDEPTHS  8

/****************************************************************************
REMARKS:
Structure returned by GetOptions, which contains configuration
information about the options for the installed device driver. All the
boolean configuration options are enabled by default and can be optionally
turned off by the user via the configuration functions.

This structure also contains the configuration information for the software
stereo page flipping support in Nucleus.

If you select the gaGlassesIOPort type, then you need to fill
in the ioPort, ioAndMask, ioLeftOrMask, ioRightOrMask and ioOffOrMask
fields. These fields define the values used to toggle the specified I/O
port when the glasses need to be flipped. First the existing value is read
from the specified I/O port, the AND mask in applied and then the appropriate
OR mask is applied depending on the state of the glasses. This value is
then written back to the desired I/O port.

If you select the gaGlassesGenericVSync type, then you need to fill in the
VSyncWidthLeft and VSyncWidthRight fields, which define the vertical
sync width to program when the desired eye should be active.

The values in the RTCFrequency and RTCAdvanceTicks define the frequency
of the stereo timer interrupt, which can be used to fine tune the overheads
taken by the stereo page flip handler for maximum performance before
stuttering begins (ie: lost frames). The RTCFrequency field can be any
power of 2 frequency between 1024Hz and 8192H, and the RTCAdvanceTicks
should be a value larger than 1. For most systems an RTCFrequency value
of 2048 and an RTCAdvanceTicks of 2 will work well. Nucleus will however
choose good defaults for the target OS if these values are not overridden.

Note:   The dwSize member is intended for future compatibility, and
        should be set to the size of the structure as defined in this
        header file. Future drivers will be compatible with older software
        by examiming this value.

HEADER:
nucleus/graphics.h

MEMBERS:
dwSize                  - Set to size of structure in bytes
memoryClock             - Currently configured memory clock
defaultMemoryClock      - Current hardware default memory clock
maxMemoryClock          - Maximum allowable memory clock
gammaRamp               - Default gamma ramp for RGB display modes
outputDevice            - Currently configured output device
TV640PALUnder           - TV parameters for 640x480 PAL underscan modes
TV640NTSCUnder          - TV parameters for 640x480 NTSC underscan modes
TV640PALOver            - TV parameters for 640x480 PAL overscan modes
TV640NTSCOver           - TV parameters for 640x480 NTSC overscan modes
TV800PALUnder           - TV parameters for 800x600 PAL underscan modes
TV800NTSCUnder          - TV parameters for 800x600 NTSC underscan modes
TV800PALOver            - TV parameters for 800x600 PAL overscan modes
TV800NTSCOver           - TV parameters for 800x600 NTSC overscan modes
numHorzDisplay          - Number of horizontal displays
numVertDisplay          - Number of vertical displays
RTCFrequency            - Frequency for real time clock for software stereo
RTCAdvanceTicks         - Number of ticks to advance for software stereo
glassesType             - Type of stereo glasses defined by GA_glassesTypeFlags
ioPort                  - Generic I/O port for controlling glasses
ioAndMask               - I/O port AND mask
ioLeftOrMask            - I/O port OR mask when left eye is active
ioRightOrMask           - I/O port OR mask when right eye is active
ioOffOrMask             - I/O port OR mask when glasses are off
vSyncWidthLeft          - Vertical sync width when left eye is active
vSyncWidthRight         - Vertical sync width when right eye is active
text80x43Height         - Character height for 80x43 text mode (8,14 or 16)
text80x50Height         - Character height for 80x50 text mode (8,14 or 16)
text80x60Height         - Character height for 80x60 text mode (8,14 or 16)
text100x43Height        - Character height for 100x43 text mode (8,14 or 16)
text100x50Height        - Character height for 100x50 text mode (8,14 or 16)
text100x60Height        - Character height for 100x60 text mode (8,14 or 16)
text132x43Height        - Character height for 132x43 text mode (8,14 or 16)
text132x50Height        - Character height for 132x50 text mode (8,14 or 16)
text132x60Height        - Character height for 132x60 text mode (8,14 or 16)
tripleScanLowRes        - True to triple scan low res modes
doubleScan512           - True to double scan 512x384 modes
stereoRefresh           - Value to use for stereo mode refresh rate
stereoRefreshInterlaced - Value to use for stereo mode interlaced refresh rate
stereoMode              - Stereo mode to be used for fullscreen applications
stereoModeWindowed      - Stereo mode to be used for windowed applications
stereoBlankInterval     - Stereo mode blank interval for above below format
stereoDevice            - Stereo device ID defined by stereo control panel
engineClock             - Currently configured graphics engine clock
defaultEngineClock      - Current hardware default graphics engine clock
maxEngineClock          - Maximum allowable graphics engine clock
LCDPanelWidth           - Width of attached LCD panel in pixels
LCDPanelHeight          - Height of attached LCD panel in lines
bLCDExpand              - Enable expansion of modes to fill LCD panel
bDebugMode              - Enable debug log filter driver (0 is off)
bGenericRefresh         - Enable generic refresh rate control
bDialAMode              - Enable Dial-A-Mode generic mode interface
bVirtualScroll          - Enable virtual scrolling functions
bDoubleBuffer           - Enable double buffering functions
bTripleBuffer           - Enable triple buffering functions
bHardwareStereoSync     - Enable hardware stereo sync flag
bStereo                 - Enable stereo display mode support
bMultiDisplay           - Enable multiple display mode support
bPortrait               - Enable portrait display mode
bFlipped                - Enable flipped display mode
bInvertColors           - Enable invert color mode
bVirtualDisplay         - Enable virtual display mode
bAGPFastWrite           - Enable AGP fast write (only here to be licensed)
bZoom                   - Enable zoom support
bMultiHead              - Enable multi-head support
bTVOut                  - Enable TV Output support
bTVTuner                - Enable TV Tuner support
bDualHead               - Enable Dual Head CRTC support
bDPMS                   - Enable DPMS Display Power Management support
bDDC                    - Enable DDC Display Data Channel functions
bDDCCI                  - Enable DDC/CI Control Interface functions
bGammaCorrect           - Enable gamma correction
bHardwareCursor         - Enable hardware cursor
bHardwareVideo          - Enable hardware video
bHardwareAccel2D        - Enable hardware 2D acceleration
bHardwareAccel3D        - Enable hardware 2D acceleration
bMonoPattern            - Enable 8x8 mono pattern fills
bTransMonoPattern       - Enable 8x8 mono transparent pattern fills
bColorPattern           - Enable 8x8 color pattern fills
bTransColorPattern      - Enable 8x8 color transparent pattern fills
bSysMem                 - Enable system memory blits
bLinear                 - Enable linear offscreen memory blits
bBusMaster              - Enable bus mastering functions
bDrawScanList           - Enable DrawScanList family of functions
bDrawEllipseList        - Enable DrawEllipseList family of functions
bDrawFatEllipseList     - Enable DrawFatEllipseList family of functions
bDrawRect               - Enable DrawRect family of functions
bDrawRectLin            - Enable DrawRectLin family of functions
bDrawTrap               - Enable DrawTrap family of functions
bDrawLine               - Enable DrawLine function
bDrawStippleLine        - Enable DrawStippleLine function
bPutMonoImage           - Enable PutMonoImage family of functions
bClipMonoImage          - Enable ClipMonoImage family of functions
bBitBlt                 - Enable BitBlt family of functions
bBitBltPatt             - Enable BitBltPatt family of functions
bBitBltColorPatt        - Enable BitBltColorPatt family of functions
bSrcTransBlt            - Enable SrcTransBlt family of functions
bDstTransBlt            - Enable DstTransBlt family of functions
bStretchBlt             - Enable StretchBlt family of functions
bConvertBlt             - Enable ConvertBlt family of functions
bStretchConvertBlt      - Enable StretchConvertBlt family of functions
bBitBltFx               - Enable BitBltFx family of functions
bGetBitmap              - Enable GetBitmap family of functions
multiHeadSize           - Virtual size for multi-head displays
multiHeadRes            - Physical resolutions for multi-head displays
multiHeadBounds         - Virtual layout for multi-head displays
****************************************************************************/
typedef struct {
    N_uint32        dwSize;
    N_fix32         memoryClock;
    N_fix32         defaultMemoryClock;
    N_fix32         maxMemoryClock;
    GA_paletteExt   gammaRamp[256];
    N_int32         outputDevice;
    GA_TVParams     TV640PALUnder;
    GA_TVParams     TV640NTSCUnder;
    GA_TVParams     TV640PALOver;
    GA_TVParams     TV640NTSCOver;
    GA_TVParams     TV800PALUnder;
    GA_TVParams     TV800NTSCUnder;
    GA_TVParams     TV800PALOver;
    GA_TVParams     TV800NTSCOver;
    N_uint8         bRes1;
    N_uint8         bRes2;
    N_int32         RTCFrequency;
    N_int32         RTCAdvanceTicks;
    N_uint8         bRes3;
    N_uint16        ioPort;
    N_uint8         ioAndMask;
    N_uint8         ioLeftOrMask;
    N_uint8         ioRightOrMask;
    N_uint8         ioOffOrMask;
    N_uint8         vSyncWidthLeft;
    N_uint8         vSyncWidthRight;
    N_uint8         text80x43Height;
    N_uint8         text80x50Height;
    N_uint8         text80x60Height;
    N_uint8         text100x43Height;
    N_uint8         text100x50Height;
    N_uint8         text100x60Height;
    N_uint8         text132x43Height;
    N_uint8         text132x50Height;
    N_uint8         text132x60Height;
    N_uint8         tripleScanLowRes;
    N_uint8         doubleScan512;
    N_uint8         stereoRefresh;
    N_uint8         stereoRefreshInterlaced;
    N_uint8         stereoMode;
    N_uint8         stereoModeWindowed;
    N_uint8         stereoBlankInterval;
    N_uint8         stereoRefreshWindowed;
    N_uint8         stereoRefreshWindowedInterlaced;
    N_uint32        stereoDevice;
    N_uint16        glassesType;
    N_uint16        stereoBlankIntervalPercent;
    N_fix32         engineClock;
    N_fix32         defaultEngineClock;
    N_fix32         maxEngineClock;
    N_uint8         stereoControlPanelOptions;
    N_uint8         stereoCursorRedraw;
    N_uint8         res0[14];
    N_int16         LCDPanelWidth;
    N_int16         LCDPanelHeight;
    N_uint8         bLCDExpand;
    N_uint8         bPrefer16bpp;
    N_uint8         bPrefer32bpp;
    N_int16         TVMaxWidth;
    N_int16         TVMaxHeight;
    N_uint8         res1[95];
    N_uint32        resolutions[GA_MAX_RESOLUTIONS];
    N_uint8         colorDepths[GA_MAX_COLORDEPTHS];
    N_uint8         maxRefresh;
    N_uint8         accelType;
    N_uint8         res2[159];
    N_uint8         bDebugMode;
    N_uint8         bGenericRefresh;
    N_uint8         bDialAMode;
    N_uint8         bVirtualScroll;
    N_uint8         bDoubleBuffer;
    N_uint8         bTripleBuffer;
    N_uint8         bHardwareStereoSync;
    N_uint8         bStereo;
    N_uint8         bMultiDisplay;
    N_uint8         bPortrait;
    N_uint8         bFlipped;
    N_uint8         bInvertColors;
    N_uint8         bReserved1;
    N_uint8         bReserved2;
    N_uint8         bVirtualDisplay;
    N_uint8         bAGPFastWrite;
    N_uint8         bZoom;
    N_uint8         bMultiHead;
    N_uint8         res3[154];
    N_uint8         bTVOut;
    N_uint8         bTVTuner;
    N_uint8         bDualHead;
    N_uint8         bDPMS;
    N_uint8         bDDC;
    N_uint8         bDDCCI;
    N_uint8         bGammaCorrect;
    N_uint8         bHardwareCursor;
    N_uint8         bHardwareColorCursor;
    N_uint8         bHardwareVideo;
    N_uint8         bHardwareAccel2D;
    N_uint8         bHardwareAccel3D;
    N_uint8         bMonoPattern;
    N_uint8         bTransMonoPattern;
    N_uint8         bColorPattern;
    N_uint8         bTransColorPattern;
    N_uint8         bSysMem;
    N_uint8         bLinear;
    N_uint8         bBusMaster;
    N_uint8         bDrawScanList;
    N_uint8         bDrawEllipseList;
    N_uint8         bDrawFatEllipseList;
    N_uint8         bDrawRect;
    N_uint8         bDrawRectLin;
    N_uint8         bDrawTrap;
    N_uint8         bDrawLine;
    N_uint8         bDrawStippleLine;
    N_uint8         bPutMonoImage;
    N_uint8         bClipMonoImage;
    N_uint8         bBitBlt;
    N_uint8         bBitBltPatt;
    N_uint8         bBitBltColorPatt;
    N_uint8         bSrcTransBlt;
    N_uint8         bDstTransBlt;
    N_uint8         bStretchBlt;
    N_uint8         bConvertBlt;
    N_uint8         bStretchConvertBlt;
    N_uint8         bBitBltFx;
    N_uint8         bGetBitmap;
    N_uint8         res4[256];
    GA_layout       multiHeadSize;
    GA_layout       multiHeadRes[GA_MAX_HEADS];
    GA_layout       multiHeadBounds[GA_MAX_HEADS];
    } GA_options;

#define FIRST_OPTION    bGenericRefresh
#define LAST_OPTION     bGetBitmap

/****************************************************************************
REMARKS:
Structure used to store the recommended modes for Nucleus.

HEADER:
nucleus/graphics.h

MEMBERS:
XResolution     - X resolution for the recommended mode
YResolution     - Y resolution for the recommended mode
BitsPerPixel    - BitsPerPixel for the recommended mode
RefreshRate     - RefreshRate for the recommended mode (up to 127Hz)
****************************************************************************/
typedef struct {
    N_uint16    XResolution;
    N_uint16    YResolution;
    N_uint8     BitsPerPixel;
    N_int8      RefreshRate;
    } GA_recMode;

/****************************************************************************
REMARKS:
Structure returned by GA_getGlobalOptions, which contains configuration
information about the options effective for all installed display devices.
This structure also contains the layout information used for multi-controller
options in Nucleus (such as what screen is located where).

Note:   The dwSize member is intended for future compatibility, and
        should be set to the size of the structure as defined in this
        header file. Future drivers will be compatible with older software
        by examiming this value.

HEADER:
nucleus/graphics.h

MEMBERS:
dwSize                  - Set to size of structure in bytes
bVirtualDisplay         - Enable virtual display mode
bPortrait               - Enable portrait display mode
bFlipped                - Enable flipped display mode
bInvertColors           - Enable invert color mode
bVBEOnly                - Enable VBE/Core fallback driver
bVGAOnly                - Enable VGA fallback driver
bReserved1              - Reverved option; must *always* be zero!
bAllowNonCertified      - Allow uncertified drivers to load
wCertifiedVersion       - Version of certify program to allow
bNoWriteCombine         - Disable write combining
bLCDUseBIOS             - Enable use of BIOS when on the LCD panel
bUseMemoryDriver        - Enable system memory driver
wSysMemSize             - Amount of memory to allocate for sysmem driver (Kb)
dwCPLFlags              - Place to store control panel UI settings
dwSharedAGPMemSize      - Amount of shared AGP memory to use for framebuffer
bUseVBECore             - Use the VBE/Core emulation driver
bUseVGACore             - Use the VGA/Core emulation driver
dwCheckForUpdates       - Time stamp to check for updates next
bNoDDCDetect            - Disable automatic DDC monitor detection
bDisableLogFile         - Disable logging of information to log file
bCheckWebSelection      - SDD GUI specific value for web check updates
virtualSize             - Virtual size for multi-controller displays
resolutions             - Physical resolutions for multi-controller displays
bounds                  - Virtual layout for multi-controller displays
****************************************************************************/
typedef struct {
    N_uint32        dwSize;
    N_uint8         bVirtualDisplay;
    N_uint8         bPortrait;
    N_uint8         bFlipped;
    N_uint8         bInvertColors;
    N_uint8         bVBEOnly;
    N_uint8         bVGAOnly;
    N_uint8         bReserved1;
    N_uint16        wCertifiedVersion;
    N_uint8         bNoWriteCombine;
    N_uint8         bAllowNonCertified;
    N_uint8         bLCDUseBIOS;
    N_uint8         bUseMemoryDriver;
    N_uint16        wSysMemSize;
    N_uint32        dwReserved2;
    N_uint8         bVBEUseLinear;
    N_uint8         bVBEUsePal;
    N_uint8         bVBEUsePM32;
    N_uint8         bReserved2;
    N_uint8         bVBEUseVBE20;
    N_uint8         bVBEUseVBE30;
    N_uint8         bVBEUsePM;
    N_uint8         bVBEUseSCI;
    N_uint8         bVBEUseDDC;
    N_uint8         bGDIUseAccel;
    N_uint8         bGDIUseBrushCache;
    N_uint8         bGDIUseBitmapCache;
    N_uint8         bDXUseAccel2D;
    N_uint8         bDXUseAccel3D;
    N_uint8         bDXUseAccelVideo;
    N_uint8         bDXWaitRetrace;
    N_uint32        dwCPLFlags;
    N_uint32        dwSharedAGPMemSize;
    N_uint8         bUseVBECore;
    N_uint8         bUseVGACore;
    N_uint32        dwCheckForUpdates;
    N_uint8         bNoDDCDetect;
    N_uint8         bDisableLogFile;
    N_uint8         bCheckWebSelection;
    N_uint16        wMonitorHSize;
    N_uint16        wMonitorVSize;
    N_uint16        wOptimizedModeXRes;
    N_uint16        wOptimizedModeYRes;
    N_uint16        wOptimizedModeBits;
    GA_recMode      recommendedMode;
    GA_recMode      recommendedMode8;
    GA_recMode      recommendedMode16;
    GA_recMode      recommendedMode24;
    GA_recMode      recommendedMode32;
    N_uint8         bAGPFastWrite;
    N_uint8         res1[67];
    GA_layout       virtualSize;
    GA_layout       resolutions[GA_MAX_VIRTUAL_DISPLAYS];
    GA_layout       bounds[GA_MAX_VIRTUAL_DISPLAYS];
    } GA_globalOptions;

/****************************************************************************
REMARKS:
Structure returned by GetModeProfile, which contains configuration
information about the mode profile for the installed device driver. A
default mode profile is shipped with the graphics device drivers, but a new
mode profile can be downloaded at any time (to implement new display modes
using the new Dial-A-Mode interface). Note that a mode must also have
the associated CRTC tables before it will work.

Note:   The dwSize member is intended for future compatibility, and
        should be set to the size of the structure as defined in this
        header file. Future drivers will be compatible with older software
        by examiming this value.

HEADER:
nucleus/graphics.h

MEMBERS:
dwSize      - Set to size of structure in bytes
numModes    - Count for the number of configured display modes
modeList    - Array of up to 256 configured display modes
numModes    - Count for the number of configured display modes
vbeModeList - Array of up to 256 modes reported to the VBE driver
****************************************************************************/
typedef struct {
    N_uint32    dwSize;
    struct {
        N_uint8 numModes;
        GA_mode modeList[256];
        } m;
    struct {
        N_uint8 numModes;
        GA_mode modeList[256];
        } vbe;
    } GA_modeProfile;

/****************************************************************************
REMARKS:
Main graphics device context structure. This structure consists of a header
block that contains configuration information about the graphic device,
as well as detection information and runtime state information.

The Signature member is filled with the null terminated string 'GRAPHICS\0'
by the driver implementation. This can be used to verify that the file loaded
really is an graphics device driver.

The Version member is a BCD value which specifies what revision level of the
graphics specification is implemented in the driver. The high byte specifies
the major version number and the low byte specifies the minor version number.
For example, the BCD value for version 1.0 is 0x100 and the BCD value for
version 2.2 would be 0x202.

The DriverRev member specifies the driver revision level, and is used by the
driver configuration software to determine which version was used to generate
the driver file.

The OemVendorName member contains the name of the vendor that developed the
device driver implementation, and can be up to 80 characters in length.

The OemCopyright member contains a copyright string for the vendor that
developed the device driver implementation and may be up to 80 characters
in length.

The AvailableModes is an pointer within the loaded driver to a list of mode
numbers for all displaymodes supported by the graphics driver.  Each mode
number occupies one word (16-bits), and is terminated by a -1 (0FFFFh). Any
modes found in this list are guaranteed to be available for the current
configuration.

The TotalMemory member indicates the maximum amount of memory physically
installed and available to the frame buffer in 1Kb units. Note that not all
graphics modes will be able to address all of this memory.

The Attributes member contains a number of flags that describes certain
important characteristics of the graphics controller. The members are
exactly the same as those provided in the GA_modeInfo block for each video
mode, but the meaning is slightly different. For each flag defined in the
GA_AttributeFlagsType enumeration, it represents whether the controller can
support these modes in any available graphics modes. Please see the
GetVideoModeInfo function for a detailed description of each flags meaning.

The TextSize member contains the size of the text mode framebuffer in bytes.
It will generally be 64Kb in length. The TextBasePtr member is a
32-bit physical memory address where the text mode framebuffer memory window
is located in the CPU address space. This will generally be 0xB0000 to cover
the VGA text framebuffer window (both color and monochrome modes).

The BankSize member contains the size of the banked memory buffer in bytes.
It can be either 4Kb or 64Kb in length. The BankedBasePtr member is a
32-bit physical memory address where the banked framebuffer memory window is
located in the CPU address space. If the banked framebuffer mode is not
available, then this member will be zero.

The LinearSize member is the 32-bit length of the linear frame buffer memory
in bytes. In can be any length up to the size of the available video memory.
The LinearBasePtr member is the 32-bit physical address of the start of frame
buffer memory when the controller is in linear frame buffer memory mode. If
the linear framebuffer is not available, then this member will be zero.

The ZBufferSize member is the 32-bit length of the local z-buffer (or depth
buffer) memory in bytes. In can be any length up to the size of the available
local z-buffer memory. The ZBufferBasePtr member is the 32-bit physical
address of the start of local z-buffer memory. Note that if the controller
does not have local z-buffer memory, but shares the z-buffer in the local
framebuffer memory, these two fields will be set to 0.

The TexMemSize member is the 32-bit length of the local texture memory in
bytes. In can be any length up to the size of the available local texture
memory. The TexMemBasePtr member is the 32-bit physical address of the start
of local texture memory. Note that if the controller does not have local
texture memory, but loads textures in the local framebuffer memory, this
field will be set to 0.

The LockedMemSize contains the amount of locked, contiguous memory in bytes
that the graphics driver requires for programming the hardware. If the graphics
accelerator requires DMA transfers for 2D and 3D rendering operations, this
member can be set to the length of the block of memory that is required by
the driver. The driver loader code will attempt to allocate a block of
locked, physically contiguous memory from the operating system and place a
pointer to this allocated memory in the LockedMem member for the driver, and
the physical address of the start of this memory block in LockedMemPhys. Note
that the memory must be locked so it cannot be paged out do disk, and it must
be physically contiguous so that DMA operations will work correctly across
4Kb CPU page boundaries. If the driver does not require DMA memory, this
value should be set to 0.

The MMIOBase member contains the 32-bit physical base addresses pointing
to the start of up to 4 separate memory mapped register areas required by the
controller. The MMIOLen member contains the lengths of each of these
memory mapped IO areas in bytes. When the application maps the memory mapped
IO regions for the driver, the linear address of the mapped memory areas will
then be stored in the corresponding entries in the IOMemMaps array, and will
be used by the driver for accessing the memory mapped registers on the
controller. If any of these regions are not required, the MMIOBase
entries will be NULL and do not need to be mapped by the application.

Note:   The memory regions pointed to by the MMIOBase addresses have
        special meanings for the first two and second two addresses that are
        mapped. If the OS loader is running the driver in user space with a
        safety level of 2, then the only the first two base addresses will
        be mapped into user space, and the second two will be mapped only
        into kernel space (kernel space can also access the user space
        mappings). Please see QueryFunctions for a more detailed overview
        of the safety levels and how this relates to these regions.

The IOMemMaps member contains the mapped linear address of the memory mapped
register regions defined by the MMIOBase and MMIOLen members.

The TextMem member contains the mapped linear address of the text mode
framebuffer, and will be filled in by the application when it has loaded the
device driver. This provides the device driver with direct access to the
video memory on the controller when in text modes.

The BankedMem member contains the mapped linear address of the banked memory
framebuffer, and will be filled in by the application when it has loaded the
device driver. This provides the device driver with direct access to the
video memory on the controller when in the banked framebuffer modes.

The LinearMem member contains the mapped linear address of the linear memory
framebuffer, and will be filled in by the application when it has loaded the
device driver. This provides the device driver with direct access to the
video memory on the controller when in the linear framebuffer modes.

Note:   On some controllers the linear framebuffer address may be different
        for different color depths, so the value in this variable may change
        gater initializing a mode. Applications should always reload the
        address of the linear framebuffer from this variable gater
        initializing a mode set to ensure that the correct value is always
        used.

The ZBufferMem member contains the mapped linear address of the local
z-buffer memory, and will be filled in by the application when it has loaded
the device driver. This provides the device driver with direct access to the
local z-buffer memory on the controller. If the controller does not have
local z-buffer memory, this member will be set to NULL.

The TexBufferMem member contains the mapped linear address of the local
texture memory, and will be filled in by the application when it has loaded
the device driver. This provides the device driver with direct access to the
local texture memory on the controller. If the controller does not have
local texture memory, this member will be set to NULL.

The LockedMem member contains a pointer to the locked DMA memory buffer
allocated for the loaded driver. The graphics driver can use this pointer to
write data directly to the DMA buffer before transferring it to the hardware.
If the driver does not require DMA memory, this value will be set to NULL by
the loader.

The LockedMemPhys member contains the 32-bit physical memory address of the
locked DMA buffer memory allocated for the driver. The graphics driver can use
this physical address to set up DMA transfer operations for memory contained
within the DMA transfer buffer. If the driver does not require DMA memory,
this value will be set to 0 by the loader.

The TextFont8x8, TextFont8x14 and TextFont8x16 members contain pointers to
the 8x8, 8x14 and 8x16 text font bitmaps allocated by the OS loader. This
data is used by the driver for VGA and extended text modes that require the
bitmap font tables.

Note:   None of the function pointers in this structure are listed here
        for brevity. All the functions are documented in the function
        documentation section for each individual function. Please refer
        to this list, or the official nucleus/graphics.h header file for more
        information.

HEADER:
nucleus/graphics.h

MEMBERS:
Signature           - 'GRAPHICS\0' 20 byte signature
Version             - Driver Interface Version
DriverRev           - Driver revision number
OemVendorName       - Vendor Name string
OemCopyright        - Vendor Copyright string
AvailableModes      - Offset to supported mode table
DeviceIndex         - Device index for the driver when loaded from disk
TotalMemory         - Amount of memory in Kb detected
Attributes          - Driver attributes
WorkArounds         - Hardware WorkArounds flags
TextSize            - Length of the text framebuffer in bytes
TextBasePtr         - Base address of the text framebuffer
BankSize            - Bank size in bytes (4Kb or 64Kb)
BankedBasePtr       - Physical addr of banked buffer
LinearSize          - Linear buffer size in bytes
LinearBasePtr       - Physical addr of linear buffer
ZBufferSize         - Z-buffer size in bytes
ZBufferBasePtr      - Physical addr of Z-buffer
TexBufferSize       - Texture buffer size in bytes
TexBufferBasePtr    - Physical addr of texture buffer
LockedMemSize       - Amount of locked memory for driver in bytes
IOBase              - Base address for I/O mapped registers (relocateable)
MMIOBase            - Base address of memory mapped I/O regions
MMIOLen             - Length of memory mapped I/O regions in bytes
DriverStart         - Pointer to the start of the driver in memory
DriverSize          - Size of the entire driver in memory in bytes
BusType             - Indicates the type of bus for the device (GA_busType)
Attributes          - Driver extended attributes flags
IOMemMaps           - Pointers to mapped I/O memory
BankedMem           - Ptr to mapped banked video mem
LinearMem           - Ptr to mapped linear video mem
ZBufferMem          - Ptr to mapped zbuffer mem
TexBufferMem        - Ptr to mapped texture buffer mem
LockedMem           - Ptr to allocated locked memory
LockedMemPhys       - Physical addr of locked memory
TextFont8x8         - Ptr to 8x8 text font data
TextFont8x14        - Ptr to 8x14 text font data
TextFont8x16        - Ptr to 8x16 text font data
VGAPal4             - Ptr to the default VGA 4bpp palette
VGAPal8             - Ptr to the default VGA 8bpp palette
****************************************************************************/
typedef struct GA_devCtx {
    /*------------------------------------------------------------------*/
    /* Device driver header block                                       */
    /*------------------------------------------------------------------*/
    char            Signature[20];
    N_uint32        Version;
    N_uint32        DriverRev;
    char            OemVendorName[80];
    char            OemCopyright[80];
    N_uint16        _FAR_ *AvailableModes;
    N_int32         DeviceIndex;
    N_uint32        TotalMemory;
    N_uint32        Attributes;
    N_uint32        WorkArounds;
    N_uint32        TextSize;
    N_uint32        TextBasePtr;
    N_uint32        BankSize;
    N_uint32        BankedBasePtr;
    N_uint32        LinearSize;
    N_uint32        LinearBasePtr;
    N_uint32        ZBufferSize;
    N_uint32        ZBufferBasePtr;
    N_uint32        TexBufferSize;
    N_uint32        TexBufferBasePtr;
    N_uint32        LockedMemSize;
    N_uint32        IOBase;
    N_uint32        MMIOBase[4];
    N_uint32        MMIOLen[4];
    void            _FAR_ *DriverStart;
    N_uint32        DriverSize;
    N_uint32        BusType;
    N_uint32        AttributesExt;
    N_uint32        res1[18];

    /*------------------------------------------------------------------*/
    /* Near pointers mapped by loader for driver                        */
    /*------------------------------------------------------------------*/
    void            _FAR_ *IOMemMaps[4];
    void            _FAR_ *TextMem;
    void            _FAR_ *BankedMem;
    void            _FAR_ *LinearMem;
    void            _FAR_ *ZBufferMem;
    void            _FAR_ *TexBufferMem;
    void            _FAR_ *LockedMem;
    N_uint32        LockedMemPhys;
    void            _FAR_ *TextFont8x8;
    void            _FAR_ *TextFont8x14;
    void            _FAR_ *TextFont8x16;
    GA_palette      _FAR_ *VGAPal4;
    GA_palette      _FAR_ *VGAPal8;
    N_uint32        res3[18];

    /*------------------------------------------------------------------*/
    /* Internal values user by OS specific code                         */
    /*------------------------------------------------------------------*/
    struct GA_devCtx _FAR_ *ring0DC;
    void            _FAR_ *pMdl;

    /*------------------------------------------------------------------*/
    /* Driver initialization functions                                  */
    /*------------------------------------------------------------------*/
    N_int32         (NAPIP InitDriver)(void);
    ibool           (NAPIP QueryFunctions)(N_uint32 id,N_int32 safetyLevel,void _FAR_ *funcs);
    void            (NAPIP UnloadDriver)(void);
    } GA_devCtx;

/****************************************************************************
REMARKS:
Device driver hardware 2D state management functions.
{secret}
****************************************************************************/
typedef struct {
    N_uint32        dwSize;
    N_int32         (NAPIP SetDrawBuffer)(GA_buffer *drawBuf);
    N_int32         (NAPIP IsIdle)(void);
    void            (NAPIP WaitTillIdle)(void);
    void            (NAPIP EnableDirectAccess)(void);
    void            (NAPIP DisableDirectAccess)(void);
    N_int32         (NAPIP SetMix)(N_int32 mix);
    void            (NAPIP SetForeColor)(GA_color color);
    void            (NAPIP SetBackColor)(GA_color color);
    void            (NAPIP Set8x8MonoPattern)(N_int32 index,GA_pattern *pattern);
    void            (NAPIP Use8x8MonoPattern)(N_int32 index);
    void            (NAPIP Use8x8TransMonoPattern)(N_int32 index);
    void            (NAPIP Set8x8ColorPattern)(N_int32 index,GA_colorPattern *pattern);
    void            (NAPIP Use8x8ColorPattern)(N_int32 index);
    void            (NAPIP Use8x8TransColorPattern)(N_int32 index,GA_color transparent);
    void            (NAPIP SetLineStipple)(GA_stipple stipple);
    void            (NAPIP SetLineStippleCount)(N_uint32 count);
    void            (NAPIP SetPlaneMask)(N_uint32 mask);
    void            (NAPIP SetSrcBlendFunc_Obsolete)(N_int32 res1);
    void            (NAPIP SetDstBlendFunc_Obsolete)(N_int32 res2);
    void            (NAPIP SetAlphaValue)(N_uint8 alpha);
    void            (NAPIP SetupForWindows)(void);
    void            (NAPIP ResetForWindows)(void);
    void            (NAPIP SetLineStyle)(N_uint32 styleMask,N_uint32 styleStep,N_uint32 styleValue);
    void            (NAPIP BuildTranslateVector)(GA_color *translate,GA_palette *dstPal,GA_palette *srcPal,int srcColors);
    void            (NAPIP SetBlendFunc)(N_int32 srcBlendFunc,N_int32 dstBlendFunc);
    } GA_2DStateFuncs;

/****************************************************************************
REMARKS:
Device driver hardware 2D rendering functions.
{secret}
****************************************************************************/
typedef struct {
    N_uint32        dwSize;
    GA_color        (NAPIP GetPixel)(N_int32 x,N_int32 y);
    void            (NAPIP PutPixel)(N_int32 x,N_int32 y);
    void            (NAPIP DrawScanList)(N_int32 y,N_int32 length,N_int16 *scans);
    void            (NAPIP DrawPattScanList)(N_int32 y,N_int32 length,N_int16 *scans);
    void            (NAPIP DrawColorPattScanList)(N_int32 y,N_int32 length,N_int16 *scans);
    void            (NAPIP DrawEllipseList)(N_int32 y,N_int32 length,N_int32 height,N_int16 *scans);
    void            (NAPIP DrawPattEllipseList)(N_int32 y,N_int32 length,N_int32 height,N_int16 *scans);
    void            (NAPIP DrawColorPattEllipseList)(N_int32 y,N_int32 length,N_int32 height,N_int16 *scans);
    void            (NAPIP DrawFatEllipseList)(N_int32 y,N_int32 length,N_int32 height,N_int16 *scans);
    void            (NAPIP DrawPattFatEllipseList)(N_int32 y,N_int32 length,N_int32 height,N_int16 *scans);
    void            (NAPIP DrawColorPattFatEllipseList)(N_int32 y,N_int32 length,N_int32 height,N_int16 *scans);
    void            (NAPIP DrawRect)(N_int32 left,N_int32 top,N_int32 width,N_int32 height);
    void            *res1;
    void            (NAPIP DrawPattRect)(N_int32 left,N_int32 top,N_int32 width,N_int32 height);
    void            (NAPIP DrawColorPattRect)(N_int32 left,N_int32 top,N_int32 width,N_int32 height);
    void            (NAPIP DrawTrap)(GA_trap *trap);
    void            (NAPIP DrawPattTrap)(GA_trap *trap);
    void            (NAPIP DrawColorPattTrap)(GA_trap *trap);
    void            (NAPIP DrawLineInt)(N_int32 x1,N_int32 y1,N_int32 x2,N_int32 y2,N_int32 drawLast);
    void            (NAPIP DrawBresenhamLine)(N_int32 x1,N_int32 y1,N_int32 initialError,N_int32 majorInc,N_int32 diagInc,N_int32 count,N_int32 flags);
    void            (NAPIP DrawStippleLineInt)(N_int32 x1,N_int32 y1,N_int32 x2,N_int32 y2,N_int32 drawLast,N_int32 transparent);
    void            (NAPIP DrawBresenhamStippleLine)(N_int32 x1,N_int32 y1,N_int32 initialError,N_int32 majorInc,N_int32 diagInc,N_int32 count,N_int32 flags,N_int32 transparent);
    void            (NAPIP DrawEllipse)(N_int32 left,N_int32 top,N_int32 A,N_int32 B);
    void            (NAPIP ClipEllipse)(N_int32 left,N_int32 top,N_int32 A,N_int32 B,N_int32 clipLeft,N_int32 clipTop,N_int32 clipRight,N_int32 clipBottom);
    void            (NAPIP PutMonoImageMSBSys)(N_int32 x,N_int32 y,N_int32 width,N_int32 height,N_int32 byteWidth,N_uint8 *image,N_int32 transparent);
    void            (NAPIP PutMonoImageMSBLin)(N_int32 x,N_int32 y,N_int32 width,N_int32 height,N_int32 byteWidth,N_int32 imageOfs,N_int32 transparent);
    void            (NAPIP PutMonoImageMSBBM)(N_int32 x,N_int32 y,N_int32 width,N_int32 height,N_int32 byteWidth,N_uint8 *image,N_int32 imagePhysAddr,N_int32 transparent);
    void            (NAPIP PutMonoImageLSBSys)(N_int32 x,N_int32 y,N_int32 width,N_int32 height,N_int32 byteWidth,N_uint8 *image,N_int32 transparent);
    void            (NAPIP PutMonoImageLSBLin)(N_int32 x,N_int32 y,N_int32 width,N_int32 height,N_int32 byteWidth,N_int32 imageOfs,N_int32 transparent);
    void            (NAPIP PutMonoImageLSBBM)(N_int32 x,N_int32 y,N_int32 width,N_int32 height,N_int32 byteWidth,N_uint8 *image,N_int32 imagePhysAddr,N_int32 transparent);
    void            (NAPIP ClipMonoImageMSBSys)(N_int32 x,N_int32 y,N_int32 width,N_int32 height,N_int32 byteWidth,N_uint8 *image,N_int32 transparent,N_int32 clipLeft,N_int32 clipTop,N_int32 clipRight,N_int32 clipBottom);
    void            (NAPIP ClipMonoImageMSBLin)(N_int32 x,N_int32 y,N_int32 width,N_int32 height,N_int32 byteWidth,N_int32 imageOfs,N_int32 transparent,N_int32 clipLeft,N_int32 clipTop,N_int32 clipRight,N_int32 clipBottom);
    void            (NAPIP ClipMonoImageMSBBM)(N_int32 x,N_int32 y,N_int32 width,N_int32 height,N_int32 byteWidth,N_uint8 *image,N_int32 imagePhysAddr,N_int32 transparent,N_int32 clipLeft,N_int32 clipTop,N_int32 clipRight,N_int32 clipBottom);
    void            (NAPIP ClipMonoImageLSBSys)(N_int32 x,N_int32 y,N_int32 width,N_int32 height,N_int32 byteWidth,N_uint8 *image,N_int32 transparent,N_int32 clipLeft,N_int32 clipTop,N_int32 clipRight,N_int32 clipBottom);
    void            (NAPIP ClipMonoImageLSBLin)(N_int32 x,N_int32 y,N_int32 width,N_int32 height,N_int32 byteWidth,N_int32 imageOfs,N_int32 transparent,N_int32 clipLeft,N_int32 clipTop,N_int32 clipRight,N_int32 clipBottom);
    void            (NAPIP ClipMonoImageLSBBM)(N_int32 x,N_int32 y,N_int32 width,N_int32 height,N_int32 byteWidth,N_uint8 *image,N_int32 imagePhysAddr,N_int32 transparent,N_int32 clipLeft,N_int32 clipTop,N_int32 clipRight,N_int32 clipBottom);
    void            (NAPIP BitBlt)(N_int32 srcLeft,N_int32 srcTop,N_int32 width,N_int32 height,N_int32 dstLeft,N_int32 dstTop,N_int32 mix);
    void            (NAPIP BitBltLin)(N_int32 srcOfs,N_int32 srcPitch,N_int32 srcLeft,N_int32 srcTop,N_int32 width,N_int32 height,N_int32 dstLeft,N_int32 dstTop,N_int32 mix);
    void            (NAPIP BitBltSys)(void *srcAddr,N_int32 srcPitch,N_int32 srcLeft,N_int32 srcTop,N_int32 width,N_int32 height,N_int32 dstLeft,N_int32 dstTop,N_int32 mix,N_int32 flipY);
    void            (NAPIP BitBltBM)(void *srcAddr,N_int32 srcPhysAddr,N_int32 srcPitch,N_int32 srcLeft,N_int32 srcTop,N_int32 width,N_int32 height,N_int32 dstLeft,N_int32 dstTop,N_int32 mix);
    void            (NAPIP BitBltPatt)(N_int32 srcLeft,N_int32 srcTop,N_int32 width,N_int32 height,N_int32 dstLeft,N_int32 dstTop,N_int32 rop3);
    void            (NAPIP BitBltPattLin)(N_int32 srcOfs,N_int32 srcPitch,N_int32 srcLeft,N_int32 srcTop,N_int32 width,N_int32 height,N_int32 dstLeft,N_int32 dstTop,N_int32 rop3);
    void            (NAPIP BitBltPattSys)(void *srcAddr,N_int32 srcPitch,N_int32 srcLeft,N_int32 srcTop,N_int32 width,N_int32 height,N_int32 dstLeft,N_int32 dstTop,N_int32 rop3,N_int32 flipY);
    void            (NAPIP BitBltPattBM)(void *srcAddr,N_int32 srcPhysAddr,N_int32 srcPitch,N_int32 srcLeft,N_int32 srcTop,N_int32 width,N_int32 height,N_int32 dstLeft,N_int32 dstTop,N_int32 rop3);
    void            (NAPIP BitBltColorPatt)(N_int32 srcLeft,N_int32 srcTop,N_int32 width,N_int32 height,N_int32 dstLeft,N_int32 dstTop,N_int32 rop3);
    void            (NAPIP BitBltColorPattLin)(N_int32 srcOfs,N_int32 srcPitch,N_int32 srcLeft,N_int32 srcTop,N_int32 width,N_int32 height,N_int32 dstLeft,N_int32 dstTop,N_int32 rop3);
    void            (NAPIP BitBltColorPattSys)(void *srcAddr,N_int32 srcPitch,N_int32 srcLeft,N_int32 srcTop,N_int32 width,N_int32 height,N_int32 dstLeft,N_int32 dstTop,N_int32 rop3,N_int32 flipY);
    void            (NAPIP BitBltColorPattBM)(void *srcAddr,N_int32 srcPhysAddr,N_int32 srcPitch,N_int32 srcLeft,N_int32 srcTop,N_int32 width,N_int32 height,N_int32 dstLeft,N_int32 dstTop,N_int32 rop3);
    void            (NAPIP SrcTransBlt)(N_int32 srcLeft,N_int32 srcTop,N_int32 width,N_int32 height,N_int32 dstLeft,N_int32 dstTop,N_int32 mix,GA_color transparent);
    void            (NAPIP SrcTransBltLin)(N_int32 srcOfs,N_int32 srcPitch,N_int32 srcLeft,N_int32 srcTop,N_int32 width,N_int32 height,N_int32 dstLeft,N_int32 dstTop,N_int32 mix,GA_color transparent);
    void            (NAPIP SrcTransBltSys)(void *srcAddr,N_int32 srcPitch,N_int32 srcLeft,N_int32 srcTop,N_int32 width,N_int32 height,N_int32 dstLeft,N_int32 dstTop,N_int32 mix,GA_color transparent,N_int32 flipY);
    void            (NAPIP SrcTransBltBM)(void *srcAddr,N_int32 srcPhysAddr,N_int32 srcPitch,N_int32 srcLeft,N_int32 srcTop,N_int32 width,N_int32 height,N_int32 dstLeft,N_int32 dstTop,N_int32 mix,GA_color transparent);
    void            (NAPIP DstTransBlt)(N_int32 srcLeft,N_int32 srcTop,N_int32 width,N_int32 height,N_int32 dstLeft,N_int32 dstTop,N_int32 mix,GA_color transparent);
    void            (NAPIP DstTransBltLin)(N_int32 srcOfs,N_int32 srcPitch,N_int32 srcLeft,N_int32 srcTop,N_int32 width,N_int32 height,N_int32 dstLeft,N_int32 dstTop,N_int32 mix,GA_color transparent);
    void            (NAPIP DstTransBltSys)(void *srcAddr,N_int32 srcPitch,N_int32 srcLeft,N_int32 srcTop,N_int32 width,N_int32 height,N_int32 dstLeft,N_int32 dstTop,N_int32 mix,GA_color transparent,N_int32 flipY);
    void            (NAPIP DstTransBltBM)(void *srcAddr,N_int32 srcPhysAddr,N_int32 srcPitch,N_int32 srcLeft,N_int32 srcTop,N_int32 width,N_int32 height,N_int32 dstLeft,N_int32 dstTop,N_int32 mix,GA_color transparent);
    void            (NAPIP StretchBlt)(N_int32 srcLeft,N_int32 srcTop,N_int32 srcWidth,N_int32 srcHeight,N_int32 dstLeft,N_int32 dstTop,N_int32 dstWidth,N_int32 dstHeight,N_int32 doClip,N_int32 clipLeft,N_int32 clipTop,N_int32 clipRight,N_int32 clipBottom,N_int32 mix);
    void            (NAPIP StretchBltLin)(N_int32 srcOfs,N_int32 srcPitch,N_int32 srcLeft,N_int32 srcTop,N_int32 srcWidth,N_int32 srcHeight,N_int32 dstLeft,N_int32 dstTop,N_int32 dstWidth,N_int32 dstHeight,N_int32 doClip,N_int32 clipLeft,N_int32 clipTop,N_int32 clipRight,N_int32 clipBottom,N_int32 mix);
    void            (NAPIP StretchBltSys)(void *srcAddr,N_int32 srcPitch,N_int32 srcLeft,N_int32 srcTop,N_int32 srcWidth,N_int32 srcHeight,N_int32 dstLeft,N_int32 dstTop,N_int32 dstWidth,N_int32 dstHeight,N_int32 doClip,N_int32 clipLeft,N_int32 clipTop,N_int32 clipRight,N_int32 clipBottom,N_int32 mix,N_int32 flipY);
    void            (NAPIP StretchBltBM)(void *srcAddr,N_int32 srcPhysAddr,N_int32 srcPitch,N_int32 srcLeft,N_int32 srcTop,N_int32 srcWidth,N_int32 srcHeight,N_int32 dstLeft,N_int32 dstTop,N_int32 dstWidth,N_int32 dstHeight,N_int32 doClip,N_int32 clipLeft,N_int32 clipTop,N_int32 clipRight,N_int32 clipBottom,N_int32 mix);
    N_int32         (NAPIP ConvertBltSys_Obsolete)(void *srcAddr,N_int32 srcPitch,N_int32 srcLeft,N_int32 srcTop,N_int32 width,N_int32 height,N_int32 dstLeft,N_int32 dstTop,N_int32 bitsPerPixel,GA_pixelFormat *pixelFormat,GA_palette *dstPal,GA_palette *srcPal,N_int32 dither,N_int32 mix,N_int32 flipY);
    N_int32         (NAPIP ConvertBltBM_Obsolete)(void *srcAddr,N_int32 srcPhysAddr,N_int32 srcPitch,N_int32 srcLeft,N_int32 srcTop,N_int32 width,N_int32 height,N_int32 dstLeft,N_int32 dstTop,N_int32 bitsPerPixel,GA_pixelFormat *pixelFormat,GA_palette *dstPal,GA_palette *srcPal,N_int32 dither,N_int32 mix);
    N_int32         (NAPIP StretchConvertBltSys_Obsolete)(void *srcAddr,N_int32 srcPitch,N_int32 srcLeft,N_int32 srcTop,N_int32 srcWidth,N_int32 srcHeight,N_int32 dstLeft,N_int32 dstTop,N_int32 dstWidth,N_int32 dstHeight,N_int32 doClip,N_int32 clipLeft,N_int32 clipTop,N_int32 clipRight,N_int32 clipBottom,N_int32 bitsPerPixel,GA_pixelFormat *pixelFormat,GA_palette *dstPal,GA_palette *srcPal,N_int32 dither,N_int32 mix,N_int32 flipY);
    N_int32         (NAPIP StretchConvertBltBM_Obsolete)(void *srcAddr,N_int32 srcPhysAddr,N_int32 srcPitch,N_int32 srcLeft,N_int32 srcTop,N_int32 srcWidth,N_int32 srcHeight,N_int32 dstLeft,N_int32 dstTop,N_int32 dstWidth,N_int32 dstHeight,N_int32 doClip,N_int32 clipLeft,N_int32 clipTop,N_int32 clipRight,N_int32 clipBottom,N_int32 bitsPerPixel,GA_pixelFormat *pixelFormat,GA_palette *dstPal,GA_palette *srcPal,N_int32 dither,N_int32 mix);
    N_int32         (NAPIP BitBltFxTest)(GA_bltFx *fx);
    void            (NAPIP BitBltFx)(N_int32 srcLeft,N_int32 srcTop,N_int32 srcWidth,N_int32 srcHeight,N_int32 dstLeft,N_int32 dstTop,N_int32 dstWidth,N_int32 dstHeight,GA_bltFx *fx);
    void            (NAPIP BitBltFxLin)(N_int32 srcOfs,N_int32 srcPitch,N_int32 srcLeft,N_int32 srcTop,N_int32 srcWidth,N_int32 srcHeight,N_int32 dstLeft,N_int32 dstTop,N_int32 dstWidth,N_int32 dstHeight,GA_bltFx *fx);
    void            (NAPIP BitBltFxSys)(void *srcAddr,N_int32 srcPitch,N_int32 srcLeft,N_int32 srcTop,N_int32 srcWidth,N_int32 srcHeight,N_int32 dstLeft,N_int32 dstTop,N_int32 dstWidth,N_int32 dstHeight,GA_bltFx *fx);
    void            (NAPIP BitBltFxBM)(void *srcAddr,N_int32 srcPhysAddr,N_int32 srcPitch,N_int32 srcLeft,N_int32 srcTop,N_int32 srcWidth,N_int32 srcHeight,N_int32 dstLeft,N_int32 dstTop,N_int32 dstWidth,N_int32 dstHeight,GA_bltFx *fx);
    void            (NAPIP GetBitmapSys)(void *dstAddr,N_int32 dstPitch,N_int32 srcLeft,N_int32 srcTop,N_int32 width,N_int32 height,N_int32 dstLeft,N_int32 dstTop,N_int32 mix);
    void            (NAPIP GetBitmapBM)(void *dstAddr,N_int32 dstPhysAddr,N_int32 dstPitch,N_int32 srcLeft,N_int32 srcTop,N_int32 width,N_int32 height,N_int32 dstLeft,N_int32 dstTop,N_int32 mix);
    void            (NAPIP UpdateScreen)(N_int32 left,N_int32 top,N_int32 width,N_int32 height);
    N_int32         (NAPIP DrawClippedLineInt)(N_int32 x1,N_int32 y1,N_int32 x2,N_int32 y2,N_int32 drawLast,N_int32 clipLeft,N_int32 clipTop,N_int32 clipRight,N_int32 clipBottom);
    N_int32         (NAPIP DrawClippedBresenhamLine)(N_int32 x1,N_int32 y1,N_int32 initialError,N_int32 majorInc,N_int32 diagInc,N_int32 count,N_int32 flags,N_int32 clipLeft,N_int32 clipTop,N_int32 clipRight,N_int32 clipBottom);
    N_int32         (NAPIP DrawClippedStippleLineInt)(N_int32 x1,N_int32 y1,N_int32 x2,N_int32 y2,N_int32 drawLast,N_int32 transparent,N_int32 clipLeft,N_int32 clipTop,N_int32 clipRight,N_int32 clipBottom);
    N_int32         (NAPIP DrawClippedBresenhamStippleLine)(N_int32 x1,N_int32 y1,N_int32 initialError,N_int32 majorInc,N_int32 diagInc,N_int32 count,N_int32 flags,N_int32 transparent,N_int32 clipLeft,N_int32 clipTop,N_int32 clipRight,N_int32 clipBottom);
    void            (NAPIP BitBltPlaneMasked)(N_int32 srcLeft,N_int32 srcTop,N_int32 width,N_int32 height,N_int32 dstLeft,N_int32 dstTop,N_uint32 planeMask);
    void            (NAPIP BitBltPlaneMaskedLin)(N_int32 srcOfs,N_int32 srcPitch,N_int32 srcLeft,N_int32 srcTop,N_int32 width,N_int32 height,N_int32 dstLeft,N_int32 dstTop,N_uint32 planeMask);
    void            (NAPIP BitBltPlaneMaskedSys)(void *srcAddr,N_int32 srcPitch,N_int32 srcLeft,N_int32 srcTop,N_int32 width,N_int32 height,N_int32 dstLeft,N_int32 dstTop,N_uint32 planeMask,N_int32 flipY);
    void            (NAPIP BitBltPlaneMaskedBM)(void *srcAddr,N_int32 srcPhysAddr,N_int32 srcPitch,N_int32 srcLeft,N_int32 srcTop,N_int32 width,N_int32 height,N_int32 dstLeft,N_int32 dstTop,N_uint32 planeMask);
    void            (NAPIP DrawRectLin)(N_int32 dstOfs,N_int32 dstPitch,N_int32 left,N_int32 top,N_int32 width,N_int32 height,GA_color color,N_int32 mix);
    void            (NAPIP DrawRectExt)(N_int32 left,N_int32 top,N_int32 width,N_int32 height,GA_color color,N_int32 mix);
    void            (NAPIP DrawStyleLineInt)(N_int32 x1,N_int32 y1,N_int32 x2,N_int32 y2,N_int32 drawLast,N_int32 transparent);
    void            (NAPIP DrawBresenhamStyleLine)(N_int32 x1,N_int32 y1,N_int32 initialError,N_int32 majorInc,N_int32 diagInc,N_int32 count,N_int32 flags,N_int32 transparent);
    N_int32         (NAPIP DrawClippedStyleLineInt)(N_int32 x1,N_int32 y1,N_int32 x2,N_int32 y2,N_int32 drawLast,N_int32 transparent,N_int32 clipLeft,N_int32 clipTop,N_int32 clipRight,N_int32 clipBottom);
    N_int32         (NAPIP DrawClippedBresenhamStyleLine)(N_int32 x1,N_int32 y1,N_int32 initialError,N_int32 majorInc,N_int32 diagInc,N_int32 count,N_int32 flags,N_int32 transparent,N_int32 clipLeft,N_int32 clipTop,N_int32 clipRight,N_int32 clipBottom);
    } GA_2DRenderFuncs;

/****************************************************************************
REMARKS:
Main device driver init functions, including all mode information, setup and
initialisation functions.
{secret}
****************************************************************************/
typedef struct {
    N_uint32        dwSize;
    void            (NAPIP GetConfigInfo)(GA_configInfo *info);
    void            *res1;
    void            (NAPIP SetModeProfile)(GA_modeProfile *profile);
    void            (NAPIP GetOptions)(GA_options *options);
    void            (NAPIP SetOptions)(GA_options *options);
    N_int32         (NAPIP GetVideoModeInfo)(N_uint32 mode,GA_modeInfo *modeInfo);
    N_int32         (NAPIP SetVideoMode)(N_uint32 mode,N_int32 *virtualX,N_int32 *virtualY,N_int32 *bytesPerLine,N_int32 *maxMem,N_int32 refreshRate,GA_CRTCInfo *crtc);
    N_uint32        (NAPIP GetVideoMode)(void);
    N_int32         (NAPIP GetCustomVideoModeInfo)(N_int32 xRes,N_int32 yRes,N_int32 virtualX,N_int32 virtualY,N_int32 bitsPerPixel,GA_modeInfo *modeInfo);
    N_int32         (NAPIP SetCustomVideoMode)(N_int32 xRes,N_int32 yRes,N_int32 bitsPerPixel,N_uint32 flags,N_int32 *virtualX,N_int32 *virtualY,N_int32 *bytesPerLine,N_int32 *maxMem,GA_CRTCInfo *crtc);
    N_uint32        (NAPIP GetClosestPixelClock)(N_int32 xRes,N_int32 yRes,N_int32 bitsPerPixel,N_uint32 pixelClock);
    void            (NAPIP GetCRTCTimings)(GA_CRTCInfo *crtc);
    void            (NAPIP SaveCRTCTimings)(GA_CRTCInfo *crtc);
    void            (NAPIP SetGlobalRefresh)(N_int32 refresh);
    N_int32         (NAPIP SaveRestoreState)(N_int32 subfunc,void *saveBuf);
    N_int32         (NAPIP SetDisplayOutput)(N_int32 device);
    N_int32         (NAPIP GetDisplayOutput)(void);
    void            (NAPIP SetSoftwareRenderFuncs)(GA_2DRenderFuncs *softwareFuncs);
    void            (NAPIP GetUniqueFilename)(char *filename,int type);
    void            *res2;
    void            (NAPIP GetMonitorInfo)(GA_monitor *monitor);
    void            (NAPIP SetMonitorInfo)(GA_monitor *monitor);
    void            (NAPIP GetCurrentVideoModeInfo)(GA_modeInfo *modeInfo);
    void            (NAPIP GetCertifyInfo)(GA_certifyInfo *info);
    void            (NAPIP SetCRTCTimings)(GA_CRTCInfo *crtc);
    ibool           (NAPIP AlignLinearBuffer)(N_int32 height,N_int32 *stride,N_int32 *offset,N_int32 *size,N_int32 growUp);
    ulong *         (NAPIP GetIORegisterTraps)(void);
    N_int32         (NAPIP GetCurrentRefreshRate)(void);
    N_int32         (NAPIP PollForDisplaySwitch)(void);
    void            (NAPIP PerformDisplaySwitch)(void);
    N_int32         (NAPIP GetVideoModeInfoExt)(N_uint32 mode,GA_modeInfo *modeInfo,N_int32 outputDevice);
    N_int32         (NAPIP GetCustomVideoModeInfoExt)(N_int32 xRes,N_int32 yRes,N_int32 virtualX,N_int32 virtualY,N_int32 bitsPerPixel,GA_modeInfo *modeInfo,N_int32 outputDevice);
    N_int32         (NAPIP SwitchPhysicalResolution)(N_int32 physicalXResolution,N_int32 physicalYResolution,N_int32 refreshRate);
    N_int32         (NAPIP GetNumberOfHeads)(void);
    N_int32         (NAPIP SetActiveHead)(N_int32 headIndex);
    N_int32         (NAPIP GetActiveHead)(void);
    } GA_initFuncs;

/****************************************************************************
REMARKS:
Main device driver runtime functions, including those to set banks, change
the displayed video memory and program the palette.
{secret}
****************************************************************************/
typedef struct {
    N_uint32        dwSize;
    void            (NAPIP SetBank)(N_int32 bank);
    void            (NAPIP SetDisplayStart)(N_int32 offset,N_int32 waitVRT);
    void            (NAPIP SetDisplayStartXY)(N_int32 x,N_int32 y,N_int32 waitVRT);
    void            (NAPIP SetStereoDisplayStart)(N_int32 leftOffset,N_int32 rightOffset,N_int32 waitVRT);
    N_int32         (NAPIP GetDisplayStartStatus)(void);
    void            (NAPIP EnableStereoMode)(N_int32 enable);
    N_int32         (NAPIP IsVSync)(void);
    void            (NAPIP WaitVSync)(void);
    void            (NAPIP SetVSyncWidth)(N_int32 width);
    N_int32         (NAPIP GetVSyncWidth)(void);
    void            (NAPIP SetPaletteData)(GA_palette *pal,N_int32 num,N_int32 index,N_int32 waitVRT);
    void            (NAPIP GetPaletteData)(GA_palette *pal,N_int32 num,N_int32 index);
    void            (NAPIP SetGammaCorrectData)(GA_palette *pal,N_int32 num,N_int32 index,N_int32 waitVRT);
    void            (NAPIP GetGammaCorrectData)(GA_palette *pal,N_int32 num,N_int32 index);
    N_int32         (NAPIP GetCurrentScanLine)(void);
    void            (NAPIP SetPaletteDataExt)(GA_paletteExt *pal,N_int32 num,N_int32 index,N_int32 waitVRT);
    void            (NAPIP GetPaletteDataExt)(GA_paletteExt *pal,N_int32 num,N_int32 index);
    void            (NAPIP SetGammaCorrectDataExt)(GA_paletteExt *pal,N_int32 num,N_int32 index,N_int32 waitVRT);
    void            (NAPIP GetGammaCorrectDataExt)(GA_paletteExt *pal,N_int32 num,N_int32 index);
    } GA_driverFuncs;

/****************************************************************************
REMARKS:
VBE/Core emulation functions. These functions should not be used by
application programs, and they are only intended to be used by the
VBE/Core emulation driver.
{secret}
****************************************************************************/
typedef struct {
    N_uint32        dwSize;
    ibool           (NAPIP SetBytesPerLine)(int bytesPerLine,int *newBytes);
    ibool           (NAPIP Set8BitDAC)(ibool enable);
    void            (NAPIP SetPaletteData)(GA_palette *pal,N_int32 num,N_int32 index,N_int32 waitVRT);
    void            (NAPIP GetPaletteData)(GA_palette *pal,N_int32 num,N_int32 index);
    } GA_VBEFuncs;

/****************************************************************************
REMARKS:
Device driver hardware video overlay functions.
{secret}
****************************************************************************/
typedef struct {
    N_uint32        dwSize;
    GA_buf *        (NAPIP AllocVideoBuffer)(N_int32 width,N_int32 height,N_int32 format);
    void            (NAPIP FreeVideoBuffer)(GA_buf *videoBuffer);
    N_int32         (NAPIP SetVideoOutput)(GA_buf *videoBuffer,N_int32 left,N_int32 top,N_int32 width,N_int32 height,N_int32 flags);
    void            (NAPIP SetVideoColorKey)(GA_buf *videoBuffer,GA_color colorKeyLo,GA_color colorKeyHi);
    N_uint32        (NAPIP StartVideoFrame)(GA_buf *videoBuffer);
    void            (NAPIP EndVideoFrame)(GA_buf *videoBuffer);
    } GA_videoFuncs;

/****************************************************************************
REMARKS:
Structure defining all the software stereo functions passed into the
buffer manafer to enable stereo support.
{secret}
****************************************************************************/
typedef struct {
    ulong           dwSize;
    ibool           (NAPIP SoftStereoInit)(GA_devCtx *dc);
    void            (NAPIP SoftStereoOn)(void);
    void            (NAPIP SoftStereoScheduleFlip)(N_uint32 leftAddr,N_uint32 rightAddr);
    N_int32         (NAPIP SoftStereoGetFlipStatus)(void);
    void            (NAPIP SoftStereoWaitTillFlipped)(void);
    void            (NAPIP SoftStereoOff)(void);
    void            (NAPIP SoftStereoExit)(void);
    } GA_softStereoFuncs;

/* {partOf:TraverseRegion} */
typedef void (NAPIP GA_regionCallback)(const GA_rect *r,void *parms);

/****************************************************************************
REMARKS:
Region management functions. These functions may be used externally for
complex region management. They are also used internally by Nucleus for
buffer management.
{secret}
****************************************************************************/
typedef struct {
    N_uint32        dwSize;
    GA_region *     (NAPIP NewRegion)(void);
    GA_region *     (NAPIP NewRectRegion)(N_int32 left,N_int32 top,N_int32 right,N_int32 bottom);
    GA_region *     (NAPIP CopyRegion)(const GA_region *s);
    void            (NAPIP CopyIntoRegion)(GA_region *d,const GA_region *s);
    void            (NAPIP ClearRegion)(GA_region *r);
    void            (NAPIP FreeRegion)(GA_region *r);
    GA_region *     (NAPIP SectRegion)(const GA_region *r1,const GA_region *r2);
    GA_region *     (NAPIP SectRegionRect)(const GA_region *r1,const GA_rect *r);
    ibool           (NAPIP UnionRegion)(GA_region *r1,const GA_region *r2);
    ibool           (NAPIP UnionRegionRect)(GA_region *r1,const GA_rect *r);
    ibool           (NAPIP UnionRegionOfs)(GA_region *r1,const GA_region *r2,N_int32 dx,N_int32 dy);
    ibool           (NAPIP DiffRegion)(GA_region *r1,const GA_region *r2);
    ibool           (NAPIP DiffRegionRect)(GA_region *r1,const GA_rect *r);
    void            (NAPIP OptimizeRegion)(GA_region *r);
    void            (NAPIP OffsetRegion)(GA_region *r,N_int32 dx,N_int32 dy);
    ibool           (NAPIP IsEmptyRegion)(const GA_region *r);
    ibool           (NAPIP IsEqualRegion)(const GA_region *r1,const GA_region *r2);
    ibool           (NAPIP PtInRegion)(const GA_region *r,N_int32 x,N_int32 y);
    void            (NAPIP TraverseRegion)(GA_region *rgn,GA_regionCallback doRect,void *parms);
    } GA_regionFuncs;

/* Forward declaration for REF2D_driver structure */
struct _REF2D_driver;

/****************************************************************************
REMARKS:
Managed buffer functions. These functions layer offscreen and system
memory buffer management on top of the 2D and 3D rendering functions.
{secret}
****************************************************************************/
typedef struct {
    N_uint32        dwSize;
    ibool           (NAPIP InitBuffers)(N_int32 numBuffers,N_uint32 flags,GA_softStereoFuncs *stereo);
    GA_buf *        (NAPIP GetPrimaryBuffer)(void);
    GA_buf *        (NAPIP GetFlippableBuffer)(N_int32 index);
    GA_buf *        (NAPIP AllocBuffer)(N_int32 width,N_int32 height,N_int32 flags);
    ibool           (NAPIP FreeBuffer)(GA_buf *buf);
    N_uint32        (NAPIP LockBuffer)(GA_buf *buf);
    void            (NAPIP UnlockBuffer)(GA_buf *buf);
    N_int32         (NAPIP SetActiveBuffer)(GA_buf *buf);
    void            (NAPIP FlipToBuffer)(GA_buf *buf,N_int32 waitVRT);
    void            (NAPIP FlipToStereoBuffer)(GA_buf *left,GA_buf *right,N_int32 waitVRT);
    int             (NAPIP GetFlipStatus)(void);
    void            (NAPIP WaitTillFlipped)(void);
    void            (NAPIP UpdateCache)(GA_buf *buf);
    void            (NAPIP UpdateFromCache)(GA_buf *buf);
    void            (NAPIP BitBltBuf)(GA_buf *buf,N_int32 srcLeft,N_int32 srcTop,N_int32 width,N_int32 height,N_int32 dstLeft,N_int32 dstTop,N_int32 mix);
    void            (NAPIP BitBltPattBuf)(GA_buf *buf,N_int32 srcLeft,N_int32 srcTop,N_int32 width,N_int32 height,N_int32 dstLeft,N_int32 dstTop,N_int32 rop3);
    void            (NAPIP BitBltColorPattBuf)(GA_buf *buf,N_int32 srcLeft,N_int32 srcTop,N_int32 width,N_int32 height,N_int32 dstLeft,N_int32 dstTop,N_int32 rop3);
    void            (NAPIP SrcTransBltBuf)(GA_buf *buf,N_int32 srcLeft,N_int32 srcTop,N_int32 width,N_int32 height,N_int32 dstLeft,N_int32 dstTop,N_int32 mix,GA_color transparent);
    void            (NAPIP DstTransBltBuf)(GA_buf *buf,N_int32 srcLeft,N_int32 srcTop,N_int32 width,N_int32 height,N_int32 dstLeft,N_int32 dstTop,N_int32 mix,GA_color transparent);
    void            (NAPIP StretchBltBuf)(GA_buf *buf,N_int32 srcLeft,N_int32 srcTop,N_int32 srcWidth,N_int32 srcHeight,N_int32 dstLeft,N_int32 dstTop,N_int32 dstWidth,N_int32 dstHeight,N_int32 doClip,N_int32 clipLeft,N_int32 clipTop,N_int32 clipRight,N_int32 clipBottom,N_int32 mix);
    void            (NAPIP BitBltPlaneMaskedBuf)(GA_buf *buf,N_int32 srcLeft,N_int32 srcTop,N_int32 width,N_int32 height,N_int32 dstLeft,N_int32 dstTop,N_uint32 planeMask);
    void            (NAPIP BitBltFxBuf)(GA_buf *buf,N_int32 srcLeft,N_int32 srcTop,N_int32 srcWidth,N_int32 srcHeight,N_int32 dstLeft,N_int32 dstTop,N_int32 dstWidth,N_int32 dstHeight,GA_bltFx *fx);
    void            (NAPIP DrawRectBuf)(GA_buf *buf,N_int32 left,N_int32 top,N_int32 width,N_int32 height,GA_color color,N_int32 mix);
    ibool           (NAPIP SetRef2d)(struct _REF2D_driver *ref2d);
    GA_clipper *    (NAPIP GetClipper)(GA_buf *buf);
    void            (NAPIP SetClipper)(GA_buf *buf,GA_clipper *clipper);
    } GA_bufferFuncs;

/****************************************************************************
REMARKS:
Managed window clipper functions. These functions manage the creation
and destruction of complex clip regions for handling clipping to window
manager windows. These functions manage translation of OS specific clip
regions to SciTech Nucleus complex clip regions.
{secret}
****************************************************************************/
typedef struct {
    N_uint32        dwSize;
    GA_clipper *    (NAPIP CreateClipper)(PM_HWND hwnd);
    ibool           (NAPIP IsClipListChanged)(GA_clipper *clipper);
    GA_rect *       (NAPIP GetClipList)(GA_clipper *clipper,N_int32 *count);
    void            (NAPIP DestroyClipper)(GA_clipper *clipper);
    } GA_clipperFuncs;

/****************************************************************************
REMARKS:
Device driver hardware cursor functions.
{secret}
****************************************************************************/
typedef struct {
    N_uint32        dwSize;
    void            (NAPIP SetMonoCursor)(GA_monoCursor *cursor);
    void            (NAPIP SetMonoCursorColor)(GA_palette *foreground,GA_palette *background);
    void            (NAPIP SetColorCursor)(GA_colorCursor *cursor);
    N_int32         (NAPIP SetCursorPos)(N_int32 x,N_int32 y);
    void            (NAPIP ShowCursor)(N_int32 visible);
    void            (NAPIP BeginAccess)(N_int32 left,N_int32 top,N_int32 right,N_int32 bottom);
    void            (NAPIP EndAccess)(void);
    void            (NAPIP SetColorCursor256)(GA_colorCursor256 *cursor);
    void            (NAPIP SetColorCursorRGBA)(GA_colorCursorRGBA *cursor);
    N_int32         (NAPIP IsHardwareCursor)(void);
    void            (NAPIP SetColorCursorRGB)(GA_colorCursorRGB *cursor);
    } GA_cursorFuncs;

#pragma pack()

struct __GA_exports;

#include "nucleus/ddc.h"
#include "nucleus/stereo.h"
#include "nucleus/ref2d.h"

#pragma pack(1)

#ifndef __WINDOWS16__
/****************************************************************************
REMARKS:
Structure defining all the Nucleus Graphics API functions as exported from
the Binary Portable DLL.
{secret}
****************************************************************************/
typedef struct __GA_exports {
    ulong           dwSize;
    int             (NAPIP GA_status)(void);
    const char *    (NAPIP GA_errorMsg)(N_int32 status);
    int             (NAPIP GA_getDaysLeft)(N_int32 shared);
    int             (NAPIP GA_registerLicense)(uchar *license,N_int32 shared);
    int             (NAPIP GA_enumerateDevices)(N_int32 shared);
    GA_devCtx *     (NAPIP GA_loadDriver)(N_int32 deviceIndex,N_int32 shared);
    ibool           (NAPIP GA_setActiveDevice)(N_int32 deviceIndex);
    void *          reserved1;
    void            (NAPIP GA_unloadDriver)(GA_devCtx *dc);
    ibool           (NAPIP REF2D_loadDriver)(GA_devCtx *hwCtx,N_int32 bitsPerPixel,N_int32 shared,REF2D_driver _FAR_ *_FAR_ *drv,PE_MODULE _FAR_ *_FAR_ *hModule,ulong _FAR_ *size);
    void            (NAPIP REF2D_unloadDriver)(REF2D_driver *drv,PE_MODULE *hModule);
    ibool           (NAPIP GA_loadRef2d)(GA_devCtx _FAR_ *dc,N_int32 shared,GA_modeInfo _FAR_ *modeInfo,N_int32 transferStart,REF2D_driver _FAR_ *_FAR_ *drv);
    void            (NAPIP GA_unloadRef2d)(GA_devCtx _FAR_ *dc);
    ibool           (NAPIP GA_softStereoInit)(GA_devCtx *dc);
    void            (NAPIP GA_softStereoOn)(void);
    void            (NAPIP GA_softStereoScheduleFlip)(N_uint32 leftAddr,N_uint32 rightAddr);
    N_int32         (NAPIP GA_softStereoGetFlipStatus)(void);
    void            (NAPIP GA_softStereoWaitTillFlipped)(void);
    void            (NAPIP GA_softStereoOff)(void);
    void            (NAPIP GA_softStereoExit)(void);
    ibool           (NAPIP GA_saveModeProfile)(GA_devCtx *dc,GA_modeProfile *profile);
    ibool           (NAPIP GA_saveOptions)(GA_devCtx *dc,GA_options *options);
    ibool           (NAPIP GA_saveCRTCTimings)(GA_devCtx *dc);
    ibool           (NAPIP GA_restoreCRTCTimings)(GA_devCtx *dc);
    int             (NAPIP DDC_init)(GA_devCtx *dc);
    ibool           (NAPIP DDC_readEDID)(N_int32 slaveAddr,uchar *edid,N_int32 length,N_int32 blockNumber,N_int32 channel);
    int             (NAPIP EDID_parse)(uchar *edid,EDID_record *rec,N_int32 requireDescriptor);
    int             (NAPIP MCS_begin)(GA_devCtx *dc);
    int             (NAPIP MCS_getCapabilitiesString)(char *data,N_int32 maxlen);
    ibool           (NAPIP MCS_isControlSupported)(uchar controlCode);
    ibool           (NAPIP MCS_enableControl)(uchar controlCode,N_int32 enable);
    ibool           (NAPIP MCS_getControlMax)(uchar controlCode,ushort *max);
    ibool           (NAPIP MCS_getControlValue)(uchar controlCode,ushort *value);
    ibool           (NAPIP MCS_getControlValues)(N_int32 numControls,uchar *controlCodes,ushort *values);
    ibool           (NAPIP MCS_setControlValue)(uchar controlCode,ushort value);
    ibool           (NAPIP MCS_setControlValues)(N_int32 numControls,uchar *controlCodes,ushort *values);
    ibool           (NAPIP MCS_resetControl)(uchar controlCode);
    ibool           (NAPIP MCS_saveCurrentSettings)(void);
    ibool           (NAPIP MCS_getTimingReport)(uchar *flags,ushort *hFreq,ushort *vFreq);
    ibool           (NAPIP MCS_getSelfTestReport)(uchar *flags,uchar *data,uchar *length);
    void            (NAPIP MCS_end)(void);
    ibool           (NAPIP GA_loadInGUI)(N_int32 shared);
    ibool           (NAPIP DDC_writeEDID)(GA_devCtx *dc,N_int32 slaveAddr,uchar *edid,N_int32 length,N_int32 blockNumber,N_int32 channel);
    ibool           (NAPIP GA_useDoubleScan)(GA_modeInfo *modeInfo);
    void            (NAPIP GA_getMaxRefreshRate)(GA_devCtx *dc,GA_modeInfo *modeInfo,N_int32 interlaced,float *maxRefresh);
    ibool           (NAPIP GA_computeCRTCTimings)(GA_devCtx *dc,GA_modeInfo *modeInfo,N_int32 refreshRate,N_int32 interlaced,GA_CRTCInfo *crtc,N_int32 pureGTF);
    ibool           (NAPIP GA_addMode)(GA_devCtx *dc,N_int32 xRes,N_int32 yRes,N_int32 bits,N_int32 saveToDisk);
    ibool           (NAPIP GA_addRefresh)(GA_devCtx *dc,N_int32 xRes,N_int32 yRes,N_int32 refresh,N_int32 saveToDisk);
    ibool           (NAPIP GA_delMode)(GA_devCtx *dc,N_int32 xRes,N_int32 yRes,N_int32 bits,N_int32 saveToDisk);
    const char *    (NAPIP N_getLogName)(void);
    void            (NAPIP N_log)(const char *fmt,...);
    int             (NAPIP MDBX_getErrCode)(void);
    const char *    (NAPIP MDBX_getErrorMsg)(void);
    ibool           (NAPIP MDBX_open)(const char *filename);
    void            (NAPIP MDBX_close)(void);
    int             (NAPIP MDBX_first)(GA_monitor *rec);
    int             (NAPIP MDBX_last)(GA_monitor *rec);
    int             (NAPIP MDBX_next)(GA_monitor *rec);
    int             (NAPIP MDBX_prev)(GA_monitor *rec);
    int             (NAPIP MDBX_insert)(GA_monitor *rec);
    int             (NAPIP MDBX_update)(GA_monitor *rec);
    int             (NAPIP MDBX_flush)(void);
    int             (NAPIP MDBX_importINF)(const char *filename,char *mfr);
    void            (NAPIP GA_getGlobalOptions)(GA_globalOptions *options,ibool shared);
    void            (NAPIP GA_setGlobalOptions)(GA_globalOptions *options);
    ibool           (NAPIP GA_saveGlobalOptions)(GA_globalOptions *options);
    const char *    (NAPIP GA_getInternalName)(N_int32 deviceIndex);
    const char *    (NAPIP GA_getNucleusConfigPath)(void);
    const char *    (NAPIP GA_getFakePCIID)(void);
    PE_MODULE *     (NAPIP GA_loadLibrary)(const char *szBPDName,ulong *size,ibool shared);
    int             (NAPIP GA_isOEMVersion)(ibool shared);
    int             (NAPIP GA_isLiteVersion)(ibool shared);
    const char *    (NAPIP GA_getDisplaySerialNo)(ibool shared);
    const char *    (NAPIP GA_getDisplayUserName)(ibool shared);
    void *          reserved2;
    REF2D_driver *  (NAPIP GA_getCurrentRef2d)(N_int32 deviceIndex);
    N_uint32 *      (NAPIP GA_getLicensedDevices)(ibool shared);
    int             (NAPIP DDC_initExt)(GA_devCtx *dc,N_int32 channel);
    int             (NAPIP MCS_beginExt)(GA_devCtx *dc,N_int32 channel);
    ibool           (NAPIP GA_loadRegionMgr)(GA_regionFuncs *funcs,PE_MODULE **hModule,ulong *size);
    void            (NAPIP GA_unloadRegionMgr)(PE_MODULE *hModule);
    void *          (NAPIP GA_getProcAddress)(PE_MODULE *hModule,const char *szProcName);
    ibool           (NAPIP GA_enableVBEMode)(GA_devCtx *dc,N_int32 xRes,N_int32 yRes,N_int32 bits,N_int32 saveToDisk);
    ibool           (NAPIP GA_disableVBEMode)(GA_devCtx *dc,N_int32 xRes,N_int32 yRes,N_int32 bits,N_int32 saveToDisk);
    void            (NAPIP GA_loadModeProfile)(GA_devCtx *dc,GA_modeProfile *profile);
    ibool           (NAPIP GA_getCRTCTimings)(GA_devCtx *dc,GA_modeInfo *modeInfo,N_int32 refreshRate,GA_CRTCInfo *crtc);
    ibool           (NAPIP GA_setCRTCTimings)(GA_devCtx *dc,GA_modeInfo *modeInfo,GA_CRTCInfo *crtc,ibool makeDefault);
    ibool           (NAPIP GA_setDefaultRefresh)(GA_devCtx *dc,N_int32 xRes,N_int32 yRes,N_int32 bits,N_int32 refreshRate,ibool saveToDisk);
    ibool           (NAPIP GA_saveMonitorInfo)(GA_devCtx *dc,GA_monitor *monitor);
    int             (NAPIP GA_detectPnPMonitor)(GA_devCtx *dc,GA_monitor *monitor,ibool *hasChanged);
    ibool           (NAPIP GA_queryFunctions)(GA_devCtx *dc,N_uint32 id,void _FAR_ *funcs);
    ibool           (NAPIP REF2D_queryFunctions)(REF2D_driver *ref2d,N_uint32 id,void _FAR_ *funcs);
    int             (NAPIP GA_getParsedEDID)(GA_devCtx *dc,EDID_record *rec);
    void            (NAPIP GA_programMTRRegisters)(GA_devCtx *dc);
    void            (NAPIP GA_setExportTable)(struct __GA_exports *table);
    void            (NAPIP GA_setMinimumDriverVersion)(N_uint32 version,N_int32 allowFallback,N_int32 shared);
    } GA_exports;

/****************************************************************************
REMARKS:
Defines the structure for holding 64-bit integers used for storing the values
returned by the precision timing functions. The precision timing functions
are used internally by the the Nucleus drivers for software stereo
support, however the granularity of the timing functions is variable.
Generally a granularity of around 1us is desired for maximum accuracy.
Where possible these import functions should be implemented using the
Intel Pentium RDTSC instruction or equivalent (with time readings
normalised to 1us granularity to avoid overflow internally).

HEADER:
nucleus/graphics.h

MEMBERS:
low     - Low 32-bits of the 64-bit integer
high    - High 32-bits of the 64-bit integer
****************************************************************************/
typedef u64 GA_largeInteger;

/****************************************************************************
REMARKS:
Structure defining all the Nucleus Graphics API functions as imported into
the Binary Portable DLL.
{secret}
****************************************************************************/
typedef struct {
    ulong           dwSize;
    GA_sharedInfo * (NAPIP GA_getSharedInfo)(int device);
    ibool           (NAPIP TimerInit)(void);
    void            (NAPIP TimerRead)(GA_largeInteger *value);
    N_uint32        (NAPIP TimerDifference)(GA_largeInteger *a,GA_largeInteger *b);
#ifndef __INTEL__
    void            (NAPIP outpb)(ulong port,uchar val);
    void            (NAPIP outpw)(ulong port,ushort val);
    void            (NAPIP outpd)(ulong port,ulong val);
    uchar           (NAPIP inpb)(ulong port);
    ushort          (NAPIP inpw)(ulong port);
    ulong           (NAPIP inpd)(ulong port);
#endif
    } GA_imports;

/****************************************************************************
REMARKS:
Function pointer type for the Binary Portable DLL initialisation entry point.
{secret}
****************************************************************************/
typedef GA_exports * (NAPIP GA_initLibrary_t)(ibool shared,const char *path,const char *bpdname,PM_imports *pmImp,N_imports *nImp,GA_imports *gaImp);
#endif

#pragma pack()

/*---------------------------- Global Variables ---------------------------*/

#ifdef  __cplusplus
extern "C" {            /* Use "C" linkage when in C++ mode */
#endif

/* {secret} Pointer to global exports structure.
 * Should not be used by application programs.
 */
#ifndef __WINDOWS16__
extern GA_exports   _VARAPI __GA_exports;
#endif

/*---------------------- Inline functions as Macros -----------------------*/

/* Useful inline macros for rectangle arithmetic */

#define GA_equalRect(r1,r2)     ((r1).left == (r2).left &&          \
                                 (r1).top == (r2).top &&            \
                                 (r1).right == (r2).right &&        \
                                 (r1).bottom == (r2).bottom)

#define GA_emptyRect(r)         ((r).bottom <= (r).top ||           \
                                 (r).right <= (r).left)

#define GA_disjointRect(r1,r2)  ((r1).right <= (r2).left ||         \
                                 (r1).left >= (r2).right ||         \
                                 (r1).bottom <= (r2).top ||         \
                                 (r1).top >= (r2).bottom)

#define GA_sectRect(s1,s2,d)                                        \
   ((d)->left = MAX((s1).left,(s2).left),                           \
    (d)->right = MIN((s1).right,(s2).right),                        \
    (d)->top = MAX((s1).top,(s2).top),                              \
    (d)->bottom = MIN((s1).bottom,(s2).bottom),                     \
    !GA_emptyRect(*d))

#define GA_sectRectFast(s1,s2,d)                                    \
    (d)->left = MAX((s1).left,(s2).left);                           \
    (d)->right = MIN((s1).right,(s2).right);                        \
    (d)->top = MAX((s1).top,(s2).top);                              \
    (d)->bottom = MIN((s1).bottom,(s2).bottom)

#define GA_sectRectCoord(l1,t1,r1,b1,l2,t2,r2,b2,d)                 \
   ((d)->left = MAX(l1,l2),                                         \
    (d)->right = MIN(r1,r2),                                        \
    (d)->top = MAX(t1,t2),                                          \
    (d)->bottom = MIN(b1,b2),                                       \
    !GA_emptyRect(*d))

#define GA_sectRectFastCoord(l1,t1,r1,b1,l2,t2,r2,b2,d)             \
    (d)->left = MAX(l1,l2);                                         \
    (d)->right = MIN(r1,r2);                                        \
    (d)->top = MAX(t1,t2);                                          \
    (d)->bottom = MIN(b1,b2)

#define GA_unionRect(s1,s2,d)                                       \
    (d)->left = MIN((s1).left,(s2).left);                           \
    (d)->right = MAX((s1).right,(s2).right);                        \
    (d)->top = MIN((s1).top,(s2).top);                              \
    (d)->bottom = MAX((s1).bottom,(s2).bottom)

#define GA_unionRectCoord(l1,t1,r1,b1,l2,t2,r2,b2,d)                \
    (d)->left = MIN(l1,l2);                                         \
    (d)->right = MAX(r1,r2);                                        \
    (d)->top = MIN(t1,t2);                                          \
    (d)->bottom = MAX(b1,b2)

#define GA_offsetRect(r,dx,dy)                                      \
    {   (r).left += dx; (r).right += dx;                            \
        (r).top += dy; (r).bottom += dy; }

#define GA_insetRect(r,dx,dy)                                       \
    {   (r).left += dx; (r).right -= dx;                            \
        (r).top += dy; (r).bottom -= dy;                            \
        if (GA_emptyRect(r))                                        \
            (r).left = (r).right = (r).top = (r).bottom = 0; }

#define GA_ptInRect(x,y,r)      ((x) >= (r).left &&                 \
                                 (x) < (r).right &&                 \
                                 (y) >= (r).top &&                  \
                                 (y) < (r).bottom)

#define GA_isSimpleRegion(r)    ((r)->spans == NULL)

/*-------------------------- Function Prototypes --------------------------*/

#ifndef __WINDOWS16__

/* Generic error handling functions for all Nucleus drivers */

int             NAPI GA_status(void);
const char *    NAPI GA_errorMsg(N_int32 status);

/* Function to get the number of days left in evaluation period */

int             NAPI GA_getDaysLeft(N_int32 shared);
int             NAPI GA_isOEMVersion(ibool shared);
int             NAPI GA_isLiteVersion(ibool shared);
const char *    NAPI GA_getDisplaySerialNo(ibool shared);
const char *    NAPI GA_getDisplayUserName(ibool shared);
N_uint32 *      NAPI GA_getLicensedDevices(ibool shared);

/* Utility function to register a linkable library license */

int             NAPI GA_registerLicense(uchar *license,N_int32 shared);

/* Utility function to override the local driver path for Nucleus */

void            NAPI GA_setLocalPath(const char *path);

/* Utility Functions to load a graphics driver and initialise it */

int             NAPI GA_enumerateDevices(N_int32 shared);
GA_devCtx *     NAPI GA_loadDriver(N_int32 deviceIndex,N_int32 shared);
ibool           NAPI GA_setActiveDevice(N_int32 deviceIndex);
void            NAPI GA_unloadDriver(GA_devCtx *dc);
const char *    NAPI GA_getInternalName(N_int32 deviceIndex);
const char *    NAPI GA_getFakePCIID(void);
const char *    NAPI GA_getNucleusConfigPath(void);
ibool           NAPI GA_loadInGUI(N_int32 shared);
void            NAPI GA_programMTRRegisters(GA_devCtx *dc);
void            NAPI GA_setExportTable(GA_exports *table);
void            NAPI GA_setMinimumDriverVersion(N_uint32 version,N_int32 allowFallback,N_int32 shared);

/* Function to obtain callback function pointers to the device driver.
 * Application level code should *always* use this function to ensure
 * that any necessary thunking steps are taken when calling device
 * driver code from ring 3 that may need to call down into a ring 0
 * device driver.
 */

ibool           NAPI GA_queryFunctions(GA_devCtx *dc,N_uint32 id,void _FAR_ *funcs);
ibool           NAPI REF2D_queryFunctions(REF2D_driver *ref2d,N_uint32 id,void _FAR_ *funcs);

/* Utility functions to interface to the 2D reference rasteriser */

ibool           NAPI GA_loadRef2d(GA_devCtx _FAR_ *dc,N_int32 shared,GA_modeInfo _FAR_ *modeInfo,N_int32 transferStart,REF2D_driver _FAR_ *_FAR_ *drv);
void            NAPI GA_unloadRef2d(GA_devCtx _FAR_ *dc);

/* Utility Function to get the currently active reference rasteriser */

REF2D_driver *  NAPI GA_getCurrentRef2d(N_int32 deviceIndex);

/* Functions to initialise, enable, disable and clean up the software
 * stereo functions provided by the Nucleus driver. For ring 3 user space
 * code, these functions will generally transition down to the system
 * helper driver (SDDHELP) to implement this as the interrupt handler
 * needs to run in kernel space.
 */

ibool           NAPI GA_softStereoInit(GA_devCtx *dc);
void            NAPI GA_softStereoOn(void);
void            NAPI GA_softStereoScheduleFlip(N_uint32 leftAddr,N_uint32 rightAddr);
N_int32         NAPI GA_softStereoGetFlipStatus(void);
void            NAPI GA_softStereoWaitTillFlipped(void);
void            NAPI GA_softStereoOff(void);
void            NAPI GA_softStereoExit(void);

/* Functions to load and initialiase the region manager */

ibool           NAPI GA_loadRegionMgr(GA_regionFuncs *funcs,PE_MODULE **hModule,ulong *size);
void            NAPI GA_unloadRegionMgr(PE_MODULE *hModule);

/* Utility functions to manipulate global options effective for all devices */

void            NAPI GA_getGlobalOptions(GA_globalOptions *options,ibool shared);
void            NAPI GA_setGlobalOptions(GA_globalOptions *options);
ibool           NAPI GA_saveGlobalOptions(GA_globalOptions *options);
ibool           NAPI GA_readGlobalOptions(GA_globalOptions *options);

/* Utility functions to save options and configuration information */

ibool           NAPI GA_saveModeProfile(GA_devCtx *dc,GA_modeProfile *profile);
void            NAPI GA_loadModeProfile(GA_devCtx *dc,GA_modeProfile *profile);
ibool           NAPI GA_saveOptions(GA_devCtx *dc,GA_options *options);
ibool           NAPI GA_getCRTCTimings(GA_devCtx *dc,GA_modeInfo *modeInfo,N_int32 refreshRate,GA_CRTCInfo *crtc);
ibool           NAPI GA_setCRTCTimings(GA_devCtx *dc,GA_modeInfo *modeInfo,GA_CRTCInfo *crtc,ibool makeDefault);
ibool           NAPI GA_setDefaultRefresh(GA_devCtx *dc,N_int32 xRes,N_int32 yRes,N_int32 bits,N_int32 refreshRate,ibool saveToDisk);
ibool           NAPI GA_saveCRTCTimings(GA_devCtx *dc);
ibool           NAPI GA_restoreCRTCTimings(GA_devCtx *dc);

/* Utility functions for monitor management */

ibool           NAPI GA_saveMonitorInfo(GA_devCtx *dc,GA_monitor *monitor);
int             NAPI GA_detectPnPMonitor(GA_devCtx *dc,GA_monitor *monitor,ibool *hasChanged);
int             NAPI GA_getParsedEDID(GA_devCtx *dc,EDID_record *rec);

/* Utility functions to create GTF display timings */

ibool           NAPI GA_useDoubleScan(GA_modeInfo *modeInfo);
void            NAPI GA_getMaxRefreshRate(GA_devCtx *dc,GA_modeInfo *modeInfo,N_int32 interlaced,float *maxRefresh);
ibool           NAPI GA_computeCRTCTimings(GA_devCtx *dc,GA_modeInfo *modeInfo,N_int32 refreshRate,N_int32 interlaced,GA_CRTCInfo *crtc,N_int32 pureGTF);

/* Utility functions to manipulate the Nucleus Dial-A-Mode features */

ibool           NAPI GA_addMode(GA_devCtx *dc,N_int32 xRes,N_int32 yRes,N_int32 bits,N_int32 saveToDisk);
ibool           NAPI GA_addRefresh(GA_devCtx *dc,N_int32 xRes,N_int32 yRes,N_int32 refresh,N_int32 saveToDisk);
ibool           NAPI GA_delMode(GA_devCtx *dc,N_int32 xRes,N_int32 yRes,N_int32 bits,N_int32 saveToDisk);

/* Utility functions to manipulate the Nucleus VBE mode filtering tables */

ibool           NAPI GA_enableVBEMode(GA_devCtx *dc,N_int32 xRes,N_int32 yRes,N_int32 bits,N_int32 saveToDisk);
ibool           NAPI GA_disableVBEMode(GA_devCtx *dc,N_int32 xRes,N_int32 yRes,N_int32 bits,N_int32 saveToDisk);

/* Prototypes for OS provided timer functions */

#ifndef __DRIVER__
/* {secret} */
ibool           NAPI GA_TimerInit(void);
/* {secret} */
void            NAPI GA_TimerRead(GA_largeInteger *value);
/* {secret} */
N_uint32        NAPI GA_TimerDifference(GA_largeInteger *a,GA_largeInteger *b);
#else
#define GA_TimerInit()          _GA_imports.TimerInit()
#define GA_TimerRead(value)     _GA_imports.TimerRead(value)
#define GA_TimerDifference(a,b) _GA_imports.TimerDifference(a,b)
#endif

/* External Intel assembler functions for high precision timing */

#ifdef  __INTEL__
/* {secret} */
ibool           NAPI _GA_haveCPUID(void);
/* {secret} */
uint            NAPI _GA_getCPUIDFeatures(void);
/* {secret} */
void            NAPI _GA_readTimeStamp(GA_largeInteger *time);
/* {secret} */
#define         CPU_HaveRDTSC   0x00000010
#endif

/* Prototypes for OS provided I/O functions for non x86 systems */

#ifndef __INTEL__
/* {secret} */
void            NAPI GA_outpb(ulong port,uchar val);
/* {secret} */
void            NAPI GA_outpw(ulong port,ushort val);
/* {secret} */
void            NAPI GA_outpd(ulong port,ulong val);
/* {secret} */
uchar           NAPI GA_inpb(ulong port);
/* {secret} */
ushort          NAPI GA_inpw(ulong port);
/* {secret} */
ulong           NAPI GA_inpd(ulong port);
#endif

/* {secret} Function to return the shared info instance for a particular device */
GA_sharedInfo * NAPI GA_getSharedInfo(int device);

/* {secret} Function to return the system wide shared exports if needed */
ibool           NAPI GA_getSharedExports(GA_exports *gaExp,ibool shared);

/* {secret} Function to return the system wide PM library functions */
PM_imports *    NAPI GA_getSystemPMImports(void);

/* {secret} Internal function to load a BPD file */
PE_MODULE *     NAPI GA_loadLibrary(const char *szBPDName,ulong *size,ibool shared);
void *          NAPI GA_getProcAddress(PE_MODULE *hModule,const char *szProcName);

#endif  /* !__WINDOWS16__ */

#ifdef  __cplusplus
}                                   /* End of "C" linkage for C++       */
#endif

#endif  /* __NUCLEUS_GRAPHICS_H */

