/****************************************************************************
*
*                   SciTech Nucleus Graphics Architecture
*
*               Copyright (C) 1991-1998 SciTech Software, Inc.
*                            All rights reserved.
*
*  ======================================================================
*  |REMOVAL OR MODIFICATION OF THIS HEADER IS STRICTLY PROHIBITED BY LAW|
*  |                                                                    |
*  |This copyrighted computer code is a proprietary trade secret of     |
*  |SciTech Software, Inc., located at 505 Wall Street, Chico, CA 95928 |
*  |USA (www.scitechsoft.com).  ANY UNAUTHORIZED POSSESSION, USE,       |
*  |VIEWING, COPYING, MODIFICATION OR DISSEMINATION OF THIS CODE IS     |
*  |STRICTLY PROHIBITED BY LAW.  Unless you have current, express       |
*  |written authorization from SciTech to possess or use this code, you |
*  |may be subject to civil and/or criminal penalties.                  |
*  |                                                                    |
*  |If you received this code in error or you would like to report      |
*  |improper use, please immediately contact SciTech Software, Inc. at  |
*  |530-894-8400.                                                       |
*  |                                                                    |
*  |REMOVAL OR MODIFICATION OF THIS HEADER IS STRICTLY PROHIBITED BY LAW|
*  ======================================================================
*
* Language:     ANSI C
* Environment:  Any 32-bit protected mode environment
*
* Description:  Module to implement the code to test the Nucleus Graphics
*               Architecture.
*
****************************************************************************/

#ifndef __GATEST_H
#define __GATEST_H

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include "nucleus/gasdk.h"
#include "gtf.h"
#include "ztimer.h"
#include "event.h"
#include "gconsole.h"

/*---------------------------- Global Variables ---------------------------*/

#ifdef  __cplusplus
extern "C" {            /* Use "C" linkage when in C++ mode */
#endif

/* Global variables in gatest.c */

extern int              cntDevice,numDevices;
extern ibool            softwareEmulate,useGTF,fullSpeed,breakPoint,doSmallTest;
extern char             accelTestName[];
extern GA_initFuncs     init;
extern GA_driverFuncs   driver;

typedef ibool   (*doTestType)(GC_devCtx *gc,int xRes,int yRes,int bitsPerPixel,N_uint32 flags,int refreshRate,GA_CRTCInfo *crtc,N_uint32 planeMask);

/*------------------------- Function Prototypes ---------------------------*/

/* General utility functions in util.c */

void    SetGraphicsMode(GC_devCtx *gc);
void    RestoreMode(GC_devCtx *gc);
int     GetModeName(char *buf,GA_modeInfo *mi);
void    InitMouse(int xRes,int yRes);
void    GetMousePos(int *x,int *y);
int     EVT_kbhit(void);
int     EVT_getch(void);
int     GetString(GC_devCtx *gc,char *str,int maxLen);

/* DPMS tests in dpmstest.c */

void    DPMSTests(GC_devCtx *gc);

/* DDC tests in ddctest.c */

void    DDCTests(GC_devCtx *gc);

/* DDC/CI tests in ddccitst.c */

void    DDCCITests(GC_devCtx *gc);

/* Text mode tests in txttest.c */

ibool   doTextTest(GC_devCtx *gc,int xRes,int yRes,int bitsPerPixel,N_uint32 flags,int refreshRate,GA_CRTCInfo *crtc,N_uint32 planeMask);

/* Centering and refresh control in center.c */

ibool   doCenter(GC_devCtx *gc,int xRes,int yRes,int bitsPerPixel,N_uint32 flags,int refreshRate,GA_CRTCInfo *crtc,N_uint32 planeMask);

/* TV centering and refresh control in tv.c */

ibool   CenterTVMode(GC_devCtx *gc,N_uint32 mode);

/* Visual tests in tests.c */

void    moire(GA_color defcolor);
int     moireTest(void);
int     pageFlipTest(void);
int     paletteTest(void);
int     wideDACTest(void);
ibool   doTest(GC_devCtx *gc,int xRes,int yRes,int bitsPerPixel,N_uint32 flags,int refreshRate,GA_CRTCInfo *crtc,N_uint32 planeMask);
ibool   doScrollTest(GC_devCtx *gc,int xRes,int yRes,int bitsPerPixel,N_uint32 flags,int refreshRate,GA_CRTCInfo *crtc,N_uint32 planeMask);
ibool   doZoomTest(GC_devCtx *gc,int xRes,int yRes,int bitsPerPixel,N_uint32 flags,int refreshRate,GA_CRTCInfo *crtc,N_uint32 planeMask);

/* Acceleration tests in conform/2dtests.c */

int     doAccelTests(const char *testName,ibool useSmallBuffer);
void    doCursorInit(void);
int     doCursorTest(const char *testName);

/* Stereo display mode test in tests.c */

ibool   doStereoTest(GC_devCtx *gc,int xRes,int yRes,int bitsPerPixel,N_uint32 flags,int refreshRate,GA_CRTCInfo *crtc,N_uint32 planeMask);

#ifdef  __cplusplus
}                       /* End of "C" linkage for C++   */
#endif

#endif  /* __GATEST_H */
