/****************************************************************************
*
*                   SciTech OS Portability Manager Library
*
*  ========================================================================
*
*    The contents of this file are subject to the SciTech MGL Public
*    License Version 1.0 (the "License"); you may not use this file
*    except in compliance with the License. You may obtain a copy of
*    the License at http://www.scitechsoft.com/mgl-license.txt
*
*    Software distributed under the License is distributed on an
*    "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
*    implied. See the License for the specific language governing
*    rights and limitations under the License.
*
*    The Original Code is Copyright (C) 1991-1998 SciTech Software, Inc.
*
*    The Initial Developer of the Original Code is SciTech Software, Inc.
*    All Rights Reserved.
*
*  ========================================================================
*
* Language:     ANSI C
* Environment:  32-bit Windows VxD
*
* Description:  C library compatible functions for use within NT drivers.
*
****************************************************************************/

#ifndef __NT_DRIVER_H
#define __NT_DRIVER_H

// Prevent stdio.h and stdlib.h includes

#define _FILE_DEFINED
#define _SIZE_T_DEFINED
#define _INC_STDIO
#define _INC_STDLIB

/*---------------------- Macros and type definitions ----------------------*/

#define EOF             (-1)
#define SEEK_SET        0
#define SEEK_CUR        1
#define SEEK_END        2

typedef struct {
    int     handle;
    int     writemode;
    int     text;
    long    offset;
    long    filesize;
    } FILE;

typedef unsigned int    size_t;
typedef long            time_t;

/*------------------------- Function Prototypes ---------------------------*/

// stdio.h

int     sprintf(char *_s, const char *_format, ...);
FILE *  fopen( const char *__filename, const char *__mode );
size_t  fread( void *__ptr, size_t __size, size_t __n, FILE *__fp );
size_t  fwrite( const void *__ptr, size_t __size, size_t __n, FILE *__fp );
int     fflush( FILE *__fp );
int     fseek( FILE *__fp, long int __offset, int __whence );
long    ftell( FILE *__fp );
int     feof( FILE *__fp );
int     fclose( FILE *__fp );
char *  fgets( char *__s, int __n, FILE *__fp );
int     fputs( const char *__s, FILE *__fp );

// stdlib.h

void *   calloc(size_t _nelem, size_t _size);
void     free(void *_ptr);
void *   malloc(size_t _size);
void *   realloc(void *_ptr, size_t _size);

// Common Windows types

#define DWORD   ULONG
#define WORD    USHORT
#define BYTE    UCHAR

/*-------------------------------- Includes -------------------------------*/

#ifndef __NO_NTDDK
#include <ntddk.h>
#endif

#endif  /* __NT_DRIVER_H */

