/****************************************************************************
*
*                       SciTech OpenGL Switching Library
*
*  ========================================================================
*
*    The contents of this file are subject to the SciTech MGL Public
*    License Version 1.0 (the "License"); you may not use this file
*    except in compliance with the License. You may obtain a copy of
*    the License at http://www.scitechsoft.com/mgl-license.txt
*
*    Software distributed under the License is distributed on an
*    "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
*    implied. See the License for the specific language governing
*    rights and limitations under the License.
*
*    The Original Code is Copyright (C) 1991-1998 SciTech Software, Inc.
*
*    The Initial Developer of the Original Code is SciTech Software, Inc.
*    All Rights Reserved.
*
*  ========================================================================
*
* Language:     ANSI C
* Environment:  Win32
*
* Description:  Header describing the function stubs for calling OpenGL
*               wgl API functions.
*
****************************************************************************/

#ifndef __WGL_STUB_H
#define __WGL_STUB_H

/*--------------------- Macros and type definitions -----------------------*/

/* Structure containing all public Win32 wgl functions supported */

#pragma pack(1)
typedef struct {
    long        dwSize;

    /* OpenGL GDI32 functions */
    int     (APIENTRYP glsChoosePixelFormat)(HDC, CONST PIXELFORMATDESCRIPTOR *);
    int     (APIENTRYP glsDescribePixelFormat)(HDC, int, UINT, LPPIXELFORMATDESCRIPTOR);
    int     (APIENTRYP glsGetPixelFormat)(HDC);
    BOOL    (APIENTRYP glsSetPixelFormat)(HDC, int, CONST PIXELFORMATDESCRIPTOR *);
    BOOL    (APIENTRYP glsSwapBuffers)(HDC);

    /* OpenGL wgl functions */
    HGLRC   (APIENTRYP glsCreateContext)(HDC);
    BOOL    (APIENTRYP glsDeleteContext)(HGLRC);
    HGLRC   (APIENTRYP glsGetCurrentContext)(VOID);
    HDC     (APIENTRYP glsGetCurrentDC)(VOID);
    PROC    (APIENTRYP glsGetProcAddress)(LPCSTR);
    BOOL    (APIENTRYP glsMakeCurrent)(HDC, HGLRC);
    BOOL    (APIENTRYP glsShareLists)(HGLRC, HGLRC);
    BOOL    (APIENTRYP glsUseFontBitmapsA)(HDC, DWORD, DWORD, DWORD);
    BOOL    (APIENTRYP glsUseFontBitmapsW)(HDC, DWORD, DWORD, DWORD);
    BOOL    (APIENTRYP glsUseFontOutlinesA)(HDC, DWORD, DWORD, DWORD, FLOAT, FLOAT, int, LPGLYPHMETRICSFLOAT);
    BOOL    (APIENTRYP glsUseFontOutlinesW)(HDC, DWORD, DWORD, DWORD, FLOAT, FLOAT, int, LPGLYPHMETRICSFLOAT);
    } GLS_wglFuncs;
#pragma pack()

/* Macros to override regular Win32 OpenGL bindings to call the gls
 * versions. Note that the macros must *always* be used, since we cannot
 * export functions named ChoosePixelFormat etc or there will be a link
 * time conflict with the exports from GDI32.DLL.
 */

#if !defined(NO_WGL_MACROS)

#define ChoosePixelFormat(a,b)                  _GLS_wglFuncs.glsChoosePixelFormat(a,b)
#define DescribePixelFormat(a,b,c,d)            _GLS_wglFuncs.glsDescribePixelFormat(a,b,c,d)
#define GetPixelFormat(a)                       _GLS_wglFuncs.glsGetPixelFormat(a)
#define SetPixelFormat(a,b,c)                   _GLS_wglFuncs.glsSetPixelFormat(a,b,c)
#define SwapBuffers(a)                          _GLS_wglFuncs.glsSwapBuffers(a)

#define wglCreateContext(a)                     _GLS_wglFuncs.glsCreateContext(a)
#define wglDeleteContext(a)                     _GLS_wglFuncs.glsDeleteContext(a)
#define wglGetCurrentContext()                  _GLS_wglFuncs.glsGetCurrentContext()
#define wglGetCurrentDC()                       _GLS_wglFuncs.glsGetCurrentDC()
#define wglGetProcAddress(a)                    _GLS_wglFuncs.glsGetProcAddress(a)
#define wglMakeCurrent(a,b)                     _GLS_wglFuncs.glsMakeCurrent(a,b)
#define wglShareLists(a,b)                      _GLS_wglFuncs.glsShareLists(a,b)
#define wglUseFontBitmapsA(a,b,c,d)             _GLS_wglFuncs.glsUseFontBitmapsA(a,b,c,d)
#define wglUseFontBitmapsW(a,b,c,d)             _GLS_wglFuncs.glsUseFontBitmapsW(a,b,c,d)
#define wglUseFontOutlinesA(a,b,c,d,e,f,g,h)    _GLS_wglFuncs.glsUseFontOutlinesA(a,b,c,d,e,f,g,h)
#define wglUseFontOutlinesW(a,b,c,d,e,f,g,h)    _GLS_wglFuncs.glsUseFontOutlinesW(a,b,c,d,e,f,g,h)

#endif

/*---------------------------- Global variables ---------------------------*/

#ifdef __cplusplus
extern "C" {
#endif

extern GLS_wglFuncs  _VARAPI _GLS_wglFuncs;

#ifdef __cplusplus
}
#endif

#endif /* __WGL_STUB_H */
