/****************************************************************************
*
*                   SciTech Multi-platform Graphics Library
*
*  ========================================================================
*
*    The contents of this file are subject to the SciTech MGL Public
*    License Version 1.0 (the "License"); you may not use this file
*    except in compliance with the License. You may obtain a copy of
*    the License at http://www.scitechsoft.com/mgl-license.txt
*
*    Software distributed under the License is distributed on an
*    "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
*    implied. See the License for the specific language governing
*    rights and limitations under the License.
*
*    The Original Code is Copyright (C) 1991-1998 SciTech Software, Inc.
*
*    The Initial Developer of the Original Code is SciTech Software, Inc.
*    All Rights Reserved.
*
*  ========================================================================
*
* Language:     ANSI C
* Environment:  Any
*
* Description:  MGL specific OpenGL header that contains the OpenGL entry
*               points table for both the GL and GLU functions. We include
*               this in a separate header so that we can include either
*               GL\gl.h or GL\glu.h without the other header and things will
*               still work correctly.
*
****************************************************************************/

#ifndef __GLU_STUB_H
#define __GLU_STUB_H

/*--------------------- Macros and type definitions -----------------------*/

/* Structure containing all public OpenGL functions supported by the MGL */

#pragma pack(1)
typedef struct {
    long    dwSize;
    void    (APIENTRYP gluBeginCurve)(GLUnurbs *nobj);
    void    (APIENTRYP gluBeginPolygon)(GLUtesselator *tess);
    void    (APIENTRYP gluBeginSurface)(GLUnurbs *nobj);
    void    (APIENTRYP gluBeginTrim)(GLUnurbs *nobj);
    int     (APIENTRYP gluBuild1DMipmaps)(GLenum target,GLint components,GLint width,GLenum format,GLenum type,const void *data);
    int     (APIENTRYP gluBuild2DMipmaps)(GLenum target,GLint components,GLint width,GLint height,GLenum format,GLenum type,const void *data);
    void    (APIENTRYP gluCylinder)(GLUquadric *qobj,GLdouble baseRadius,GLdouble topRadius,GLdouble height,GLint slices,GLint stacks);
    void    (APIENTRYP gluDeleteNurbsRenderer)(GLUnurbs *nobj);
    void    (APIENTRYP gluDeleteQuadric)(GLUquadric *state);
    void    (APIENTRYP gluDeleteTess)(GLUtesselator *tess);
    void    (APIENTRYP gluDisk)(GLUquadric *qobj,GLdouble innerRadius,GLdouble outerRadius,GLint slices,GLint loops);
    void    (APIENTRYP gluEndCurve)(GLUnurbs *nobj);
    void    (APIENTRYP gluEndPolygon)(GLUtesselator *tess);
    void    (APIENTRYP gluEndSurface)(GLUnurbs *nobj);
    void    (APIENTRYP gluEndTrim)(GLUnurbs *nobj);
    const GLubyte*  (APIENTRYP gluErrorString)(GLenum errCode);
    void    (APIENTRYP gluGetNurbsProperty)(GLUnurbs *nobj,GLenum property,GLfloat *value);
    const GLubyte*  (APIENTRYP gluGetString)(GLenum name);
    void    (APIENTRYP gluGetTessProperty)(GLUtesselator *tess,GLenum which,GLdouble *value);
    void    (APIENTRYP gluLoadSamplingMatrices)(GLUnurbs *nobj,const GLfloat modelMatrix[16],const GLfloat projMatrix[16],const GLint viewport[4]);
    void    (APIENTRYP gluLookAt)(GLdouble eyex,GLdouble eyey,GLdouble eyez,GLdouble centerx,GLdouble centery,GLdouble centerz,GLdouble upx,GLdouble upy,GLdouble upz);
    GLUnurbs* (APIENTRYP gluNewNurbsRenderer)(void);
    GLUquadric* (APIENTRYP gluNewQuadric)(void);
    GLUtesselator* (APIENTRYP gluNewTess)(void );
    void    (APIENTRYP gluNextContour)(GLUtesselator *tess,GLenum type);
    void    (APIENTRYP gluNurbsCallback)(GLUnurbs *nobj,GLenum which,void (CALLBACKP fn)());
    void    (APIENTRYP gluNurbsCurve)(GLUnurbs *nobj,GLint nknots,GLfloat *knot,GLint stride,GLfloat *ctlarray,GLint order,GLenum type);
    void    (APIENTRYP gluNurbsProperty)(GLUnurbs *nobj,GLenum property,GLfloat value);
    void    (APIENTRYP gluNurbsSurface)(GLUnurbs *nobj,GLint sknot_count,float *sknot,GLint tknot_count,GLfloat *tknot,GLint s_stride,GLint t_stride,GLfloat *ctlarray,GLint sorder,GLint torder,GLenum type);
    void    (APIENTRYP gluOrtho2D)(GLdouble left,GLdouble right,GLdouble bottom,GLdouble top);
    void    (APIENTRYP gluPartialDisk)(GLUquadric *qobj,GLdouble innerRadius,GLdouble outerRadius,GLint slices,GLint loops,GLdouble startAngle,GLdouble sweepAngle);
    void    (APIENTRYP gluPerspective)(GLdouble fovy,GLdouble aspect,GLdouble zNear,GLdouble zFar);
    void    (APIENTRYP gluPickMatrix)(GLdouble x,GLdouble y,GLdouble width,GLdouble height,const GLint viewport[4]);
    int     (APIENTRYP gluProject)(GLdouble objx,GLdouble objy,GLdouble objz,const GLdouble modelMatrix[16],const GLdouble projMatrix[16],const GLint viewport[4],GLdouble *winx,GLdouble *winy,GLdouble *winz);
    void    (APIENTRYP gluPwlCurve)(GLUnurbs *nobj,GLint count,GLfloat *array,GLint stride,GLenum type);
    void    (APIENTRYP gluQuadricCallback)(GLUquadric *qobj,GLenum which,void (CALLBACKP fn)());
    void    (APIENTRYP gluQuadricDrawStyle)(GLUquadric *quadObject,GLenum drawStyle);
    void    (APIENTRYP gluQuadricNormals)(GLUquadric *quadObject,GLenum normals);
    void    (APIENTRYP gluQuadricOrientation)(GLUquadric *quadObject,GLenum orientation);
    void    (APIENTRYP gluQuadricTexture)(GLUquadric *quadObject,GLboolean textureCoords);
    int     (APIENTRYP gluScaleImage)(GLenum format,GLint widthin,GLint heightin,GLenum typein,const void *datain,GLint widthout,GLint heightout,GLenum typeout,void *dataout);
    void    (APIENTRYP gluSphere)(GLUquadric *qobj,GLdouble radius,GLint slices,GLint stacks);
    void    (APIENTRYP gluTessBeginContour)(GLUtesselator *tess);
    void    (APIENTRYP gluTessBeginPolygon)(GLUtesselator *tess,void *polygon_data);
    void    (APIENTRYP gluTessCallback)(GLUtesselator *tess,GLenum which,void (CALLBACKP fn)());
    void    (APIENTRYP gluTessEndContour)(GLUtesselator *tess);
    void    (APIENTRYP gluTessEndPolygon)(GLUtesselator *tess);
    void    (APIENTRYP gluTessNormal)(GLUtesselator *tess,GLdouble x,GLdouble y,GLdouble z);
    void    (APIENTRYP gluTessProperty)(GLUtesselator *tess,GLenum which,GLdouble value);
    void    (APIENTRYP gluTessVertex)(GLUtesselator *tess,GLdouble coords[3],void *data);
    int     (APIENTRYP gluUnProject)(GLdouble winx,GLdouble winy,GLdouble winz,const GLdouble modelMatrix[16],const GLdouble projMatrix[16],const GLint viewport[4],GLdouble *objx,GLdouble *objy,GLdouble *objz);
    } GLS_gluFuncs;
#pragma pack()

#if !defined(NO_GLU_MACROS)
#define gluBeginCurve(nobj)                                                                                     _GLS_gluFuncs.gluBeginCurve(nobj)
#define gluBeginPolygon(tess)                                                                                   _GLS_gluFuncs.gluBeginPolygon(tess)
#define gluBeginSurface(nobj)                                                                                   _GLS_gluFuncs.gluBeginSurface(nobj)
#define gluBeginTrim(nobj)                                                                                      _GLS_gluFuncs.gluBeginTrim(nobj)
#define gluBuild1DMipmaps(target,components,width,format,type,data)                                             _GLS_gluFuncs.gluBuild1DMipmaps(target,components,width,format,type,data)
#define gluBuild2DMipmaps(target,components,width,height,format,type,data)                                      _GLS_gluFuncs.gluBuild2DMipmaps(target,components,width,height,format,type,data)
#define gluCylinder(qobj,baseRadius,topRadius,height,slices,stacks)                                             _GLS_gluFuncs.gluCylinder(qobj,baseRadius,topRadius,height,slices,stacks)
#define gluDeleteNurbsRenderer(nobj)                                                                            _GLS_gluFuncs.gluDeleteNurbsRenderer(nobj)
#define gluDeleteQuadric(state)                                                                                 _GLS_gluFuncs.gluDeleteQuadric(state)
#define gluDeleteTess(tess)                                                                                     _GLS_gluFuncs.gluDeleteTess(tess)
#define gluDisk(qobj,innerRadius,outerRadius,slices,loops)                                                      _GLS_gluFuncs.gluDisk(qobj,innerRadius,outerRadius,slices,loops)
#define gluEndCurve(nobj)                                                                                       _GLS_gluFuncs.gluEndCurve(nobj)
#define gluEndPolygon(tess)                                                                                     _GLS_gluFuncs.gluEndPolygon(tess)
#define gluEndSurface(nobj)                                                                                     _GLS_gluFuncs.gluEndSurface(nobj)
#define gluEndTrim(nobj)                                                                                        _GLS_gluFuncs.gluEndTrim(nobj)
#define gluErrorString(errCode)                                                                                 _GLS_gluFuncs.gluErrorString(errCode)
#define gluGetNurbsProperty(nobj,property,value)                                                                _GLS_gluFuncs.gluGetNurbsProperty(nobj,property,value)
#define gluGetString(name)                                                                                      _GLS_gluFuncs.gluGetString(name)
#define gluGetTessProperty(tess,which,value)                                                                    _GLS_gluFuncs.gluGetTessProperty(tess,which,value)
#define gluLoadSamplingMatrices(nobj,modelMatrix,projMatrix,viewport)                                           _GLS_gluFuncs.gluLoadSamplingMatrices(nobj,modelMatrix,projMatrix,viewport)
#define gluLookAt(eyex,eyey,eyez,centerx,centery,centerz,upx,upy,upz)                                           _GLS_gluFuncs.gluLookAt(eyex,eyey,eyez,centerx,centery,centerz,upx,upy,upz)
#define gluNewNurbsRenderer()                                                                                   _GLS_gluFuncs.gluNewNurbsRenderer()
#define gluNewQuadric()                                                                                         _GLS_gluFuncs.gluNewQuadric()
#define gluNewTess()                                                                                            _GLS_gluFuncs.gluNewTess()
#define gluNextContour(tess,type)                                                                               _GLS_gluFuncs.gluNextContour(tess,type)
#define gluNurbsCallback(nobj,which,fn)                                                                         _GLS_gluFuncs.gluNurbsCallback(nobj,which,fn)
#define gluNurbsCurve(nobj,nknots,knot,stride,ctlarray,order,type)                                              _GLS_gluFuncs.gluNurbsCurve(nobj,nknots,knot,stride,ctlarray,order,type)
#define gluNurbsProperty(nobj,property,value)                                                                   _GLS_gluFuncs.gluNurbsProperty(nobj,property,value)
#define gluNurbsSurface(nobj,sknot_count,sknot,tknot_count,tknot,s_stride,t_stride,ctlarray,sorder,torder,type) _GLS_gluFuncs.gluNurbsSurface(nobj,sknot_count,sknot,tknot_count,tknot,s_stride,t_stride,ctlarray,sorder,torder,type)
#define gluOrtho2D(left,right,bottom,top)                                                                       _GLS_gluFuncs.gluOrtho2D(left,right,bottom,top)
#define gluPartialDisk(qobj,innerRadius,outerRadius,slices,loops,startAngle,sweepAngle)                         _GLS_gluFuncs.gluPartialDisk(qobj,innerRadius,outerRadius,slices,loops,startAngle,sweepAngle)
#define gluPerspective(fovy,aspect,zNear,zFar)                                                                  _GLS_gluFuncs.gluPerspective(fovy,aspect,zNear,zFar)
#define gluPickMatrix(x,y,width,height,viewport)                                                                _GLS_gluFuncs.gluPickMatrix(x,y,width,height,viewport)
#define gluProject(objx,objy,objz,modelMatrix,projMatrix,viewport,winx,winy,winz)                               _GLS_gluFuncs.gluProject(objx,objy,objz,modelMatrix,projMatrix,viewport,winx,winy,winz)
#define gluPwlCurve(nobj,count,array,stride,type)                                                               _GLS_gluFuncs.gluPwlCurve(nobj,count,array,stride,type)
#define gluQuadricCallback(qobj,which,fn)                                                                       _GLS_gluFuncs.gluQuadricCallback(qobj,which,fn)
#define gluQuadricDrawStyle(quadObject,drawStyle)                                                               _GLS_gluFuncs.gluQuadricDrawStyle(quadObject,drawStyle)
#define gluQuadricNormals(quadObject,normals)                                                                   _GLS_gluFuncs.gluQuadricNormals(quadObject,normals)
#define gluQuadricOrientation(quadObject,orientation)                                                           _GLS_gluFuncs.gluQuadricOrientation(quadObject,orientation)
#define gluQuadricTexture(quadObject,textureCoords)                                                             _GLS_gluFuncs.gluQuadricTexture(quadObject,textureCoords)
#define gluScaleImage(format,widthin,heightin,typein,datain,widthout,heightout,typeout,dataout)                 _GLS_gluFuncs.gluScaleImage(format,widthin,heightin,typein,datain,widthout,heightout,typeout,dataout)
#define gluSphere(qobj,radius,slices,stacks)                                                                    _GLS_gluFuncs.gluSphere(qobj,radius,slices,stacks)
#define gluTessBeginContour(tess)                                                                               _GLS_gluFuncs.gluTessBeginContour(tess)
#define gluTessBeginPolygon(tess,polygon_data)                                                                  _GLS_gluFuncs.gluTessBeginPolygon(tess,polygon_data)
#define gluTessCallback(tess,which,fn)                                                                          _GLS_gluFuncs.gluTessCallback(tess,which,fn)
#define gluTessEndContour(tess)                                                                                 _GLS_gluFuncs.gluTessEndContour(tess)
#define gluTessEndPolygon(tess)                                                                                 _GLS_gluFuncs.gluTessEndPolygon(tess)
#define gluTessNormal(tess,x,y,z)                                                                               _GLS_gluFuncs.gluTessNormal(tess,x,y,z)
#define gluTessProperty(tess,which,value)                                                                       _GLS_gluFuncs.gluTessProperty(tess,which,value)
#define gluTessVertex(tess,coords,data)                                                                         _GLS_gluFuncs.gluTessVertex(tess,coords,data)
#define gluUnProject(winx,winy,winz,modelMatrix,projMatrix,viewport,objx,objy,objz)                             _GLS_gluFuncs.gluUnProject(winx,winy,winz,modelMatrix,projMatrix,viewport,objx,objy,objz)
#endif

/*---------------------------- Global variables ---------------------------*/

#ifdef __cplusplus
extern "C" {
#endif

extern GLS_gluFuncs _VARAPI _GLS_gluFuncs;

#ifdef __cplusplus
}
#endif

#endif /* __GLU_STUB_H */
