/****************************************************************************
*
*                         SciTech Display Doctor
*
*               Copyright (C) 1991-1998 SciTech Software, Inc.
*                            All rights reserved.             
*
*  ======================================================================
*  |REMOVAL OR MODIFICATION OF THIS HEADER IS STRICTLY PROHIBITED BY LAW|
*  |                                                                    |
*  |This copyrighted computer code is a proprietary trade secret of     |
*  |SciTech Software, Inc., located at 505 Wall Street, Chico, CA 95928 |
*  |USA (www.scitechsoft.com).  ANY UNAUTHORIZED POSSESSION, USE,       |
*  |VIEWING, COPYING, MODIFICATION OR DISSEMINATION OF THIS CODE IS     |
*  |STRICTLY PROHIBITED BY LAW.  Unless you have current, express       |
*  |written authorization from SciTech to possess or use this code, you |
*  |may be subject to civil and/or criminal penalties.                  |
*  |                                                                    |
*  |If you received this code in error or you would like to report      |
*  |improper use, please immediately contact SciTech Software, Inc. at  |
*  |530-894-8400.                                                       |
*  |                                                                    |
*  |REMOVAL OR MODIFICATION OF THIS HEADER IS STRICTLY PROHIBITED BY LAW|
*  ======================================================================
*
* Language:     ANSI C
* Environment:  Any
*
* Description:  Support library for implementing hardware and software
*               stereo support using Nucleus drivers and IHV DirectX 8
*               drivers under Win32.
*
****************************************************************************/

#ifndef __DDSTEREO_H
#define __DDSTEREO_H

#include "nucleus/graphics.h"

/*--------------------------- Macros and Typedefs -------------------------*/

/* We use C calling conventions for all our functions */

#define DDSAPI  _ASMAPI

/****************************************************************************
REMARKS:
Error codes returned by DDS_init function to indicate driver load status
if loading the device driver failed. Most of these error codes are just
duplicates of the codes returned by the Nucleus device driver loader library.

HEADER:
ddstereo.h

MEMBERS:
ddsOK               - No error
ddsNotDetected      - Hardware not detected
ddsNotPOSTed        - Hardware has not been POSTed
ddsDriverNotFound   - Driver file not found
ddsCorruptDriver    - File loaded not a driver file
ddsLoadMem          - Not enough memory to load driver
ddsOldVersion       - Driver file is an older version
ddsIOError          - General I/O error
ddsMemMapError      - Could not map physical memory areas
ddsStereoDisabled   - Stereo support is disabled
ddsStereoStarted    - DDS_start has already been called
ddsUnableToFindCRTC - Unable to compute valid CRTC timings using GTF
ddsLockFailed       - DirectDraw lock of a surface failed
ddsInternalError    - Internal error in the DirectDraw stereo library
ddsUnknownMode      - Unknown stereo mode
ddsVideoMemError    - Not enough video memory to support stereo mode
ddsDDrawCapsError   - DirectDraw capabilities unavailable for stereo mode
ddsNotCertified     - Driver file is not certified for stereo
ddsDDrawVersion     - DirectDraw version is not current
ddsNotConfigured    - Driver file has not yet been configured for stereo
ddsWindowError      - Invalid window handle
ddsMultiMonError    - Multiple display devices not available
ddsDLLError         - External DLL unable to be loaded
ddsCRTOnly          - Requires an external analog CRT display only
****************************************************************************/
typedef enum {
    ddsOK,
    ddsNotDetected,
    ddsNotPOSTed,
    ddsDriverNotFound,
    ddsCorruptDriver,
    ddsLoadMem,
    ddsOldVersion,
    ddsMemMapError,
    ddsIOError,
    ddsStereoDisabled,
    ddsStereoStarted,
    ddsUnableToFindCRTC,
    ddsLockFailed,
    ddsInternalError,
    ddsUnknownMode,
    ddsVideoMemError,
    ddsDDrawCapsError,
    ddsNotCertified,
    ddsDDrawVersion,
    ddsNotConfigured,
    ddsWindowError,
    ddsMultiMonError,
    ddsDLLError,
    ddsCRTOnly,
    } DDS_errorType;

#ifdef  _D3D8_H_
/* {secret} */
typedef LPDIRECT3DDEVICE8       DDS_LPD3D8;
/* {secret} */
typedef LPDIRECT3DSURFACE8      DDS_LPD3DSURF8;
/* {secret} */
typedef HWND                    DDS_HWND;
#else
/* {secret} */
typedef void                    *DDS_LPD3D8;
/* {secret} */
typedef void                    *DDS_LPD3DSURF8;
/* {secret} */
typedef void                    *DDS_HWND;
#endif

/*--------------------------- Function Prototypes -------------------------*/

#ifdef  __cplusplus
extern "C" {            /* Use "C" linkage when in C++ mode */
#endif

int     DDSAPI DDS_init(int deviceIndex);
int     DDSAPI DDS_getError(void);
char*   DDSAPI DDS_getErrorString(int error);
int     DDSAPI DDS_getStereoMode(void);
int     DDSAPI DDS_getWindowedStereoMode(void);
int     DDSAPI DDS_getBlankIntervalLines(void);
int     DDSAPI DDS_isFlipChainNeeded(void);
int     DDSAPI DDS_start8(DDS_HWND hwnd,DDS_LPD3D8 lpD3D,DDS_LPD3DSURF8 lpPrimarySurf);
void    DDSAPI DDS_stereoOn(void);
int     DDSAPI DDS_scheduleFlip8(DDS_HWND hwnd,DDS_LPD3DSURF8 lpLeftSurf,DDS_LPD3DSURF8 lpRightSurf);
int     DDSAPI DDS_getFlipStatus(void);
void    DDSAPI DDS_waitTillFlipped(void);
void    DDSAPI DDS_stereoOff(void);
void    DDSAPI DDS_stop(DDS_HWND hwnd);
void    DDSAPI DDS_restoreDisplayMode(void);
void    DDSAPI DDS_exit(void);

#ifdef  __cplusplus
}                       /* End of "C" linkage for C++   */
#endif

#endif /* __DDSTEREO_H */
