############################################################################
#
#               Copyright (C) 2000-2001 SciTech Software, Inc.
#                            All rights reserved.
#
# Descripton:   Common makefile definitions for the wxWindows programs.
#               Requires the SciTech Software makefile definitions package
#               to be installed.
#
#############################################################################

.IMPORT .IGNORE: WXMGL WXUNIV

# Include definitions for the target system

.IF $(USE_WIN32)

# We are compiling against the Win32 version, so include all the stupid flags.

PRECOMP_HDR     := wx/wxprec.h
USE_RTTI        := 1
USE_CPPEXCEPT   := 1
CFLAGS          += -D__WIN95__ -D__WXMSW__ -D__WINDOWS__

# Link with wxWindows static link libraries or DLL library. Static link is default.

.IF $(DYNAMIC_LINK)

# Link with wxWindows DLL

DLL_CRTL        := 1
CFLAGS          += -DWXUSINGDLL -DWXXMLISDLL=1
EXELIBS         += wxwind$L

.ELSE

# Link with wxWindows static link libraries

.IF $(STKCALL)
EXELIBS         += $(LL)swxwin$(LE) $(LL)sjpeg$(LE) $(LL)spng$(LE) $(LL)sxpm$(LE) $(LL)stiff$(LE)
.ELSE
EXELIBS         += $(LL)wxwin$(LE) $(LL)jpeg$(LE) $(LL)png$(LE) $(LL)xpm$(LE) $(LL)tiff$(LE)
.ENDIF
EXELIBS         += $(LL)comctl32$(LE) $(LL)uuid$(LE)

.ENDIF

# Compile and link the program resource file

RESOURCE        := $(PROGRAM)$R

.ELIF $(USE_OS232)

# We are compiling against the OS/2 version, so include all the stupid flags.

PRECOMP_HDR     := wx/wxprec.h
USE_RTTI        := 1
USE_CPPEXCEPT   := 1
CFLAGS          += -D__WXPM__ -DTCPV40HDRS

# Link with wxWindows static link libraries

.IF $(STATIC_LINK)
.IF $(STKCALL)
EXELIBS         += $(LL)swxwin$(LE) $(LL)sjpeg$(LE) $(LL)spng$(LE) $(LL)sxpm$(LE) $(LL)stiff$(LE)
.ELSE
EXELIBS         += $(LL)wxwin$(LE) $(LL)jpeg$(LE) $(LL)png$(LE) $(LL)xpm$(LE) $(LL)tiff$(LE)
.ENDIF
EXELIBS         += SO32DLL$L #$(LL)comctl32$(LE) $(LL)uuid$(LE)
.ELSE

# Link with wxWindows DLL

CFLAGS          += -DWXUSINGDLL
EXELIBS         += wxwin$L
.ENDIF

.ENDIF

# Common stuff (not platform specific)

# If we want debug for wxWindows on define this var in your makefiles
.IF $(WXDBG)
CFLAGS          += -D__WXDEBUG__
.ENDIF

# Use wxUniv if required
.IF $(WXUNIV)
CFLAGS          += -D__WXUNIVERSAL__
.ENDIF

# Compile and link the program resource file

RESOURCE        := $(PROGRAM)$R

$(PROGRAM)$E: $(EXTRAINC) $(OBJECTS) $(RESOURCE)

DEPEND_OBJ      := $(OBJECTS)

.INCLUDE: "$(SCITECH)/makedefs/common.mk"

