/****************************************************************************
*
*           			   UVBELib Sample Program
*
*               Copyright (C) 1991-1998 SciTech Software, Inc.
*                            All rights reserved.
*
*  ======================================================================
*  |REMOVAL OR MODIFICATION OF THIS HEADER IS STRICTLY PROHIBITED BY LAW|
*  |                                                                    |
*  |This copyrighted computer code contains proprietary technology      |
*  |owned by SciTech Software, Inc., located at 505 Wall Street,        |
*  |Chico, CA 95928 USA (http://www.scitechsoft.com).                   |
*  |                                                                    |
*  |The contents of this file are subject to the SciTech Nucleus        |
*  |License; you may *not* use this file or related software except in  |
*  |compliance with the License. You may obtain a copy of the License   |
*  |at http://www.scitechsoft.com/nucleus-license.txt                   |
*  |                                                                    |
*  |Software distributed under the License is distributed on an         |
*  |"AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or      |
*  |implied. See the License for the specific language governing        |
*  |rights and limitations under the License.                           |
*  |                                                                    |
*  |REMOVAL OR MODIFICATION OF THIS HEADER IS STRICTLY PROHIBITED BY LAW|
*  ======================================================================
*
* Language:     ANSI C
* Environment:  32-bit DOS
*
* Description:  Test program for the UVBELib linkable library.
*
****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "pmapi.h"
#include "uvbelib.h"

/* SuperVGA information block */

#pragma pack(1)

typedef struct {
	char    VESASignature[4];       /* 'VESA' 4 byte signature          */
	short   VESAVersion;            /* VBE version number               */
	ulong	OEMStringPtr;           /* Far pointer to OEM string        */
	ulong	Capabilities;           /* Capabilities of video card       */
	ulong	VideoModePtr;           /* Far pointer to supported modes   */
	short   TotalMemory;            /* Number of 64kb memory blocks     */
	char    reserved[236];          /* Pad to 256 byte block size       */
	} VgaInfoBlock;

#pragma pack()

#ifdef	ISV_LICENSE
#include "isv.c"
#endif

int main(void)
{
	RMREGS			regs;
	RMSREGS			sregs;
	VgaInfoBlock	vgaInfo;
	ushort			*mode;
	uint			vgLen;
	uchar			*vgPtr;
	unsigned 		r_vgseg,r_vgoff;
	int				errCode;

	/* Register the ISV license file if desired */
#ifdef	ISV_LICENSE
	UV_registerLicense(OemLicense);
#endif

	/* Install the linkable library */
	if ((errCode = UV_install("",true,true)) != UV_ok) {
		printf(UV_getErrorStr(errCode));
		exit(1);
		}

	/* Now display information about the installed hardware */
	printf("UVBELib %s.%s - %s\n",
		UV_getMajorVersion(),
		UV_getMinorVersion(),
		UV_getReleaseDate());
	printf("%s\n\n", UV_getCopyrightStr());
	printf("  Chipset: %s\n",UV_getSuperVGAStr());
	printf("  RAMDAC:  %s\n",UV_getDACStr());
	printf("  Clock:   %s\n",UV_getClockStr());
	printf("\n");

	/* Allocate a 256 byte block of real memory for communicating with
	 * the VESA BIOS.
	 */
	if ((vgPtr = PM_getVESABuf(&vgLen,&r_vgseg,&r_vgoff)) == NULL) {
		printf("Unable to allocate VESA memory buffer!\n");
		exit(1);
		}

	/* Call the VESA VBE to see if it is out there */
	regs.x.ax = 0x4F00;
	regs.x.di = r_vgoff;
	sregs.es = r_vgseg;
	memcpy(vgPtr,"VBE2",4);
	PM_int86x(0x10, &regs, &regs, &sregs);
	memcpy(&vgaInfo,vgPtr,sizeof(VgaInfoBlock));
	if (regs.x.ax == 0x4F && strncmp(vgaInfo.VESASignature,"VESA",4) == 0) {
		printf("VESA VBE version %d.%d BIOS detected\n\n",
			vgaInfo.VESAVersion >> 8, vgaInfo.VESAVersion & 0xF);
		printf("Available video modes:\n");
		mode = PM_mapRealPointer(vgaInfo.VideoModePtr >> 16, vgaInfo.VideoModePtr & 0xFFFF);
		while (*mode != 0xFFFF) {
			printf("    %04hXh (%08X)\n", *mode, (int)mode);
			mode++;
			}
		}
	else
		printf("VESA VBE not found\n");

	/* Clean up and exit the linkable library */
	UV_exit();
	return 0;
}
