/****************************************************************************
*
*                         SciTech Display Doctor
*
*               Copyright (C) 1991-1998 SciTech Software, Inc.
*                            All rights reserved.
*
*  ======================================================================
*  |REMOVAL OR MODIFICATION OF THIS HEADER IS STRICTLY PROHIBITED BY LAW|
*  |                                                                    |
*  |This copyrighted computer code is a proprietary trade secret of     |
*  |SciTech Software, Inc., located at 505 Wall Street, Chico, CA 95928 |
*  |USA (www.scitechsoft.com).  ANY UNAUTHORIZED POSSESSION, USE,       |
*  |VIEWING, COPYING, MODIFICATION OR DISSEMINATION OF THIS CODE IS     |
*  |STRICTLY PROHIBITED BY LAW.  Unless you have current, express       |
*  |written authorization from SciTech to possess or use this code, you |
*  |may be subject to civil and/or criminal penalties.                  |
*  |                                                                    |
*  |If you received this code in error or you would like to report      |
*  |improper use, please immediately contact SciTech Software, Inc. at  |
*  |530-894-8400.                                                       |
*  |                                                                    |
*  |REMOVAL OR MODIFICATION OF THIS HEADER IS STRICTLY PROHIBITED BY LAW|
*  ======================================================================
*
* Language:     ANSI C
* Environment:  Any
*
* Description:  Module to implement the code to test the Nucleus Graphics
*				Architecture text mode support.
*
****************************************************************************/

#include "nucleus/gatest.h"

/*----------------------------- Implementation ----------------------------*/

/****************************************************************************
REMARKS:
Display the information about the video mode.
****************************************************************************/
static void displayModeInfo(
    GC_devCtx *gc,
	GA_modeInfo *mi)
{
	int		i,maxx,maxy,len,attr = GC_makeAttr(GC_WHITE, GC_BLUE);
	char	buf[80];

	maxx = (mi->XResolution/mi->XCharSize)-1;
	maxy = (mi->YResolution/mi->YCharSize)-1;
	GC_writec(gc,0,0,attr,'');
	GC_writec(gc,maxx,0,attr,'');
	GC_writec(gc,maxx,maxy,attr,'');
	GC_writec(gc,0,maxy,attr,'');
	for (i = 1; i < maxx; i++) {
		GC_writec(gc,i,0,attr,'');
		GC_writec(gc,i,maxy,attr,'');
		}
	for (i = 1; i < maxy; i++) {
		GC_writec(gc,0,i,attr,'');
		GC_writec(gc,maxx,i,attr,'');
		}
	sprintf(buf,"Text Mode: %d x %d (%dx%d character cell)",
		mi->XResolution / mi->XCharSize,
		mi->YResolution / mi->YCharSize,
		mi->XCharSize, mi->YCharSize);
	len = strlen(buf);
	GC_gotoxy(gc,(GC_maxx(gc)-len)/2,GC_maxy(gc)/2);
	GC_puts(gc,buf);
}

/****************************************************************************
REMARKS:
Main function to do the interactive tests.
****************************************************************************/
ibool doTextTest(
	GC_devCtx *_gc,
	int xRes,
	int yRes,
	int bitsPerPixel,
	N_uint32 flags,
	int refreshRate,
	GA_CRTCInfo *crtc,
	N_uint32 planeMask)
{
	GC_devCtx   *gc;
	int	        i;

	/* Obtain the mode information and set the display mode */
    GC_leave(_gc);
	dc = _gc->dc;
	virtualX = virtualY = bytesPerLine = -1;
	modeInfo.dwSize = sizeof(modeInfo);
	if (xRes == -1) {
		if (init.GetVideoModeInfo(flags,&modeInfo) != 0)
			return false;
		if (init.SetVideoMode(flags,&virtualX,&virtualY,&bytesPerLine,&maxMem,refreshRate,crtc) != 0)
			return false;
		}
	else {
		if (init.GetCustomVideoModeInfo(xRes,yRes,-1,-1,bitsPerPixel,&modeInfo) != 0)
			return false;
		if (init.SetCustomVideoMode(xRes,yRes,bitsPerPixel,flags,&virtualX,&virtualY,&bytesPerLine,&maxMem,crtc) != 0)
			return false;
		}
    gc = GC_create(dc,-1,-1,GC_FONT_8X8);
	GC_setAttr(gc,GC_makeAttr(GC_YELLOW,GC_BLUE));
	GC_fillText(gc,0, 0, GC_maxx(gc), GC_maxy(gc),
		GC_makeAttr(GC_RED, GC_BLUE), '');

	displayModeInfo(gc,&modeInfo);
	if (EVT_getch() == 0x1B)
		goto DoneTest;
	GC_setBackground(gc,GC_makeAttr(GC_CYAN, GC_BLUE), '');
	for (i = 0; i < GC_maxy(gc) + 1; i++)
		GC_scroll(gc,GC_SCROLL_UP, 1);

	displayModeInfo(gc,&modeInfo);
	if (EVT_getch() == 0x1B)
		goto DoneTest;
	GC_setBackground(gc,GC_makeAttr(GC_RED, GC_BLUE), '');
	for (i = 0; i < GC_maxy(gc) + 1; i++)
		GC_scroll(gc,GC_SCROLL_DOWN, 1);

	displayModeInfo(gc,&modeInfo);
	EVT_getch();

	/* Return to text mode, restore the state of the console and exit */
DoneTest:
	GC_destroy(gc);
    GC_restore(_gc);
	return true;
}

