/****************************************************************************
*
*                SciTech Nucleus Command Line Gamma program
*
*               Copyright (C) 1991-1998 SciTech Software, Inc.
*                            All rights reserved.
*
*  ======================================================================
*  |REMOVAL OR MODIFICATION OF THIS HEADER IS STRICTLY PROHIBITED BY LAW|
*  |                                                                    |
*  |This copyrighted computer code contains proprietary technology      |
*  |owned by SciTech Software, Inc., located at 505 Wall Street,        |
*  |Chico, CA 95928 USA (http://www.scitechsoft.com).                   |
*  |                                                                    |
*  |The contents of this file are subject to the SciTech Nucleus        |
*  |License; you may *not* use this file or related software except in  |
*  |compliance with the License. You may obtain a copy of the License   |
*  |at http://www.scitechsoft.com/nucleus-license.txt                   |
*  |                                                                    |
*  |Software distributed under the License is distributed on an         |
*  |"AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or      |
*  |implied. See the License for the specific language governing        |
*  |rights and limitations under the License.                           |
*  |                                                                    |
*  |REMOVAL OR MODIFICATION OF THIS HEADER IS STRICTLY PROHIBITED BY LAW|
*  ======================================================================
*
* Language:     ANSI C
* Environment:  Any 32-bit protected mode environment
*
* Description:  Simple program that allows the Nucleus gamma ramp to be
*				changed from the command line.
*
****************************************************************************/

#include "nucleus/graphics.h"
#include "sdd/copyrigh.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

/*---------------------------- Global Variables ---------------------------*/

static GA_devCtx		*dc = NULL;
static GA_initFuncs		init;
static GA_configInfo	info;
static GA_options		opt;

/*----------------------------- Implementation ----------------------------*/

/****************************************************************************
REMARKS:
Display the sign on banner.
****************************************************************************/
static void banner(void)
{
	printf("GAGamma - SciTech Nucleus Gamma Ramp Selection Program\n");
	printf("          %s\n", SCITECH_COPYRIGHT_MSG_SHORT);
	printf("\n");
}

/****************************************************************************
REMARKS:
Display the help screen.
****************************************************************************/
static void help(void)
{
	banner();
	printf("Valid commands are:\n");
	printf("\n");
	printf("  gagamma export     <device>\n");
	printf("  gagamma import     [filename] <device>\n");
	exit(-1);
}

/****************************************************************************
REMARKS:
Load the Nucleus driver and intialise it.
****************************************************************************/
static void LoadDriver(
	int deviceIndex)
{
	if (!dc) {
		if ((dc = GA_loadDriver(deviceIndex,false)) == NULL)
			PM_fatalError(GA_errorMsg(GA_status()));
		init.dwSize = sizeof(init);
		if (!GA_queryFunctions(dc,GA_GET_INITFUNCS,&init))
			PM_fatalError("Unable to get device driver functions!");
		info.dwSize = sizeof(info);
		init.GetConfigInfo(&info);
		opt.dwSize = sizeof(opt);
		init.GetOptions(&opt);
		}
}

/****************************************************************************
REMARKS:
Show the current settings for the device.
****************************************************************************/
static void ExportGamma(
	int deviceIndex)
{
	int	i;
	
	LoadDriver(deviceIndex);
	printf(
		"Gamma ramp for %s %s (device %d):\n\n",
		info.ManufacturerName, info.ChipsetName,
		deviceIndex);
	for (i = 0; i < 256; i++) {
		printf("%03d: %04X, %04X, %04X\n",
			i,
			opt.gammaRamp[i].Red,
			opt.gammaRamp[i].Green,
			opt.gammaRamp[i].Blue);
		}
}

/****************************************************************************
REMARKS:
Show the current settings for the device.
****************************************************************************/
static void ImportGamma(
	const char *filename,
	int deviceIndex)
{
	FILE 	*f;
	char	buf[256];
	int		i,red,green,blue;

	if ((f = fopen(filename,"r")) == NULL) {
		printf("Unable to open file '%s'\n", filename);
		exit(-1);
		}	
	LoadDriver(deviceIndex);
	while (!feof(f) && fgets(buf,sizeof(buf),f)) {
		if (sscanf(buf,"%d: %x,%x,%x",&i,&red,&green,&blue) == 4) {
			opt.gammaRamp[i].Red = red;
			opt.gammaRamp[i].Green = green;
			opt.gammaRamp[i].Blue = blue;
			}
		}
	fclose(f);
	init.SetOptions(&opt);
	GA_saveOptions(dc,&opt);
}

/****************************************************************************
REMARKS:
Main program entry point
****************************************************************************/
int main(
	int argc,
	char *argv[])
{
	/* Now handle the query */
	if (argc >= 2 && stricmp(argv[1],"export") == 0) {
		if (argc == 2)
			ExportGamma(0);
		else
			ExportGamma(atoi(argv[2]));
		}
	else if (argc >= 3 && stricmp(argv[1],"import") == 0) {
		int device = (argc == 3) ? 0 : atoi(argv[3]);
		ImportGamma(argv[2],device);
		}
	else
		help();
	if (dc)
		GA_unloadDriver(dc);
	return 0;
}

