/****************************************************************************
*
*                       SciTech Nucleus AGP Test program
*
*               Copyright (C) 1991-1998 SciTech Software, Inc.
*                            All rights reserved.
*
*  ======================================================================
*  |REMOVAL OR MODIFICATION OF THIS HEADER IS STRICTLY PROHIBITED BY LAW|
*  |                                                                    |
*  |This copyrighted computer code contains proprietary technology      |
*  |owned by SciTech Software, Inc., located at 505 Wall Street,        |
*  |Chico, CA 95928 USA (http://www.scitechsoft.com).                   |
*  |                                                                    |
*  |The contents of this file are subject to the SciTech Nucleus        |
*  |License; you may *not* use this file or related software except in  |
*  |compliance with the License. You may obtain a copy of the License   |
*  |at http://www.scitechsoft.com/nucleus-license.txt                   |
*  |                                                                    |
*  |Software distributed under the License is distributed on an         |
*  |"AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or      |
*  |implied. See the License for the specific language governing        |
*  |rights and limitations under the License.                           |
*  |                                                                    |
*  |REMOVAL OR MODIFICATION OF THIS HEADER IS STRICTLY PROHIBITED BY LAW|
*  ======================================================================
*
* Language:     ANSI C
* Environment:  Any 32-bit protected mode environment
*
* Description:  Simple program that loads the AGP driver and reports the
*				detected hardware configuration.
*
****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "nucleus/agp.h"

/*----------------------------- Implementation ----------------------------*/

const char *GetApertureSizeName(
	int size)
{
	switch (size) {
		case agpSize4MB:	return "4MB";
		case agpSize8MB:    return "8MB";
		case agpSize16MB:   return "16MB";
		case agpSize32MB:   return "32MB";
		case agpSize64MB:   return "64MB";
		case agpSize128MB:  return "128MB";
		case agpSize256MB:  return "256MB";
		}
	return "Unknown!";
}

int main(void)
{
	AGP_devCtx		*dc;
	AGP_driverFuncs	agp;
	AGP_configInfo	info;

	// Load the device driver for this device
	if ((dc = AGP_loadDriver(0)) == NULL)
		PM_fatalError(AGP_errorMsg(AGP_status()));
	agp.dwSize = sizeof(agp);
	if (!dc->QueryFunctions(AGP_GET_DRIVERFUNCS,&agp))
		PM_fatalError("Unable to get device driver functions!");
	info.dwSize = sizeof(info);
	agp.GetConfigInfo(&info);
	printf(
		"Manufacturer:    %s\n"
		"Chipset:         %s\n"
		"Driver Revision: %s\n"
		"Driver Build:    %s\n",
		info.ManufacturerName, info.ChipsetName,
		info.VersionInfo, info.BuildDate);
	printf(
		"Aperture Base:   0x%08X\n"
		"Aperture Size:   %s\n",
		agp.GetApertureBase(),
		GetApertureSizeName(agp.GetApertureSize()));
	AGP_unloadDriver(dc);
	return 0;
}
