/****************************************************************************
*
*                                       SciTech Multi-platform Graphics Library
*
*  ========================================================================
*
*    The contents of this file are subject to the SciTech MGL Public
*    License Version 1.0 (the "License"); you may not use this file
*    except in compliance with the License. You may obtain a copy of
*    the License at http://www.scitechsoft.com/mgl-license.txt
*
*    Software distributed under the License is distributed on an
*    "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
*    implied. See the License for the specific language governing
*    rights and limitations under the License.
*
*    The Original Code is Copyright (C) 1991-1998 SciTech Software, Inc.
*
*    The Initial Developer of the Original Code is SciTech Software, Inc.
*    All Rights Reserved.
*
*  ========================================================================
*
* Language:             ANSI C
* Environment:  Any
*
* Description:  Demo showing how to use do X and Y flippped sprites with the
*               MGL.
*
****************************************************************************/

#include "mglsamp.h"

#define IMAGE_NAME "doggie2.bmp"

/*----------------------------- Global Variables --------------------------*/

char 			demoName[] = "sprites";
int 			bmpWidth,bmpHeight,bmpDepth;
int 			maxx,maxy;
pixel_format_t 	bmpPF;

/*------------------------------ Implementation ---------------------------*/

/****************************************************************************
PARAMETERS:
dc     		- Display dc
trans  		- Turn on/off transparent blitting

REMARKS:
Demo showing how to use memory dc's to store sprites and to use blit them
from the memory dc to the display dc.
****************************************************************************/
ibool flipBlit(
	MGLDC *dc)
{
	palette_t 		pal[256];
    int 			i,oldCheckId;
	MGLDC 			*memdc;
    bltfx_t         fx;

	/* Display title message at the top of the window. */
    mainWindow(dc,"System Memory 8bpp Flipped Blit Demo");
    statusLine("Press any key to continue, ESC to Abort");

	/* Create a memory device context */
	if ((memdc = MGL_createMemoryDC(bmpWidth,bmpHeight,bmpDepth,&bmpPF)) == NULL)
		MGL_fatalError(MGL_errorMsg(MGL_result()));

	/* Load a bitmap into the memory device context. The palette gets
	 * loaded into the memory device context as well.
	 */
	if (!MGL_loadBitmapIntoDC(memdc,IMAGE_NAME,0,0,true))
		MGL_fatalError(MGL_errorMsg(MGL_result()));

	/* Set the display device context with the palette from the
	 * memory device context.
	 */
    MGL_getPalette(memdc,pal,MGL_getPaletteSize(memdc),0);
    MGL_setPalette(dc,pal,MGL_getPaletteSize(memdc),0);
    MGL_realizePalette(dc,MGL_getPaletteSize(memdc),0,true);
    oldCheckId = MGL_checkIdentityPalette(false);

    /* Setup transparent effects blit */
    MGL_makeCurrentDC(memdc);
    fx.flags = MGL_BLT_COLOR_KEY_SRC_SINGLE;
    fx.colorKeyLo = MGL_realColor(dc,MGL_getPixelCoord(0,0));
    MGL_makeCurrentDC(dc);

	/* Copy image from image in memory to the screen. */
    i = 0;
    while (!checkEvent()) {
        if (i & 1)
            fx.flags |= MGL_BLT_FLIPX;
        else
            fx.flags &= ~MGL_BLT_FLIPX;
        if (i & 2)
            fx.flags |= MGL_BLT_FLIPY;
        else
            fx.flags &= ~MGL_BLT_FLIPY;
        MGL_bitBltFxCoord(dc,memdc,0,0,bmpWidth,bmpHeight,
            MGL_random(maxx+bmpWidth)-bmpWidth/2,
            MGL_random(maxy+bmpWidth)-bmpWidth/2,&fx);
        i++;
		}

	/* Remove all device contexts from memory. */
    MGL_destroyDC(memdc);
    MGL_checkIdentityPalette(oldCheckId);
    MGL_setDefaultPalette(dc);
	return pause();
}

/****************************************************************************
PARAMETERS:
dc     		- Display dc
trans  		- Turn on/off transparent blitting

REMARKS:
Demo showing how to use memory dc's to store sprites and to use blit them
from the memory dc to the display dc.
****************************************************************************/
ibool flipBitmap(
	MGLDC *dc)
{
    int 			i,oldCheckId;
    bitmap_t        *bitmap;
    bltfx_t         fx;

	/* Display title message at the top of the window. */
    mainWindow(dc,"System Memory Bitmap 8bpp Flipped Blit Demo");
    statusLine("Press any key to continue, ESC to Abort");

	/* Load the bitmap */
    if ((bitmap = MGL_loadBitmap(IMAGE_NAME,true)) == NULL)
		MGL_fatalError(MGL_errorMsg(MGL_result()));

	/* Set the display device context with the palette from the
	 * memory device context.
	 */
    MGL_setPalette(dc,bitmap->pal,256,0);
    MGL_realizePalette(dc,256,0,true);
    oldCheckId = MGL_checkIdentityPalette(false);

    /* Setup transparent effects blit */
    fx.flags = MGL_BLT_COLOR_KEY_SRC_SINGLE;
    fx.colorKeyLo = *((uchar*)bitmap->surface);

	/* Copy image from image in memory to the screen. */
    i = 0;
    while (!checkEvent()) {
        if (i & 1)
            fx.flags |= MGL_BLT_FLIPX;
        else
            fx.flags &= ~MGL_BLT_FLIPX;
        if (i & 2)
            fx.flags |= MGL_BLT_FLIPY;
        else
            fx.flags &= ~MGL_BLT_FLIPY;
        MGL_putBitmapFx(dc,
            MGL_random(maxx+bmpWidth)-bmpWidth/2,
            MGL_random(maxy+bmpWidth)-bmpWidth/2,bitmap,&fx);
        i++;
		}

	/* Remove all device contexts from memory. */
    MGL_unloadBitmap(bitmap);
    MGL_checkIdentityPalette(oldCheckId);
    MGL_setDefaultPalette(dc);
	return pause();
}

void demo(MGLDC *dc)
{
	/* Get the screen size and store them. */
    maxx = MGL_maxx();
    maxy = MGL_maxy();

	/* Get image information */
	MGL_getBitmapSize(IMAGE_NAME,&bmpWidth,&bmpHeight,&bmpDepth,&bmpPF);

	if (!flipBlit(dc))
		return;
	if (!flipBitmap(dc))
		return;
}

