/****************************************************************************
*
*					SciTech Multi-platform Graphics Library
*
*  ========================================================================
*
*    The contents of this file are subject to the SciTech MGL Public
*    License Version 1.0 (the "License"); you may not use this file
*    except in compliance with the License. You may obtain a copy of
*    the License at http://www.scitechsoft.com/mgl-license.txt
*
*    Software distributed under the License is distributed on an
*    "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
*    implied. See the License for the specific language governing
*    rights and limitations under the License.
*
*    The Original Code is Copyright (C) 1991-1998 SciTech Software, Inc.
*
*    The Initial Developer of the Original Code is SciTech Software, Inc.
*    All Rights Reserved.
*
*  ========================================================================
*
* Language:		ANSI C
* Environment:	Any
*
* Description:  Simple demo showing how to use the MGL_copyPage function to
*				copy data from one display page to another using the
*				hardware blitter if available.
*
****************************************************************************/

#include <string.h>
#include "mglsamp.h"

/*----------------------------- Global Variables --------------------------*/

char demoName[] = "copypage";

/*------------------------------ Implementation ---------------------------*/

void demo(MGLDC *dc)
{
	/* Check that we have two display pages available */
	if (MGL_maxPage(dc) == 0)
		MGL_fatalError("This sample requires two display pages!");

	/* Display new title message and draw first display page */
	mainWindow(dc,"CopyPage Demonstration program (Page 1)");
	statusLine("Press any key to view second page, ESC to Abort");
	MGL_setColor(MGL_GREEN);
	MGL_fillRectCoord(0,0,MGL_sizex(dc),MGL_sizey(dc));
	MGL_setColor(MGL_WHITE);
	MGL_drawStrXY(4,4,"Page 1");

	/* Draw second display page while it is hidden */
	defaultAttributes(dc);
	MGL_setActivePage(dc,1);
	mainWindow(dc,"CopyPage Demonstration program (Page 2)");
	statusLine("Press any key to copy data from first page, ESC to Abort");
	MGL_setColor(MGL_CYAN);
	MGL_fillRectCoord(0,0,MGL_sizex(dc),MGL_sizey(dc));
	MGL_setColor(MGL_WHITE);
	MGL_drawStrXY(4,4,"Page 2");
	if (waitEvent() == ESC) return;

	/* Make the second display page visible */
	MGL_setVisualPage(dc,1,true);
	if (waitEvent() == ESC) return;

	/* Now copy data from first page to second page */
	MGL_copyPageCoord(dc,0,0,0,MGL_sizex(dc)/4,MGL_sizey(dc)/4,
		MGL_sizex(dc)/2,MGL_sizey(dc)/2,MGL_REPLACE_MODE);

	/* Wait for key press and exit */
	pause();
}

