@echo off
rem Generic batch file to build a version of the library. This batch file
rem assumes that the correct batch files exist to setup the appropriate
rem compilation environments, and that the DMAKE.EXE program is available
rem somewhere on the path.
rem
rem Builds as release or debug depending on the value of the CHECKED
rem environment variable.

rem Unset all environment variables that change the compile process
set DBG=
set OPT=
set OPT_SIZE=
set BUILD_DLL=
set IMPORT_DLL=
set FPU=
set CHECKS=
set BETA=

if %1==va30-o32 goto va30-o32
if %1==va30-p32 goto va30-p32
if %1==va30-drv goto va30-drv
if %1==wc10ad16 goto wc10ad16
if %1==wc10ad32 goto wc10ad32
if %1==wc10aw16 goto wc10aw16
if %1==wc10aw32 goto wc10aw32
if %1==wc10ac32 goto wc10ac32
if %1==wc10ao32 goto wc10ao32
if %1==wc10ap32 goto wc10ap32
if %1==wc10asnp goto wc10asnp
if %1==wc10-d16 goto wc10-d16
if %1==wc10-d32 goto wc10-d32
if %1==wc10-w16 goto wc10-w16
if %1==wc10-w32 goto wc10-w32
if %1==wc10-c32 goto wc10-c32
if %1==wc10-o32 goto wc10-o32
if %1==wc10-p32 goto wc10-p32
if %1==wc10-snp goto wc10-snp
if %1==wc11-d16 goto wc11-d16
if %1==wc11-d32 goto wc11-d32
if %1==wc11-w16 goto wc11-w16
if %1==wc11-w32 goto wc11-w32
if %1==wc11-c32 goto wc11-c32
if %1==wc11-o32 goto wc11-o32
if %1==wc11-p32 goto wc11-p32
if %1==wc11-snp goto wc11-snp
if %1==bc20-o32 goto bc20-o32
if %1==bc20-o32 goto bc20-o32
if %1==emx-o32 goto emx-o32
if %1==emx-p32 goto emx-p32
if %1==cl60-drv goto cl60-drv
if %1==cl386-drv goto cl386-drv

echo Usage: BUILD 'compiler_name' [DMAKE commands]
echo.
echo Where 'compiler_name' is of the form comp-os, where
echo 'comp' defines the compiler and 'os' defines the OS environment.
echo For instance 'wc10-o32' is for Watcom C++ 10.6 for OS/2 Console.
echo The value of 'comp' can be any of the following:
echo.
echo    bc20 - Borland C++ 2.0
echo    va30 - IBM VisualAge C++ 3.0 32-bit
echo    wc10 - Watcom C++ 10.6
echo    wc11 - Watcom C++ 11.0
echo    emx  - emx 0.9d
echo.
echo The value of 'os' can be one of the following:
echo.
echo    d16  - 16-bit DOS
echo    d32  - 32-bit DOS
echo    w16  - 16-bit Windows GUI mode
echo    c32  - 32-bit Windows console mode
echo    w32  - 32-bit Windows GUI mode
echo    o16  - 16-bit OS/2 console mode
echo    o32  - 32-bit OS/2 console mode
echo    p32  - 32-bit OS/2 Presentation Manager
echo    snp  - 32-bit SciTech Snap application
goto end

rem -------------------------------------------------------------------------
rem Setup for the specified compiler

:va30-o32
call va30-o32.cmd
goto compileit

:va30-p32
call va30-p32.cmd
goto compileit

:va30-drv
call va30-drv.cmd
goto compileit

:wc10ad16
call wc10ad16.cmd
goto compileit

:wc10ad32
call wc10ad32.cmd
goto compileit

:wc10atnt
call wc10atnt.cmd
goto compileit

:wc10aw16
call wc10aw16.cmd
goto compileit

:wc10aw32
call wc10aw32.cmd
goto compileit

:wc10ac32
call wc10ac32.cmd
goto compileit

:wc10ao32
call wc10ao32.cmd
goto compileit

:wc10ap32
call wc10ap32.cmd
goto compileit

:wc10-d16
call wc10-d16.cmd
goto compileit

:wc10-d32
call wc10-d32.cmd
goto compileit

:wc10-tnt
call wc10-tnt.cmd
goto compileit

:wc10-w16
call wc10-w16.cmd
goto compileit

:wc10-w32
call wc10-w32.cmd
goto compileit

:wc10-c32
call wc10-c32.cmd
goto compileit

:wc10-o32
call wc10-o32.cmd
goto compileit

:wc10-p32
call wc10-p32.cmd
goto compileit

:wc11-d16
call wc11-d16.cmd
goto compileit

:wc11-d32
call wc11-d32.cmd
goto compileit

:wc11-tnt
call wc11-tnt.cmd
goto compileit

:wc11-w16
call wc11-w16.cmd
goto compileit

:wc11-w32
call wc11-w32.cmd
goto compileit

:wc11-c32
call wc11-c32.cmd
goto compileit

:wc11-o32
call wc11-o32.cmd
goto compileit

:wc11-p32
call wc11-p32.cmd
goto compileit

:bc20-o32
call bc20-o32.cmd
goto compileit

:bc20-p32
call bc20-p32.cmd
goto compileit

:emx-o32
call emx-o32.cmd
goto compileit

:emx-p32
call emx-p32.cmd
goto compileit

:cl60-drv
call cl60-drv.cmd
goto compileit

:cl386-drv
call cl386-drv.cmd
goto compileit

:compileit
k_rm -f *.lib *.a
dmake %2 %3 %4 %5 %6 %7 %8 %9
if errorlevel 1 goto errorend
goto end

:errorend
echo *************************************************
echo * An error occurred while building the library. *
echo *************************************************
:end

