/*
** Vectorize a complete directory to ART-format
** WORKLab, 17.12.96
** 
*/
parse upper arg path options
if path = "" then do
say "invalid directory path"
say "syntax: vectall <directory> [<options>]"
say ""
say "        ,where <directory> is a valid path ('.' for current dir)"
say "        (only files with suffix BMP, TIF or GIF will be converted)"
say "        <options> one of(L)ine (vectorizes using lines)," 
say "        or (B)ezier (vectorizes using Bezier curves)"
say "        default is Line."
say ""
say "output directory is the current directory."
exit
end

/* current dir ? */
if path = '.' then path=directory()

/* vector type */
if left(options,1)== 'B' then 
   options="-BEZIER" 
else  options = ""

call SysFileTree path||"\*" ,"file","FO"
say file.0 "files found"
do  i=1 to file.0

   /*suffix = right(file.i, lastpos('.', file.i))*/
   suffix = right(file.i, 3)
   /* valid file type ? */
   if suffix="BMP" | suffix ="GIF" | suffix="TIF"
   then do
      /* put art filename together */
      name = filespec("name", file.i)
      base = left(file.i, lastpos('.', file.i))
      base = right(base, length(base)-lastpos('\', file.i))
      say " "
      say "===> converting" file.i "to" base||"ART <==="
      "kvec" file.i base||"ART" "-FOR ART" options
   end
   else do 
      say "unknown format!:" file.i
      iterate
   end


end

exit
