/*
** Vectorize an image in BMP, TIF or GIF format to ART-Format
** WORKLab, 17.12.96
*/
parse upper arg path options
if path = "" then do
say "invalid file name"
say "syntax: vec2art <filename.typ> [<options>]"
say ""
say "        ,where filename type is one of (BMP, TIF, GIF)"
say "        and options one of(L)ine (vectorizes using lines)," 
say "        or (B)ezier (vectorizes using Bezier curves)"
say "        default is Line."
exit
end

name = filespec("name", path)
base = left(name, lastpos('.', name))
if left(options,1)== 'B' then 
      options="-BEZIER" 
else  options = ""
say "--> converting" path "to" base||"ART"
"kvec" path base||"ART" "-FOR ART" options
exit
