/* JView Installation REXX script */
/* Copyright (c) 1995  - 1996 Crunch Products                              */

Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs
currentdirectory = DIRECTORY()
If Substr( currentdirectory, Length(currentdirectory), 1 ) <> "\"
    Then currentdirectory = currentdirectory || "\"
Call SysCls
Call SysCurState 'ON'
/*Screen is cleared, get destination drive and directory */
Say
Say
Say "Welcome to the JView and JView Pro installation procedure."
Say "If you wish to abandon this installation, hit Ctrl+C to abort. "

GetInstallDirectory:
Say
Say "Please enter the complete path where you want JView to be installed."
Say "If you would like it installed in C:\JVW just hit the Enter key"
Say

Parse Pull dest_directory

/* Use our default if enter key hit */
If dest_directory = ""  Then dest_directory = "C:\JVW\"

/* Make sure there is a trailing backslash */
If Substr(dest_directory, Length(dest_directory), 1 ) <> "\"  Then dest_directory = dest_directory || "\"

/* Check to make sure a drive is specified - use C drive if not */
installdrive = Filespec("DRIVE", dest_directory)
If installdrive = ""  Then installdrive = "C"

/* Check to make sure a path is specified - use root if not */
installpath  = Filespec("PATH", dest_directory) 
If installpath = ""   Then installpath= "\"

dest_directory = installdrive || installpath

/* uppercase version */
dest_directory_uppercase = Translate(dest_directory)

/* And a version without a slash */
dest_noslash = Substr(dest_directory, 1, Length(dest_directory) - 1 )

/* Confirm destination directory */
Say
Say "Your specified install location is " dest_directory || "."
Say "Is this correct? (Yes/No):"
Say
Call YesNo
If RESULT <> 'Y' Then Call GetInstallDirectory

Say
Say "Creating your specified install directory " dest_directory || " (wait ...)"
rc = SysMkDir(Substr(dest_directory, 1, Length(dest_directory)-1))
Select
     When rc = 0 Then NOP
     When rc = 5 Then Do
           Say "Directory" dest_directory "already exists."
           Say "Enter 'Yes' to continue or 'No' to stop the installation."
           Call YesNo
           If RESULT <> 'Y' Then Exit
           End /* do */
     Otherwise Do
           SAY "Couldn't create destination directory" dest_directory "try another or hit Ctrl+C to stop."
           Call GetInstallDirectory
           End /* do */
     End /* select */

/* Install files */

Say "UnArchiving files to " dest_directory "..."
Say "JView is packaged using Info-ZIP's compression"
Say "utility.  The installation program uses UnZip to read the zip files."
Say "Info-ZIP's software (Zip, UnZip and related utilities) is"
Say "free and can be obtained as source code or executables from"
Say "various anonymous-ftp sites, including ftp.uu.net:/pub/archiving/zip."
Say
'@unzip -U -j -o jvw_all.zip -d 'dest_directory

Say "Doing the JView Folder Creation..."
rc = SysCreateObject("WPFolder", "JView Graphics", "<WP_DESKTOP>", "OBJECTID=<JVIEW_FOLDER>;ICONFILE=", "R")

title = 'JView'
classname = 'WPProgram'
location = '<JVIEW_FOLDER>'
filter= '*.GIF,*.JPG,*.JPEG,*.BMP,*.TGA,*.PBM,*.PGM,*.PPM,*.TIF,*.TIFF,*.RLE,*.MET,*.PCX,*.X11,*.RAS,*.SLS,*.PCD,*.PNG;'
setup = 'EXENAME='dest_directory'JView.exe;STARTUPDIR='dest_directory';PROGTYPE=PM;ASSOCFILTER='filter
option = 'update'

Say "Doing the JView Object Creation..."
rc = SysCreateObject(classname, title, location, setup, option)
Say
Say "All better now"
Say "You should take the *.BMP association off of the icon editor, if"
Say "you have not done so already."
Say

bootdrive = Substr(Translate(Value('PATH',,'OS2ENVIRONMENT')),Pos('\OS2\SYSTEM',Translate(Value('PATH',,'OS2ENVIRONMENT')))-2,2)

temp_defined = 0
Call IsTempPathDefined
If RESULT == 'Y' Then temp_defined = 1

path_defined = 0
Call IsPathDefined
If RESULT == 'Y' Then path_defined = 1

libpath_defined = 0
Call IsLibPathDefined
If RESULT == 'Y' Then libpath_defined = 1

If (path_defined = 1 & libpath_defined = 1 & temp_defined = 1)  Then Do
   Say
   Say "Installation Complete"
   Exit
   End  /* Do */

Say
Say "Your CONFIG.SYS file defines several environment variables that determine"
Say "how OS/2 and your applications work.  With your permission, this script"
Say "will modify them if needed."
Say
If (path_defined = 0 | libpath_defined = 0) Then Do
   Say " First, we will need to add " dest_directory " to your"
   Say " PATH statement and LIBPATH statements.  Doing so will"
   Say " allow you to start JView from any command"
   Say " line.  If " dest_directory " is NOT"
   Say " placed into these variables, you can still run"
   Say " JView from its Icon or from the " dest_directory 
   Say " directory via the command line."
   Say
   Say "Do you wish to modify your config.sys? (Yes/No)"
   Say
   Call YesNo
   If RESULT <> 'Y' Then Do
      Say 
      Say "Not updating config.sys, Installation Complete."
      Exit
      End  /* Do */
   End /* do */

If (temp_defined = 0) Then Do
    Call CreateTemp
    temp_directory = RESULT
    If temp_directory = "" Then temp_defined = 1
    End  /* Do */

If (path_defined = 0 | libpath_defined = 0) Then Call UpdateConfigPaths
/*Wont get here unless paths were OK to start with */
If temp_defined = 0 Then Do
   oldconfig=bootdrive'\CONFIG.SYS'
   rc = lineout(oldconfig, "SET TMP="||temp_directory)
   rc = lineout(oldconfig)
   Say "Installation done.  Reboot your machine for TMP"
   Say "directory to become useful."
   Exit
End  /* Do */

Say
Say "Installation Complete."
Say "You will need to reboot your computer for changes to take effect."
Say
Exit
   
UpdateConfigPaths:
oldconfig=bootdrive'\CONFIG.SYS'
newconfig=bootdrive'\CONFIG.JVW'
tmpconfig=bootdrive'\TMP.SYS'
Call SysFileDelete(newconfig)

Do while lines(oldconfig)
    inline=linein(oldconfig)
    upperinline = Translate(inline)
    Parse Value inline With os2var '=' os2value
    os2var = Translate(os2var)
    If ( (os2var =  "SET PATH" & path_defined = 0) | (os2var = "LIBPATH" & libpath_defined = 0) ) Then Do
        /*
         * see if there is a ; at the end of the value
        */
        position=lastpos(';',os2value)
        lenvalue=length(os2value)

        If position=lenvalue Then Do
           /* ; at end of value */
           jview_line = os2var'='os2value''dest_noslash';'
           End
        Else Do
           /* ; NOT at end of value */
           jview_line=os2var'='os2value';'dest_noslash';'
           End
        rc = lineout(newconfig, jview_line)
        End
    Else
        rc = lineout(newconfig, inline)
    End

If temp_defined = 0 Then rc = lineout(newconfig, "SET TMP="||temp_directory)

rc = lineout(newconfig)
rc = lineout(oldconfig)

/******************************************************************/
/* Copy created file(CONFIG.JVW) to temporary file(TMP.SYS),      */
/* copy original file(CONFIG.SYS) to new file(CONFIG.JVW),        */
/* and copy temporary file(TMP.SYS) to original file(CONFIG.SYS). */
/******************************************************************/

'@copy 'oldconfig' 'tmpconfig' 2>nul >nul'
'@copy 'newconfig' 'oldconfig' 2>nul >nul'
'@copy 'tmpconfig' 'newconfig' 2>nul >nul'

Call SysFileDelete( tmpconfig )

SAY "  Your CONFIG.SYS file has been updated."
SAY "  Your old CONFIG.SYS has been copied to " newconfig || "."
SAY "  in order for the changes to take effect,"
SAY "  please Shutdown and Restart OS/2."

Exit

IsLibPathDefined:
oldconfig=bootdrive'\CONFIG.SYS'
Do while lines(oldconfig)
    inline=linein(oldconfig)
    upperinline = Translate(inline)
    Parse Value inline With os2var '=' os2value
    os2var = Translate(os2var)
    If (os2var = "LIBPATH") Then Do
       os2value = Translate(os2value)
       If Pos(Translate(Substr(dest_directory, 1, Length(dest_directory) - 1 )), os2value) <> 0 Then Do
          rc = lineout(oldconfig)
          Return 'Y'
          End  /* Do */
       End
    End
rc=lineout(oldconfig)
Return 'N'

IsPathDefined:
temp_string = Value("PATH", , "OS2ENVIRONMENT")
temp_string = Translate(temp_string)
If Pos(Translate(Substr(dest_directory, 1, Length(dest_directory) - 1 )), temp_string) <> 0 Then Return 'Y'
oldconfig=bootdrive'\CONFIG.SYS'
Do while lines(oldconfig)
    inline=linein(oldconfig)
    upperinline = Translate(inline)
    Parse Value inline With os2var '=' os2value
    os2var = Translate(os2var)
    If (os2var = "SET PATH") Then Do
       os2value = Translate(os2value)
       If Pos(Translate(Substr(dest_directory, 1, Length(dest_directory) - 1 )), os2value) <> 0 Then Do
          rc = lineout(oldconfig)
          Return 'Y'
          End  /* Do */
       End
    End
rc=lineout(oldconfig)
Return 'N'

IsTempPathDefined:
temp_directory = Value("TMP", , "OS2ENVIRONMENT")
If temp_directory = "" Then temp_directory = Value("TEMP", , "OS2ENVIRONMENT")
If temp_directory <> "" Then Return 'Y'
oldconfig=bootdrive'\CONFIG.SYS'
Do while lines(oldconfig)
    inline=linein(oldconfig)
    upperinline = Translate(inline)
    Parse Value inline With os2var '=' os2value
    os2var = Translate(os2var)
    If (os2var = "SET TEMP" | os2var = "SET TMP") Then Do
          rc = lineout(oldconfig)
          Return 'Y'
          End  /* Do */
    End
rc=lineout(oldconfig)
Return 'N'


CreateTemp:
Say
Say "JView needs to have a place to put temporary files, in fact many applications"
Say "need such a directory.  The location of this directory is set by one of two"
Say "environmental variables set in your config.sys.  These variables are TMP"
Say "and TEMP.  You currently do not have either defined."
Say 
Say "Do you wish to create such a directory and add it to your config.sys? (Yes/No)"
Call YesNo
If RESULT <> 'Y' Then Return ""

CreateTempLocal:
Say
Say "Please enter the complete drive and path where you want TMP to"
Say "be located.  If you would like it installed in C:\TMP just hit the"
Say "Enter key.  Do NOT define this directory to be the same as"
Say "your JView installation directory."
Say

Parse Pull temp_string

/* Use our default if enter key hit */
If temp_string = ""  Then temp_string = "C:\TMP"

/* Make sure there is a trailing backslash*/
If Substr(temp_string, Length(temp_string), 1 ) <> "\"  Then temp_string = temp_string || "\"

/* Check to make sure a drive is specified - use C drive if not */
ctdrive = Filespec("DRIVE", temp_string)
If ctdrive = ""  Then ctdrive = "C"

/* Check to make sure a path is specified - use root if not */
ctpath  = Filespec("PATH", temp_string)
If ctpath = ""   Then ctpath= "\"

temp_string = ctdrive || ctpath
If Length(temp_string) > 3 Then temp_string = Substr(temp_string, 1, Length(temp_string) - 1)

/* Confirm destination directory */
Say
Say "Your specified TMP location is " temp_string || "."
Say "Is this correct? (Yes/No):"
Say

Call YesNo
If RESULT <> 'Y' Then Do
   Call CreateTempLocal
   Return temp_string
   End /* do */

Say
Say "Creating your specified TMP directory " temp_string || " (wait ...)"

If Translate(temp_string) == Translate(dest_noslash) Then
   rc = 10
Else
   rc = SysMkDir(temp_string)

Select
     When rc = 0 Then NOP
     When rc = 5 Then Do
           Say "Directory" temp_string "already exists."
           Say "Enter 'Yes' to continue or 'No' to try another."
           Call YesNo
           If RESULT <> 'Y' Then Do
              Call CreateTempLocal
              Return temp_string
              End /* do */
           End /* do */
     Otherwise Do
           Say "Couldn't create destination directory" temp_string
           Say "try another or hit Ctrl+C to stop."
           Call CreateTempLocal
           Return temp_string
           End /* do */
     End /* select */

Return temp_string




YesNo:
retval = ""
DO WHILE retval = ""
      PARSE PULL response
      SELECT
            WHEN ( TRANSLATE( response ) = 'N' | TRANSLATE( response ) = 'NO' )
                   THEN
                    retval = 'N'
            WHEN ( TRANSLATE( response ) = 'Y' | TRANSLATE( response ) = 'YES' )
                    THEN
                    retval = 'Y'
            OTHERWISE
                    Say
                    Say "Invalid response.  Please re-enter."
      END
END
RETURN retval


