#if !defined (__GRAPH2_HPP__)
#define __GRAPH2_HPP__ 1

#if defined (__cplusplus)
extern "C" {
#endif

#if defined (__GNUC__)
   #if !defined (_System)
      #if defined (__cplusplus)
         #define _System
      #else
         #define _System __attribute__((system))
      #endif
      #define _System_Defined_
   #endif
#endif


#pragma pack(1)
typedef struct __Rgb2__ {
   unsigned char b;
   unsigned char g;
   unsigned char r;
   unsigned char options;
} Rgb2;
#pragma pack(4)

/* Do not change this constants, because graph2.exe uses hardcoded */
/* sizes */
#define SCREENX      640
#define SCREENY      480
#define COLORS       256

#define COLORMASK     0xFF

#define GR_NORMAL   0x00
#define GR_OR       0x01
#define GR_XOR      0x02
#define GR_AND      0x03

typedef struct __GraphMem__ {
   unsigned long ulSize;
   unsigned char GrMode;
   unsigned char GrColor;
   unsigned GrXPos;
   unsigned GrYPos;
   unsigned long colors;
   Rgb2  Palette[COLORS];
   unsigned char GrBuf[SCREENX*SCREENY];
   volatile unsigned long modify;
   volatile unsigned long palmodify;
} GraphMem;

extern GraphMem* __GrPtr;
#if defined (__WATCOMC__)
   #pragma aux __GrPtr "*"       /* Alle anderen Compiler sind ok */
#endif

unsigned      _System __GrInit(unsigned clientFg);
/* unsigned clientFg==0 means: start Graph2.exe minimized */
/* else start Graph2.exe in Foreground with focus */

unsigned      _System __GrTerm(void);

unsigned char _System __GrGetMode(void);
void          _System __GrSetMode(unsigned newMode);
/* newMode is one of the GR_XXX-constants */

unsigned char _System __GrGetColor(void);
void          _System __GrSetColor(unsigned char paintColor);

void          _System __GrSetScreen(unsigned char color);
void          _System __GrCls(void);

void          _System __GrSetPalEntry1(unsigned index, unsigned long packedRgb2);
void          _System __GrSetPalEntry (unsigned index, unsigned char r,
                                       unsigned char g, unsigned char b);

void          _System __GrGetPalEntry1(unsigned index, unsigned long* packedRgb2);
void          _System __GrGetPalEntry2(unsigned index, Rgb2* rgb);
void          _System __GrGetPalEntry(unsigned index, unsigned char *r,
                                      unsigned char *g, unsigned char *b);

void          _System __GrMoveTo(unsigned x, unsigned y);
unsigned      _System __GrGetX(void);
unsigned      _System __GrGetY(void);

void          _System __GrSetPel(unsigned x, unsigned y);
unsigned char _System __GrGetPel(unsigned x, unsigned y);

void          _System __GrLineTo(unsigned x, unsigned y);
void          _System __GrLine(unsigned x, unsigned y, unsigned xe, unsigned ye);

void          _System __GrCircle(unsigned x, unsigned y, unsigned radius);


void          _System __GrRectl(unsigned xlu, unsigned ylu,
                                unsigned xrt, unsigned yrt);
void          _System __GrFillRectl(unsigned xlu, unsigned ylu,
                                    unsigned xrt, unsigned yrt);

#if defined (__GNUC__)
   #if defined (IN_GRAPH2)
       #include <fastgraph2.h>
   #endif
   #if defined (_System_Defined_)
      #undef _System_Defined_
      #undef _System
   #endif
#endif

#if defined (__cplusplus)
}
#endif
#endif   /* __GRAPH2_HPP__ */
