/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class PNGWriter
implements ImageObserver {
    private static final int MAX_IDAT_SIZE = 2000000000;

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return true;
    }

    public void writePNG(Image image, String string) {
        System.out.println(" Writing: " + string);
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(string));
            this.writeSignature(dataOutputStream);
            this.writeHeader(image, dataOutputStream);
            this.writeData(image, dataOutputStream);
            this.writeTrailer(dataOutputStream);
            dataOutputStream.close();
            return;
        }
        catch (IOException iOException) {
            System.out.println("Cant open file: " + string + ", exiting");
            System.exit(0);
            return;
        }
    }

    private void writeSignature(DataOutputStream dataOutputStream) {
        byte[] byArray = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        ByteArray byteArray = new ByteArray(byArray);
        byteArray.output(dataOutputStream);
    }

    private void writeData(Image image, DataOutputStream dataOutputStream) {
        int n = image.getWidth(this);
        int n2 = image.getHeight(this);
        System.out.println(" image is " + n + " x " + n2);
        int[] nArray = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
        ByteArray byteArray = new ByteArray();
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Error interpreting pixel data, exiting");
            System.exit(0);
        }
        int n3 = 0;
        while (n3 < n2) {
            byteArray.append((byte)0);
            int n4 = 0;
            while (n4 < n) {
                byteArray.append((byte)(nArray[n3 * n + n4] >> 16 & 0xFF));
                byteArray.append((byte)(nArray[n3 * n + n4] >> 8 & 0xFF));
                byteArray.append((byte)(nArray[n3 * n + n4] & 0xFF));
                ++n4;
            }
            ++n3;
        }
        byteArray.compress();
        this.writeDataChunks(dataOutputStream, byteArray);
    }

    private void writeDataChunks(DataOutputStream dataOutputStream, ByteArray byteArray) {
        while (byteArray.length() > 0) {
            ByteArray byteArray2 = new ByteArray("IDAT");
            byteArray2.append(byteArray.getBytes(2000000000));
            this.writeChunk(dataOutputStream, byteArray2);
        }
    }

    private void writeTrailer(DataOutputStream dataOutputStream) {
        ByteArray byteArray = new ByteArray("IEND");
        this.writeChunk(dataOutputStream, byteArray);
    }

    private void writeHeader(Image image, DataOutputStream dataOutputStream) {
        ByteArray byteArray = new ByteArray("IHDR");
        byteArray.append(image.getWidth(this));
        byteArray.append(image.getHeight(this));
        byteArray.append((byte)8);
        byteArray.append((byte)2);
        byteArray.append((byte)0);
        byteArray.append((byte)0);
        byteArray.append((byte)0);
        this.writeChunk(dataOutputStream, byteArray);
    }

    private void writeChunk(DataOutputStream dataOutputStream, ByteArray byteArray) {
        byteArray.append(byteArray.getCRC());
        byteArray.prepend(byteArray.length() - 8);
        byteArray.output(dataOutputStream);
    }
}

