/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.Deflater;

public class ByteArray {
    byte[] array;
    public static final boolean COMPRESS = true;

    public ByteArray() {
    }

    public ByteArray(byte[] byArray) {
        this.array = byArray;
    }

    public ByteArray(String string) {
        this.array = string.getBytes();
    }

    public void prepend(String string) {
        byte[] byArray = string.getBytes();
        this.prepend(byArray);
    }

    public int length() {
        if (this.array == null) {
            return 0;
        }
        return this.array.length;
    }

    public void output(DataOutputStream dataOutputStream) {
        try {
            dataOutputStream.write(this.array, 0, this.array.length);
            return;
        }
        catch (IOException iOException) {
            System.out.println("Error writing output file, exiting");
            System.exit(0);
            return;
        }
    }

    public int getCRC() {
        CRC32 cRC32 = new CRC32();
        cRC32.update(this.array, 0, this.array.length);
        return (int)cRC32.getValue();
    }

    public void append(byte[] byArray) {
        if (this.array != null) {
            int n = this.array.length + byArray.length;
            byte[] byArray2 = new byte[n];
            int n2 = 0;
            n2 = 0;
            while (n2 < this.array.length) {
                byArray2[n2] = this.array[n2];
                ++n2;
            }
            n2 = 0;
            while (n2 < byArray.length) {
                byArray2[n2 + this.array.length] = byArray[n2];
                ++n2;
            }
            this.array = byArray2;
            return;
        }
        this.array = byArray;
    }

    public void prepend(byte[] byArray) {
        if (this.array != null) {
            int n = this.array.length + byArray.length;
            byte[] byArray2 = new byte[n];
            int n2 = 0;
            n2 = 0;
            while (n2 < byArray.length) {
                byArray2[n2] = byArray[n2];
                ++n2;
            }
            n2 = 0;
            while (n2 < this.array.length) {
                byArray2[n2 + byArray.length] = this.array[n2];
                ++n2;
            }
            this.array = byArray2;
            return;
        }
        this.array = byArray;
    }

    public void append(byte by) {
        if (this.array != null) {
            int n = this.array.length + 1;
            byte[] byArray = new byte[n];
            int n2 = 0;
            n2 = 0;
            while (n2 < this.array.length) {
                byArray[n2] = this.array[n2];
                ++n2;
            }
            byArray[this.array.length] = by;
            this.array = byArray;
            return;
        }
        this.array = new byte[1];
        this.array[0] = by;
    }

    public void prepend(byte by) {
        if (this.array != null) {
            int n = this.array.length + 1;
            byte[] byArray = new byte[n];
            byArray[0] = by;
            int n2 = 0;
            n2 = 0;
            while (n2 < this.array.length) {
                byArray[n2 + 1] = this.array[n2];
                ++n2;
            }
            this.array = byArray;
            return;
        }
        this.array = new byte[1];
        this.array[0] = by;
    }

    public void append(int n) {
        byte[] byArray = new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        this.append(byArray);
    }

    public void prepend(int n) {
        byte[] byArray = new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        this.prepend(byArray);
    }

    public void compress() {
        byte[] byArray = new byte[(int)((double)this.array.length * 1.001 + 13.0)];
        Deflater deflater = new Deflater();
        deflater.reset();
        deflater.setInput(this.array, 0, this.array.length);
        deflater.finish();
        int n = deflater.deflate(byArray, 0, byArray.length);
        this.array = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            this.array[n2] = byArray[n2];
            ++n2;
        }
    }

    public byte[] getBytes(int n) {
        if (this.array == null) {
            return null;
        }
        if (this.array.length <= 0) {
            return null;
        }
        if (this.array.length <= n) {
            ByteArray byteArray = new ByteArray(this.array);
            this.array = null;
            return byteArray.toByte();
        }
        ByteArray byteArray = new ByteArray();
        ByteArray byteArray2 = new ByteArray();
        int n2 = this.array.length;
        int n3 = 0;
        n3 = 0;
        while (n3 < n) {
            byteArray.append(this.array[n3]);
            ++n3;
        }
        n3 = n;
        while (n3 < n2) {
            byteArray2.append(this.array[n3]);
            ++n3;
        }
        this.array = byteArray2.toByte();
        return byteArray.toByte();
    }

    private byte[] toByte() {
        byte[] byArray = new byte[this.array.length];
        int n = 0;
        while (n < this.array.length) {
            byArray[n] = this.array[n];
            ++n;
        }
        return byArray;
    }
}

