/*         Tagged-file Support Main Macro; Version 2.2  */
/*                                                      */
/* This is the main processing macro for the tagged-    */
/* file syntax support, part of EBOOKIE PACKAGE from    */
/* PCTOOLS.                                             */
/*                                                      */
/* It intercepts the following keys:                    */
/*   tab ....... tab word (variable)                    */
/*   backtab ... backtab word (variable)                */
/*   space ..... check for tag                          */
/*   c_space ... check for tag                          */
/*   c_enter ... check for tag                          */
/*   enter ..... check for tag                          */
/*   up ........ check for tag                          */
/*   down ...... check for tag                          */
/*   pgup ...... check for tag                          */
/*   pgdn ...... check for tag                          */
/*   tag_start . start of tag (configurable)            */
/*   tag_end ... check for tag (configurable)           */
/*   a_1 ....... edit imbed file                        */
/*   a_2 ....... enter remembered tag                   */
/*   a_h ....... get keyword help                       */
/*   c_h ....... view tag reference                     */      /* temple */
/*   a_i ....... index                                  */
/*   and all other keys of the keyboard.                */
/*                                                      */
/* The following commands are supported:                */
/*   bookie .... Force start/stop of tag support        */
/*   bookief ... Define tag-definition files            */
/*   bkmattr ... Insert attibutes (optional)            */
/*   bkmsym .... Replace all chars with symbols (opt.)  */
/*   bkmdebug .. Debugging support (optional)           */
/*                                                      */
/* For the change history refer to EBOOKIE SCRIPT.      */
/*                                                      */

/* Check if we are in the main E.E compilation, or      */
/* if the support is compiled separately.               */
compile if not defined(BLACK)
  const bkm_is_external=1
  include 'stdconst.e'
  include 'colors.e'
  tryinclude 'mycnf.e'
compile if not defined(EBOOKIE_ENH)
  const EBOOKIE_ENH = 0
compile endif
compile if EBOOKIE_ENH = 1
;  include 'EPMGCNF.SMP'
compile if not defined(NLS_LANGUAGE)
  NLS_LANGUAGE = 'ENGLISH'
compile endif
include NLS_LANGUAGE'.e'
compile endif
compile if EPM & EVERSION < '5.16'
  tryinclude 'econfig.e'
compile endif
;  include 'stdcnf.e'
compile else
  const bkm_is_external=0
compile if not defined(EBOOKIE_ENH)
  const EBOOKIE_ENH = 0
compile endif
compile endif

/* First we check the version of the editor. The        */
/* minimum version required are the .12 versions. If    */
/* the user has a wrong version, compiling terminates   */
/* with an error message.                               */
compile if E3
  compile if EVERSION < '3.12'
    *** EBOOKIE: Error, incorrect version of E3, must be at least 3.12.
  compile endif
compile endif

compile if EOS2
  compile if EVERSION < '4.12'
    *** EBOOKIE: Error, incorrect version of EOS2, must be at least 4.12.
  compile endif
compile endif

compile if EPM
  compile if EVERSION < '5.12'
    *** EBOOKIE: Error, incorrect version of EPM, must be at least 5.12.
  compile endif
compile endif

/* First we have to define some constants.              */
CONST
  bkm_version='2.10'

/* LAM:  Define these as STDCNF.E would:                */
compile if not defined(ENHANCED_ENTER_KEYS)
   ENHANCED_ENTER_KEYS = 0
compile endif
compile if not defined(ENTER_ACTION)
   ENTER_ACTION   = 'ADDLINE'
compile endif
compile if not defined(EPATH)
 compile if EPM    -- EPM uses a different name, for easier coexistance
   EPATH= 'epmpath'
 compile else
   EPATH= 'epath'
 compile endif
compile endif

   ANY_CLASS = 0
   COLOR_CLASS = 1

/* Check whether the user wants to replace the colons   */
/* of invalid tags with "&gml." or "&colon" If it is    */
/* zero, the colons are not replaced.                   */
compile if defined(my_bkm_repl_colon)
  bkm_repl_colon=my_bkm_repl_colon
compile else
  bkm_repl_colon=1
compile endif

/* The default tag-definition file.                     */
compile if defined(my_bkm_def_file)
  bkm_def_file=my_bkm_def_file
compile else
  bkm_def_file='BKMTAGS.DEF'
compile endif

/* Change margins?                                      */
compile if defined(my_bkm_margins)
  bkm_margins=my_bkm_margins
compile else
  bkm_margins='1 70 1'
compile endif

/* Define if EBOOKIE is allowed to change the margins when      */
/* switching to a non-ebookie file. Note: this only has an      */
/* effect in E3. '0' means that EBOOKIE is allowed to change    */
/* the margins, '1' means that EBOOKIE will not change the      */
/* margins.                                                     */
compile if defined(my_bkm_dont_touch_margins)
  compile if E3
    bkm_dont_touch_margins=my_bkm_dont_touch_margins
  compile else
    bkm_dont_touch_margins=0
  compile endif
compile else
  bkm_dont_touch_margins=0
compile endif

/* Dynamic margins?                                     */
compile if defined(my_bkm_tags_between)
  bkm_tags_between=my_bkm_tags_between
compile else
  bkm_tags_between=''
compile endif
compile if bkm_tags_between <> ''
compile if bkm_dont_touch_margins
    *** EBOOKIE: Error, conflicting options 'my_bkm_tags_between' and 'my_bkm_dont_touch_margins'.
compile endif
compile endif

/* Debugging?                                           */
compile if defined(my_bkm_debugging)
  bkm_debugging=my_bkm_debugging
compile else
compile if bkm_is_external
  bkm_debugging=1            -- include debugging if externally linked
compile else
  bkm_debugging=0            -- save space, don't include debugging
compile endif
compile endif

/* Define the page-up routine                           */
compile if defined(my_bkm_page_up)
  bkm_page_up=my_bkm_page_up
compile else
  bkm_page_up=0
compile endif

/* Define the page-down routine                         */
compile if defined(my_bkm_page_down)
  bkm_page_down=my_bkm_page_down
compile else
  bkm_page_down=0
compile endif

/* Define the line-up routine                           */
compile if defined(my_bkm_line_up)
  bkm_line_up=my_bkm_line_up
compile else
  bkm_line_up=0
compile endif

/* Define the line-down routine                         */
compile if defined(my_bkm_line_down)
  bkm_line_down=my_bkm_line_down
compile else
  bkm_line_down=0
compile endif

/* Define the enter-key routine                         */
compile if defined(my_bkm_enter)
  bkm_enter=my_bkm_enter
compile else
  bkm_enter=0
compile endif

/* Define if we want to replace special keys with the   */
/* appropriate BookMaster symbols.                      */
compile if defined(my_bkm_want_symbols)
  bkm_want_symbols=my_bkm_want_symbols
compile else
  bkm_want_symbols=1
compile endif

compile if bkm_want_symbols
  compile if defined(my_bkm_codepage)
    bkm_cdpg=my_bkm_codepage
  compile else
    bkm_cdpg='437'
  compile endif
compile endif

/* Define the number of lines searched when no footprint*/
/* is found, or the extension does not indicate a tagged*/
/* file.                                                */
compile if defined(my_bkm_search)
  bkm_search=my_bkm_search
compile else
  bkm_search=0
compile endif

/* Define the file extensions for which you want the support to */
/* be started automatically. If you set this constant to blank  */
/* the file extension is not used to determine the file type.   */
compile if defined(my_bkm_files)
  bkm_files=my_bkm_files
compile else
  bkm_files='SCR BKM SCT FOI IPF SCRIPT STYLE'
compile endif

/* Define which definition is to be used with a specific extenstion */
compile if defined(my_bkm_ext_def)
  bkm_ext_def=my_bkm_ext_def
compile else
  bkm_ext_def=''
compile endif

/* Define the parameter expansion. "ALL" means that the space   */
/* key always expands all parameters, "USUAL" (which is the     */
/* default) expands only the usual parameters (c-enter or       */
/* c-space then expands all parameters).                        */
compile if defined(my_bkm_space_key)
  bkm_space_key=my_bkm_space_key
compile else
  bkm_space_key='USUAL'
compile endif

/* Define the attribute support. This is only available in EPM  */
compile if EVERSION > '5.15'
compile if defined(my_bkm_attr)
  bkm_attr=my_bkm_attr
compile if defined(my_bkm_attr_colors)
  bkm_attr_colors=my_bkm_attr_colors
compile else
  bkm_attr_colors=223  -- White + Light_MagentaB
compile endif
compile if defined(my_bkm_attr_init)
  bkm_attr_init=my_bkm_attr_init
compile else
  bkm_attr_init=0
compile endif
compile else  -- else not defined(my_bkm_attr)
  bkm_attr=0
compile endif
compile else  -- else EVERSION <= 5.15
  bkm_attr=0
compile endif

/* Define the index support. */
compile if defined(my_bkm_idx_supp)
  bkm_idx_supp=my_bkm_idx_supp
compile else
  bkm_idx_supp=1
compile endif

compile if bkm_idx_supp
  compile if defined(my_bkm_keep_index_cases)
    bkm_keep_index_cases=my_bkm_keep_index_cases
  compile else
    bkm_keep_index_cases=0
  compile endif
compile endif

/* Define the help support. */
compile if defined(my_bkm_help_support)
  bkm_help_support=my_bkm_help_support
compile else
  bkm_help_support=1
compile endif

/* Define the help support. */               /* temple */
compile if defined(my_bkm_help_reference)
  compile if EPM
    bkm_help_reference=my_bkm_help_reference
  compile else
    bkm_help_reference=0                    /* NO in DOS mode */
  compile endif
compile else
  compile if EPM
    bkm_help_reference=1                    /* Only in EPM */
  compile else
    bkm_help_reference=0                    /* otherwise no */
  compile endif
compile endif

compile if not defined(KEEP_HELP_AT_RIGHT)
   KEEP_HELP_AT_RIGHT = 1   -- Ensure that the Help menu is rightmost
compile endif

compile if not defined(TILDE_CHAR)
 compile if EVERSION < '5.21'
   TILDE_CHAR = ''
 compile else
   TILDE_CHAR = '~'
 compile endif
compile endif

/* The DEFINIT routine is called when the editor is     */
/* started. First we define some global variables.      */
definit
  universal bkm_def
  universal bkm_idx
  universal bkm_avail
compile if bkm_tags_between<>''
  universal bkm_between
  universal bkm_between_new
compile endif
compile if bkm_debugging
  universal bkm_debug
compile endif
  universal bkm_nocheck
  universal bkm_save_file
  universal bkm_last_colon
  universal bkm_last_colon_line
  universal bkm_num
  universal bkm_cur_num
  universal bkm_rep_tag
  universal bkm_config
compile if bkm_want_symbols
  universal bkm_symbols
  universal bkm_symbols_active
  universal bkm_sym_file
  universal bkm_codepage
compile endif
  universal bkm_tag_start
  universal bkm_tag_end
  universal bkm_end_tag
  universal bkm_inv_tag_rep
  universal bkm_temp_path
  universal bkm_keepspace
compile if EPM
  universal bkm_did_menu
  universal defaultmenu
  universal activemenu
 compile if EVERSION >= 5.20
   universal activeaccel
 compile endif

  link_rc = rc
compile endif

; LAM:  Would be both shorter and faster to convert this to:
;  parse value '' with bkm_temp_path bkm_def bkm_config bkm_idx ...

  bkm_temp_path=''
  bkm_def=''                    -- internal name of the definition file
  bkm_config = ''
  bkm_idx=''                    -- name of the index
  bkm_avail=-1                  -- flag (-1=not init., 0=unavailable, 1=available)
compile if bkm_tags_between<>''
  bkm_between=''                -- starting tag of margin change construct
  bkm_between_new=''            -- change required?
compile endif
compile if bkm_debugging
  bkm_debug=0                   -- flag (0=no debug, 1=debug on)
compile endif
; 'echo on'                     -- remove semicolon to get additional trace
  bkm_nocheck=0                 -- flag (1=don't check files in bkm_init)
  bkm_save_file=''              -- current tag definition files
  bkm_last_colon=0              -- position of last colon
  bkm_last_colon_line=0         -- line number of last colon
  bkm_num=1                     -- number of the first/next index and tag-def. file
  bkm_cur_num=0                 -- number of the current index
  bkm_rep_tag=''                -- tag which should be inserted if a_2 is pressed
  bkm_tag_start=''              -- first character of a tag
  bkm_tag_end=''                -- last character of a tag
  bkm_end_tag=''                -- character sequence of end-tags
  bkm_inv_tag_rep=''            -- character sequence replacing the tag-start of invalid tags
  bkm_keepspace = 0             -- initialize
compile if bkm_want_symbols
  bkm_symbols=''                -- symbol table
  bkm_symbols_active = 0        -- symbol support activated for this file
  bkm_sym_file=''               -- symbol file name
  bkm_codepage=''               -- current codepage
/* Now we try to get the number of the current codepage.*/
compile if E3
  if dos_version()>320 then
    parse value int86x(DOS_INT, 26113, '') with erc acp . scp . . cflag ','
    if not cflag then
      bkm_codepage=strip(acp)
    endif
  else
    bkm_codepage=bkm_cdpg
  endif
compile else
compile if EVERSION >= 6
  codepage = '????'; datalen = '????'
  call dynalink32('DOSCALLS',            -- dynamic link library name
                '#291',                -- ordinal value for DOS32QueryCP
                atol(4)            ||  -- length of code page list
                offset(codepage)   ||  -- string offset
                selector(codepage) ||  -- string selector
                offset(datalen)    ||  -- string offset
                selector(datalen),2)   -- string selector
  bkm_codepage = strip(ltoa(codepage,10))
compile else
  codepage = '??'; datalen = '??'
  call dynalink('DOSCALLS',            -- dynamic link library name
                '#130',                -- ordinal value for DOSGetCP
                atoi(2)            ||  -- length of code page list
                selector(codepage) ||  -- string selector
                offset(codepage)   ||  -- string offset
                selector(datalen)  ||  -- string selector
                offset(datalen) )      -- string offset
  bkm_codepage = strip(itoa(codepage,10))
compile endif
compile endif
compile endif
  call bkm_make_bkm()           -- create the ".BKM" hidden file
compile if EPM
  bkm_did_menu = 0
  compile if bkm_is_external = 1
    call bkm_build_menu()
  compile endif
  rc = link_rc  -- LAM:  Avoid link error message problem.
compile if EVERSION > '5.49' & EBOOKIE_ENH = 1
  include 'd:\epm551\load.e'
defselect
  call bkm_defselect()
compile endif -- EVERSION > '5.49' & EBOOKIE_ENH = 1
compile endif -- EPM

/* Define a new command. "bookie" turns the tag         */
/* formatting on or off.                                */
defc bookie=
  universal bkm_avail
  universal bkm_last_colon
  universal bkm_cur_num
  universal bkm_save_file
compile if bkm_tags_between<>''
  universal bkm_between
  universal bkm_between_new
compile endif
compile if bkm_want_symbols
  universal bkm_sym_file
compile endif
  if bkm_avail=0 then
    call bkm_say("No tag-definition file active.",0)
  else
    parm=strip(lowcase(arg(1)))
    if parm='' then parm='on' endif
    if substr(parm,1,2)='of' then
compile if bkm_tags_between<>''
      bkm_between=''
      bkm_between_new=''
compile endif
      bkm_last_colon=0
compile if bkm_want_symbols
      bkm_sym_file=''
compile endif
      call bkm_upd_files(0,' ')
      call bkm_select()
      keys edit_keys
    elseif parm='on' then
      if bkm_avail=-1 then call bkm_chg_def_file(bkm_def_file,0) endif
      if bkm_avail=1 then
        bkm_last_colon=0
compile if E3
        call bkm_chg_def_file(bkm_save_file,0)
        call bkm_upd_files(bkm_cur_num,' ')
        call bkm_upd_line_one()
        call bkm_select()
compile else
        call bkm_upd_line_one()
        call bkm_init()
        keys bkm_keys
compile endif
      endif
    else
     call bkm_say("Invalid parameter" arg(1) "supplied, must be 'ON' or 'OFf'.",0)
    endif
  endif

/* Define the "bookief" command to switch to different  */
/* tag-definition file(s)                               */
defc bookief=
  universal bkm_cur_num
  universal bkm_rep_tag
  if arg(1)='' then
    call bkm_say("Required parameter 'filename' omitted.",0)
  else
    call bkm_chg_def_file(arg(1),0)
    call bkm_upd_line_one()
    call bkm_upd_files(bkm_cur_num,' ')
    call bkm_select()
  endif

compile if bkm_attr
defc bkmattr=
  call bkm_add_attr(arg(1))
compile endif

compile if bkm_want_symbols
defc bkmsym=
  universal bkm_symbols
  universal bkm_symbols_active
  universal bkm_sym_file
  universal bkm_codepage
  universal bkm_tag_start
  universal bkm_tag_end
  universal bkm_inv_tag_rep
  fline=0
  if lowcase(arg(1))='on' then
    parse value bkm_sym_file with bkm_sym_file '.' .
    call bkm_get_sym()
  else
    if lowcase(arg(1))='off' then
      bkm_symbols_active = 0
      call bkm_upd_files(-1,' ')
    else
      if bkm_symbols='' then
        call bkm_say("Symbol support not active.",0)
      else
        getfileid symid,bkm_sym_file    -- get id of symbol file
        if symid='' then
          call bkm_say("Symbol support not active.",0)
        else
          if marktype()=='' then
            if lowcase(arg(1))='all' then
              fline=1
              lline=.last
              type='LINE'
            else
              call bkm_say("No marked line(s), and 'all' parameter not specified.",0)
            endif
          else
            getmark fline, lline, fcol, lcol
            type=marktype()
          endif
          if fline then
            lines_changed=0
            dont_doit=0
            tag_started=0
            for i=fline to lline
              line_changed=0
              sayerror "BKMSYM: Processing line" i"."
              getline line,i
              if type='LINE' then
                fcol=1
                lcol=length(strip(line,'T'))
              endif
              j=fcol-1
              loop
                j=j+1
                if j>lcol then leave endif
                k=substr(line,j,1)
                if bkm_tag_start==k then           -- start of a tag?
                  parse value substr(line,j) with tag .
                  parse value tag with tag (bkm_tag_end) .
                  if length(tag)>1 then
                    tag_line=bkm_find_tag(tag)      -- try again
                    if tag_line=0 then
                      line=substr(line,1,j-1) || bkm_inv_tag_rep || substr(line,j+1)
                      lcol=lcol+length(bkm_inv_tag_rep)-1
                      j=j+length(bkm_inv_tag_rep)-1
                      line_changed=1
                    else
                      tag_started=1
                      if lowcase(tag)=':cgraphic' then
                        dont_doit=1
                      endif
                      if lowcase(tag)=':ecgraphic' then
                        dont_doit=0
                      endif
                    endif
                  endif
                elseif bkm_tag_end==k then         -- end of a tag?
                  tag_started=0
                else                               -- else check for replacement
                  if not dont_doit then
                    if not tag_started then
                      if pos(k,bkm_symbols) then   -- if found continue
                        getline xline,asc(k),symid  -- get the line from the symbol file
                        parse value xline with . k .       -- get the replacement string
;;                      k=strip(k)                 -- remove leading & trailing blanks (LAM: Parse did that.)
                        line=substr(line,1,j-1) || k || substr(line,j+1)
                        lcol=lcol+length(k)-1
                        j=j+length(k)-1
                        line_changed=1
                      endif
                    endif
                  endif
                endif
              endloop
              if line_changed then
                replaceline line,i
                lines_changed=lines_changed+1
              endif
            endfor
            call bkm_say("Processing ended, "lines_changed" lines changed.",0)
          endif
        endif
      endif
    endif
  endif
compile endif

compile if bkm_debugging
/* Define the "bkmdebug" command to ease the debugging  */
defc bkmdebug=
  universal bkm_def
  universal bkm_idx
  universal bkm_avail
compile if bkm_tags_between<>''
  universal bkm_between
compile endif
  universal bkm_debug
  universal bkm_save_file
  universal bkm_num
  universal bkm_cur_num
  universal bkm_rep_tag
  universal bkm_tag_start
  universal bkm_tag_end
  universal bkm_end_tag
  universal bkm_inv_tag_rep
  universal bkm_temp_path
  universal vTEMP_PATH
  universal vAUTOSAVE_PATH
compile if bkm_want_symbols
  universal bkm_symbols
  universal bkm_symbols_active
  universal bkm_sym_file
  universal bkm_codepage
compile endif
compile if bkm_attr
  universal bkm_did_bkmattr
compile endif
  xdebug=strip(lowcase(arg(1)))
  if xdebug='on' then
    bkm_debug=1
  elseif substr(xdebug,1,2)='of' then
    bkm_debug=0
    'echo off'
  elseif substr(xdebug,1,1)='t' then
    'echo on'
    bkm_debug=1
  elseif substr(xdebug,1,1)='e' then
    'echo off'
  elseif substr(xdebug,1,1)='d' then
    insertline ".**EBOOKIE**DEBUGGING**INFO**START**",.line+1
    insertline ".* version:" bkm_version", DOS (OS/2) version="dos_version(),.line+2
    insertline ".* def:" bkm_def,.line+3
    insertline ".* idx:" bkm_idx,.line+4
    insertline ".* avail:" bkm_avail,.line+5
    insertline ".* save_file:" bkm_save_file,.line+6
    insertline ".* num:" bkm_num,.line+7
    insertline ".* cur_num:" bkm_cur_num,.line+8
    insertline ".* rep_tag:" strip(bkm_rep_tag),.line+9
    insertline ".* tag_start:" bkm_tag_start,.line+10
    insertline ".* tag_end:" bkm_tag_end,.line+11
    insertline ".* end_tag:" bkm_end_tag,.line+12
    insertline ".* inv_tag_rep:" bkm_inv_tag_rep,.line+13
    insertline ".* Files known to EBOOKIE:",.line+14
    j=15
    getfileid id,'.BKM'
    if id<>'' then
      last=id.last
      for i=1 to last
        getline line,i,id
        if line='' then iterate endif
        if not pos('==',line) then iterate endif
        insertline ".*     "||line,.line+j
        j=j+1
      endfor
    else
      insertline ".*     file .BKM not in ring.",.line+j
      j=j+1
    endif
compile if bkm_want_symbols
    insertline ".* symbols:" bkm_symbols,.line+j
    insertline ".* symbols_active:" bkm_symbols_active,.line+j+1
    insertline ".* codepage=" bkm_codepage,.line+j+2
    insertline ".* sym_file=" bkm_sym_file,.line+j+3
    j=j+4
compile endif
compile if bkm_tags_between<>''
    insertline ".* between:" bkm_between,.line+j
    j=j+1
compile endif
    insertline ".* bkm_temp_path=" bkm_temp_path,.line+j
    j=j+1
compile if bkm_attr
    insertline ".* bkm_did_bkmattr=" bkm_did_bkmattr,.line+j
    j=j+1
compile endif
    insertline ".**EBOOKIE**DEBUGGING**INFO**END**",.line+j
  else
    call bkm_say("Invalid parameter" arg(1) "supplied, must be 'ON|OFf|Display|Trace|Etrace'.",0)
  endif
compile else
defc bkmdebug=
  call bkm_say("Debugging not configured.",0)
compile endif

defc bkmimbed=
  call bkm_imbed()

defc bkmrem=
  call bkm_rem()

compile if bkm_help_support
defc bkmhelp=
  call bkm_help(arg(1))
compile endif

compile if bkm_idx_supp
defc bkmidx=
  call bkm_idx_make()
compile endif

/* Define the keyset. It redefines the following keys:  */
/*   tab ....... tab word                               */
/*   backtab ... backtab word                           */
/*   space ..... check for bkm tag                      */
/*   enter ..... check for bkm tag                      */
/*   period .... check for bkm tag                      */
/*   colon ..... start of bkm tag                       */
/*   up ........ same as period                         */
/*   down ...... same as period                         */
/*   pgup ...... same as period                         */
/*   pgdown .... same as period                         */
/*   a_1 ....... edit imbed file                        */
/*   a_2 ....... insert default tag                     */
/*   a_h ....... help for tag or attribute              */
/*   c_h ....... view reference for tag                 */    /* temple */
/*   a_i ....... index                                  */
compile if E3
defkeys bkm_keys overlay
compile else
defkeys bkm_keys overlay clear
compile endif

/* Define the tabulators to tab one word at the time,   */
/* or use regular tabs.                                 */
def tab=
compile if bkm_tags_between<>''
  universal bkm_between
  if bkm_between='' then                -- if in regular text
compile endif
    getline line                        -- get the current line
    line=strip(line,'T')                -- clean trailing spaces
    line=Substr(line,.col+1)            -- get stuff right of the cursor
    if line<>' ' then                   -- not empty?
      tab_word                          -- jump to next word
    else
      tab                               -- go to next tabstop
    endif
compile if bkm_tags_between<>''
  else                                  -- within example?
    tab                                 -- use regular tabs
  endif
compile endif

def s_tab=
compile if bkm_tags_between<>''
  universal bkm_between
  if bkm_between='' then                -- if in regular text
compile endif
    getline line                        -- get the current line
    line=strip(line,'T')                -- clean trailing spaces
    line=Substr(line,.col+1)            -- get stuff right of the cursor
    if line<>' ' then                   -- not empty?
      backtab_word                      -- jump back one word
    else
      backtab                           -- use regular tabstop
    endif
compile if bkm_tags_between<>''
  else                                  -- within example?
    backtab                             -- use regular tabs
  endif
compile endif

def pgup=
  universal expand_on
  universal bkm_last_colon
  universal bkm_tag_end
  if bkm_last_colon & expand_on then            -- anything to do?
    if not bkm_expansion(bkm_tag_end) then      -- check for tag
compile if bkm_tags_between<>''
      call bkm_pgup()                           -- no tag, page up
compile else
compile if bkm_page_up=1
      call my_page_up()                         -- call user exit
compile else
      page_up                                   -- do regular page up
compile endif
compile endif
    endif
  else                                          -- nothing to do
compile if bkm_tags_between<>''
    call bkm_pgup()                             -- page up
compile else
compile if bkm_page_up=1
    call my_page_up()                           -- call user exit
compile else
    page_up                                     -- regular page up
compile endif
compile endif
  endif
  bkm_last_colon=0                              -- reset last colon position

def pgdn=
  universal expand_on
  universal bkm_last_colon
  universal bkm_tag_end
  if bkm_last_colon & expand_on then            -- anything to do?
    if not bkm_expansion(bkm_tag_end) then      -- check for tag
compile if bkm_tags_between<>''
      call bkm_pgdn()                           -- no tag, page down
compile else
compile if bkm_page_down=1
      call my_page_down()                       -- call user exit
compile else
      page_down                                 -- do regular page down
compile endif
compile endif
    endif
  else                                          -- nothing to do
compile if bkm_tags_between<>''
    call bkm_pgdn()                             -- page down
compile else
compile if bkm_page_down=1
    call my_page_down()                         -- call user exit
compile else
    page_down                                   -- regular page down
compile endif
compile endif
  endif
  bkm_last_colon=0                              -- reset last colon position

def up=
  universal expand_on
  universal bkm_last_colon
  universal bkm_tag_end
compile if bkm_tags_between<>''
  universal bkm_between_new
  universal bkm_between
compile endif
  if bkm_last_colon & expand_on then            -- anything to do?
    if not bkm_expansion(bkm_tag_end) then      -- check for tag
compile if bkm_tags_between<>''
      call bkm_up()                             -- no tag, line up
compile endif
compile if bkm_line_up=1
      call my_up()                              -- call user exit
compile else
      up                                        -- do regular line up
compile endif
    endif
  else                                          -- nothing to do
compile if bkm_tags_between<>''
    call bkm_up()                               -- line up
compile endif
compile if bkm_line_up=1
    call my_up()                                -- call user exit
compile else
    up                                          -- regular line up
compile endif
  endif
compile if bkm_tags_between<>''
  if bkm_between<>bkm_between_new then call bkm_upd_files(-1,bkm_between_new) endif
compile endif
  bkm_last_colon=0                              -- reset last colon position

def down=
  universal expand_on
  universal bkm_last_colon
  universal bkm_tag_end
compile if bkm_tags_between<>''
  universal bkm_between_new
  universal bkm_between
compile endif
  if bkm_last_colon & expand_on then            -- anything to do?
    if not bkm_expansion(bkm_tag_end) then      -- check for tag
compile if bkm_tags_between<>''
      call bkm_down()                           -- no tag, line down
compile endif
compile if bkm_line_down=1
      call my_down()                            -- call user exit
compile else
      down                                      -- do regular line down
compile endif
    endif
  else                                          -- nothing to do
compile if bkm_tags_between<>''
    call bkm_down()                             -- line down
compile endif
compile if bkm_line_down=1
    call my_down()                              -- call user exit
compile else
    down                                        -- regular line down
compile endif
  endif
compile if bkm_tags_between<>''
  if bkm_between<>bkm_between_new then call bkm_upd_files(-1,bkm_between_new) endif
compile endif
  bkm_last_colon=0                              -- reset last colon position

/* Define the space bar. Is it the end of a tag?        */
compile if EVERSION >= 5
def space=
compile else
def ' '=
compile endif
  universal expand_on
  universal bkm_last_colon
compile if bkm_attr
  universal bkm_did_bkmattr
compile endif
  if bkm_last_colon & expand_on then    -- something to do?
    if not bkm_expansion(' ') then      -- check for tag
compile if bkm_attr & EVERSION = '5.19'
    if not insert_state() then delete_char endif
compile endif
      keyin ' '                         -- if none, type space
    endif
  else
compile if bkm_attr & EVERSION = '5.19'
    if not insert_state() then delete_char endif
compile endif
compile if bkm_attr & EVERSION >= '5.50'
    if insert_state() & bkm_did_bkmattr then
       offst = -1
       query_attribute class, val, IsPush, offst, .col, .line
       if class then
          oldlevel = .levelofattributesupport
          .levelofattributesupport = 3
          call to_offset_zero()
       endif
    else
       class = 0
    endif
compile endif
    keyin ' '                           -- type space
compile if bkm_attr & EVERSION >= '5.50'
    if insert_state() & bkm_did_bkmattr & class then
      .levelofattributesupport = oldlevel
    endif
compile endif
  endif
  bkm_last_colon=0                      -- reset last colon position

/* Define the c_space (or c_enter) key to display all   */
/* optional parameters.                                 */
compile if EPM
def c_space=
compile else
def c_enter=
compile endif
  universal expand_on
  universal bkm_last_colon
  if bkm_last_colon & expand_on then    -- something to do?
    if not bkm_expansion('a') then      -- check for tag
compile if EPM
compile if bkm_attr & EVERSION = '5.19'
    if not insert_state() then delete_char endif
compile endif
      keyin ' '                         -- type regular space
compile else
      call my_c_enter()                 -- call default routine
compile endif
    endif
  else
compile if EPM
compile if bkm_attr & EVERSION = '5.19'
    if not insert_state() then delete_char endif
compile endif
    keyin ' '                           -- type space
compile else
    call my_c_enter()                   -- call default routine
compile endif
  endif
  bkm_last_colon=0                      -- reset last colon position

/* Check the enter key. It might be a regular "enter"   */
/* but it might also be the end of a tag.               */
def enter=
  universal expand_on
  universal bkm_last_colon
compile if ENHANCED_ENTER_KEYS & ENTER_ACTION <> ''
  universal enterkey
compile endif
  if bkm_last_colon & expand_on then            -- something to do?
    if not bkm_expansion(bkm_tag_end) then      -- check for tag
compile if bkm_enter
      call my_enter_key()               -- call user exit
compile elseif ENHANCED_ENTER_KEYS & ENTER_ACTION <> ''
      call enter_common(enterkey)
compile else
      call my_enter()                   -- call default routine
compile endif
compile if E3
    else
      call maybe_autosave()             -- check for autosave
compile endif
    endif
  else
compile if bkm_enter
    call my_enter_key()                 -- call user exit
compile elseif ENHANCED_ENTER_KEYS & ENTER_ACTION <> ''
      call enter_common(enterkey)
compile else
    call my_enter()                     -- call default routine
compile endif
  endif
  bkm_last_colon=0                      -- reset last colon position

def a_1=
  call bkm_imbed()

def a_2=
  call bkm_rem()

compile if bkm_help_support
def a_h=
  call bkm_help('a')

def c_h=
  call bkm_help('c')
compile endif

compile if bkm_idx_supp
  def a_i=
  call bkm_idx_make()
compile endif

compile if E3
def '!' - '' =
compile else
def otherkeys
compile endif
compile if bkm_want_symbols
  universal bkm_symbols
  universal bkm_symbols_active
  universal bkm_sym_file
compile endif
  universal bkm_last_colon
  universal bkm_last_colon_line
  universal expand_on
  universal bkm_tag_start
  universal bkm_tag_end
  universal bkm_end_tag
  universal bkm_keepspace
compile if bkm_attr
  universal bkm_did_bkmattr
compile endif
  k=lastkey()                           -- get the last typed character
compile if EVERSION > 4
  if length(k)=1 then                   -- regular key?
compile endif
compile if EVERSION < 5
    if not command_state() then         -- check for command line
compile endif
      if bkm_tag_start==k then           -- start of a tag?
        bkm_last_colon=.col             -- yes, save position
        bkm_last_colon_line=.line       -- and save the line number
      elseif bkm_tag_end==k then         -- end of a tag?
        if bkm_last_colon & expand_on then    -- do we have to do something?
          bkm_keepspace = 0
          if bkm_expansion(bkm_tag_end) then k='' endif -- expand it
        endif
        bkm_last_colon=0                -- reset last tag-start postition
      elseif k==',' then                -- end of a tag?
        if bkm_last_colon & expand_on then    -- do we have to do something?
          bkm_keepspace = 1
          if bkm_expansion(bkm_tag_end) then k='' endif -- expand it
        endif
        bkm_last_colon=0                -- reset last tag-start postition
compile if bkm_want_symbols
      else                              -- else check for replacement
        if bkm_symbols_active = 1 then  -- symbol support active?
          if pos(k,bkm_symbols) then    -- if found key in table continue
            getfileid id,bkm_sym_file   -- get id of symbol file
            if id<>'' then              -- if available
              getline line,asc(k),id    -- get the line from the symbol file
              parse value line with . k .       -- get the replacement string
            endif
          endif
        endif
compile endif
      endif
compile if EVERSION < 5
    endif
compile endif
compile if bkm_attr & EVERSION >= '5.16' & EVERSION <= '5.19'
    if not insert_state() then delete_char endif
compile endif
compile if bkm_attr & EVERSION >= '5.50'
    if insert_state() & bkm_did_bkmattr then
       offst = -1
       query_attribute class, val, IsPush, offst, .col, .line
       if class then
          oldlevel = .levelofattributesupport
          .levelofattributesupport = 3
          call to_offset_zero()
       endif
    else
       class = 0
    endif
compile endif
    keyin k
compile if bkm_attr & EVERSION >= '5.50'
    if insert_state() & bkm_did_bkmattr & class then
      .levelofattributesupport = oldlevel
    endif
compile endif
compile if EVERSION > 4
  endif
compile endif

compile if E3
tryinclude 'mykeys.bkm'
compile endif

compile if bkm_enter or bkm_page_up or bkm_page_down or bkm_line_up or bkm_line_down
  tryinclude 'mybkmkey.e'               -- include user exit routines
compile endif

/* The next routines are included only if the dynamic   */
/* margins feature is selected.                         */

compile if bkm_tags_between<>''
/* Process the page up key                              */
defproc bkm_pgup()
  universal bkm_between_new
  universal bkm_between
  fline=.line                           -- get the current line
compile if bkm_page_up=1
  call my_page_up()                     -- call user exit
compile else
  page_up                               -- do regular page up
compile endif
  lline=.line                           -- save new line number
  for i=fline to lline by -1            -- loop over all lines skipped
    i                                   -- set current line
    call bkm_up()                       -- do a line-up
  endfor
  if bkm_between<>bkm_between_new then call bkm_upd_files(-1,bkm_between_new) endif

/* Process the page down key                            */
defproc bkm_pgdn()
  universal bkm_between_new
  universal bkm_between
  fline=.line                           -- get the current line
compile if bkm_page_down=1
  call my_page_down()                   -- call user exit
compile else
  page_down                             -- do regular page down
compile endif
  lline=.line                           -- save new line number
  for i=fline to lline                  -- loop over all lines skipped
    i                                   -- set current line
    call bkm_down()                     -- do a line-down
  endfor
  if bkm_between<>bkm_between_new then call bkm_upd_files(-1,bkm_between_new) endif

/* Process the up key.                                  */
defproc bkm_up()
  universal bkm_between
  universal bkm_tag_start
  universal bkm_tag_end
  universal bkm_end_tag
compile if bkm_debugging
  universal bkm_debug
compile endif
  universal bkm_between_new
  getline line                          -- get the current line
  parse value line with tag .           -- get the first word of the line
  if substr(tag,1,1)=bkm_tag_start then -- is the first character a tag-start?
    parse value tag with tag (bkm_tag_end) .    -- remove the tag-end
    tag=lowcase(strip(tag))             -- cleanup
    if bkm_between<>'' then             -- are we between something=
      if tag=bkm_end_tag||substr(bkm_between,2) | tag=bkm_between then  -- is the current tag an end-tag?
        'ma' bkm_margins                -- yes, set margins to default
compile if bkm_debugging
        if bkm_debug then call bkm_say("Margins changed to" bkm_margins".",0) endif
compile endif
        bkm_between_new=''              -- clean flag
      endif
    else
      tag=bkm_tag_start||substr(tag,3)  -- not between something
compile if EVERSION >= '5.20'
      if wordpos(tag,bkm_tags_between) then             -- in the list of tags to watch?
compile else
      if pos(tag||' ',bkm_tags_between||' ') then       -- in the list of tags to watch?
compile endif
        'ma 1 254 1'                    -- yes, reset margins
compile if bkm_debugging
        if bkm_debug then call bkm_say("Margins changed to 1 254 1.",0) endif
compile endif
        bkm_between_new=tag             -- save current tag
      endif
    endif
  endif

/* Process the down key                                 */
defproc bkm_down()
  universal bkm_between
  universal bkm_between_new
  universal bkm_tag_start
  universal bkm_tag_end
  universal bkm_end_tag
compile if bkm_debugging
  universal bkm_debug
compile endif
  getline line                          -- get the current line
  parse value line with tag .           -- get the first word
  if substr(tag,1,1)=bkm_tag_start then -- check for tag-start character
    parse value tag with tag (bkm_tag_end) .    -- remove tag-end
    tag=lowcase(strip(tag))             -- cleanup
    if bkm_between<>'' then             -- are we between something?
      if tag=bkm_end_tag||substr(bkm_between,2) then    -- did we find a tag-end?
        'ma' bkm_margins                -- set margins to default
compile if bkm_debugging
        if bkm_debug then call bkm_say("Margins changed to" bkm_margins".",0) endif
compile endif
        bkm_between_new=''              -- set flag
      endif
    else                                -- not between something
compile if EVERSION >= '5.20'
      if wordpos(tag,bkm_tags_between) then             -- is it in the list?
compile else
      if pos(tag||' ',bkm_tags_between||' ') then       -- is it in the list?
compile endif
        'ma 1 254 1'                    -- set margins
compile if bkm_debugging
        if bkm_debug then call bkm_say("Margins changed to 1 254 1.",0) endif
compile endif
        bkm_between_new=tag             -- save tag in flag
      endif
    endif
  endif

compile endif

/* The following is the main routine of the macro.        */
/* We have found a tag. Or better, there was a colon,     */
/* followed by some undetermined number of other          */
/* characters, and then a space, a period, or an "enter". */
defproc bkm_expansion(char)
  universal bkm_last_colon
  universal bkm_last_colon_line
  universal linerest
  universal bkm_line_text
compile if bkm_tags_between<>''
  universal bkm_between
  universal bkm_between_new
compile endif
compile if bkm_debugging
  universal bkm_debug
compile endif
  universal bkm_avail
  universal bkm_nocheck
  universal bkm_save_file
  universal bkm_rep_tag
  universal bkm_tag_start
  universal bkm_tag_end
  universal bkm_end_tag
  universal bkm_inv_tag_rep
compile if bkm_want_symbols
  universal bkm_symbols
  universal bkm_symbols_active
  universal bkm_sym_file
compile endif
/* First we have to check if the file should be         */
/* processed by the macro. If not, we return as fast as */
/* we can.                                              */
  if bkm_avail<>1 then return 0 endif           -- If support is inactive, return
  if bkm_find_file(.filename)<1 then return 0 endif     -- shall we do something?
compile if bkm_debugging
  if bkm_debug then call bkm_say("bkm_expansion("char"), bkm="bkm_find_file(.filename)", colon="bkm_last_colon", line="bkm_last_colon_line".",0) endif
compile endif
/* It seems that there is work to do. First we get the  */
/* text of the current line to retrieve the tag.        */
  retc=1                                        -- set OK return code
compile if EPM
  if .line then                                 -- is there a line?
compile else
  if .line and (not command_state()) then       -- line? command state?
compile endif
    getline line                -- Get the entire line in the variable "line".
    line=strip(line,'T')        -- Clean up trailing garbage.
    tag=''                      -- clean current tag
    linerest=''                 -- clean stuff after tag
    caution=0                   -- reset flag
/* First we have to check for the automatic word wrap,  */
/* which could have moved the tag to the next line. In  */
/* this case the first word MUST contain a colon at the */
/* beginning of somewhere in the middle.                */
    if .line=bkm_last_colon_line+1 then         -- are we in the next line?
      parse value line with fword .             -- yes, get first word
      bkm_last_colon=pos(bkm_tag_start,fword)   -- find position of tag in word
      if not bkm_last_colon then return 0 endif   -- return if no tag-start found
    endif
/* When the current column is greater than the column   */
/* of the colon, it might be a tag.                     */
    if .col>bkm_last_colon then                 -- cursor right of tag-start?
      tag=substr(line,bkm_last_colon,.col-bkm_last_colon)       -- get the tag
      if substr(tag,1,1)<>bkm_tag_start then return 0 endif     -- no tag-start?
      linerest=substr(line,.col)                -- get stuff to the right
/* If the tag already contains a colon there must be    */
/* something wrong. We get the tag, but we have to be   */
/* careful.                                             */
      if pos(bkm_tag_end,tag) then            -- tag contains tag-end?
        tag=substr(tag,1,pos(bkm_tag_end,tag)-1)        -- get tag
        linerest=substr(line,bkm_last_colon+length(strip(tag))+1) -- get rest
        caution=2                               -- set caution flag
      endif
    else
/* The cursor is before, or right on the colon. This    */
/* case has to be treated differently. Probably it is   */
/* not a tag anyhow, but then we might have to replace  */
/* the colon with "&gml." or "&colon.".                 */
      tag=substr(line,bkm_last_colon)           -- get rest of line
      if substr(tag,1,1)<>bkm_tag_start then return 0 endif     -- exit if no tag
      parse value tag with tag .                -- get first word of tag
      caution=1                                 -- set caution flag
      if pos(bkm_tag_end,tag) then            -- do we have a tag-end too?
        tag=substr(tag,1,pos(bkm_tag_end,tag)-1)        -- remove it
        linerest=substr(line,bkm_last_colon+length(strip(tag))+1) -- get new rest
        caution=2                               -- be careful
      else
        linerest=substr(line,bkm_last_colon+length(strip(tag))) -- get rest
      endif
    endif
    if bkm_last_colon>1 then                    -- tag-start not in first col?
      line=substr(line,1,bkm_last_colon-1)      -- get left stuff
    else
      line=''                                   -- no left stuff
    endif
/* Now we have got the tag. Put it into lower case and  */
/* remove the leading and trailing blanks.              */
    save_tag=strip(tag)                         -- save original cases
    tag=lowcase(save_tag)                       -- fold to lowercase
compile if bkm_debugging
    if bkm_debug then call bkm_say("bkm_expansion... tag="tag" caution="caution" line="line" linerest="linerest,0) endif
compile endif
/* If the length of the tag is 1, the user has just     */
/* typed a colon followed by a space. We leave this     */
/* as entered.                                          */
    if length(tag)>1 then                       --
/* Let's check if there is a valid tag. "tag_line" will */
/* contain "0" if it is not a valid tag, otherwise it   */
/* contains the number of the line with the tag. The    */
/* global variable "bkm_line_text" contains the text of */
/* the line, which contains the formatting intructions. */
      tag_line=bkm_find_tag(tag)        -- search tag in index
/* If the return code was -1 we have found an           */
/* inconsistency in the index. Now we have to create    */
/* the index again.                                     */
      if tag_line=-1 then               -- invalid index found?
        file=bkm_save_file              -- save all definition file names
        bkm_save_file=''                -- cleanup
        call bkm_chg_def_file(file,1)   -- force index generation
        call bkm_upd_line_one()         -- update line one
        call bkm_select()               -- activate support
        tag_line=bkm_find_tag(tag)      -- try again
/* If the return code again indicates an inconsistency, */
/* there is nothing left to do except to stop the       */
/* support. This should never happen.                   */
        if tag_line=-1 then             -- serious trouble
          call bkm_say("Unrecoverable error with definition file and index, support halted.",0)
          bkm_avail=0                   -- deactivate support
          bkm_nocheck=1                 -- deactivate initialization
          return 0                      -- exit
        endif
      endif
      if tag_line=0 then                -- did we find the tag?
/* No, either replace it with variable, or just return. */
compile if bkm_repl_colon=1
/* The caution flag is 2 when we found an invalid tag   */
/* including the tag-end character. The tag-start       */
/* character will be replaced.                          */
        if caution=2 then               -- replace it.
          replaceline line||bkm_inv_tag_rep||substr(save_tag,2)||bkm_tag_end||linerest
        else            -- otherwise just replace the tag-start character
          replaceline line||bkm_inv_tag_rep||substr(save_tag,2)||linerest
        endif
        if .col>=bkm_last_colon then .col=.col+length(bkm_inv_tag_rep)-1 endif -- set cursor
compile endif
        retc=0          -- set bad return code (this is necessary, because the
;                       -- last key typed by the user has not been inserted in
;                       -- the text yet.
      else
        if caution then
          if linerest<>'' then return 0 endif
          if caution=2 then return 0 endif
        endif
/* The tag has been found. The variable bkm_line_text   */
/* contains the formatting instructions. The format     */
/* of this line is:                                     */
/*                                                      */
/* :tag   the tag name (without the ending period)      */
/*                                                      */
/* flag   the flag. Refer to the routine "bkm_process"  */
/*        for a description of the flag.                */
/*                                                      */
/* text   the required parameters of the tag. The '#'   */
/*        sign can be used to position the cursor.      */
/*                                                      */
/* +      delimiter                                     */
/*                                                      */
/* text   the usual optional parameters                 */
/*                                                      */
/* +      delimiter                                     */
/*                                                      */
/* text   all optional parameters                       */
/*                                                      */
/* ||     delimiter                                     */
/*                                                      */
/* text   additional lines which should be inserted     */
/*        after the tag. A "\" is interpreted as "CR"   */
/*        the "#" can be used to position the cursor.   */
/*                                                      */
/* ||     delimiter                                     */
/*                                                      */
/* text   lines which should go BEFORE the tag.         */
/*                                                      */
/* ||     delimiter                                     */
/*                                                      */
/* tag    tag which will be assigned to the a_2 key     */
/*                                                      */
        parse value bkm_line_text with xtag flag sameline '||' otherlines '||' beforelines '||' rep_tag
        if rep_tag<>'' then             -- anything after the third delimiter?
          bkm_rep_tag=rep_tag           -- assign it to the a_2 key
compile if bkm_tags_between<>''
          call bkm_upd_files(-1,bkm_between)    -- save it in hidden file
compile else
          call bkm_upd_files(-1,' ')            -- save it in hidden file
compile endif
        endif
        parse value sameline with req '+' opt '+' all   -- get the parameters
compile if bkm_space_key='ALL'
        if char=' ' then char='a' endif
compile endif
        sameline=strip(req)             -- remove blanks
        opt=strip(opt)                  -- from optional too
        all=strip(all)                  -- and finally from optional optional.
        if char='a' then                -- shall we display everything?
          char=' '                      -- set to space
          opt=opt||' '||all             -- optional is all
        endif
        if char=' ' then                -- want parameters displayed
/* Now we have to remove the tag-end character (if any) */
          if pos(bkm_tag_end,sameline) then sameline=substr(sameline,1,pos(bkm_tag_end,sameline)-1) endif
          sameline=strip(sameline||' '||opt)    -- store all parms
        endif
/* Set the defaults.                                    */
        if flag='' then flag=1 endif    -- default flag is 1
        if sameline='' then             -- nothing there?
          sameline=bkm_tag_end||'#'     -- position cursor after end
        else
/* If the first character of the parameter is not an tag-end    */
/* the we must have a space inserted. (Otherwise the parameters */
/* would be glued to the tag, and we don't want that, do we?)   */
          if substr(sameline,1,1)<>bkm_tag_end then sameline=' '||sameline endif
/* Now we have to add a tag-end character at the end.           */
          if not pos(bkm_tag_end,sameline) then sameline=sameline||bkm_tag_end endif
/* If there is no cursor position defined, we put the cursor    */
/* after the end of the tag.                                    */
          if not pos('#',sameline) then sameline=sameline||'#' endif
        endif
/* Process the tag.                                     */
        retc=bkm_process(line,tag,flag,sameline,strip(otherlines),strip(beforelines))
/* Get the line which contains the cursor. If there is  */
/* something after the cursor we have to switch         */
/* inserting on.                                        */
        getline line                    -- get current line
        if substr(line,.col)<>'' then   -- something after the cursor?
          if not insert_state() then insert_toggle       -- insert on if yes
compile if EVERSION >= '5.50'
             call fixup_cursor()
compile endif
           endif
        endif
/* If the dynamic margins are configured, check it too. */
compile if bkm_tags_between<>''
        parse value line with xtag .                    -- get tag
        parse value xtag with xtag (bkm_tag_end) .      -- remove tag-end
        if xtag<>tag then -- not the same? (that means that the cursor is not in the line which contains the tag)
          if pos(tag||' ',bkm_tags_between||' ') then   -- tag in list?  [LAM: change to wordpos() for 5.20+?]
            'ma 1 254 1'                        -- reset margins
compile if bkm_debugging
            if bkm_debug then call bkm_say("Margins changed to 1 254 1.",0) endif
compile endif
            call bkm_upd_files(-1,tag)          -- store in hidden file
            bkm_between_new=tag                 -- set flag
          endif
        endif
compile endif
      endif
compile if bkm_want_symbols
    else                              -- else check for replacement
      retc=0                            -- set bad return code
      if bkm_symbols_active = 1 then    -- symbol support active?
        if pos(bkm_tag_start,bkm_symbols) then  -- if key found in table continue
          getfileid id,bkm_sym_file   -- get id of symbol file
          if id<>'' then              -- if available
            getline line,asc(bkm_tag_start),id  -- get the line from the symbol file
            parse value line with . k .       -- get the replacement string
            keyin k                     -- type the variable
            retc=1                      -- good return code
          endif
        endif
      endif
compile else
    else
      retc=0
compile endif
    endif
  else
    retc=0
  endif
return retc

/* Generic routine to insert the tag and optionally     */
/* the parameters into the same, or into multiple       */
/* lines. The input parameters are:                     */
/*  1 ... the part of the line to the left of the tag   */
/*  2 ... the tag (without the ending period)           */
/*  3 ... a switch. This switch can be:                 */
/*        1 ... force tag on new line, leave linerest   */
/*              on old line.                            */
/*        2 ... force tag on new line, move linerest    */
/*              after the tag.                          */
/*        3 ... leave tag where it is, if add. tag      */
/*              defines, put on end of line.            */
/*        4 ... additional tags contain file name which */
/*              should be inserted. Parameters are      */
/*              resolved as if flag=1.                  */
/*        5 ... same as 4, but tag is not inserted into */
/*              text.                                   */
/*  4 ... the parameters which should be inserted       */
/*  5 ... other tags which have to be inserted into     */
/*        new lines, or the same line (flag=3)          */
/*  6 ... other stuff which should be inserted before   */
/*        the line with the tag.                        */
defproc bkm_process(line,tag,force,parms,xother,beforelines)
  universal bkm_last_colon
  universal linerest
  universal bkm_save_file
  universal bkm_nocheck
  universal bkm_tag_end
  universal bkm_keepspace
compile if bkm_attr
  universal bkm_did_bkmattr
compile endif
compile if bkm_debugging
  universal bkm_debug
  if bkm_debug then call bkm_say("bkm_process("line","tag","force","parms","xother","beforelines")",0) endif
compile endif
  if force > 10 then
    force = force - 10
    bkm_keepspace = 1
  endif
  if line='' & linerest='' & not bkm_keepspace then bkm_last_colon=1 endif  -- move tag to position one
  savepos=pos('#',parms)                -- save new cursor postition
  cursor=savepos+length(tag)+bkm_last_colon-1   -- calculate new position
/* Remove the number (hash) sign from the parameters    */
  -- LAM:  If we know there's always a '#', could replace next two lines (if 5.20 or above):
  parse value parms with p1 '#' p2
  parms=p1||p2                  -- concatinate parameter
  -- with:  parms = delstr(parms, savepos, 1)
/* Save current line number, this is where the cursor   */
/* should go.                                           */
  new_line=.line
  if force=1 | force=4 then             -- tag must start in new line
    if bkm_last_colon=1 & linerest='' then      -- is alread there?
      replaceline tag||parms                    -- put tag and parms in line
    else
/* Remove the tag from the middle of the line, and      */
/* create a separate line for the tag.                  */
      replaceline line||linerest
compile if bkm_attr
      if bkm_did_bkmattr=1 then call bkm_upd_line_attr(.line) endif
compile endif
/* Now we have to redefine the cursor position          */
      cursor=cursor-bkm_last_colon+1
      if bkm_keepspace then
        if strip(line||linerest) = '' then
          replaceline substr(' ',1,length(line))||tag||parms
        else
          insertline substr(' ',1,length(line))||tag||parms,.line+1
/* The tag is on the next line, therefore we have to    */
/* position the cursor one line down.                   */
          new_line=new_line+1
          down
        endif
        cursor=cursor+length(line)
      else
        insertline tag||parms,.line+1
/* The tag is on the next line, therefore we have to    */
/* position the cursor one line down.                   */
        new_line=new_line+1
        down
      endif
    endif
    if force=4 then             -- get additional lines from file
/* xother contains file name                            */
      call bkm_get(strip(upcase(xother)))
      if rc<>0 then                             -- file not found, tell user
        call bkm_say("File" strip(upcase(xother)) "not found, repair" bkm_save_file".",0)
compile if EVERSION < 4
      else
        call bkm_init()                         -- initialize support
compile endif
      endif
      xother=''                                 -- cleanup
    endif
  elseif force=2 then
/* Remove the tag from the middle of the line, but      */
/* move the remainder of the line after the tag.        */
    if bkm_last_colon=1 then            -- tag-start in column 1?
      replaceline tag||parms||linerest  -- insert tag in position 1
    else
      replaceline line                  -- store stuff left of the tag
compile if bkm_attr
      if bkm_did_bkmattr=1 then call bkm_upd_line_attr(.line) endif
compile endif
      cursor=cursor-bkm_last_colon+1    -- position cursor
      if bkm_keepspace then
        if strip(line||linerest) = '' then
          replaceline substr(' ',1,length(line))||tag||parms||linerest   -- create a new line with the rest
        else
          insertline substr(' ',1,length(line))||tag||parms||linerest,.line+1   -- create a new line with the rest
          new_line=new_line+1               -- down one line
          down
        endif
        cursor=cursor+length(line)
      else
        insertline tag||parms||linerest,.line+1   -- create a new line with the rest
        new_line=new_line+1               -- down one line
        down
      endif
    endif
  elseif force=3 then                   -- tag may be anywhere in the line
    if bkm_last_colon=1 & linerest='' then      -- we are in position 1
      replaceline tag||parms            -- store tag and parameters
    else
/* This is a special case. The tag has been in the middle of a  */
/* line, we don't want to generate additional lines. So we      */
/* take the stuff which would otherwise go in new lines, and    */
/* put it in the line where the tag is.                         */
      parse value xother with p1 '#' p2 -- remove #
      xother=p1||p2                     -- concatenate
      parse value xother with p1 '\' p2 -- remove new line
      xother=p1||p2                     -- concatenate again
      replaceline line||tag||parms||linerest||xother -- replace line
      xother=''                         -- cleanup
    endif
  elseif force=5 then                   -- get data from file
/* xother contains file name                            */
    call bkm_get(strip(upcase(xother)))
    if rc then                             -- file not found, tell user
      call bkm_say("File" strip(upcase(xother)) "not found, repair" bkm_save_file".",0)
compile if EVERSION < 4
    else
      call bkm_init()                         -- initialize support
compile endif
    endif
    xother=''                                 -- cleanup
    if line||linerest='' then           -- tag was on empty line
      deleteline                        -- delete line
    else                                -- otherwise
      replaceline line||linerest        -- remove tag from line
      new_line=new_line+1               -- position cursor
      down
    endif
    getline xline,new_line              -- get new cursor position
    cursor=length(strip(xline))+1
  else
    call bkm_say('Flag' force 'for' tag 'invalid, repair' bkm_save_file".",0)
  endif
compile if bkm_attr
  if bkm_did_bkmattr=1 then call bkm_upd_line_attr(.line) endif
compile endif
/* Now generate additional lines, if any.               */
  if beforelines<>'' then               -- anything to add before the tag?
    loop                                -- loop over data
      parse value beforelines with iline '\' beforelines -- get CR
      if beforelines='' & iline='' then leave endif     -- any more data?
      if substr(iline,1,1)='%' then
        filename=upcase(strip(substr(iline,2)))
        savesize=.last                          -- save current size
        '-1'                                    -- back one line
        call bkm_get(filename)
        if rc then                             -- file not found, tell user
          call bkm_say("File" filename "not found, repair" bkm_save_file".",0)
          '+1'
        else
          new_line=new_line+.last-savesize        -- new line position
compile if EVERSION < 4
          call bkm_init()                         -- initialize support
compile endif
        endif
      else
        insertline iline,.line            -- yes, insert line, even if blank
compile if bkm_attr
        if bkm_did_bkmattr=1 then call bkm_upd_line_attr(.line) endif
compile endif
        new_line=new_line+1               -- remember new line position
      endif
      new_line                            -- set global
    endloop
  endif
  if xother<>'' then
    i=0
    loop                                  -- loop over stuff after the tag
      i=i+1
      parse value xother with iline '\' xother    -- get CR
      if xother='' & iline='' then leave endif    -- exit loop if nothing else
      if substr(iline,1,1)='%' then
        filename=upcase(strip(substr(iline,2)))
        savesize=.last                          -- save current size
        saveline=.line
        .line=.line+i-1                         -- calculate where it should go
        call bkm_get(filename)
        if rc then                             -- file not found, tell user
          call bkm_say("File" filename "not found, repair" bkm_save_file".",0)
          .line=.line+1-i
        else
          i=i+.last-savesize-1                    -- set new index
          saveline
compile if EVERSION < 4
          call bkm_init()                         -- initialize support
compile endif
        endif
      else
        insertline iline,.line+i            -- insert data
        x=pos('#',iline)                    -- cursor in this line?
        y=pos('@',iline)
        if x | y then                         -- yes, '#' found
          if x>1 then                       -- position at first column?
compile if EVERSION >= '5.20'
            iline = delstr(iline, x, 1)     -- no, delete that character
compile else
            parse value iline with p1 '#' p2  -- no, get before and after
            iline=p1||p2                    -- concatinate them
compile endif
          elseif y>1 then                   -- position at first column?
compile if EVERSION >= '5.20'
            iline = delstr(iline, y, 1)     -- no, delete that character
compile else
            parse value iline with p1 '@' p2  -- no, get before and after
            iline=p1||p2                    -- concatinate them
compile endif
          else
            iline=strip(substr(iline,2))    -- get rest of line
          endif
          replaceline iline,.line+i         -- replace the line
/* Now we have to check if the cursor is already positioned in  */
/* the line with the tag. If not, we can move it to this        */
/* position safely.                                             */
          if parms=bkm_tag_end | not savepos | y then  -- only default cursor?
            cursor=x+y                      -- yes, set cursor
            new_line=.line+i                -- set new line position
          endif
        endif
compile if bkm_attr
        if bkm_did_bkmattr=1 then call bkm_upd_line_attr(.line+i) endif
compile endif
      endif
    endloop
  endif
/* At the end we have to set the new cursor position.   */
  .col=cursor                           -- set cursor position
  new_line                              -- move cursor to correct line
return 1

/* The next routine checks the tag. If it is valid, the */
/* return code contains the line number of the tag in   */
/* the tag-definition file. If not, the return code is  */
/* zero. If an inconsistency is found, the return code  */
/* is set to -1.                                        */
defproc bkm_find_tag(tag)
  universal bkm_line_text
  universal bkm_def
  universal bkm_idx
compile if bkm_debugging
  universal bkm_debug
  if bkm_debug then call bkm_say('Searching for tag' tag".",0) endif
compile endif
/* Save the id of the current file.                     */
/* Get the id of the index file.                        */
  getfileid id,bkm_idx                  -- get id of index
  if id='' then return -1 endif         -- exit if index not found
/* A word to the index. The first line of the index     */
/* contains the names of the current tag-definition     */
/* files. This is checked somewhere else. At this point */
/* we can be sure that the index points to the right    */
/* tag-definition file.                                 */
  for i = 2 to 9999                     -- loop over index
    if i>id.last then leave endif       -- end of file?
    getline tagline,i,id                -- no, get line from index
    xpos=pos(tag||' ',tagline)          -- check for tag
    if xpos then                      -- tag found
      xtag=substr(tagline,xpos)         -- make tag first word
      parse value xtag with curtag curline .    -- get tag and line number
      getfileid id,bkm_def              -- get id of definition file
      if id='' then return -1 endif     -- exit if no definition file found
      getline bkm_line_text,curline,id  -- get the line with the number found in the index
      parse value bkm_line_text with istag flag . -- get tag and flag
      if istag<>tag then return -1 endif -- same tag? If not -> inconsistant
      if flag='-' then return 0 endif   -- tag "undefined" ?
      return curline                    -- return data to caller
    endif
  endfor
return 0                                -- no luck, no tag

/* Routine to display text on the status line. If debug */
/* is on, also wait for a key.                          */
defproc bkm_say(msg,flag)
compile if bkm_debugging
  universal bkm_debug
  if bkm_debug then flag=1 endif        -- wait for key in debug mode
compile endif
  if flag=1 then                        -- wait for key?
compile if EVERSION < 5
    msg=msg||' ...'                     -- yes, put ellipses after text
compile endif
    call messageNwait("EBOOKIE: "msg)   -- prefix message with "EBOOKIE"
compile if EVERSION < 5
    getfileid curfileid                 -- get current id
    sayerror 0                          -- clean message area
    activatefile curfileid              -- get back current file
compile endif
  else                                  -- don't wait for key
    call message("EBOOKIE: "msg)        -- call appropriate routine
  endif

/* The following routine is accessed at the time the    */
/* file is read from the disk. First we have to check   */
/* for the footprint ".* EBOOKIE". Then the extension   */
/* checked. Finally, if configured, we check a user-    */
/* defined number of lines for a valid tag. If the      */
/* tag we find is invalid, we don't start the support,  */
/* If it is OK; we start EBOOKIE.                       */
/*                                                      */
/* In E3 this routine is also accessed whenever the user*/
/* switches from one file to the other in the ring,     */
/* therefore we have to take care of that too.          */
/*                                                      */
defproc bkm_init()
  universal bkm_last_colon
  universal bkm_def
  universal bkm_idx
  universal bkm_avail
  universal bkm_message
compile if bkm_debugging
  universal bkm_debug
compile endif
  universal bkm_nocheck
  universal bkm_save_file
  universal bkm_cur_num
  universal bkm_rep_tag
  universal bkm_tag_start
  universal bkm_tag_end
  universal bkm_end_tag
  universal bkm_config
compile if bkm_tags_between<>''
  universal bkm_between_new
compile endif
compile if bkm_attr
  universal bkm_did_bkmattr
compile endif
  universal vTEMP_PATH
  universal vAUTOSAVE_PATH
  universal bkm_temp_path

compile if bkm_debugging
  if bkm_debug then call bkm_say("bkm_init()" .filename,0) endif
compile endif

  if bkm_temp_path='' then
    bkm_temp_path=strip(vAUTOSAVE_PATH)
compile if defined(AUTOSAVE_PATH)
    if bkm_temp_path='' then
      bkm_temp_path=strip(AUTOSAVE_PATH)
    endif
compile endif
    if bkm_temp_path='' then
      bkm_temp_path=strip(vTEMP_PATH)
    endif
compile if defined(TEMP_PATH)
    if bkm_temp_path='' then
      bkm_temp_path=strip(TEMP_PATH)
    endif
compile endif
    if bkm_temp_path<>'' then
compile if EVERSION >= '5.20'
      if rightstr(bkm_temp_path,1)<>'\' then
compile else
      if substr(bkm_temp_path,length(bkm_temp_path),1)<>'\' then
compile endif
        bkm_temp_path=bkm_temp_path||'\'
      endif
    endif
  endif
/* Skip files which we should not touch.                */
  if bkm_nocheck=1 then return 0 endif          -- internal files are not checked
  if substr(.filename,1,1)='.' then return 0 endif -- files which start with a period are not checked
  if .filename=bkm_def then return 0 endif      -- the definitions file is not checked
  if .filename=bkm_idx then return 0 endif      -- so is the index
/* Notify debugging user if we continue our work.       */
compile if bkm_debugging
  if bkm_debug then call bkm_say("bkm_init()" .filename "continues",0) endif
compile endif
compile if EVERSION < 4
  if bkm_find_file(.filename)>=0 then           -- look for file in hidden table
    call bkm_select()                           -- start the support
    return 0                                    -- return to caller
  endif
compile endif
  bkm=0                                 -- cleanup
  for i=1 to .last                      -- loop over beginning of file
    getline line,i                      -- get line
    parse value line with flag1 flag2 '(' def_file ')' . -- find footprint
    if flag1='.*' & flag2='EBOOKIE' then
      bkm=1                             -- footprint found
      leave                             -- exit loop
    endif
    if substr(flag1,1,2)<>'.*' then leave endif -- no comment, exit loop
  endfor
  if not bkm then
    def_file=bkm_def_file
    ext=filetype()
compile if EVERSION >= '5.20'
    if ext <> '' & wordpos(upcase(ext),upcase(bkm_files)) then
compile else
    x_files=bkm_files     -- LAM: assume this is because old versions of E uppercased the upcase() parm; doesn't happen with current versions.
    if pos(' '||strip(upcase(ext))||' ',' '||strip(upcase(x_files))||' ') then
compile endif
      bkm=1
      x_files=bkm_ext_def
      x=pos(strip(upcase(ext))||'=',upcase(x_files))
      if x then
        x_files=Substr(x_files,x)
        parse value x_files with . '=' def_file '=' .
        if pos('=',x_files) then
          x = lastpos(' ',def_file)
          def_file = substr(def_file,1,x)
        endif
        def_file=strip(def_file)
        If Substr(def_file,1,1) = '"' | substr(def_file,1,1) = "'" then
          def_file = Substr(def_file,2,Length(def_file)-2)
        endif
        if def_file = '' then def_file=bkm_def_file endif
      endif
compile if bkm_search > 0
    else
      search=max(bkm_search, 10)
/* Now search the first 100 lines of the file, or at    */
/* least the number of lines the user has specified.    */
      for i=1 to search
        if i=.last then leave endif
        getline line,i
        parse value line with tag .
        if substr(tag,1,1)<>bkm_tag_start then iterate endif
        parse value tag with tag (bkm_tag_end) .
        if length(tag)<2 then iterate endif
        if bkm_avail=-1 then
          call bkm_chg_def_file(def_file,0)
        endif
        if bkm_avail=0 then return 0 endif
        if bkm_find_tag(lowcase(tag))=0 then leave endif
        bkm=1
        leave
      endfor
compile endif
    endif
  endif
  bkm_rep_tag=''
  if bkm<>0 then
    call bkm_chg_def_file(def_file,0)
    if bkm_avail=0 then return 0 endif
    bkm=bkm_cur_num
    call bkm_upd_line_one()
compile if E3
    keys bkm_keys
compile endif
compile if bkm_dont_touch_margins=0
    'ma' bkm_margins
compile endif
    join_after_wrap=0
    bkm_last_colon=0
compile if EVERSION < 5
    c_state = command_state()
    if c_state then commandtoggle; endif
compile endif
    if bkm_config <> '' then
      'xcom L /.mod' bkm_config'/ca'
      bkm_config = ''
    else
      top
      down
    endif
compile if EVERSION < 5
    if c_state then commandtoggle; endif
compile endif
compile if bkm_attr
    bkm_did_bkmattr=1
    call attribute_on(1)  -- "Color attributes" flag
    call attribute_on(8)  -- "Save attributes" flag
compile if bkm_attr_init=1
    call bkm_add_attr('on')
compile endif
compile endif
  endif
  call bkm_upd_files(bkm,' ')
compile if bkm_tags_between<>''
  bkm_between_new=''
compile endif
compile if bkm_debugging
  if bkm_debug then call bkm_say("bkm_init()" .filename" ended, rc="bkm,0) endif
compile endif
return bkm

/* The following routine is called during the DEFSELECT */
/* processing in EOS2 or EPM, or during the             */
/* select_edit_keys() processing in E3.                 */
defproc bkm_select()
  universal bkm_last_colon
compile if bkm_tags_between<>''
  universal bkm_between
  universal bkm_between_new
compile endif
compile if bkm_debugging
  universal bkm_debug
  if bkm_debug then call bkm_say("bkm_select() called for ".filename,0) endif
compile endif
  bkm=bkm_find_file(.filename)
  if bkm>0 then
compile if E3
    keys bkm_keys
compile if bkm_dont_touch_margins=0
    'ma' bkm_margins
compile endif
    join_after_wrap=0
compile endif
    bkm_last_colon=0
    call bkm_switch(bkm)
compile if bkm_tags_between<>''
    bkm_between_new=bkm_between
    if bkm_between<>'' then
      'ma 1 254 1'
    endif
compile endif
compile if E3
  else
    ext=filetype()
    if ext='' then
      keys edit_keys
compile if bkm_dont_touch_margins=0
      'tabs' DEFAULT_TABS
      'ma' DEFAULT_MARGINS
compile endif
compile if E_SYNTAX_ASSIST and ALTERNATE_KEYSETS
    elseif ext='E' then
       keys e_keys
compile if bkm_dont_touch_margins=0
       'tabs' E_TABS
       'ma'   E_MARGINS
compile endif
compile endif
compile if C_SYNTAX_ASSIST and ALTERNATE_KEYSETS
    elseif ext='C' then
       keys c_keys
compile if bkm_dont_touch_margins=0
       'tabs' C_TABS
       'ma'   C_MARGINS
compile endif
compile endif
compile if P_SYNTAX_ASSIST and ALTERNATE_KEYSETS
    elseif ext='PAS' | ext='PASCAL' then
       keys pas_keys
compile if bkm_dont_touch_margins=0
       'tabs' P_TABS
       'ma'   P_MARGINS
compile endif
compile endif
compile if REXX_SYNTAX_ASSIST and ALTERNATE_KEYSETS
    elseif ext='BAT' | ext='CMD' | ext='EXC' | ext='EXEC' | ext='XEDIT' then
      getline line,1
      if substr(line,1,2)='/*' or (line='' & .last = 1) then
        keys rexx_keys
compile if bkm_dont_touch_margins=0
        'tabs' REXX_TABS
        'ma'   REXX_MARGINS
compile endif
      endif
compile endif
    else
      keys edit_keys
compile if bkm_dont_touch_margins=0
      'tabs' DEFAULT_TABS
      'ma' DEFAULT_MARGINS
compile endif
    endif
compile endif
  endif
return 0

/* Open or change the tag-definition files.             */
defproc bkm_chg_def_file(file,force)
  universal bkm_def
  universal bkm_idx
  universal bkm_avail
  universal bkm_nocheck
  universal bkm_save_file
  universal bkm_num
  universal bkm_cur_num
compile if bkm_want_symbols
  universal bkm_symbols
  universal bkm_symbols_active
  universal bkm_sym_file
  universal bkm_codepage
compile endif
  universal bkm_tag_start
  universal bkm_tag_end
  universal bkm_end_tag
  universal bkm_rep_tag
  universal bkm_inv_tag_rep
  universal bkm_temp_path
compile if bkm_debugging
  universal bkm_debug
  if bkm_debug then call bkm_say("bkm_chg_def_file("file","force")",0) endif
compile endif
  savefile=upcase(strip(file))
  save_def=bkm_def
  save_idx=bkm_idx
  save_avail=bkm_avail
  save_cur_num=bkm_cur_num
compile if bkm_want_symbols
  save_symbols=bkm_symbols
  save_symbols_active=bkm_symbols_active
  save_sym_file=bkm_sym_file
compile endif
  if not force then
    for i = 1 to 99
      xrc=bkm_switch(i)
      if xrc=1 then leave endif
      if savefile=bkm_save_file then
        getfileid id,'.BKM'
compile if EVERSION < '5.0'
        save_command_state=command_state()
        if save_command_state then commandtoggle endif
compile endif
        for j=1 to id.last
          getline line,j,id
          parse value line with fname '==' retc '||' .
          if retc=i then
            call bkm_find_file(fname)
            leave
          endif
        endfor
compile if EVERSION < '5.0'
        if save_command_state then commandtoggle endif
compile endif
        getfileid bkm_def_fileid,bkm_def
        getline tag_fline,1,bkm_def_fileid
        call bkm_get_parms(tag_fline,1)
compile if bkm_want_symbols
        if bkm_sym_file<>'' then
          bkm_sym_file=upcase(bkm_sym_file||'.'||bkm_codepage)
        endif
compile endif
        return 0
      endif
    endfor
  endif
  getfileid curfileid
  parse value upcase(file) with file .
  retc=0
  bkm_avail=1
  bkm_def=bkm_findfile(file)
  if bkm_def='' then bkm_avail=0 endif
  if bkm_avail=1 then
    bkm_path=''
    bkm_def=upcase(bkm_def)
    x=lastpos('\',bkm_def)
    if x then bkm_path=substr(bkm_def,1,x) endif
    bkm_nocheck=1
    if save_def<>'' & force=1 then
      getfileid id,save_def
      if id<>'' then
        activatefile id
        .modify=0
        'quit'
      endif
    endif
    if save_idx<>'' & force=1 then
      getfileid id,save_idx
      if id<>'' then
        activatefile id
        .modify=0
        'quit'
      endif
    endif
    activatefile curfileid
compile if bkm_debugging
    if bkm_debug then call bkm_say("Inititalizing tag support.",0) endif
compile endif
compile if EVERSION > 5
    'xcom edit' bkm_def
    .visible=0
compile else
    'xcom edit /h /q' bkm_def
compile endif
    bkm_save_file=substr(bkm_def,length(strip(bkm_path))+1)
    x=lastpos('.',bkm_save_file)
    if x then
      bkm_idx=substr(bkm_save_file,1,x)||'IDX'
    else
      bkm_idx=bkm_save_file||'.IDX'
    endif
    if force=1 then
      bkm_def='.D'||strip(save_cur_num)
      bkm_cur_num=save_cur_num
    else
      bkm_def='.D'||strip(bkm_num)
      bkm_cur_num=bkm_num
      bkm_num=bkm_num+1
    endif
    .filename=bkm_def
    getfileid bkm_def_fileid
    getline tag_fline,1,bkm_def_fileid
    call bkm_get_parms(tag_fline,1)
    msg=''
    parse value savefile with . savefile
    for i=1 to 9
      parse value savefile with file savefile
      if file=' ' then leave endif
      '0'
      call bkm_get(strip(upcase(file)))
      if rc then
        msg=msg||' '||strip(upcase(file))
      else
        activatefile bkm_def_fileid
        bkm_save_file=bkm_save_file||' '||strip(upcase(file))
        getline tag_fline,1,bkm_def_fileid
        call bkm_get_parms(tag_fline,0)
compile if bkm_want_symbols
        tag_fline='* EBOOKIE tag_start='||bkm_tag_start||' tag_end='||bkm_tag_end||' end_tag='||bkm_end_tag||' a_2='||bkm_rep_tag||' invalid='||bkm_inv_tag_rep||' symbols='||bkm_sym_file
compile else
        tag_fline='* EBOOKIE tag_start='||bkm_tag_start||' tag_end='||bkm_tag_end||' end_tag='||bkm_end_tag||' a_2='||bkm_rep_tag||' invalid='||bkm_inv_tag_rep
compile endif
        replaceline tag_fline,1,bkm_def_fileid
      endif
    endfor
    .modify=0
    if msg<>'' then
      activatefile curfileid
      call bkm_say("The file(s)"msg "could not be found.",1)
    endif
    line='.* EBOOKIE ('||Strip(bkm_save_file)||')'
    if bkm_temp_path='' then bkm_temp_path=bkm_path endif
    bkm_idx=bkm_temp_path||bkm_idx
compile if EVERSION > 5
    'xcom edit' bkm_idx
    .visible=0
compile else
    'xcom edit /h /q' bkm_idx
compile endif
    .filename=bkm_idx
    getfileid bkm_idx_fileid
    if not rc then
      maxlines=.last
      getline oline,1
      if oline<>line | force=1 then
        for i=1 to maxlines
          deleteline 1
          if rc then leave endif
        endfor
        rc=1
      endif
    endif
    if rc then
      activatefile curfileid
      call bkm_say("Inititalizing tag support, creating tag index, please wait...",0)
      activatefile bkm_def_fileid
      j=1
      bkm_tags=''
      for i=1 to 9999
        if i>.last then leave endif
        getline tline,i
        parse value tline with xtag rest
        if substr(xtag,1,1)<>bkm_tag_start then iterate endif
        bkm_tags=bkm_tags||' '||strip(xtag)||' '||i
        if length(bkm_tags)>240 then
          activatefile bkm_idx_fileid
          if j=1 then
            insertline line,j
            j=j+1
          endif
          insertline lowcase(strip(bkm_tags)),j
          j=j+1
          bkm_tags=''
          activatefile bkm_def_fileid
        endif
      endfor
      if length(bkm_tags) then
        activatefile bkm_idx_fileid
        if j=1 then
          insertline line,j
          j=j+1
        endif
        insertline lowcase(strip(bkm_tags)),j
      endif
      activatefile bkm_idx_fileid
      'xcom save' bkm_idx
    endif
    if force=1 then
      bkm_idx='.I'||strip(save_cur_num)
    else
      bkm_idx='.I'||strip(bkm_cur_num)
    endif
    .filename=bkm_idx
    .modify=0
    activatefile curfileid
compile if bkm_want_symbols
    call bkm_get_sym()
compile endif
    bkm_nocheck=0
  else
    bkm_def=save_def
    bkm_idx=save_idx
    bkm_avail=save_avail
    bkm_cur_num=save_cur_num
compile if bkm_want_symbols
    bkm_symbols=save_symbols
    bkm_symbols_active=save_symbols_active
    bkm_sym_file=save_sym_file
compile endif
    if bkm_avail=1 then
      call bkm_say("Could not find the file" file", support status unchanged.",0)
    else
      call bkm_say("Could not find the file" file", support not available.",0)
      bkm_avail=0
    endif
    retc=1
  endif
  activatefile curfileid
return retc

compile if bkm_want_symbols
defproc bkm_get_sym()
  universal bkm_symbols
  universal bkm_symbols_active
  universal bkm_sym_file
  universal bkm_codepage
compile if bkm_debugging
  universal bkm_debug
  if bkm_debug then call bkm_say("bkm_get_sym()",0) endif
compile endif
  getfileid curfileid
compile if bkm_debugging
  if bkm_debug then call bkm_say("Checking symbol support, file="upcase(bkm_sym_file||'.'||bkm_codepage),0) endif
compile endif
  if bkm_sym_file<>'' & bkm_codepage<>'' then
    bkm_sym_file=upcase(bkm_sym_file||'.'||bkm_codepage)
    getfileid id,bkm_sym_file
    if id='' | bkm_symbols = '' then
compile if bkm_debugging
      if bkm_debug then call bkm_say("Inititalizing symbol table.",0) endif
compile endif
      bkm_symbols=''
      bkm_symbols_active = 0
      xfile=bkm_findfile(bkm_sym_file)
      if xfile<>'' then
compile if EVERSION > 5
        'xcom edit' xfile
        .visible=0
compile else
        'xcom edit /h /q' xfile
compile endif
        if rc then
          call bkm_say("Error during load of" bkm_sym_file" rc=" rc", symbol support not active.",0)
          bkm_sym_file=''
          bkm_symbols=''
        else
          .filename=bkm_sym_file
          getline nosym,1
          deleteline 1
          .modify=0
compile if E3
          for i=33 to .last           -- skip x'00' to x'20' in E3
compile else
          for i=1 to .last
compile endif
            getline iline,i
            if asc(substr(iline,1,1))=i then
              parse value iline with char symbol '--' .
              if symbol<>'' then
                if not pos(strip(char),nosym) then
                  bkm_symbols=bkm_symbols||strip(char)
                endif
              endif
            endif
          endfor
          bkm_symbols=strip(bkm_symbols)
          bkm_symbols_active = 1
        endif
        activatefile curfileid
        call bkm_upd_files(-1,' ')
      else
        call bkm_say("Could not locate the file" bkm_sym_file", symbol support not active.",0)
        bkm_sym_file=''
        bkm_symbols=''
      endif
    else
      bkm_symbols_active = 1
      call bkm_upd_files(-1,' ')
    endif
  else
    bkm_sym_file=''
    bkm_symbols=''
  endif
compile endif

defproc bkm_upd_line_one()
  universal bkm_save_file
compile if bkm_debugging
  universal bkm_debug
  if bkm_debug then call bkm_say("bkm_upd_line_one()",0) endif
compile endif
  oldmod=.modify
  footprint='.* EBOOKIE ('||Strip(bkm_save_file)||')'
  if .last<1 then
    insertline footprint,1
  else
    for i=1 to .last
      getline oline,i
      parse value oline with flag1 flag2 .
      if flag1='.*' & flag2='EBOOKIE' then
        if oline<>footprint then
          replaceline footprint,i
        endif
        leave
      endif
      if substr(flag1,1,2)<>'.*' then
        insertline footprint,i
        if .last=2 & textline(2)='' then  -- A new file;
          .modify=oldmod                  -- allow quitting without prompt
        endif
        leave
      endif
    endfor
  endif
; .modify=oldmod

defproc bkm_switch(num)
  universal bkm_save_file
  universal bkm_def
  universal bkm_idx
  universal bkm_cur_num
compile if bkm_debugging
  universal bkm_debug
  if bkm_debug then call bkm_say("bkm_switch("num")",0) endif
compile endif
  newidx='.I'||strip(num)
  if bkm_idx=newidx then return 0 endif
  retc=0
  getfileid id,newidx
  if id<>'' then
    getline oline,1,id
    parse value oline with flag1 flag2 '(' save_file ')' .
    if flag1='.*' & flag2='EBOOKIE' then
      bkm_idx=newidx
      bkm_def='.D'||strip(num)
      bkm_save_file=save_file
      bkm_cur_num=num
    else
compile if bkm_debugging
      if bkm_debug then call bkm_say("bkm_switch("num") file "newidx" no header",0) endif
compile endif
      retc=1
    endif
  else
compile if bkm_debugging
    if bkm_debug then call bkm_say("bkm_switch("num") file "newidx" not found",0) endif
compile endif
    retc=1
  endif
return retc

defproc bkm_findfile(file)
compile if bkm_debugging
  universal bkm_debug
  if bkm_debug then call bkm_say("bkm_findfile("file")",0) endif
compile endif
  if not pos('\',file) & not pos(':',file) then
    findfile xfile, file, EPATH
compile if E3
    if rc then findfile xfile, file, 'PATH' endif
compile else
    if rc then findfile xfile, file, '', 'D' endif  -- LAM: searches E(PM)PATH & DPATH
compile endif
  else
    findfile xfile, file, ''
  endif
  if not rc then return xfile endif
; xfile=''
; return xfile
; LAM:  falling off the end automatically returns the null string.

defproc bkm_get(file)
compile if bkm_debugging
  universal bkm_debug
  if bkm_debug then call bkm_say("bkm_get("file")",0) endif
compile endif
  xfile=bkm_findfile(file)
  if xfile='' then return 1 endif
  file=xfile
  getfileid curfileid
  s_last=.last
  rc=0
  copy_rc=0
  bkm_nocheck=1
compile if EVERSION > 5
/* Note: This is a temporary fix for EPM. The "get"     */
/*       command doesn't work here. Don't ask me why... */  -- LAM:  why???
  'xcom edit' file
  .visible=0
  copy_rc=rc
  call psave_mark(save_mark)
compile if bkm_attr
  'bkmattr'
compile endif
  top
  mark_line
  bottom
  mark_line
  activatefile curfileid
  rc=0
  copy_mark
  copy_rc=copy_rc  -- LAM:  huh?
  getfileid fileid,file
  activatefile fileid
  'quit'
  activatefile curfileid
  parse value save_mark with s_firstline s_lastline s_firstcol s_lastcol s_mkfileid s_mt
  if fileid=s_mkfileid then
    diff=fileid.last-s_last
    if fileid.line<s_firstline then s_firstline=s_firstline+diff; endif
    if fileid.line<s_lastline then s_lastline=s_lastline+diff; endif
  endif
  call prestore_mark(s_firstline s_lastline s_firstcol s_lastcol s_mkfileid s_mt)
compile else
  'get' file
  copy_rc=rc
compile endif
  if copy_rc then
    call bkm_say("Error during 'get' of" file", cc="copy_rc".",1)
  endif
  activatefile curfileid
  bkm_nocheck=0
return copy_rc

defproc bkm_find_file(name)
  universal bkm_avail
  universal bkm_rep_tag
compile if bkm_tags_between<>''
  universal bkm_between
compile endif
  universal bkm_tag_start
  universal bkm_tag_end
  universal bkm_end_tag
  universal bkm_inv_tag_rep
compile if bkm_want_symbols
  universal bkm_symbols
  universal bkm_symbols_active
  universal bkm_sym_file
compile endif
compile if bkm_attr
  universal bkm_did_bkmattr
compile endif
compile if bkm_debugging
  universal bkm_debug
  if bkm_debug then call bkm_say("bkm_find_file("name")",0) endif
compile endif
  retc=-1
  getfileid id,'.BKM'
  if id='' then
    call bkm_make_bkm()
    getfileid id,'.BKM'
    if id='' then
      call bkm_say("Could not allocate the file '.BKM', support halted.",1)
      bkm_avail=0
      return retc
    endif
  endif
compile if EVERSION < '5.0'
  save_command_state=command_state()
  if save_command_state then commandtoggle endif
compile endif
  for i=1 to id.last
    getline line,i,id
    rep_tag=''
    between=''
compile if bkm_want_symbols
compile if bkm_attr
    parse value line with fname '==' retc '||' between '||' rep_tag '||' tag_start '||' tag_end '||' end_tag '||' inv_tag_rep '||' sym_file '||' bkm_symbols_active '||' bkm_did_bkmattr .
compile else
    parse value line with fname '==' retc '||' between '||' rep_tag '||' tag_start '||' tag_end '||' end_tag '||' inv_tag_rep '||' sym_file '||' bkm_symbols_active .
compile endif
compile else
compile if bkm_attr
    parse value line with fname '==' retc '||' between '||' rep_tag '||' tag_start '||' tag_end '||' end_tag '||' inv_tag_rep '||' bkm_did_bkmattr .
compile else
    parse value line with fname '==' retc '||' between '||' rep_tag '||' tag_start '||' tag_end '||' end_tag '||' inv_tag_rep .
compile endif
compile endif
    if fname=name then leave endif
  endfor
  if fname<>name then
    retc=-1
  else
    retc=strip(retc)
compile if bkm_tags_between<>''
    bkm_between=strip(between)
compile endif
    bkm_rep_tag=strip(rep_tag)
    bkm_tag_start=strip(tag_start)
    bkm_tag_end=strip(tag_end)
    bkm_end_tag=strip(end_tag)
    bkm_inv_tag_rep=strip(inv_tag_rep)
compile if bkm_want_symbols
    bkm_sym_file=strip(sym_file)
    getline bkm_symbols,i+1,id
compile endif
  endif
compile if EVERSION < '5.0'
  if save_command_state then commandtoggle endif
compile endif
return retc

defproc bkm_upd_files(bkm,tag)
  universal bkm_avail
  universal bkm_cur_num
  universal bkm_rep_tag
compile if bkm_tags_between<>''
  universal bkm_between
compile endif
  universal bkm_tag_start
  universal bkm_tag_end
  universal bkm_end_tag
  universal bkm_inv_tag_rep
compile if bkm_want_symbols
  universal bkm_symbols
  universal bkm_symbols_active
  universal bkm_sym_file
compile endif
compile if bkm_attr
  universal bkm_did_bkmattr
compile endif
compile if bkm_debugging
  universal bkm_debug
  if bkm_debug then call bkm_say("bkm_upd_files("bkm","tag")",0) endif
compile endif
  if bkm=-1 then bkm=bkm_cur_num endif
  getfileid id,'.BKM'
  if id='' then
    call bkm_make_bkm()
    getfileid id,'.BKM'
    if id='' then
      call bkm_say("Could not allocate the file '.BKM', support halted.",1)
      bkm_avail=0
      return 0
    endif
  endif
compile if EVERSION < '5.0'
  save_command_state=command_state()
  if save_command_state then commandtoggle endif
compile endif
  for i=1 to id.last
    getline line,i,id
    parse value line with fname '==' .
    if fname=.filename then leave endif
  endfor
  bkm_between=strip(tag)
compile if bkm_want_symbols
  line=.filename '==' strip(bkm) '||' bkm_between '||' strip(bkm_rep_tag) '||' bkm_tag_start '||' bkm_tag_end '||' bkm_end_tag '||' bkm_inv_tag_rep '||' bkm_sym_file '||' bkm_symbols_active
compile else
  line=.filename '==' strip(bkm) '||' bkm_between '||' strip(bkm_rep_tag) '||' bkm_tag_start '||' bkm_tag_end '||' bkm_end_tag '||' bkm_inv_tag_rep
compile endif
compile if bkm_attr
  line=line '||' bkm_did_bkmattr
compile endif
  if fname<>.filename then
    insertline line,1,id
compile if bkm_want_symbols
    insertline bkm_symbols,2,id
compile endif
  else
    replaceline line,i,id
compile if bkm_want_symbols
    replaceline bkm_symbols,i+1,id
compile endif
  endif
  id.modify=0
compile if EVERSION < '5.0'
  if save_command_state then commandtoggle endif
compile endif

defproc bkm_make_bkm()
compile if bkm_debugging
  universal bkm_debug
  if bkm_debug then call bkm_say("bkm_make_bkm() called. Current=".filename,0) endif
compile endif
/* Now we create the internal work file.                */
  getfileid curfileid           -- save the current file name
compile if EPM
  'xcom edit /n .BKM'           -- Create the file
  .visible=0
compile endif
compile if EOS2
  'xcom edit /h /q /c .BKM'     -- EOS2
compile endif
compile if E3
  'xcom edit /h /q /n .BKM'     -- E3
compile endif
  .filename='.BKM'              -- set the file name
  activatefile curfileid

defproc bkm_get_parms(line,flag)
  universal bkm_tag_start
  universal bkm_tag_end
  universal bkm_end_tag
  universal bkm_rep_tag
  universal bkm_inv_tag_rep
  universal bkm_tag_start
  universal bkm_save_file
compile if bkm_want_symbols
  universal bkm_sym_file
compile endif
compile if bkm_debugging
  universal bkm_debug
  if bkm_debug then call bkm_say("bkm_get_parms("line","flag") called.",0) endif
compile endif
  parse value line with delim1 delim2 .
  if strip(delim1)='*' & strip(delim2)='EBOOKIE' then
    if flag=1 then
      x=pos('tag_start=',line)
      if x then
;;      tag_start=substr(line,x+length('tag_start='),1)
;;      if strip(tag_start)<>'' then        -- LAM:  If it's not null,
;;        bkm_tag_start=strip(tag_start)    -- use result
;;      else                                -- but if result is null
;;        bkm_tag_start=''                  -- use null ???
;;      endif                               -- Then why bother checking if it's null?
        bkm_tag_start=strip(substr(line,x+length('tag_start='),1))  -- or x+10
      endif
      x=pos('tag_end=',line)
      if x then
;;      tag_end=substr(line,x+length('tag_end='),1)
;;      if strip(tag_end)<>'' then
;;        bkm_tag_end=strip(tag_end)
;;      else
;;        bkm_tag_end=''
;;      endif
        bkm_tag_end=strip(substr(line,x+length('tag_end='),1))  -- or x+8
      endif
      x=pos('end_tag=',line)
      if x then
compile if EVERSION >= '5.20'
        bkm_end_tag=word(substr(line,x+length('end_tag=')),1)  -- or x+8
compile else
        end_tag=substr(line,x+length('end_tag='))
        parse value end_tag with end_tag .
;;      if strip(end_tag)<>'' then
;;        bkm_end_tag=strip(end_tag)
;;      else
;;        bkm_end_tag=''
;;      endif
        bkm_end_tag=strip(end_tag)
compile endif
      endif
    endif
    x=pos('a_2=',line)
    if x then
      rep_tag=substr(line,x+length('a_2='))
      if substr(rep_tag,1,1)<>' ' then
        parse value rep_tag with bkm_rep_tag .
      else
        bkm_rep_tag=''
      endif
    endif
    x=pos('invalid=',line)
    if x then
      inv_tag_rep=substr(line,x+length('invalid='))
      if substr(inv_tag_rep,1,1)<>' ' then
        parse value inv_tag_rep with bkm_inv_tag_rep .
      else
        bkm_inv_tag_rep=''
      endif
    endif
compile if bkm_want_symbols
    x=pos('symbols=',line)
    if x then
      sym_file=substr(line,x+length('symbols='))
      if substr(sym_file,1,1)<>' ' then
        parse value sym_file with bkm_sym_file .
      else
        bkm_sym_file=''
      endif
    endif
compile endif
  endif
  if flag=1 then
    if bkm_tag_start='' then bkm_tag_start=':' endif
    if bkm_tag_end='' then bkm_tag_end='.' endif
    if bkm_end_tag='' then bkm_end_tag=':e' endif
    if bkm_rep_tag='' then bkm_rep_tag=':p.' endif
    if bkm_inv_tag_rep='' then
      bkm_inv_tag_rep='&gml.'
      if substr(bkm_save_file,1,1)='B' then
        bkm_inv_tag_rep='&colon.'
      endif
    endif
compile if bkm_want_symbols
    if bkm_sym_file='' & substr(bkm_save_file,1,1)='B' then
      parse value bkm_save_file with bkm_sym_file '.' .
    endif
compile endif
  endif
  if bkm_inv_tag_rep='' then bkm_inv_tag_rep=bkm_tag_start endif

/* DEFLOAD is called when a new file is read into the   */
/* ring. In EOS2 and EPM this routine can be here, in   */
/* E3 it must be included in MYSELECT.E, which calls    */
/* the procedure bkm_init().                            */
compile if EVERSION >= '4.12'
defproc bkm_defload()
  universal bkm_did_menu
compile if bkm_debugging
  universal bkm_debug
  if bkm_debug then call bkm_say("DEFLOAD called for ".filename,0) endif
compile endif
compile if EVERSION > 5
  if bkm_did_menu <> 1 then call bkm_build_menu() endif
compile endif
return bkm_init()

/* DEFSELECT is called when the file is moved in the    */
/* topmost position of the ring. This is for EPM and    */
/* EOS2 only, in E3 this (and more) is done in bkm_init.*/
defproc bkm_defselect()
compile if bkm_debugging
  universal bkm_debug
  if bkm_debug then call bkm_say("DEFSELECT called for ".filename,0) endif
compile endif
  if bkm_find_file(.filename)>0 then
    call bkm_select()
  endif
compile endif

compile if bkm_attr
defproc bkm_upd_line_attr(linenum)
  universal bkm_tag_start
  universal bkm_tag_end
compile if EVERSION > '5.16' & EVERSION < '5.50'
  saveline = .line
  savecol = .col
compile endif
  xline=strip(textline(linenum),'T')
  first=pos(bkm_tag_start,xline)
  while first do
    last=pos(bkm_tag_end,xline,first)
    if last<first then last=length(xline) endif
    if last<>first then
compile if EVERSION >= '5.50'
      insert_attribute  COLOR_CLASS, 23, 0, -1, last+1, linenum
compile elseif EVERSION > '5.16'
      lastlength = length(xline)
      insert_attribute  COLOR_CLASS, 23, 0, -1, last+1, linenum
      .col = last+1
      linenum
      call shed_attributes()
      getline xline,linenum
      if lastlength <> length(xline) then
        .col = length(xline)
        oldlevel = .levelofattributesupport
        .levelofattributesupport = 3
        delete_char
        .levelofattributesupport = oldlevel
      endif
compile else
      insert_attribute  COLOR_CLASS, 23, 0, 1, last, linenum
compile endif
      insert_attribute  COLOR_CLASS, bkm_attr_colors, 1, -1, first, linenum
    endif
    first=pos(bkm_tag_start,xline,last+1)
  endwhile
compile if EVERSION > '5.16' & EVERSION < '5.50'
  saveline
  .col = savecol
compile endif

defproc bkm_add_attr(xcmd)
  universal bkm_tag_start
  universal bkm_tag_end
  universal bkm_did_bkmattr
  bkm_did_bkmattr=1
  call psave_pos(OldCursorPos)
  OldRC = RC
  display -3
  saveautosave=.autosave
  savemodify = .modify
  .autosave=0
  0; .col=1
  TheOffset = -300
  TheColumn = 1
  TheLine   = 0
  TheClass  = ANY_CLASS
  attribute_action FIND_NEXT_ATTR_SUBOP, TheClass, TheOffset, TheColumn, TheLine
  while TheClass do
    attribute_action DELETE_ATTR_SUBOP, TheClass, TheOffset, TheColumn, TheLine
    TheClass  = ANY_CLASS
    attribute_action FIND_NEXT_ATTR_SUBOP, TheClass, TheOffset, TheColumn, TheLine
  endwhile
  0; .col=1
  if lowcase(xcmd)<>'off' then
    "xcom l /"bkm_tag_start"/"
    while not rc do
      first=.col
      fline=.line
      getline line
      if pos(substr(line,first+1,1),'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789') then
        "xcom l /"bkm_tag_end"/"
        last=.col
        lline=.line
compile if EVERSION >= '5.50'
        insert_attribute  COLOR_CLASS, 23, 0, -1, last+1, lline
compile elseif EVERSION > '5.16'
        getline xline,lline
        lastlength = length(xline)
        insert_attribute  COLOR_CLASS, 23, 0, -1, last+1, lline
        .col = last+1
        lline
        call shed_attributes()
        getline xline,lline
        if lastlength <> length(xline) then
          .col = length(xline)
          oldlevel = .levelofattributesupport
          .levelofattributesupport = 3
          delete_char
          .levelofattributesupport = oldlevel
        endif
        .col = last
compile else
        insert_attribute  COLOR_CLASS, 23, 0, 1, last, lline
compile endif
        insert_attribute  COLOR_CLASS, bkm_attr_colors, 1, -1, first, fline
      else
        .col=.col+1
      endif
      "xcom l /"bkm_tag_start"/"
    endwhile
  else
    bkm_did_bkmattr=0
  endif
  rc = OldRC
  .autosave=saveautosave
  .modify = savemodify
  display 3
  call prestore_pos(OldCursorPos)
  call bkm_upd_files(-1,' ')

; Thanks to Jason Crawford for the following code
defproc to_offset_zero()
   oldline = .line;
   up; down;
   .line = oldline;

---===shed_attributes===-----------------------------------------
--
-- To use shed_attributes(), move the cursor to the character that
--   is passing its attributes to neighboring characters.
--
-- This procedure is handy because it provides a method for
--  putting an attribute at a positive offset despite the
--  best efforts of EPM 5.18 to prevent this.
-- This code will move all the attributes at the beginning
--   of a character to the previous character, and all
--   attributes following the attribute to the next character.

-- This kludge is based on the enhanced behavior of delete_char
--   when levelofattributesupport has its second bit set.
--   This behavior moves attributes to adjacent characters
--   before removing the character.  The cursor must be at
--   offset 0 for this to happen, otherwise an attribute
--   will be removed instead.


defproc shed_attributes()
  oldcol  = .col;
  TheText = textline(.line)
  TheChar = substr(TheText, oldcol, 1);
  --
  call to_offset_zero(); -- just to be sure at offset 0
  oldlevel = .levelofattributesupport;
  .levelofattributesupport = 3
     delete_char;
     keyin TheChar;
  .levelofattributesupport = oldlevel
  left;

compile if EVERSION >= '5.50'
defc bkm_upd_line_attr =
  universal bkm_did_bkmattr
  if bkm_did_bkmattr=1 then
    oldmod = .modify
    replaceline textline(.line)
    call bkm_upd_line_attr(.line)
    .modify = oldmod
  endif
compile endif
compile endif

defproc bkm_imbed()
  universal bkm_config
  bkm_config = ''
compile if EVERSION < 5
 if not command_state() then         -- check for command line
compile endif
   line = upcase(textline(.line))
   parse value line with cmd file ';' .
   parse value file with file "'" .
   parse value file with file '"' .
   if cmd='.IM' | cmd='.SETUP' | cmd='.IM#XMP' | cmd = '.USING' | cmd='.IM$XMP' then
     If Pos('(',file) then
       parse value file with '(' file ')' .
     endif
     if cmd='.USING' then
       saveline = .line
       savecol = .col
       'xcom L /.config/ca-'
       if not rc then
         parse value textline(.line) with . bkm_config .
       endif
       saveline
       .col = savecol
     endif
     parse value .filename with fn ft fm
     if ft<>'' & fm<>'' then
/* Fix host session id problem, thanks to Pat Lockhart */
       hsid = ''
       if pos(':',fn) then
         parse value fn with hsid ':' fn
         if hsid <> '' then hsid = hsid||':' endif
       endif
       parse value file with ifn ift ifm .
       If ift='' then ift='SCRIPT' endif
       If ifm='' then ifm=fm endif
       ifn = hsid||ifn
       'edit' ifn ift ifm  -- edit host file
     else
       If not pos('.',file) then
         ext = 'SCR'
         fm = ''
         parse value file with file fm .
         if fm <> '' then ext = substr(fm,1,3) endif
         file=file||'.'||ext
       endif
       path=''
       If lastpos('\',.filename) then
         path=substr(.filename,1,lastpos('\',.filename))
       endif
       ifile=bkm_findfile(strip(path||file))
       if ifile='' then ifile=bkm_findfile(file) endif
       if ifile='' then ifile=strip(path||file) endif   -- new file
       'edit' ifile
     endif
compile if E3
     call bkm_init()
compile endif
   else
     call bkm_say("Line doesn't contain '.im', '.setup', or '.using'.",0)
   endif
compile if EVERSION < 5
 endif                               -- check for command line
compile endif

defproc bkm_rem()
  universal expand_on
  universal bkm_rep_tag
  universal bkm_last_colon
  universal bkm_last_colon_line
  universal bkm_tag_start
  universal bkm_tag_end
  universal bkm_end_tag
  if expand_on then                     -- shall we do something?
    if bkm_rep_tag<>'' then             -- anything defined?
      if pos(bkm_tag_end,bkm_rep_tag) then      -- find tag-end character
        char=bkm_tag_end                        -- save it
        parse value bkm_rep_tag with k (char) . -- remove it from tag
        k=strip(k)                      -- remove leading and trailing blanks
      else
        char=' '                        -- no tag-end character included
        k=strip(bkm_rep_tag)            -- get tag
      endif
      bkm_last_colon=.col               -- save position of tag-start
      bkm_last_colon_line=.line         -- save line number
      keyin k                           -- type characters
      call bkm_expansion(char)          -- expand it if a tag
      bkm_last_colon=0                  -- reset last colon position
    endif
  endif

compile if bkm_help_support
defproc bkm_help(aorc)
  universal bkm_save_file
  universal bkm_tag_start
compile if bkm_help_reference           /* temple */
  if aorc = 'a' then
    call bkm_ref()
    return 0
  endif
compile endif
  if bkm_find_file(.filename)=0 then
    call bkm_say("Support is not active for this file",0)
  else
    parse value bkm_save_file with help_file hrest
    Parse Value help_file with s_help_file '.' .
    s_help_file=s_help_file||'.HLP'
    loop
      Parse Value help_file with help_file '.' .
      help_file=help_file||'.HLP'
      getfileid curfile
      getfileid id,help_file
      if id='' then
        help_file=bkm_findfile(help_file)
        if help_file<>'' then
compile if EPM
          'xcom edit' help_file
          .visible=0
compile else
          'xcom edit /h /q' help_file
compile endif
          activatefile curfile
          if rc then
            call bkm_say("Unable to load the file" help_file", out of storage",0)
          endif
        endif
        getfileid id,help_file
      endif
      if id <> '' then leave endif
      if hrest = '' then leave endif
      parse value hrest with help_file hrest
    endloop
    if id='' then
      call bkm_say("Unable to find the file" s_help_file", support not available",0)
    else
      getline line,.line
      fcol=lastpos(' ',line,.col)+1
      lcol=pos(' ',line||' ',.col)-1
      xword=strip(substr(line,fcol,lcol-fcol+1))
      if Substr(xword,1,1) <> '.' then
        parse value xword with xword '.' .
      endif
      if Substr(xword,1,1) <> '=' then
        parse value xword with xword '=' .
      endif
      done=0
      for i = 1 to id.last                  -- loop over help file
        getline helpline,i,id               -- no, get line from index
        if substr(helpline,1,1)=' ' then iterate endif
        parse value helpline with attribute .
        parse value attribute with attribute '\' .
        parse value attribute with attribute '=' .
        if upcase(attribute)=upcase(xword) then
          done=1
          getfileid hlpfile,'.HLP'
          if hlpfile <> '' then
            activatefile hlpfile
            .modify=0
            'quit'
          endif
          'xcom edit /q /n .HLP'
          sayerror 0
          'ma 1 80 1'
          join_after_wrap=0
          for j=i to id.last
            getline helpline,j,id
            if substr(helpline,1,1)<>' ' then
              parse value helpline with attribute .
              parse value attribute with attribute '\' .
              parse value attribute with attribute '=' .
              if upcase(attribute)<>upcase(xword) then leave endif
              If j>i then
                insert
                insert
                insert
                down
                down
                down
                begin_line
              endif
            endif
            helpline=strip(helpline)
            getline line
            if strip(line)<>'' then helpline=' 'helpline endif
            loop
              if not pos('\',helpline) then leave endif
              parse value helpline with xleft '\' helpline
              keyin xleft
              insert
              down
              begin_line
            endloop
            keyin helpline
          endfor
          .modify=0
          'top'
          leave
        endif
      endfor
      if not done then
        call bkm_say("No help for" xword "found.",0)
      endif
    endif
  endif
compile endif

compile if bkm_idx_supp
defproc bkm_idx_make()
  universal bkm_avail
  if bkm_avail=1 & bkm_find_file(.filename)>0 Then
    type=marktype()
    if type='' then
      fline=.line
      lline=.line
      fcol=.col
      lcol=.col
    else
      getmark fline, lline, fcol, lcol
    endif
    if type='LINE' then
      call bkm_say("Line mark invalid, must be block mark or not marked at all.",0)
    else
      if fline<>lline then
        call bkm_say("The marked block must not span lines.",0)
      else
        getline line,fline
        if fcol=lcol then
          fcol=lastpos(' ',' '||line,fcol)
          if substr(line,fcol,1)=' ' then fcol=fcol+1 endif
          lcol=pos(' ',line||' ',lcol)-1
        endif
        xblock=strip(substr(line,fcol,lcol-fcol+1))
        loop
          x=pos(':',xblock)
          if not x then leave endif
          y=pos('.',xblock,x)
          if not y then leave endif
compile if EVERSION >= '5.20'
          xblock=delstr(xblock,x,y-x+1)
compile else
          if x=1 then
            xblock=substr(xblock,y+1)
          else
            xblock=substr(xblock,1,x-1)||substr(xblock,y+1)
          endif
compile endif
        endloop
        loop
          x=verify(xblock, ',"''', 'M')  -- LAM:  Handles , " and ' in one loop.
          if not x then leave endif
compile if EVERSION >= '5.20'
          xblock=delstr(xblock,x,1)
compile else
          if x=1 then
            xblock=substr(xblock,2)
          else
            xblock=substr(xblock,1,x-1)||substr(xblock,x+1)
          endif
compile endif
        endloop
        if substr(xblock,1,1)='(' then  -- LAM: Could delete all parens by adding '()' to verify() string above...
          xblock=substr(xblock,2)
compile if EVERSION >= '5.20'
          if rightstr(xblock,1)=')' then xblock=leftstr(xblock,length(xblock)-1) endif
compile else
          if substr(xblock,length(xblock),1)=')' then xblock=substr(xblock,1,length(xblock)-1) endif
compile endif
        endif
        xblock=strip(xblock)
compile if EVERSION >= '5.20'
        if rightstr(xblock,1)='.' then
compile else
        if substr(xblock,length(xblock),1)='.' then
compile endif
          x=lastpos('&',xblock)
          if x then
            if pos(' ',xblock,x) then
              xblock=substr(xblock,1,length(xblock)-1)
            endif
          else
            xblock=substr(xblock,1,length(xblock)-1)
          endif
        endif
        x=pos('.',xblock)
        if x then
          if not lastpos('&',xblock,x) then
            if not lastpos(' ',xblock) then
              xblock=substr(xblock,x+1)
            endif
          endif
        endif
compile if bkm_keep_index_cases
        yblock=strip(xblock)
        xblock=''
        loop
          parse value yblock with xword yblock
          if xword='' then leave endif
          zword=lowcase(xword)
          if xword=upcase(xword) then
            xblock=xblock xword
          else
            xblock=xblock zword
          endif
        endloop
compile endif
        xblock=strip(xblock)
        insertline ".***",fline+1
        insertline ":i1."xblock,fline+2
compile if EVERSION >= '5.20'
        for i=2 to words(xblock)
          insertline ":i1." || subword(xblock,i) || ", " || subword(xblock,1,i-1),fline+i+1
        endfor
        insertline ".***",fline+i+1
compile else
        j=1
        for i=3 to 99
          x=0
          for k=1 to j
            x=pos(' ',xblock,x+1)
          endfor
          if not x then leave endif
          insertline ":i1." || substr(xblock,x+1) || ", " || substr(xblock,1,x),fline+i
          j=j+1
        endfor
        insertline ".***",fline+i
compile endif
        unmark
      endif
    endif
  endif
compile endif

compile if bkm_help_reference           /* temple */
defproc bkm_ref()
  universal bkm_tag_start
  universal bkm_tag_end
  universal bkm_save_file
  if bkm_find_file(.filename)=0 then
    call bkm_say("Support is not active for this file",0)
  else
    parse value bkm_save_file with help_file hrest
    parse value help_file with s_help_file '.' .
    s_help_file=s_help_file||'.INF'
    xfile = ''
    loop
      Parse Value help_file with help_file '.' .
      help_file=help_file||'.INF'
      findfile xfile, help_file, 'BOOKSHELF'
;;    if rc then findfile xfile, help_file, 'EPATH' endif  -- LAM:  EPM uses EPMPATH, not EPATH, and
      if rc then findfile xfile, help_file, '', 'D' endif  -- this searches EPMPATH as well as DPATH
      if not rc then leave endif
      if hrest = '' then leave endif
      parse value hrest with help_file hrest
    endloop
    if xfile = '' then
       call bkm_say("Help file" s_help_file "not found.",0)
       return 0
    endif
    getline line,.line
    fcol=lastpos(' ',line,.col)+1
    lcol=pos(' ',line||' ',.col)-1
    xword=strip(substr(line,fcol,lcol-fcol+1))
    if Substr(xword,1,1) = bkm_tag_start then
      xword = substr(xword,2)
    endif
    if pos(bkm_tag_end,xword) then
       xword = substr(xword,1,pos(bkm_tag_end,xword)-1)
    endif
    if Substr(xword,1,1) <> '=' then
      parse value xword with xword '=' .
    endif
    'VIEW' xfile xword
  endif
compile endif

compile if EPM
defproc bkm_build_menu()
  universal defaultmenu
  universal activemenu
  universal bkm_did_menu
 compile if EVERSION >= 5.20
   universal activeaccel
 compile endif
compile if KEEP_HELP_AT_RIGHT
  deletemenu defaultmenu, 6, 0, 0  -- delete the existing Help menu (we want it to stay at the right)
compile endif
  grey = 16384
  buildsubmenu defaultmenu, 21,      'E'TILDE_CHAR'bookie',    ' ',           0,0
  buildmenuitem defaultmenu,21, 2101, '~Bookie on',            'bookie on',   0,0
  buildmenuitem defaultmenu,21, 2102, 'Bookie ~off',           'bookie off',  0,0
  buildmenuitem defaultmenu,21, 2103, \0,                      '',            4,0
compile if bkm_attr
  buildmenuitem defaultmenu,21, 2104, '~Attribute on',         'bkmattr on',  0,0
  buildmenuitem defaultmenu,21, 2105, 'A~ttribute off',        'bkmattr off', 0,0
compile if EVERSION >= '5.50'
  buildmenuitem defaultmenu,21, 2120, '~Fixup attributes',     'bkm_upd_line_attr', 0,0
compile endif
compile else
  buildmenuitem defaultmenu,21, 2104, '~Attribute on',         'bkmattr on',  0,grey
  buildmenuitem defaultmenu,21, 2105, 'A~ttribute off',        'bkmattr off', 0,grey
compile if EVERSION >= '5.50'
  buildmenuitem defaultmenu,21, 2120, '~Fixup attributes',     'bkm_upd_line_attr', 0,grey
compile endif
compile endif
  buildmenuitem defaultmenu,21, 2106, \0,                      '',            4,0
compile if bkm_want_symbols
  buildmenuitem defaultmenu,21, 2107, '~Symbols all/mark',     'bkmsym all',  0,0
  buildmenuitem defaultmenu,21, 2121, 'Symbols on',            'bkmsym on',   0,0
  buildmenuitem defaultmenu,21, 2122, 'Symbols off',           'bkmsym off',  0,0
compile else
  buildmenuitem defaultmenu,21, 2107, '~Symbols all/mark',     'bkmsym all',  0,grey
  buildmenuitem defaultmenu,21, 2121, 'Symbols on',            'bkmsym on',   0,grey
  buildmenuitem defaultmenu,21, 2122, 'Symbols off',           'bkmsym off',  0,grey
compile endif
  buildmenuitem defaultmenu,21, 2108, \0,                      '',            4,0
compile if bkm_debugging
  buildmenuitem defaultmenu,21, 2109, '~Debug on',             'bkmdebug on', 0,0
  buildmenuitem defaultmenu,21, 2110, 'D~ebug off',            'bkmdebug off',0,0
  buildmenuitem defaultmenu,21, 2111, 'De~bug on+echo',        'bkmdebug t'  ,0,0
  buildmenuitem defaultmenu,21, 2112, 'Debug dis~play',        'bkmdebug d'  ,0,0
compile else
  buildmenuitem defaultmenu,21, 2109, '~Debug on',             'bkmdebug on' ,0,grey
  buildmenuitem defaultmenu,21, 2110, 'D~ebug off',            'bkmdebug off',0,grey
  buildmenuitem defaultmenu,21, 2111, 'De~bug on+echo',        'bkmdebug t'  ,0,grey
  buildmenuitem defaultmenu,21, 2112, 'Debug dis~play',        'bkmdebug d'  ,0,grey
compile endif
  buildmenuitem defaultmenu,21, 2113, \0,                      '',            4,0
  buildmenuitem defaultmenu,21, 2114, 'Edit ~imbed'\9'a_1',    'bkmimbed',    0,0
  buildmenuitem defaultmenu,21, 2115, 'Insert default ~tag'\9'a_2', 'bkmrem', 0,0
compile if bkm_help_support
  buildmenuitem defaultmenu,21, 2116, '~Help for tag'\9'a_h',   'bkmhelp',    0,0
compile else
  buildmenuitem defaultmenu,21, 2116, '~Help for tag'\9'a_h',   'bkmhelp',    0,grey
compile endif
compile if bkm_idx_supp
  buildmenuitem defaultmenu,21, 2118, 'I~ndex word/mark'\9'a_i', 'bkmidx',    0,0
compile else
  buildmenuitem defaultmenu,21, 2118, 'I~ndex word/mark'\9'a_i', 'bkmidx',    0,grey
compile endif
  buildmenuitem defaultmenu,21, 2119, 'Vie~w documentation' ,   'view ebookie',    0,0
compile if KEEP_HELP_AT_RIGHT
 compile if EVERSION >= '5.20'  -- We know that OS/2 must be over 1.2
  call add_help_menu(defaultmenu, 1)  -- rebuild the help menu
 compile else
  call add_help_menu(defaultmenu, dos_version()>=1020)  -- rebuild the help menu
 compile endif
compile endif
  if activemenu = defaultmenu then     -- If this is the active menu, then
     showmenu defaultmenu              -- activate the above changes
  endif
compile if EVERSION >= 5.20 & TILDE_CHAR <> ''
   buildacceltable activeaccel, 'dokey a+B', AF_CHAR+AF_ALT,                  66, 2191  -- a+B
   buildacceltable activeaccel, 'dokey a+B', AF_CHAR+AF_ALT,                  98, 2192  -- a+b
   activateacceltable  activeaccel
compile endif
  bkm_did_menu = 1
compile endif  -- EPM
