/* Find the string "xx xxx xxxx xx:xx:xx" in the run.exe                     */
/* executable and replace it with the current data and time.   Rename  and   */
/* move the executable and help files to the ELAS REXX bin directory,        */
/*                                                                           */
/* Doug Rickman Feb. 2, 1998, mod 5/20/1998; Oct 5, 1998                     */

signal on Halt
signal on NotReady

if rxfuncquery('rexxlibregister') then do         /* this will start rexxlib */
	call rxfuncadd 'rexxlibregister', 'rexxlib', 'rexxlibregister'  
	call rexxlibregister
	end
if rxfuncquery('sysloadfuncs') then do           /* this will start rexxutil */
	CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs' 
	CALL SysLoadFuncs
	end

Flag=0 /* This is checked to see if I have had more than one error message. */
/* 1 */
/* Copy the RUN.EXE into a file whose name is based on the directory name.   */

in='run.exe'
in=dosfname(in)

parse value parsefn(in) with drive path filename extension
path             =strip(path,'T','\')
last             =lastpos('\',path)
parse var path . =(last) lastDirectory
lastDirectory    =strip(lastDirectory,'L','\')

newname=lastdirectory||'.exe'
fullname=drive':'path'\'newname
rc=doscopy(in,fullname,'R')

/* 2 */
/* Get the date and time, find the key string in the executable and modify it.*/

date=date()
time=time()
parse var date day month year
date=right(day,2) right(month,3) year

fsize=dosfsize(fullname)

data=charin(fullname,1,fsize)
pos=pos('xx xxx xxxx xx:xx:xx',data)
if pos\=0 then do
   output=overlay(date time,data,pos)
   end
else do
   string='"The date time string was not found."' '"MoveIt.cmd warning"' '/B2:"OK"' '/T:20'
   '@echo off'
   'pmpopup2' string
   end


rc=charout(fullname,output,1)
rc=lineout(fullname)


exit

DosCopyError:
Flag=Flag+1
select
	when rc=2 then text='Source file not found. '
	when rc=3 then text='Source or target path not found. '
	when rc=5 then text=' Target file exists but "A" or "R" mode not specified. '
	when rc=32 then text=' Sharing violation for source or target file. '
	when rc=108 then text=' Source or target drive locked. '
	when rc=112 then text=' Disk full. '
	when rc=206 then text=' Invalid source or target file name. '
	when rc=267 then text=' Source name is a directory. '
	when rc=282 then text=' Extended attributes not supported for target. '
	otherwise        text=' Heck if I know what the error is!'
	end /* select */
if Flag=2 then /* There are two or more errors.  Sound the bell. */
string='"The file 'in 'could not be copied.~~'text'"' '"ELASmoveit.cmd warning"' '/B2:"OK"' '/T:4' '/BELL'
else
string='"The file 'in 'could not be copied.~~'text'"' '"ELASmoveit.cmd warning"' '/B2:"OK"' '/T:4'
'@echo off'
start 'pmpopup2' string
return

/* --------------------------------------------------------------------------*/
/* --- begin subroutine - Help:                                 -------------*/
Help:
rc= charout(,'1b'x||'[31;7m'||'MoveIt:'||'1b'x||'[0m'||'0d0a'x)
say 'Copy the .exe and .hlp files from the ELASII\source to the final locations'

say ''
rc= charout(,'1b'x||'[33;1m'||'usage:'||'1b'x||'[0m')
say 'Just type Moveit in the directory and stand back.'
say ''

say ''
say 'Doug Rickman  Feb. 3,1998'
exit
return

/* --- end  subroutine - Help:                                  -------------*/
/* --------------------------------------------------------------------------*/

/* --------------------------------------------------------------------------*/
/* --- begin subroutine - Halt:                                 -------------*/
Halt:
say 'This is a graceful exit from a Cntl-C'
exit
/* --- end  subroutine - Halt:                                  -------------*/
/* --------------------------------------------------------------------------*/
/* --- begin subroutine - NotReady:                             -------------*/
NotReady:
say 'It would seem that you are pointing at non-existant data.  Oops.  Bye!'
exit
/* --- end  subroutine - NotReady:                              -------------*/
/* --------------------------------------------------------------------------*/

