:userdoc.
:docprof toc=1234 ctrlarea=coverpage.
:title.Digitize2
:ctrldef.
:ctrl ctrlid=IPFEDefault controls='search print index contents esc back forward ' coverpage.
:ectrldef.
.* Documentation written by Doug Rickman,GHCC/MSFC/NASA
.* Created by IPF Editor Version 2.12 (C) 1992-1995 Perez Computing Services
.* To order the IPF Editor call: 1-800-IPF-7622
.* For information call: 1-360-428-5025
.*********************************************************
.*UserList=Undefined
.*UserList=Doug Rickman
.*DocType=HLP
.*HelpTargetRC=
.*HelpTargetH=
.*HelpTargetC=

:h1 res=110 name=Purpose_110 id=110.Purpose
.*:EditTime=959791087
.*:EditUser=1
:i1. Purpose
:p.With :hp2.Digitize2:ehp2. the user can convert a line or other feature in a raster image to a string of x,y points.  The points
.*BR
may optionally stored in an ASCII file.  :hp2.Digitize2:ehp2. was designed to help convert old graphs, figures, charts and other
.*BR
illustrations into a tabular digital format.  

:p.:hp2.Digitize2:ehp2. addresses three special problems inherent in this type of work.  First, it is rather easy to scan the printed
.*BR
material, but getting it aligned accurately is a nuisance.  Second, many scanners and certainly most zerographic reproductions are
.*BR
not uniformly scaled.  Therefore, :hp2.Digitize2:ehp2. by default can correct for rotated images and it does a linear correction
.*BR
for scale distortions.  Finally, :hp2.Digitize2:ehp2. allows the user to also edit the image.  This will be done automatically during
.*BR
digitizing or optionally using the various paint tools available.  This can greatly simplify keeping track of progress when working
.*BR
on complex imagery.  


:h1 res=200 titlebar=both scroll=both.Operation
.*:EditTime=959966937
.*:EditUser=1
:i1. Operating Instructions
:p.:hp2.Digitize2:ehp2. combines an interactive digitizer with a paint program.  As points are digitized the image is edited.  

:p.Normally, the user will start by :link reftype=hd res=240.loading a new image:elink. and :link reftype=hd res=280.setting the
.*BR
transformation:elink. from image to data coordinates.  After this is done a :link reftype=hd res=250.file to hold the digitized points:elink.
.*BR
is specified and the :link reftype=hd res=255.save checkbox:elink. on the coordinates panel clicked.  Now, as long as either the
.*BR
:link reftype=hd res=50.pen or line tool:elink. is active any single left mouse button release will digitize a point.  The points
.*BR
will be saved in an ASCII file if the :link reftype=hd res=255.Save:elink. option is checked on the :link reftype=hd res=260.Coordinates
.*BR
panel:elink..  If points are currently being saved they will also be displayed in the Points List panel if it is currently open.
.*BR
 See Recommendations and Comments for more discussion.

:p.Very often the image is at a scale such that it can not be displayed all at once.  When this occurs the image can be :link reftype=hd res=15.zoomed:elink.
.*BR
or a piece can be :link reftype=hd res=85.cropped:elink. from the whole image and the piece can be expanded as needed.  

:p.:hp2.Digitize2:ehp2. uses separate panels for most distinct operations.  The main panel holds the :link reftype=hd res=285.image:elink..

:p.
:p.
:p.Notes&colon.

:p.:hp2.Digitize2:ehp2. allows most panels to be interactively resized and positioned.  The next time the program starts panels
.*BR
will be returned to their position and size when the program closed.

:p.To digitize points you must have a transformation from image x,y to data coordinates.  This is done using the :link reftype=hd res=280.setup:elink.
.*BR
panel.


:h2 name=Image_Panel_285  res=285.Image Panel
.*:EditTime=959968122
.*:EditUser=1
:i1.Image Panel
:p.This panel shows the selected image file.   What you see is what you get.  The menu items allow you to select files, do various
.*BR
edit operations,  change the view and access various settings.

:artwork align=center name='D:\SOURCE\VISPROSOURCE\DIGITIZE2\MAINPANEL.BMP'.

:p.A right mouse click over the image will provide a popup menu with many of these options.  

:p.A double click with the left mouse button will either zoom in or zoom out.  Which is determined by the :link reftype=hd res=15.active
.*BR
zoom option:elink. shown in the view menu.

:p.The size of this window can be changed interactively.


:h2 name=Coordinates_Panel_260  res=260 titlebar=both scroll=both x=0% y=0% width=42% height=100% group=260.Coordinates Panel
.*:EditTime=959968122
.*:EditUser=1
:i1.Coordinates Panel
:link reftype=hd res=255 vpx=42% vpy=77% vpcx=57% vpcy=23%  group=255 dependent auto scroll=both titlebar=both rules=sizeborder.
:link reftype=hd res=265 vpx=42% vpy=57% vpcx=58% vpcy=20%  group=265 dependent auto scroll=both titlebar=both rules=sizeborder.
:link reftype=hd res=45 vpx=42% vpy=36% vpcx=57% vpcy=21%  group=45 dependent auto scroll=both titlebar=both rules=sizeborder.
:link reftype=hd res=270 vpx=42% vpy=18% vpcx=57% vpcy=18%  group=270 dependent auto scroll=both titlebar=both rules=sizeborder.
:link reftype=hd res=275 vpx=42% vpy=0% vpcx=58% vpcy=18%  group=275 dependent auto scroll=both titlebar=both rules=sizeborder.

:p.This shows the selected coordinates in image and data based units.  It also can allow you to save a series of points into a file
.*BR
and comment the file.  Before points can be saved an :link reftype=hd res=250.output file must be designated:elink..

:artwork align=center name='D:\SOURCE\VISPROSOURCE\DIGITIZE2\COORDINATESPANEL.BMP'.
:artlink.
:link reftype=hd res=150 x=9 y=184 cx=311 cy=25.
:link reftype=hd res=135 x=8 y=158 cx=312 cy=24.
:link reftype=hd res=270 x=59 y=108 cx=218 cy=26.
:link reftype=hd res=275 x=60 y=84 cx=218 cy=22.
:link reftype=hd res=255 x=10 y=57 cx=69 cy=22.
:link reftype=hd res=45 x=82 y=56 cx=120 cy=23.
:link reftype=hd res=265 x=204 y=55 cx=114 cy=24.
:link reftype=hd res=265 x=9 y=27 cx=311 cy=29.
:eartlink.

:p.:hp9.Most of the above image is actually a selection of links to various parts of this document.  A single click within the image
.*BR
will highlight the area if it is a link.  A double click will take you to the appropriate section of the document.:ehp9.


:p.The relationship between image X,Y and data coordinates is maintained as the image is zoomed and cropped.

:p.:hp2.Digitize2:ehp2. remembers the position of this panel.  If the program closes normally the next time it is started it will
.*BR
return to where you placed it.


:h3 name=Output_Point_File_150  res=150.Output Point File
.*:EditTime=959966970
.*:EditUser=1
:i1.Output Point File
:p.This shows the file which will receive any new comments or points from digitizing.  You can change this by either entering a name
.*BR
directly, a right mouse click in the field will give a file dialog, or by selecting the :link reftype=hd res=250.Output Point File:elink.
.*BR
option under the main panel's File menu.

:p.Remember, this file is always appended.  :hp2.Digitize2:ehp2. does not edit existing data!

:h3 name=Image_x_y__270  res=270 x=42% y=18% width=57% height=18% group=270.Image x,y 
.*:EditTime=940445199
.*:EditUser=1
:i1.Image x,y 
:p.This field shows the image X,Y location for the selected point.  If a transformation has been :link reftype=hd res=280.setup:elink.
.*BR
the matching data coordinates will be automatically computed and shown in :link reftype=hd res=275.the field below this one:elink..


:h3 name=Data_coordinates_275  res=275 x=42% y=0% width=58% height=18% group=275.Data coordinates
.*:EditTime=959882853
.*:EditUser=1
:i1.Data coordinates
:p.This field shows the data coordinates of the selected point.  This will only work if the image to data transformation has been
.*BR
:link reftype=hd res=275.setup:elink..  The format of the values is controlled via the :link reftype=hd res=135.Format:elink. drop
.*BR
down list box.


:h3 name=Format_135  res=135.Format
.*:EditTime=959884245
.*:EditUser=1
:i1.Format
:p.You can change the format of the data coordinates using this drop down list box.  You may either select existing options or enter
.*BR
your own.  This field can have up to four integers and a trailing comment.  The comment should have a leading ";". As to how the
.*BR
four numbers are used a full explanation requires you to look up the ":link reftype=launch object='view.exe' data='REXX.INF'.FORMAT:elink."
.*BR
function in the REXX documentation.

:p.Briefly stated, there are 4 values.  The first is the number of places before the decimal point.  The second is the number of
.*BR
places after the decimal point.  The third and fourth control exponential representation.
 
 The third sets the number of places to be used for the exponent part, if any.  The fourth sets the trigger point for use of exponential
.*BR
notation. If the number of places needed for the integer part exceeds the third number, exponential notation is used. Likewise, exponential
.*BR
notation is used if the number of places needed for the decimal part exceeds twice this value.  If 0 is specified for the fourth
.*BR
value, exponential notation is always used unless the exponent would be 0.


:h3 name=Save_Checkbox_255  res=255 x=42% y=77% width=57% height=23% group=255.Save Checkbox
.*:EditTime=940445389
.*:EditUser=1
:i1.Save Checkbox
:p.If this is checked all points selected in the image will be written :link reftype=hd res=250.to a file:elink. in ASCII format.
.*BR
 The values written are the coordinates in data units, not the image X,Y values.


:h3 name=Comments_265  res=265 x=42% y=57% width=58% height=20% group=265.Write Comment
.*:EditTime=959967380
.*:EditUser=1
:i1.Comments
:p.Comments may be entered into the points file.  Do this by typing the desired text into the comments entry field and then selecting
.*BR
the comments pushbutton.


:h3 name=New_Line_45  res=45 x=42% y=36% width=57% height=21% group=45.New Line
.*:EditTime=940944805
.*:EditUser=1
:i1.New Line
:p.This will insert a blank line into the output file.  This helps denote the end of one string of points and the start of another.


:h2 name=Tools_Palette_50  res=50 titlebar=both scroll=both titlebar=both scroll=both x=0% y=0% width=42% height=100% group=50.Tools Palette
.*:EditTime=959967510
.*:EditUser=1
:i1.Tools Palette
:link reftype=hd res=70 vpx=42% vpy=70% vpcx=58% vpcy=30%  group=70 dependent auto scroll=both titlebar=both rules=sizeborder.
:link reftype=hd res=75 vpx=42% vpy=38% vpcx=58% vpcy=32%  group=70 dependent auto scroll=both titlebar=both rules=sizeborder.
:link reftype=hd res=80 vpx=42% vpy=0% vpcx=58% vpcy=38%  group=70 dependent auto scroll=both titlebar=both rules=sizeborder.

:p.The tools palette allows you to select from 14 image editing tools.  The visual behaviour of these tools is controlled by the
.*BR
:link reftype=hd res=60.Paint Settings:elink. item under the Settings menu.

:artwork align=center name='D:\SOURCE\VISPROSOURCE\DIGITIZE2\TOOLSPANEL.BMP'.


:p.Two of the tools&colon. :link reftype=hd res=75.Pen:elink. - :artwork runin name='D:\SOURCE\VISPROSOURCE\DIGITIZE2\PALDRAW.BMP'.,
.*BR
 and :link reftype=hd res=80.Line:elink. - :artwork runin name='D:\SOURCE\VISPROSOURCE\DIGITIZE2\PALLINE.BMP'., have special meaning
.*BR
under :hp2.Digitize2:ehp2..   When either of these are the active tools :hp2.Digitize2:ehp2. will display the image X,Y location
.*BR
and if possible the data coordinates.  These are shown in the :link reftype=hd res=260.coordinates panel:elink..

:note.The location reported by :hp2.Digitize2:ehp2. is for the point at which the left mouse button is released.


:p.:hp2.Digitize2:ehp2. remembers the position of this panel.  If the program closes normally the next time it is started it will
.*BR
return to where you placed it.


:h3 name=Select_70  res=70 x=42% y=70% width=58% height=30% group=70.Select
.*:EditTime=959790555
.*:EditUser=1
:i1.Select
:p.The Select tool, :artwork runin name='D:\SOURCE\VISPROSOURCE\DIGITIZE2\PALSELEC.BMP'., allows you to define a rectangular region
.*BR
of interest.  This can be used for various painting operations.  More importantly for :hp2.Digitize2:ehp2. the selected region can
.*BR
be cropped from the original image and then zoomed to a desired scale.


:h3 name=Pen_75  res=75 x=42% y=38% width=58% height=32% group=70.Pen
.*:EditTime=959790554
.*:EditUser=1
:i1.Pen
:p.Pen - :artwork runin name='D:\SOURCE\VISPROSOURCE\DIGITIZE2\PALDRAW.BMP'. draws on the image as long as the left mouse button
.*BR
is depressed.   What is drawn is controlled by the :link reftype=hd res=60.Paint Settings:elink..  By default a single dot is drawn
.*BR
on the image to mark the digitized point.

:p.When this is the active tool :hp2.Digitize2:ehp2. will display the image X,Y location and if possible the data coordinates. 
.*BR
These are shown in the :link reftype=hd res=260.coordinates panel:elink..


:note.The location reported by :hp2.Digitize2:ehp2. is for the point at which the left mouse button is released.  Therefore, when
.*BR
using the pen do not move the mouse while digitizing a point.


:h3 name=Line_80  res=80 x=42% y=0% width=58% height=38% group=70.Line
.*:EditTime=959790553
.*:EditUser=1
:i1.Line
:p.Line - :artwork runin name='D:\SOURCE\VISPROSOURCE\DIGITIZE2\PALLINE.BMP'. draws line segments on the image.  The starting point
.*BR
of a segment occurs where the left mouse button is depressed.  The end of the segment occurs when the left mouse button is released.
.*BR
  What is drawn is controlled by the :link reftype=hd res=60.Paint Settings:elink..  

:p.When this is the active tool :hp2.Digitize2:ehp2. will display the image X,Y location and if possible the data coordinates. 
.*BR
These are shown in the :link reftype=hd res=260.coordinates panel:elink..


:note.The location reported by :hp2.Digitize2:ehp2. is for the point at which the left mouse button is released.


:p.A good way to use the line tool to digitize is to start anywhere along a feature of interest and click then release the mouse
.*BR
button without moving the mouse.  This will record a point.  Then depress the left mouse button and move to the next desired point,
.*BR
where you release the mouse button.  This will record another point and draw a line connecting the start and stop.  To continue repeat
.*BR
the process of depress - move - release.


:h2 name=Points_List_Panel_140  res=140.Points List Panel
.*:EditTime=959967155
.*:EditUser=1
:i1.Points List Panel
:p.The Points List panel will show what is being written to the current points file.  Comments written to the points file are also
.*BR
shown here.  This is a simple way to monitor progress.  

:artwork align=center name='D:\SOURCE\VISPROSOURCE\DIGITIZE2\POINTSLISTPANEL.BMP'.

:p.When the :link reftype=hd res=255.Save:elink. checkbox is first turned on, any existing information in the panel is erased. 
.*BR
Selecting the :link reftype=hd res=45.New Line:elink. option will also erase the contents of this panel (NOT the contents of the
.*BR
points file!).

:p.This panel does not allow you to edit the information in the points file.  If you wish to do that, use an editor.

:h2 name=File_Menu_35  res=35 titlebar=both scroll=none titlebar=both scroll=both x=0% y=0% width=42% height=100% group=35.File Menu
.*:EditTime=940942433
.*:EditUser=1
:i1.File Menu
:link reftype=hd res=240 vpx=42% vpy=68% vpcx=58% vpcy=32%  group=240 dependent auto scroll=both titlebar=both rules=sizeborder.
:link reftype=hd res=290 vpx=42% vpy=36% vpcx=58% vpcy=32%  group=290 dependent auto scroll=both titlebar=both rules=sizeborder.
:link reftype=hd res=250 vpx=42% vpy=0% vpcx=58% vpcy=36%  group=250 dependent auto scroll=both titlebar=both rules=sizeborder.

:p.The file menu lets you&colon.

:ul compact .
:li.select a new image file to display,

:li.save an edited image over the original file,

:li.save an edited image to a new file,

:li.designate a file to save digitized points.
:eul.


:h3   res=240 x=42% y=68% width=58% height=32% group=240.Input Image Selection
.*:EditTime=959882835
.*:EditUser=1
:i1.Input File Selection
:p.An input image file can be selected by using the Files menu option.  .BMP, .TIF, .GIF and .PCX formats are supported.  

:p.:hp2.Digitize2:ehp2. remembers the last image used and will reload it if the file is still available when :hp2.Digitize2:ehp2.
.*BR
is started again.  If an existing :link reftype=hd res=280.transformation:elink. is available the image and data coordinate values
.*BR
for all three points will be visible.  They may be manually edited if necessary.  Selecting the OK checkbox in the lower right corner
.*BR
of the setup panel will compute the transformation and close the setup window.

:warning text='**  Memory Usage  **   '.:hp2.Digitize2:ehp2. will load the entire image into memory.  This can be brutal if the
.*BR
image is larger than your free RAM!:ewarning.


:h3 name=Save_Image_290  res=290 x=42% y=36% width=58% height=32% group=290.Save Image
.*:EditTime=940883569
.*:EditUser=1
:i1.Save Image
:p.After the image has been edited you may either save the image over the original file or save to a new file using the Save As item
.*BR
under the File menu.


:h3   res=250 x=42% y=0% width=58% height=36% group=250.Output Point File Selection
.*:EditTime=959966427
.*:EditUser=1
:i1.Output File Selection
:p.Points may be saved to an ASCII file.  The :hp2.File:ehp2. menu item :hp2.Save Points:ehp2. allows the user to specify the name
.*BR
of the file to be used.

:p.Checking the :link reftype=hd res=255.Save:elink. checkbox on the :link reftype=hd res=260.Coordinates Panel:elink. will cause
.*BR
all x,y points computed from the image to be saved into the file.  The new line pushbutton writes a blank line into the output file.
.*BR
 The comment pushbutton will write whatever text is in the comment field into the file.

:p.If an existing file is used the new points will be appended to the end of the file.

:p.The following illustrates the output.
:p.
:xmp.
This is an example comment.
4.60972937 -0.04260154
5.06349657 0.13064470
6.20083580 0.22152797
7.0538402 0.28969043
8.4482493 0.26412951
10.1652939 0.21868787
11.3792349 0.22436808
12.4127075 0.26128941
13.7688157 0.27833002
14.9444558 0.32661177
15.6059561 0.60778188
16.5900921 0.86907129
17.7546964 1.09911957
18.8043982 1.45697245

:exmp.


:h2 name=Edit_Menu_85  res=85.Edit Menu
.*:EditTime=940965368
.*:EditUser=1
:i1.Edit Menu
:p.The edit menu provides the following items.  The use of these should be fairly self evident.   Note the keyboard accelerators.
:p.

:ul compact .
:li.Undo

:li.Crop

:li.Copy

:li.Cut

:li.Paste

:li.Clear

:li.Select all

:li.Select none
:eul.

:p.The use of Crop is important in :hp2.Digitize2:ehp2..  With it the selected region can be cropped from the original image and
.*BR
then zoomed to a desired scale.  :hp2.Digitize2:ehp2. keeps track of the cropping and zoom operations to maintain the transformation
.*BR
from image X,Y to data coordinates.


:h2 name=View_Menu_295  res=295.View Menu
.*:EditTime=959790092
.*:EditUser=1
:i1.View Menu
:p.The view menu items will let you 

:ul compact .
:li.Reload image

:li.View all

:li.Actual size

:li.Zoom the image in 

:li.Zoom the image out

:li.Reload the image

:li.current scale

:li.Tool palette

:li.Coordinate window
:eul.

:p.Regretfully there are two function that do not work.  If anyone can figure out how to make them work, I would sure like to know.
.*BR
 Neither Overview or Pan work.  Both fail due to errors or limitations in VisProRexx Gold 3.1.


:h3 name=Reload_image_20  res=20.Reload image
.*:EditTime=940884885
.*:EditUser=1
:i1.Reload image
:p.This reloads the current file from disk.  Magnification factor is unchanged.


:h3 name=View_all_90  res=90.View all
.*:EditTime=940965372
.*:EditUser=1
:i1.View all
:p.This will scale the image so that all of the data are displayed with as much detail as possible.


:h3 name=Actual_Size_10  res=10.Actual Size
.*:EditTime=940884354
.*:EditUser=1
:i1.Actual Size
:p.This resets the magnification to 1.


:h3 name=Zoom_15  res=15.Zoom
.*:EditTime=940884836
.*:EditUser=1
:i1.Zoom
:p.Selecting zoom in and zoom out will bring you closer to the image (you see less area but more detail) or away from the image (you
.*BR
see more area but lose detail).  The current expansion factor is shown in the current scale item of the View menu.

:p.Each time the zoom in or zoom out is selected the operation is performed.  Double clicking the left mouse button will also perform
.*BR
which ever one of these items is active.  This gives you a quick way with the mouse to repeat a zoom operation.

:p.The zoom factors are predetermined and can not be changed by the user.  Magnifications factors greater than 1 are in integer
.*BR
steps&colon. 1, 2, 3, ...  Reductions factors (zoom out) are in steps 0.9, 0.8, ... 0.4, 0.3, 0.25, 0.20, 0.15, 0.125, 0.12, 0.11,
.*BR
0.10, 0.9, ... 0

:p.Remember that the menu item ":link reftype=hd res=10.Actual size:elink." returns you to magnification 1.


:h3 name=Overview_5  res=5.Overview
.*:EditTime=940964589
.*:EditUser=1
:i1.Overview
:p.This item does not currently work.

:p.What it may eventually do is something like this....

:p.This will show the entire image in another window.   The current area displayed in the Image Panel is defined by a rectangular
.*BR
box.  You can define a new area by holding the left mouse button down and dragging over the area of interest.  The existing area
.*BR
can be shifted by holding the right mouse button down within the box and dragging it to a new location.


:h3 name=Pan_40  res=40.Pan
.*:EditTime=940942267
.*:EditUser=1
:i1.Pan
:p.Panning is not yet implemented.  There is either a bug in the "CALL VpImgEdt window, 'IMAGE', 'SETSELECTION', x1, y1, x2, y2"
.*BR
method provided by VisProRexx or I don't know how to make it work. 

:p.C'est la vie.


:h3 name=Open_Close_Tool_Palette__25  res=25.Open/Close Tool Palette 
.*:EditTime=959968092
.*:EditUser=1
:i1.Open/Close Tool Palette 
:p.This will open the :link reftype=hd res=50.tool palette:elink. if it is closed and close it if it is open.  Simple, right?


:h3 name=Open_Close_Coordinate_window_30  res=30.Open/Close Coordinate Panel
.*:EditTime=959968076
.*:EditUser=1
:i1.Open/Close Coordinate window
:p.This will open the :link reftype=hd res=260.coordinate:elink. window if it is closed and close it if it is open.  Simple, right?


:h3 name=Open_Close_Points_List_Panel_300  res=300.Open/Close Points List Panel
.*:EditTime=959968057
.*:EditUser=1
:i1.Open/Close Points List Panel
:p.This will open the :link reftype=hd res=140.points list panel:elink. if it is closed and close it if it is open.  Simple, right?

:h2 name=Settings_Menu_55  res=55.Settings Menu
.*:EditTime=940946316
.*:EditUser=1
:i1.Settings Menu
:p.There are controls for&colon.
:p.
:ul compact .
:li.the :link reftype=hd res=280.transformation:elink. (image X,Y to data coordinates),

:li.:link reftype=hd res=60.image painting:elink.,

:li.:link reftype=hd res=65.font selection:elink..
:eul.


:h3 name=Setup_280  res=280.Transformation Setup
.*:EditTime=959971570
.*:EditUser=1
:i1.Setup
:p.Setup is a series of steps.  Assuming you are doing a new image or you have selected the initialize pushbutton you will be stepped
.*BR
through the process.  

:artwork align=center name='D:\SOURCE\VISPROSOURCE\DIGITIZE2\SETUPPANEL.BMP'.

:p.You first have to pick a point in the image and then you must enter the coordinates for that point.  After you are satisfied
.*BR
with both sets of values select the OK checkbox.  

:p.Then you must pick a second point.  The panel is phrased as though you must pick a point in the extreme right.  This is not a
.*BR
requirement, but it is usually prudent.  After you have clicked on the image you will have to type in the data coordinates for the
.*BR
point.  After you are satisfied with both sets of values select the OK checkbox.

:p.Finally, pick a third point.  As with the second point, it is prudent to put it in the upper left corner of the data.  After
.*BR
you are satisfied with both sets of values select the OK checkbox.

:p.This will cause the transformation image data to be computed and the setup window will close.  Note that :hp2.Digitize2:ehp2.
.*BR
:hp8.assumes the axes of the image being digitized are linear:ehp8..  Log, polar and other coordinate geometries are not supported.

:p.If an existing transformation is available the image and data coordinate values for all three points will be visible.  They may
.*BR
be manually edited if necessary.  Selecting the OK checkbox in the lower right corner of the setup panel will compute the transformation
.*BR
and close the setup window.

:p.The coordinates you enter must be a pair of numbers.  :hp2.Digitize2:ehp2. will read the field, replace any commas with blanks
.*BR
and then take the first string found and the remainder of the string as two numbers.  Thus you may enter

:sl compact .

:li.2.1 3999
:li.2.1, 3999
:li.3999, 2.1
:li.3999     2.1
:li.3.999E+3 0.21E+1

:esl.

:p.as valid coordinates.  But you may not enter

:sl compact .
:li.2.1 3,999
:li.2_1 3999
:li.14Eh 3999
:li.'14E'x  3999
:li.&pi. 3999
:li.100100110b 3999
:li.1/10 3999
:esl.

:h3 name=Paint_Settings_60  res=60.Paint Settings
.*:EditTime=940946213
.*:EditUser=1
:i1.Paint Settings
:p.These are taken straight from the VisProRexx example program VPPaint.  Their operation should be fairly obvious.  In my work I
.*BR
have used several different video cards and have found that how well some of these function is extremely variable.  As I have no
.*BR
control over them if they work for you, fine.  Otherwise, ....


:h3 name=Font_65  res=65.Font
.*:EditTime=940946276
.*:EditUser=1
:i1.Font
:p.Font selection.  Now what more can I say here?


:h1 name=Recommendations__amp__Comments_145  res=145.Recommendations &amp. Comments
.*:EditTime=959968122
.*:EditUser=1
:i1.Recommendations &amp. Comments
:p.Set up of the transformation is critical.  You should always test the validity of the transformation being done by picking several
.*BR
points whose data coordinates are known.  For example pick two or three points along the axis.

:p.The transformation operation uses a linear operation in X and a linear operation in Y.  This is done to handle rotation and scaling
.*BR
problems.  Scaling problems are common in images derived from data obtained off of zerographically reproduced material.

:p.The image is edited as digitization is done.  Therefore you will be asked if you want to save the image when you close the program.
.*BR
 On large tasks this is a real benefit as it lets you keep track of your progress.

:p.:hp2.Digitize2:ehp2. does not edit existing information in the points file.  If you need to do this, use an editor.

:h1   res=1050.Installation
.*:EditTime=959791087
.*:EditUser=1
:i1.Installation
:p.:hp2.Digitize2:ehp2. is an OS/2 REXX program utilizing one or more of these packages&colon. REXXIPC, REXXLIB, RXU, VREXX and VisProREXX.
.*BR
 The following table shows what &per.dlls and &per.exes must be present on your system and suggested locations for these files. 
.*BR
Other necessary parts of VisProREXX are within the executable.

:p.Unless you are an ELASII user the Digitize2.hlp file must be in same directory as :hp2.Digitize2:ehp2..



:table cols='13 13 13 27 11' rules=both frame=box.
:row.
:c."DLLs"
:c."EXEs"
:c.Used by
:c.Suggested Location
:c.Used in this program?
:row.
:c.rexxlib.dll    
:c.
:c.rexxlib
:c.boot&colon./OS2/apps/dll
:c.yes
:row.
:c.rxu.dll
:c.
:c.rxu
:c.boot&colon./OS2/apps/dll
:c.yes
:row.
:c.VPIMGEDT.DLL
:c.
:c.VisProRexx
:c.boot&colon./OS2/apps/dll
:c.yes
:row.
:c.VPPTNSEL.DLL
:c.
:c.VisProRexx
:c.boot&colon./OS2/apps/dll
:c.yes
:row.
:c.VPCLRSEL.DLL
:c.
:c.VisProRexx
:c.boot&colon./OS2/apps/dll
:c.yes
:row.
:c.VPUTIL.DLL
:c.
:c.VisProRexx
:c.boot&colon./OS2/apps/dll
:c.yes
:row.
:c.VPOBJ.DLL
:c.
:c.VisProRexx
:c.boot&colon./OS2/apps/dll
:c.yes
:etable.


:h1 name=License_160  res=1060.Licenses
.*:EditTime=940448290
.*:EditUser=1
:i1.License
:p.Where used in the Licenses section and appended subsections, the phrase 'this program' refers to :hp2.Digitize2:ehp2..

:p.This program is copyrighted.  It may be freely distributed provided this copyright is retained with the program.  It is provided
.*BR
free of charge and with no warranty of any kind.

:p.For copies of the software licenses which cover, where appropriate, the included code within this program see&colon.  

:ul.

:li.:link reftype=hd res=1070.REXXLIB:elink. 

:li.:link reftype=hd res=1075.VisProREXX:elink.

:li.:link reftype=hd res=1090.RXU:elink.

:eul.


:h2 name=RexxLib_170  res=1070.RexxLib
.*:EditTime=937842801
.*:EditUser=1
:i1.RexxLib
:p.REXXLIB is copyrighted software belonging to Quercus Systems and is included by permission of Quercus Systems.   Users of this
.*BR
program are not permitted to use REXXLIB except in conjunction with this program.  Any further use by an end user (except for evaluation)
.*BR
requires purchase of at least a basic registration from Quercus Systems.

:xmp.
  Use of REXXLIB in this program is according to the following terms from my (Doug Rickman) REXXLIB license  - 
  
 The executable portions (only) of REXXLIB may be included with commercial, "shareware", or "freeware" application software or applications
.*BR
distributed "in house"
  as long as you pay for one full registration and agree to the following terms and conditions:
 
   1. Only executable .EXE and .DLL files may be included. No other copyrighted files of Quercus Systems (including all or any portion
.*BR
of the online documentation)
      may be included with the product.
 
   2. Included files must not be modified in any way. In particular, embedded copyright notices must be left intact.
 
   3. Your documentation should explicitly state that REXXLIB is copyrighted software belonging to Quercus Systems and is included
.*BR
with your software by permission 
      of Quercus Systems.
 
   4. Users of your product are not permitted to use REXXLIB except in conjunction with your product. Any further use by an end
.*BR
user (except for evaluation)
      requires purchase of at least a basic registration.
 
   5. No part of REXXLIB may be included with other collections of tools or libraries intended primarily for use by programmers.
   

:exmp.


:h2 name=VisProRexx_175  res=1075.VisProRexx
.*:EditTime=959791044
.*:EditUser=1
:i1.VisProRexx
:p.VisProREXX is copyrighted software belonging to Hockware, Inc. and is included in this program by permission of Hockware.   Users
.*BR
are not permitted to use VisProREXX except in conjunction with this program.  Any further use by an end user (except for evaluation)
.*BR
requires purchase of at least a registration from Hockware, Inc.

:p.  Use of VisProREXX in this program is according to the following terms from my (Doug Rickman) VisProREXX license  -   (Darn,
.*BR
I cannot find the terms in any of my on-line documentation!!!)  It is only in the printed manual and I'll be darned if I'll retype
.*BR
it.


:h2 name=RXU_190  res=1090.RXU
.*:EditTime=937842829
.*:EditUser=1
:i1.RXU
:p.According to the author's upload notes attached with RXU.zip RXU is a public domain (free ware) package.

:xmp. 
RXU is a package of diverse OS/2 Rexx External Functions.  
 
   Author:        Dave Boll
                  (CompuServe = 74170,2016)
                  Internet: 74170.2016@compuserve.com
   Release Date:  6 April, 1996
   Version:       1.a
   
:exmp.


:h1   res=1040.Author
.*:EditTime=940965366
.*:EditUser=1
:i1.Author
:sl compact .
:li.Doug Rickman
:li.Global Hydrology and Climate Center
:li.Marshall Space Flight Center/NASA
:li.977 Explorer Blvd. 
:li.Huntsville, Alabama 35806
:li.256-922-5889
:li.doug@hotrocks.msfc.nasa.gov
:li.
:li.Current Revision of documentation Oct 26, 1999
:esl.

:p.Digitize2 is based on a VisProRexx program, VPPaint, which comes with VisProRexx Gold 3.1.              


:h1 name=Change_History_130  res=130.Change History
.*:EditTime=959968122
.*:EditUser=1
:i1.Change History
:p.May 31, 2000
:ol compact.
:li.First release.
:eol.

:p.June 2, 2000
:ol compact.
:li.Bug stomping!
:li.Added format control to coordinate panel.
:li.Added points list panel.
:eol.


.*EndDocPanels

.*FootnotesHere

:euserdoc.
