/*****************************/
/* REXX command-line install */
/*****************************/
/*        BMPMan             */
/*****************************/

'@echo off'
'cls'

SIGNAL ON FAILURE
SIGNAL ON ERROR

CALL RxFuncAdd "SysLoadFuncs","REXXUTIL","SysLoadFuncs"
CALL SysLoadFuncs

CurDir=DIRECTORY()
ViewPath=SysSearchPath('PATH','VIEW.EXE')
if ViewPath='' then
  do
     say ''
     say 'Error!  VIEW.EXE not found!  INF Files will use C:\OS2\VIEW.EXE...'
     ViewPath='C:\OS2\VIEW.EXE'
  end
EPath=SysSearchPath('PATH','E.EXE')
if EPath='' then
  do
     say ''
     say 'Error!  E.EXE not found!  Text Files will use C:\OS2\E.EXE...'
     ViewPath='C:\OS2\E.EXE'
  end

say ''
say '*********************************************'
say '*      Welcome to the BMPMan/2 Install      *'
say '*********************************************'
say ''
say 'The install will create objects on your desktop using the'
say 'current directory.  If this is not what you want, move the'
say 'program file(s) to their destination directory and re-run'
say 'the install program.'
say ''
call charout,'Press any key to start Install or Q to quit...'
parse upper value SysGetKey('NOECHO') with key
if key='Q' then
  EXIT

say ''

classname='WPFolder'
title='BMPMan/2'
location='<WP_DESKTOP>'
setup='CCVIEW=NO;ICONFILE='||CurDir||'\BMPFOLD.ICO;OBJECTID=<BMPMAN_FOLDER>;'
option='R'
call BldObj

classname='WPProgram'
title='BMPMan/2'
location='<BMPMAN_FOLDER>'
setup='EXENAME='||CurDir||'\BMPMAN.EXE;STARTUPDIR='||CurDir||';OBJECTID=<BMPMAN_PROG>;'
option='R'
call BldObj

classname='WPProgram'
title='BMPMan'||'0A'x||'Information'
location='<BMPMAN_FOLDER>'
setup='EXENAME='||ViewPath||';ICONFILE='||CurDir||'\BMPINF.ICO;PARAMETERS=BMPMAN.INF;STARTUPDIR='||CurDir||';OBJECTID=<BMPMAN_INFO>;'
option='R'
call BldObj

classname='WPProgram'
title='Order Form'
location='<BMPMAN_FOLDER>'
setup='EXENAME='||EPath||';PARAMETERS='||CurDir||'\ORDER.FRM;STARTUPDIR='||CurDir||';OBJECTID=<BMPMAN_ORDERFRM>;'
option='R'
call BldObj

StartupDrive=SysSearchPath('PATH','CONFIG.SYS')
StartupDrive=FILESPEC("drive",StartupDrive)
if STREAM('VPREXX.DLL','C','QUERY EXISTS') \= '' then
do
  say ''
  say 'VPREXX.DLL must be present in a directory contained in the LIBPATH'
  say 'variable in config.sys.  I recommend '||StartupDrive||'\OS2\DLL'
  call charout,'Would you like to copy VPREXX.DLL to '||StartupDrive||'\OS2\DLL (Y/N)?'
  parse upper value SysGetKey('NOECHO') with key
  if key ='Y' then
    do
       say ''
       'COPY VPREXX.DLL '||StartupDrive||'\OS2\DLL > nul'
    end
  else
    do
       say ''
       say 'Okay, then remember to place VPREXX.DLL in a directory contained in your LIBPATH!'
    end
end

say ''
call charout,'Press any key to exit...'
key=SysGetKey('NOECHO')
EXIT

/* Build Object Procedure */
BldObj:
call charout ,'Building: 'title substr(classname,3,)

result = SysCreateObject(classname, title, location, setup, option)

If result=1 Then call charout ,' ...Created!'
else
  call charout ,' ...Not created! Return code='result
say ' '
Return

/*****************************************************************************/
 * Standard REXX program error handler
 *****************************************************************************/
ERROR:
    say ''
    SAY 'An install error has occurred...'
    EXIT

FAILURE:
    say ''
    SAY 'An install error has occurred...'
    EXIT

