#include <sys/types.h>
#include <dirent.h>
#include <io.h>
#include <sys/stat.h>
#include "zsh.h"
#undef stat
#undef opendir
#undef closedir
#undef readdir
#undef seekdir
#undef telldir

struct DIRX {
    struct DIRX *next;
    DIR *de;
    int now;
};

static struct DIRX* dirstart = 0;

DIR *wrap_opendir(name)
const char *name;
{
    char *buf;
    char namesub[] = "a:./";
    char *n;
    char *rt;
    DIR *ret;
    struct dirent *rdd;
    char *namSK;

    namSK = alloca(strlen(name)+1);
    strcpy(namSK,name);	
    strEtoSK(namSK);	
    name = namSK;
	
    if (*name && name[1] == ':' && name[2] == '\0') {
	namesub[0] = *name;
	n = namesub;
    } else if ((*name == '/') && isset(REFERSYSROOT) && (rt = zgetenv("SYSROOT"))){
	buf = alloca(strlen(name) + strlen(rt) + 2);
	strcpy(buf,sysroot(name));
	n = buf;
    } else {
	buf = alloca(strlen(name) + 2);
	strcpy(buf,name);
	n = buf;
    }
    ret = opendir(n);

    if (!ret)
	return ret;
/*  if (!strcmp(name, "/") || (*name && !strcmp(name+1, ":/"))) {*/
    rdd = readdir(ret);
    seekdir(ret,0);
						/* In the case of root dir, execute below line */
    if (!rdd || strcmp(rdd->d_name, ".")) {
	struct DIRX *i;
	i = (struct DIRX *) zalloc(sizeof(struct DIRX));
	i->next = dirstart;
	i->de  = ret;
	i->now  = 0;
	dirstart = i;
    }
    return ret;
}

struct dirent *wrap_readdir(de)
DIR *de;
{
    static struct dirent d;
    struct dirent *ret = NULL;
    struct DIRX *i;
    static struct {
    	ino_t   d_ino;
	int     d_reclen;
	int     d_namlen;
	char    d_name[MAXNAMLEN*2+1];
    } newret;
    int match = 0;
    for (i = dirstart; i; i=i->next){
	if (i->de == de) {
	    switch ((i->now)++) {
	      case 0:
		d.d_ino = 0;
		d.d_reclen = 0;
		d.d_namlen = 1;
		strcpy(d.d_name, ".");
		ret = &d;
		break;
	      case 1:			
		d.d_ino = 0;
		d.d_reclen = 0;
		d.d_namlen = 2;
		strcpy(d.d_name, "..");
		ret = &d;
		break;
	      default:
		ret = readdir(de);
		while (ret && (!strcmp(ret->d_name,".") || !strcmp(ret->d_name,"..")))
		    ret = readdir(de);
	    }
	    match = 1;
	    break;
	}
    }
    if (!match) ret = readdir(de);
    if (!ret)
	return ret;
    
    if ((ret->d_name)[ret->d_namlen - 1] == '/') {
	(ret->d_name)[--(ret->d_namlen)] = '\0';
    }

    newret.d_ino = ret->d_ino;
    newret.d_reclen = ret->d_reclen;
    newret.d_namlen = ret->d_namlen;
    strcpySKtoE(newret.d_name, ret->d_name);
    ret = (struct dirent*)&newret;		/* danger!!! */

    return ret;
}

void  wrap_seekdir(de, offset)
DIR *de;
off_t offset;
{
    struct DIRX *i;
    for (i = dirstart; i; i=i->next){
	if (i->de == de) {
	    i->now = offset;
	    if (offset < 2) {
		seekdir(de, 0);
		return;
	    } else {
		seekdir(de, offset - 2);
		return;
	    }
	}
    }
    seekdir(de,offset);
    return;
}

void  wrap_closedir(de)  /**/
DIR *de;
{
    struct DIRX *i, *n;
    n = 0;
    closedir(de);
    for (i = dirstart; i; i=i->next){
	if (i->de == de) {
	    if (n) {
		n->next = i->next;
		free(i);
		return;
	    } else {
		dirstart = i->next;
		free(i);
		return;
	    }
	}
	n = i;
    }
}

off_t wrap_telldir(de)  /**/
DIR *de;
{
    struct DIRX *i, *n;
    n = 0;
    for (i = dirstart; i; i=i->next){
	if (i->de == de) {
	    if (i->now < 2) {
		return (off_t) i->now;
	    } else {
		return (off_t) (telldir(de) + 2);
	    }
	}
    }
    return telldir(de);
}

int wrap_stat( const char *name, struct stat *buf ) {
  char name2[FILENAME_MAX];

  strcpy( name2, name );
  if ( isalpha( name2[0] ) && name2[1] == ':' && name2[2] == 0 ) {
      if ( 0 > _getcwd1( name2+2, name2[0]&0x5f ) ) {
	  errno = ENOENT;
	  return -1;
      }
  }
  return stat( name2, buf );
}
