#define KCGLOBAL
#include "zsh.h"
#include "ctypes.h"

unsigned char *strlowerE(s) /**/
unsigned char *s;
{
    unsigned char *ret = s;

    while (*s) {
/*  if (isEkanji(*s) && isEkanji2(*(s+1)) || isEkana1(*s) && isEkana2(*(s+1)))*/
	if ( (isEkanji(*s) && isEkanji2(*(s+1))) || isEkana1(*s))
	    s+=2;
	else if (isupper(*s)) {
	    *s = (unsigned char) tolower(*s);
	    s++;
	} else {
	    s++;
	}
    }
    return ret;
}

unsigned char *strcpyEtoSK(d,s) /**/
unsigned char *d;
unsigned char *s;
{
    unsigned char *ret = d;
    while (*s){
	if (isEkanji(*s) && isEkanji2(*(s+1))) {
	    *d++ = *s++;
	    *d++ = *s++;
	    EtoS(d-2, d-1);
	} else if(isEkana1(*s)) {
	    s++;
	    *d++ = *s++;
	} else
	    *d++ = *s++;
    }		
    *d = 0;	
    return ret;
}

/* strcpySKtoE: d̃obt@ŝQ{ȂƂȂ */
unsigned char *strcpySKtoE(d, s) /**/
unsigned char *d;
unsigned char *s;
{
	unsigned char *ret;
	ret = d;
	while (*s) {
		if (isSkanji(*s) && isSkanji2(*(s+1))) {
			*d++ = *s++;
			*d++ = *s++;
			StoE(d-2, d-1);
		} else if (iskana(*s)) {
			*d++ = 0xa0;
			*d++ = *s++;
		} else
			*d++ = *s++;
		}
	*d = 0;
	return ret;
}

void	StoE(C1, C2) /**/
unsigned char *C1;
unsigned char *C2;
{
    int c1 = *C1, c2 = *C2;
    int	b1, b2;
    
    if(c1) {
						/* kanji character. */
	b1 = c1 & 0xff;				/* Shift-JIS first byte */
	b2 = c2 & 0xff;				/* Shift-JIS second byte */
	c1 -= (c1 < 0xa0) ? 0x71 : 0xb1;
	c1 = (c1 << 1) + 1;
	if(c2 > 0x7f)
	    --c2;
	if(c2 > 0x9d) {
	    c2 -= 0x7d;
	    ++c1;
	}
	else
	    c2 -= 0x1f;
	*C1 = (c1 | 0x80);
	*C2 = (c2 | 0x80);
    } else {					/* ank character. */
/*	if(iskana(c2))
	    putchar(0x8e);
	    putchar(c2);
*/
    }
}

void	EtoS(C1, C2) /**/
unsigned char *C1;
unsigned char *C2;
{
    int c1 = *C1, c2 = *C2;

    if(c1 == 0)					/* ank character. */
/*	putchar(c2);*/
	;
    else if(isEkana1(c1)) {
	*C1 = c2;
	*C2 = c2;
    } else {
						/* kanji character. */
	c1 &= 0x7f;
	c2 &= 0x7f;
	if(c1 & 1)
	    c2 += 0x1f;
	else
	    c2 += 0x7d;
	if(c2 >= 0x7f)
	    ++c2;
	c1 = ((c1 - 0x21) >> 1) + 0x81;
	if(c1 > 0x9f)
	    c1 += 0x40;
	*C1 = c1;
	*C2 = c2;
    }
}

int strElen(s) /**/
unsigned char *s;
{
    int len = 0;
    while (*s){
	if (isEkanji(*s) && isEkanji2(*(s+1))) {
	    s += 2;
	    len += 2;
	} else if(isEkana1(*s)) {
	    s += 2;
	    len++;
	} else {
	    s++;
	    len++;
	}
    }
    return len;
}

unsigned char *strdupEtoSK(s) /**/
unsigned char *s;
{
    unsigned char *ret, *d;
    ret = d = malloc(strlen(s) + 1);
    while (*s){
	if (isEkanji(*s) && isEkanji2(*(s+1))) {
	    *d++ = *s++;
	    *d++ = *s++;
	    EtoS(d-2, d-1);
	} else if(isEkana1(*s)) {
	    s++;
	    *d++ = *s++;
	} else
	    *d++ = *s++;
    }		
    *d = 0;	
    return ret;
}

unsigned char *strtmpEtoSK(s) /**/
unsigned char *s;
{
    static unsigned char *ret = NULL;
    if (ret)
	free(ret);
    ret = strdupEtoSK(s);
    return ret;
}

unsigned char *strdupSKtoE(s) /**/
unsigned char *s;
{
    unsigned char *d, *ret;
    d = ret = (unsigned char *) malloc(strlen(s)* 2 + 2);
    while (*s) {
	if (isSkanji(*s) && isSkanji2(*(s+1))) {
	    *d++ = *s++;
	    *d++ = *s++;
	    StoE(d-2, d-1);
	} else if (iskana(*s)) {
	    *d++ = 0xa0;
	    *d++ = *s++;
	} else
	    *d++ = *s++;
    }
    *d = 0;
    return ret;
}

void strSKtoE(s) /**/
unsigned char *s;
{
    static unsigned char *buf;
    unsigned char *d, *ss = s;
    d = buf = (char *) alloca(strlen(s)*2 +1);
/*  while (*s && MAXNAMLEN*2 >(d - buf)) {*/
    while (*s) {
	if (isSkanji(*s) && isSkanji2(*(s+1))) {
	    *d++ = *s++;
	    *d++ = *s++;
	    StoE(d-2, d-1);
	} else if (iskana(*s)) {
	    *d++ = 0xa0;
	    *d++ = *s++;
	} else
	    *d++ = *s++;
    }
    *d = 0;
    strcpy(ss,buf);
}

void strEtoSK(s) /**/
unsigned char *s;
{
    unsigned char *d = s;
    while (*s){
	if (isEkanji(*s) && isEkanji2(*(s+1))) {
	    *d++ = *s++;
	    *d++ = *s++;
	    EtoS(d-2, d-1);
	} else if(isEkana1(*s)) {
	    s++;
	    *d++ = *s++;
	} else
	    *d++ = *s++;
    }
    *d = 0;	
}

int	hankakulen(s) /**/
unsigned char *s;
{
    int ret = 0;
    
    for (;*s;s++) {
/*	if (isEkana1(*s) && isEkana2(*(s+1))){*/
	if (isEkana1(*s)) {
	    ret++;
	    s++;
	}
    }

    return ret;
}

unsigned char *strtmpSKtoE(s) /**/
unsigned char *s;
{
    static unsigned char *ret;
    if (ret)
	free(ret);
    ret = strdupSKtoE(s);
    return ret;
}

