/*
 *
 * exec.c - command execution
 *
 * This file is part of zsh, the Z shell.
 *
 * This software is Copyright 1992 by Paul Falstad
 *
 * Permission is hereby granted to copy, reproduce, redistribute or otherwise
 * use this software as long as: there is no monetary profit gained
 * specifically from the use or reproduction of this software, it is not
 * sold, rented, traded or otherwise marketed, and this copyright notice is
 * included prominently in any copy made.
 *
 * The author make no claims as to the fitness or correctness of this software
 * for any use whatsoever, and it is provided as is. Any use of this software
 * is at the user's own risk.
 *
 */

#ifdef __EMX__
# define INCL_DOS
# include <sys/process.h>
#endif
#include "zsh.h"
#include <errno.h>
#ifdef SJIS
# include "ctypes.h"
#endif
#ifdef __human68k__
# include "doslib.h"
# include <errno.h>
extern volatile int time_User_count;
extern volatile int time_System_count;
extern int _keep_cwd_on_exec;
extern int timecount;
#endif

#ifdef __human68k__
#define execerr() { closemnodes(mfds); lastval = 1; return; }
#else
#define execerr() { if (forked) _exit(1); \
	closemnodes(mfds); lastval = 1; return; }
#endif

#ifndef __human68k__
static Lklist args;
#endif

/* parse list in a string */

List parselstring(s)		/**/
char *s;
{
    List l;

    hungets(s);
    strinbeg();
    pushheap();
    if (!(l = parse_list())) {
	strinend();
	hflush();
	popheap();
	return NULL;
    }
    strinend();
    return l;
}

/* execute a string */

void execstring(s)		/**/
char *s;
{
    List l;

    if ((l = parselstring(s))) {
	execlist(l);
	popheap();
    }
}

/* fork and set limits */

int phork()
{				/**/
    int pid;

#ifdef RLIM_INFINITY
    int t0;

#endif

    if (thisjob >= MAXJOB - 1) {
	zerr("job table full", NULL, 0);
	return -1;
    }
    pid = fork();
    if (pid == -1) {
	zerr("fork failed: %e", NULL, errno);
	return -1;
    }
#ifdef RLIM_INFINITY
    if (!pid)
	for (t0 = 0; t0 != RLIM_NLIMITS; t0++)
	    setrlimit(t0, limits + t0);
#endif
    return pid;
}


static int list_pipe = 0, nowait, list_pipe_pid, pline_level = 0;
static int list_pipe_child = 0, list_pipe_job;
static char list_pipe_text[JOBTEXTSIZE];

/* execute a current shell command */

int execcursh(cmd)		/**/
Cmd cmd;
{
    if (!list_pipe)
	deletejob(jobtab + thisjob);
    runlist(cmd->u.list);
    cmd->u.list = NULL;
    return lastval;
}

/* execve after handling $_ and #! */

#define POUNDBANGLIMIT 64

#ifdef __human68k__
int zexecve(pth_, argv,execscript)
char *pth_;
char **argv;
int execscript;
{
#elif defined(__EMX__)
struct ttyinfo shttyinfo2;
int zexecve(pth_, argv)	/**/
char *pth_;
char **argv;
{
#else
int zexecve(pth, argv)
char *pth;
char **argv;
{
#endif
    int eno;
    static char buf[MAXPATHLEN * 2];
    char **eep;
#ifdef __human68k__
    int errnoX, saveSignal;
#endif
#if defined(__human68k__) || defined(__EMX__)
    char **ep, **ep_path, **ep_PATH, *ep_newpath, *ep_pathbak = NULL;
    char *ep_PATHbak = NULL;
    char **envi_export,**envp,**envp2;
    int ct, imargin,i;
    char *pth, *pth2;

    pth = strdupEtoSK(pth_);
    if (*pth == '/' && isset(REFERSYSROOT) && zgetenv("SYSROOT"))
	pth2 = ztrdup(sysroot(pth));
    else
	pth2 = NULL;
#endif

    for (eep = environ; *eep; eep++)
	if (**eep == '_' && (*eep)[1] == '=')
	    break;
    buf[0] = '_';
    buf[1] = '=';
#ifdef __human68k__
    setintenv("COLUMNS",columns);
    setintenv("LINES",lines);
#endif
#ifdef HAS_DRIVE
    if (*pth == '/' || (*pth && pth[1] == ':' && pth[2] == '/'))
#else
    if (*pth == '/')
#endif
	strcpy(buf + 2, pth);
    else
	sprintf(buf + 2, "%s/%s", pwd, pth);
    if (!*eep)
	eep[1] = NULL;
    *eep = buf;

#if defined(__human68k__) || defined(__EMX__)
    if (pth2) { /* refersysrootȏꍇ _=/foo/barꂽdrivetpXݒ */
	free(pth);
	pth = pth2;
    }
    for (envp = environ, ct = 2; *envp; envp++,ct++);
    envp = environ;
    imargin = getiparam("ENVMARGIN");
    envi_export = envp2 = (char **) zalloc(sizeof(char *)*(ct+imargin));
    for (; *envp; envp++)
	*envp2++ = strdupEtoSK(*envp);
    for (i = 0; i < imargin; i++)
	*envp2++ = "";
    *envp2 = NULL;

    ep_path = ep_PATH = 0;
    for (ep = envi_export; *ep; ep++) {
	if (!strncmp("path=", *ep,5)) {
	    ep_path = ep;
	    if (ep_PATH != 0)	break;
	}
	if (!strncmp("PATH=", *ep, 5)) {
	    ep_PATH = ep;
	    if (ep_path != 0)	break;
	}
    }
    ep_newpath=0;
    if (ep_path !=0 && ep_PATH != 0) {
	char *tmps;
	tmps = ztrdup(join(path,';'));
	ep_newpath = zalloc(strlen(tmps) + 6);
#if defined(__human68k__)
	strcpy(ep_newpath, "path=");
	strcat(ep_newpath, tmps);
	free(tmps);
	convert_slash_to_backslash(ep_newpath);
	ep_pathbak = *ep_path;
	*ep_path = ep_newpath;

	ep_newpath = ztrdup(*ep_PATH);			
	ep_PATHbak = *ep_PATH;
	*ep_PATH = ep_newpath;
#else
	strcpy(ep_newpath, "PATH=");
	strcat(ep_newpath, tmps);
	free(tmps);
	convert_slash_to_backslash(ep_newpath);
	ep_PATHbak = *ep_PATH;
	*ep_PATH = ep_newpath;

	ep_newpath = ztrdup(*ep_path);
	ep_pathbak = *ep_path;
	*ep_path = ep_newpath;
#endif
    }
#endif						/* human or emx */
#ifdef __human68k__
    /*JgfBNgۑ _keep_cwd_on_exec = 1, (ۑ = 0) */
    _keep_cwd_on_exec = 1;	
    for (pi = pth + strlen(pth) -1; pi > pth; pi--){
	if (*pi == '/' || *pi == ':') {
	    pi++;
	    break;
	}
    }
    for (pp = cdcmds; *pp; pp++){
	if (!stricmp(pi, *pp)) {
	    _keep_cwd_on_exec = 0;	
	    break;
	}
    }
    saveSignal = signal(SIGINT, SIG_DFL);
    if (strlen(pth) > 4 && !stricmp(&pth[strlen(pth)-4], ".bat")) {
#define BATARGC 10
	int argc = 0;
	char *ptr;
	char *ptr2 , *ptrh[BATARGC];
	char **ptr3, **av, **ptr4, *ptr5;
	if (ptr = zgetenv("BATSHELL")) {
	    ptr = ztrdup(ptr);
	} else {
	    ptr = ztrdup("COMMAND.X");
	}
	for(ptr2 = ptr, argc = 0, ptr3 = ptrh; *ptr2 && argc < BATARGC;){
	    while(*ptr2 == ' ')
		*ptr2++ = '\0';
	    if (!*ptr2) break;
	    ptrh[argc++] = ptr2;
	    while(*ptr2 && *ptr2 != ' ')
		ptr2++;
	    if (!*ptr2) break;
	}
	ptrh[argc] = 0;
	convert_slash_to_backslash(ptr5 = ztrdup(argv[0]));
	for (ptr3 = argv; *ptr3; ptr3++)
	    argc ++;
	av = ptr3 = (char **) malloc((sizeof (char *) + 2) * argc);
	for (ptr4 = ptrh; *ptr3++ = *ptr4++; ) ;
	*(ptr3 - 1) = ptr5;
	for (ptr4 = argv+1; *ptr3++ = *ptr4++; ) ;
	errnoX = spawnve(P_WAIT,av[0],av,envi_export);
	free(av);
	free(ptr);
	free(ptr5);
    } else {
	errnoX = spawnve(P_WAIT,pth,argv,envi_export);
    }
    signal(SIGINT, saveSignal);

    if (errnoX >= 0) {
	/* spawn success */
	int func;
	char *dir;
	errno = -1;
#define BIN_CD 11
#define BIN_PUSHD 13
	if (!_keep_cwd_on_exec){ /* cd\R}hɂcdۂ̌㏈ */
	    if (isset(AUTOPUSHD))
		func = BIN_PUSHD;
	    else 
		func = BIN_CD;
	    dir = zgetwd();
	    cd_new_pwd(func, dir);
	    free(dir);
	}
    }
#elif defined(__EMX__)
    if (strlen(pth) > 4 && (!stricmp(&pth[strlen(pth)-4], ".bat") || !stricmp(&pth[strlen(pth)-4], ".cmd")) ) {
#define BATARGC 10
	int argc = 0;
	char *ptr;
	char *ptr2 , *ptrh[BATARGC];
	char **ptr3, **av, **ptr4, *ptr5;
	if ( (ptr = zgetenv("COMSPEC")) ) {
	    ptr = ztrdup(ptr);
	} else {
	    ptr = ztrdup("CMD.EXE");
	}
	for(ptr2 = ptr, argc = 0, ptr3 = ptrh; *ptr2 && argc < BATARGC;){
	    while(*ptr2 == ' ')
		*ptr2++ = '\0';
	    if (!*ptr2) break;
	    ptrh[argc++] = ptr2;
	    while(*ptr2 && *ptr2 != ' ')
		ptr2++;
	    if (!*ptr2) break;
	}
	ptrh[argc++] = "/C";
	ptrh[argc] = NULL;
	convert_slash_to_backslash(ptr5 = ztrdup(argv[0]));
	for (ptr3 = argv; *ptr3; ptr3++)
	    argc ++;
	av = ptr3 = (char **) malloc((sizeof (char *) + 2) * argc);
	for (ptr4 = ptrh; (*ptr3++ = *ptr4++); ) ;
	*(ptr3 - 1) = ptr5;
	for (ptr4 = argv+1; (*ptr3++ = *ptr4++); ) ;
	execve( av[0], av, envi_export );
    } else {
	ULONG apptype;
	if ( NO_ERROR == DosQueryAppType( pth, &apptype )
	    && apptype&FAPPTYP_EXETYPE == FAPPTYP_WINDOWAPI ) {
	    int ret = spawnve( P_PM, pth, argv, envi_export );
	    if ( 0 <= ret ) {
		exit( ret );
	    }
	} else
	    execve( pth, argv, envi_export );
    }
#else
    execve(pth, argv, environ);
#endif
#ifdef __human68k__
    if ((eno = errno) > 0 && execscript) {
#elif defined(__EMX__)
    if ((eno = errno) > 0 ) {
#else
    if ((eno = errno) == ENOEXEC) {
#endif
	char execvebuf[POUNDBANGLIMIT + 1], *ptr, *ptr2, *argv0;
	int fd, ct, t0;

	if ((fd = open(pth, O_RDONLY)) >= 0) {
	    argv0 = *argv;
	    *argv = pth;
	    ct = read(fd, execvebuf, POUNDBANGLIMIT);
	    close(fd);
	    if (ct > 0) {
		if (execvebuf[0] == '#')
		    if (execvebuf[1] == '!') {
			for (t0 = 0; t0 != ct; t0++)
			    if (execvebuf[t0] == '\n')
				execvebuf[t0] = '\0';
			execvebuf[POUNDBANGLIMIT] = '\0';
			for (ptr = execvebuf + 2; *ptr && *ptr == ' '; ptr++);
			for (ptr2 = ptr; *ptr && *ptr != ' '; ptr++);
			if (*ptr) {
			    *ptr = '\0';
			    argv[-2] = ptr2;
			    argv[-1] = ptr + 1;
#ifdef __human68k__
			    saveSignal = signal(SIGINT, SIG_DFL);
			    errnoX = spawnve(P_WAIT, ptr2, argv-2, envi_export);
			    signal(SIGINT, saveSignal);
			    if (errnoX >= 0)
				eno = errno = -1;
			    else
				eno = errno;
#elif defined(__EMX__)
			    execve(ptr2, argv - 2, envi_export);
#else
			    execve(ptr2, argv - 2, environ);
#endif
			} else {
			    argv[-1] = ptr2;
#ifdef __human68k__
			    saveSignal = signal(SIGINT, SIG_DFL);
			    errnoX = spawnve(P_WAIT, ptr2, argv-1, envi_export);
			    signal(SIGINT, saveSignal);
			    if (errnoX >= 0)
				eno = errno = -1;
			    else
				eno = errno;
#elif defined(__EMX__)
			    execve(ptr2, argv - 1, envi_export);
#else
			    execve(ptr2, argv - 1, environ);
#endif
			}
		    } else {
#ifdef __human68k__
			struct stat st;
			if (stat(pth,&st) >= 0 && (st.st_mode & S_IEXEC)) {
#endif
			argv[-1] = "sh";
#if defined(__human68k__)
			saveSignal = signal(SIGINT, SIG_DFL);
			errnoX = spawnve(P_WAIT, sysroot("/bin/sh"), argv-1, envi_export);
			signal(SIGINT, saveSignal);
			if (errnoX >= 0)
			    eno = errno = -1;
			else
			    eno = errno;
			} else
			    eno = ENOEXEC;
#elif defined(__EMX__)
			execve("sh", argv - 1, envi_export);
#else
			execve("/bin/sh", argv - 1, environ);
#endif
		} else {
#ifdef __human68k__
		    struct stat st;
		    if (stat(pth,&st) >= 0 && (st.st_mode & S_IEXEC)) {
#endif
		    for (t0 = 0; t0 != ct; t0++)
			if (!execvebuf[t0])
			    break;
		    if (t0 == ct) {
			argv[-1] = "sh";
#if defined(__human68k__)
			saveSignal = signal(SIGINT, SIG_DFL);
			errnoX = spawnve(P_WAIT, sysroot("/bin/sh"), argv-1, envi_export);
			signal(SIGINT, saveSignal);
			if (errnoX >= 0)
			    eno = errno = -1;
			else
			    eno = errno;
#elif defined(__EMX__)
			execve("sh", argv - 1, envi_export);
#else
			execve("/bin/sh", argv - 1, environ);
#endif
		    }
#ifdef __human68k__
		    } else
			eno = ENOEXEC;
#endif
		}
	    } else
		eno = errno;
	    *argv = argv0;
	} else
	    eno = errno;
    }
#if defined(__human68k__) || defined(__EMX__)
    if (ep_newpath) {
	free(*ep_path);
	free(*ep_PATH);
	*ep_path = ep_pathbak;
	*ep_PATH = ep_PATHbak;
    }
    for (envp = envi_export; *envp; envp++)
	free(*envp);
    free(pth);
    free(envi_export);
#if defined(__human68k__)
    lastval = errnoX;
#endif
#endif
    return eno;
}

#define MAXCMDLEN (MAXPATHLEN*4)

/* execute an external command */

#ifdef __human68k__
static char bufX[MAXPATHLEN];
#endif

#ifdef __human68k__
int execute(dash,args)
int dash;
Lklist args;
{
#else
void execute(dash)	/**/
int dash;
{
#endif
    static Lklist exargs;
    char **argv, *arg0, **pp;
    char *z, *s, buf[MAXCMDLEN], buf2[MAXCMDLEN];
    int ee, eno = 0;
    Cmdnam cn;
#ifdef __human68k__
    struct FILBUF attrs;
    int i;
    int slen, st;
    char *file, *ss, *sr;
#endif
#if defined(__EMX__)
    int i;
    int slen, st;
    char *file, *ss, *sr;
    HDIR FindHandle = HDIR_SYSTEM;
    ULONG FindCount = 1;
    FILEFINDBUF3 FindBuffer;
#endif

    if (empty(args)) {
	zerr("no command", NULL, 0);
#ifdef __human68k__
	return -1;
#else
	_exit(1);
#endif
    }
    if (!exargs && (s = zgetenv("STTY"))) {
	exargs = args;
	args = NULL;
	zyztem("stty", s);
	args = exargs;
	exargs = NULL;
    }
#if defined(__human68k__) || defined(__EMX__)
    arg0 = (unsigned char *) alloca(strlen(peekfirst(args))  + 4);
    strcpy(arg0, peekfirst(args));
#else
    arg0 = (char *)peekfirst(args);
#endif
    cn = (Cmdnam) gethnode(arg0, cmdnamtab);
#if defined(__human68k__) || defined(__EMX__)
/*
    if (!cn) {
	strcpy(bufX,arg0);
	killx68ext(bufX);
	cn = (Cmdnam) gethnode(bufX,cmdnamtab);
    }
*/
    if (cn && ISEXCMD(cn->flags)) {
	/* gq̈ႤR}h𐳂nbVȂ̂
	   C܂ł̎bĂ[u
	   nbVĂR}h̊gqarg0̊gqႤ
	   nbVĂȂƂɂ
	   */
	int j, exton = 0, hasslash = 0;
	char *p;
	for (p = arg0; *p; p++) {
	    if (*p == '/') {
		hasslash = 1;
		break;
	    }
	}
	if (!hasslash) {
	    for (i = 2; i <= x68extN; i++) {
		if ((j = strlen(arg0) - strlen(x68ext[i])) > 0 &&
		    !stricmp(&arg0[j], x68ext[i])) {
		    exton = 1;
		    break;
		}
	    }
	    if (exton) {
#if defined(__EMX__)
		for (p = cn->u.cmd + strlen(cn->u.cmd) - 1;  p >= cn->u.cmd; p--)
#else
		for (p = cn->u.name + strlen(cn->u.name) - 1;  p >= cn->u.name; p--)
#endif
		    if (*p == '/') {
			p++;
			break;
		    }
		if (stricmp(arg0, p))
		    cn = NULL;
	    }
	}
    }
#endif
    if (cn && (cn->flags & DISABLED))
	cn = NULL;
    if ((z = zgetenv("ARGV0"))) {
	setdata(firstnode(args), (void_ptr) ztrdup(z));
	delenv(z - 6);
    } else if (dash) {
	sprintf(buf2, "-%s", arg0);
	setdata(firstnode(args), (void_ptr) ztrdup(buf2));
    }
    argv = makecline(args);
    unblockchld();
    if ((int)strlen(arg0) > MAXPATHLEN) {
	zerr("command too long: %s", arg0, 0);
#ifdef __human68k__
	return -1;
#else
	_exit(1);
#endif
    }
#ifdef HAS_DRIVE
    for (s = arg0; *s; s++)
	if (*s == '/' || *s == ':') {
#if defined(__human68k__)	    
	    errno = zexecve(arg0,argv,1);
	    if (errno == -1) return lastval;
#else
	    errno = zexecve(arg0,argv);
#endif
	    if (arg0 == s || *s == ':' || unset(PATHDIRS)) {
		zerr("%e: %s",arg0,errno);
#if defined(__human68k__)	    
		return -1;
#else
		_exit(1);
#endif
	    }
	    break;
	}
#else
    for (s = arg0; *s; s++)
	if (*s == '/') {
	    errno = zexecve(arg0, argv);
	    if (arg0 == s || unset(PATHDIRS) ||
		(arg0[0] == '.' && (arg0 + 1 == s ||
				    (arg0[1] == '.' && arg0 + 2 == s)))) {
		zerr("%e: %s", arg0, errno);
		_exit(1);
	    }
	    break;
	}
#endif
#ifdef HAS_DRIVE
    if (isset(REFERSYSROOT))
	sr = zgetenv("SYSROOT");
    else
	sr = 0;
/* ő΃pXׂ̂̂Ă */
    if (cn && ISEXCMD(cn->flags)) {
	char nn[MAXPATHLEN];
		
	if (cn->flags & BUILTIN)
	    strcpy(nn, cn->u.cmd);
	else {
	    for (pp = path; pp < cn->u.name; pp++)
		if (**pp == '/' && !sr) {
		    buf[0] = CURDRV() + 'A';
		    buf[1] = ':';
		    z = buf+2;
		    strucpy(&z,*pp);
		    *z++ = '/';
		    strcpy(z,arg0);
#ifdef __human68k__
		    ee = zexecve(buf,argv,1);
		    if (ee == -1) return lastval;
#else
		    ee = zexecve(buf,argv);
#endif
		    if (ee != ENOENT) eno = ee;
		} else if (**pp != '/' && !(**pp && (*pp)[1] == ':' && (*pp)[2] == '/')) {
		    char *bufSK;
		    z = buf;
		    strucpy(&z,*pp);
		    *z++ = '/';
		    strcpy(z,arg0);

		    bufSK = (char *) alloca(strlen(buf)+1);
		    strcpyEtoSK(bufSK,buf);
#if defined(__human68k__)	    
		    if (FILES(&attrs, bufSK, 0x27) >= 0) {/*fBNg͂ */
			ee = zexecve(buf,argv,1);
			if (ee == -1) return lastval;
#elif defined(__EMX__)
		    FindHandle = HDIR_SYSTEM;  FindCount = 1;
		    if ( DosFindFirst( bufSK, &FindHandle, 0x27, (PVOID)&FindBuffer,
				       sizeof(FindBuffer), &FindCount, FIL_STANDARD ) == NO_ERROR ) {/*fBNg͂ */
			DosFindClose( FindHandle );
			ee = zexecve(buf,argv);
#endif
			if (ee != ENOENT) eno = ee;
		    }
		    
		    file = (char *) alloca((slen = strlen(bufSK))+5);
		    strcpy(file, bufSK);
		    strcat(file, "*.*");
#ifdef __human68k__
		    st = FILES(&attrs, file, 0x27);
		    if (ss = strrchr(bufSK, '/')){
			slen = bufSK - ss + slen -1;
		    }
		    if ( st >= 0 ){
			for (; st >= 0; st = NFILES( &attrs )) {
			    for (i = 2; i <= x68extN; i++){
				if (!stricmp(&attrs.name[slen],x68ext[i])){
				    ee = zexecve(buf,argv,1);
				    if (ee == -1) return lastval;
#elif defined(__EMX__)
		    FindHandle = HDIR_SYSTEM;  FindCount = 1;
		    st = DosFindFirst( file, &FindHandle, 0x27, (PVOID)&FindBuffer,
				       sizeof(FindBuffer), &FindCount, FIL_STANDARD );
		    if ( (ss = strrchr(bufSK, '/')) ){
			slen = bufSK - ss + slen -1;
		    }
		    if ( st == NO_ERROR ){
			for (; st == NO_ERROR; FindCount = 1, st = DosFindNext( FindHandle, (PVOID)&FindBuffer,
										sizeof(FindBuffer), &FindCount ) ) {
			    for (i = 2; i <= x68extN; i++){
				if (!stricmp(&FindBuffer.achName[slen],x68ext[i])){
				    ee = zexecve(buf,argv);
#endif
				    if (ee != ENOENT) eno = ee;
				}
			    }
			}
#if defined(__EMX__)
			DosFindClose( FindHandle );
#endif
		    }
		}
	    strcpy(nn, cn->u.name ? *(cn->u.name) : "");
	    strcat(nn, "/");
	    strcat(nn, cn->nam);
	}
#ifdef __human68k__
	ee = zexecve(nn,argv,1);
	if (ee == -1) return lastval;
#else
	ee = zexecve(nn,argv);
#endif
	if (ee != ENOENT)
	    eno = ee;
    }

#else
    if (cn && ISEXCMD(cn->flags)) {
	char nn[MAXPATHLEN];

	if (cn->flags & BUILTIN)
	    strcpy(nn, cn->u.cmd);
	else {
	    for (pp = path; pp < cn->u.name; pp++)
		if (**pp == '.' && (*pp)[1] == '\0') {
		    ee = zexecve(arg0, argv);
		    if (ee != ENOENT)
			eno = ee;
		} else if (**pp != '/') {
		    z = buf;
		    strucpy(&z, *pp);
		    *z++ = '/';
		    strcpy(z, arg0);
		    ee = zexecve(buf, argv);
		    if (ee != ENOENT)
			eno = ee;
		}
	    strcpy(nn, cn->u.name ? *(cn->u.name) : "");
	    strcat(nn, "/");
	    strcat(nn, cn->nam);
	}
	ee = zexecve(nn, argv);

	if (ee != ENOENT)
	    eno = ee;
    }
#endif
#ifdef HAS_DRIVE
    for (pp = path; *pp; pp++) {
	char *bufSK;
	z = buf;
	if (**pp == '/' && sr){
	    strucpy(&z,sr);
	    if (*(z-1) == '/')
		*(--z) = '\0';
	}
	strucpy(&z,*pp);
	if (z == buf || (*(z-1) != '/'))
	    *z++ = '/';
	strcpy(z,arg0);
	
	bufSK = (char *) alloca(strlen(buf)+1);
	strcpyEtoSK(bufSK,buf);

#if defined(__human68k__)
	if (FILES(&attrs, bufSK, 0x27) >= 0) {/*fBNg͂ */
	    ee = zexecve(buf,argv,1);
	    if (ee == -1) return lastval;
#elif defined(__EMX__)
	FindHandle = HDIR_SYSTEM;  FindCount = 1;
	if ( DosFindFirst( bufSK, &FindHandle, 0x27, (PVOID)&FindBuffer,
			   sizeof(FindBuffer), &FindCount, FIL_STANDARD ) == NO_ERROR ) {
	    DosFindClose( FindHandle );
	    ee = zexecve(buf,argv);
#endif
	    if (ee != ENOENT) eno = ee;
	}
	file = (char *) alloca((slen = strlen(bufSK))+5);
	strcpy(file, bufSK);
	strcat(file, "*.*");
#if defined(__human68k__)
	st = FILES(&attrs, file, 0x27);
	if (ss = strrchr(bufSK, '/')){
	    slen = bufSK - ss + slen -1;
	}
	if (st >= 0){
	    for (; st >= 0; st = NFILES(&attrs)) {
		for (i = 2; i <= x68extN; i++){
		    if (!stricmp(&attrs.name[slen],x68ext[i])){
			ee = zexecve(buf,argv,1);
			if (ee == -1) return lastval;
#elif defined(__EMX__)
	if ( (ss = strrchr(bufSK, '/')) ){
	    slen = bufSK - ss + slen -1;
	}
	FindHandle = HDIR_SYSTEM;  FindCount = 1;
	st = DosFindFirst( file, &FindHandle, 0x27, (PVOID)&FindBuffer, sizeof(FindBuffer), &FindCount, FIL_STANDARD );
	if ( st == NO_ERROR ){
	    for (; st == NO_ERROR; FindCount = 1, st = DosFindNext( FindHandle, (PVOID)&FindBuffer,
								    sizeof(FindBuffer), &FindCount ) ) {
		for (i = 2; i <= x68extN; i++){
		    if ( !stricmp( &FindBuffer.achName[slen], x68ext[i] ) ){
			ee = zexecve(buf,argv);
#endif
			if (ee != ENOENT) eno = ee;
		    }
		}
	    }
#if defined(__EMX__)
	    DosFindClose( FindHandle );
#endif
	}
    }
#else
    for (pp = path; *pp; pp++)
	if ((*pp)[0] == '.' && !(*pp)[1]) {
	    ee = zexecve(arg0, argv);
	    if (ee != ENOENT)
		eno = ee;
	} else {
	    z = buf;
	    strucpy(&z, *pp);
	    *z++ = '/';
	    strcpy(z, arg0);
	    ee = zexecve(buf, argv);
	    if (ee != ENOENT)
		eno = ee;
	}
#endif
#ifdef __human68k__
    if (eno == -1) return lastval;
#endif
    if (eno)
	zerr("%e: %s", arg0, eno);
#if defined(__EMX__)
    else {
	const char* p = zgetenv( "LANG" );
	int japanese = p && toupper( p[0] ) == 'J';
	zerr(japanese ? "R}h܂̓t@CႢ܂: %s" : "command not found: %s", arg0, 0);
    }
#else
    else
	zerr("command not found: %s", arg0, 0);
#endif
#ifdef __human68k__
    return -1;
#endif
    _exit(1);
}

#if defined(__human68k__) || defined(__EMX__)
#define try(X) { 	if ( (x68k = iscom(X)) ){			\
			    strcpy(buf2, X);				\
			    strcat(buf2, x68ext[x68k]);			\
			    return ztrdup(buf2);			\
			}						\
		}
#else
#define try(X) { if (iscom(X)) return ztrdup(X); }
#endif

/* get the full pathname of an external command */

char *findcmd(arg0)		/**/
char *arg0;
{
    char **pp;
    char *z, *s, buf[MAXCMDLEN];
    Cmdnam cn;
#if defined(__human68k__) || defined(__EMX__)
    int i, x68k;
    char buf2[MAXPATHLEN];
#endif

    cn = (Cmdnam) gethnode(arg0, cmdnamtab);
#if defined(__human68k__) || defined(__EMX__)
    if (!cn) {
	for (i = 2; i <= x68extN; i++) {
	    strcpy(buf2,arg0);
	    strcat(buf2,x68ext[i]);
	    cn = (Cmdnam) gethnode(buf2,cmdnamtab);
	    if (cn)	break;
	}
    }
#endif
    if (!cn && isset(HASHCMDS))
	cn = hashcmd(arg0, path);
    if (cn && cn->flags & DISABLED)
	cn = NULL;
    if ((int)strlen(arg0) > MAXPATHLEN)
	return NULL;
    for (s = arg0; *s; s++)
#ifdef HAS_DRIVE
	if (*s == '/' || *s == ':') {
	    try(arg0);
	    if (arg0 == s || *s == ':' || unset(PATHDIRS)) {
		return NULL;
	    }
	    break;
	}
#else
    if (*s == '/') {
	try(arg0);
	if (arg0 == s || unset(PATHDIRS)) {
	    return NULL;
	}
	break;
    }
#endif
    if (cn && ISEXCMD(cn->flags)) {
	char nn[MAXPATHLEN];

	if (cn->flags & BUILTIN)
	    strcpy(nn, cn->u.cmd);
	else {
	    for (pp = path; pp < cn->u.name; pp++)
#ifdef HAS_DRIVE
		if (**pp != '/' && !(**pp && (*pp)[1] == ':' && (*pp)[2] == '/' )) {
#else
		if (**pp != '/') {
#endif
		    z = buf;
		    strucpy(&z, *pp);
#ifdef HAS_DRIVE
		    if (z == buf || (*(z-1) != '/'))
#endif
		    *z++ = '/';
		    strcpy(z, arg0);
		    try(buf);
		}
	    strcpy(nn, cn->u.name ? *(cn->u.name) : "");
	    strcat(nn, "/");
	    strcat(nn, cn->nam);
	}
	try(nn);
    }
    for (pp = path; *pp; pp++) {
	z = buf;
	strucpy(&z, *pp);
	*z++ = '/';
	strcpy(z, arg0);
	try(buf);
    }
    return NULL;
}

int iscom(s)			/**/
char *s;
{
#if defined(__human68k__) || defined(__EMX__)
    int i, st, slen, imin;
    char *file, *ss, *sr;
    char *buf;
#if defined(__human68k__)
    struct FILBUF attrs;
#endif
#if defined(__EMX__)
    HDIR FindHandle = HDIR_SYSTEM;
    ULONG FindCount = 1;
    FILEFINDBUF3 FindBuffer;
#else
    struct stat statbuf;
#endif

    if (strlen(s) >= 2 && !strcmp(&s[strlen(s)-2],"/.")) return 0;
    if (strlen(s) >= 3 && !strcmp(&s[strlen(s)-3],"/..")) return 0;
    buf = alloca(strlen(s)+1);
    strcpy(buf, s);
    strEtoSK(buf);
    s = buf;
    if (*s == '/' && isset(REFERSYSROOT) && (sr = zgetenv("SYSROOT")))
	s = sysroot(s);
#if defined(__human68k__)
    if (FILES(&attrs, s, 0x27) >= 0) return 1;	/*fBNg͂ */
#elif defined(__EMX__)
    if ( DosFindFirst( s, &FindHandle, 0x27, (PVOID)&FindBuffer,
		      sizeof(FindBuffer), &FindCount, FIL_STANDARD ) == NO_ERROR ) {
	DosFindClose( FindHandle );
	return 1;
    }
#endif
    file = (char *) alloca((slen = strlen(s))+5);
    strcpy(file, s);
    strcat(file, "*.*");
    imin = x68extN + 1;
#if defined(__human68k__)
    st = FILES(&attrs, file, 0x27);
    if (ss = strrchr(s, '/')){
	slen = s - ss + slen -1;
    }
    if (st >= 0){
	for (; st >= 0; st = NFILES(&attrs)) {
	    for (i = 2; i <= x68extN; i++){
		if (!stricmp(&attrs.name[slen],x68ext[i]) && i < imin) imin = i;
	    }
	}
#elif defined(__EMX__)
    FindHandle = HDIR_SYSTEM;  FindCount = 1;
    st = DosFindFirst( file, &FindHandle, 0x27, (PVOID)&FindBuffer, sizeof(FindBuffer), &FindCount, FIL_STANDARD );
    if ( (ss = strrchr(s, '/')) ){
	slen = s - ss + slen -1;
    }
    if ( st == NO_ERROR ){
	for (; st == NO_ERROR; FindCount = 1, st = DosFindNext( FindHandle, (PVOID)&FindBuffer,
								sizeof(FindBuffer), &FindCount ) ) {
	    for (i = 2; i <= x68extN; i++){
		if (!stricmp(&FindBuffer.achName[slen],x68ext[i]) && i < imin) imin = i;
	    }
	}
	DosFindClose( FindHandle );
#endif
    }
    return (imin == x68extN + 1) ? 0 : imin ;
#else
    return (access(s, X_OK) == 0 && stat(s, &statbuf) >= 0 &&
	    S_ISREG(statbuf.st_mode));
#endif
}

int isrelative(s)		/**/
char *s;
{
#ifdef HAS_DRIVE
    if (*s != '/' && !(*++s == ':' && *++s == '/'))
#else
    if (*s != '/')
#endif
	return 1;
    for (; *s; s++)
	if (*s == '.' && s[-1] == '/' &&
	    (s[1] == '/' || s[1] == '\0' ||
	     (s[1] == '.' && (s[2] == '/' || s[2] == '\0'))))
	    return 1;
    return 0;
}

Cmdnam hashcmd(arg0, pp)	/**/
char *arg0;
char **pp;
{
    char *s, buf[MAXPATHLEN];
    char **pq;
    Cmdnam cn;
#if defined(__human68k__) || defined(__EMX__)
    char buf2[MAXPATHLEN];
    int x68k = 1;
#else
    DIR *dir;
    struct dirent *de;
#endif

    for (; *pp; pp++)
#ifdef HAS_DRIVE
	if ((*pp && (*pp)[1] == ':' && (*pp)[2] == '/' )
		|| (**pp == '/' && isset(REFERSYSROOT) && zgetenv("SYSROOT"))) {
	    s = buf;
	    strucpy(&s, *pp);
	    if (s == buf || (*(s-1) != '/'))
		*s++ = '/';
	    *s++ = '/';
	    strcpy(s, arg0);
	    if ( (x68k = iscom(buf)) )
		break;
#else
	if (**pp == '/') {
	    s = buf;
	    strucpy(&s, *pp);
	    *s++ = '/';
	    strcpy(s, arg0);
	    if (iscom(buf))
		break;
#endif
	}
    if (!*pp || isrelative(*pp))
	return NULL;
    cn = (Cmdnam) zcalloc(sizeof *cn);
    cn->flags = EXCMD;
    cn->u.name = pp;
#if defined(__human68k__) || defined(__EMX__)
    strcpy(buf2, arg0);
    strcat(buf2, x68ext[x68k]);
    addhnode(ztrdup(buf2), cn, cmdnamtab, freecmdnam);
#else
    addhnode(ztrdup(arg0), cn, cmdnamtab, freecmdnam);
#endif
    if (unset(HASHDIRS))
	return cn;
    for (pq = pathchecked; pq <= pp; pq++) {
#if defined(__human68k__) || defined(__EMX__)
	int st;
	char bufpq[MAXPATHLEN], *s, *sr;
#if defined(__human68k__)
	struct FILBUF attrs;
#endif
#if defined(__EMX__)
	HDIR FindHandle = HDIR_SYSTEM;
	ULONG FindCount = 1;
	FILEFINDBUF3 FindBuffer;
#endif

	if (isrelative(*pq))
	    continue;
	strcpy(bufpq,*pq);
	strEtoSK(bufpq);
	s = bufpq;
	if (*s && s[strlen(s)-1] != '/')
		strcat(s, "/");
	strcat(s, "*.*");
	if (*s == '/' && isset(REFERSYSROOT) && (sr = zgetenv("SYSROOT")))
		s = sysroot(s);
#ifdef __human68k__
	st = FILES(&attrs, s, 0x27);
	for (; st >= 0; st = NFILES( &attrs )) {
	    if (strcmp(attrs.name, "..") && strcmp(attrs.name, "."))
		addhcmdnode(strtmpSKtoE(attrs.name), pq);
	}
#elif defined(__EMX__)
	st = DosFindFirst( s, &FindHandle, 0x27, (PVOID)&FindBuffer, sizeof(FindBuffer), &FindCount, FIL_STANDARD );
	for (; st == NO_ERROR; FindCount = 1, st = DosFindNext( FindHandle, (PVOID)&FindBuffer,
								sizeof(FindBuffer), &FindCount ) ) {
	    if ( strcmp( FindBuffer.achName, ".." ) && strcmp( FindBuffer.achName, "." ) )
		addhcmdnode( strtmpSKtoE( FindBuffer.achName ), pq );
	}
	DosFindClose( FindHandle );
#endif
#else
	if (isrelative(*pq) || !(dir = opendir(*pq)))
	    continue;
	readdir(dir);
	readdir(dir);
	while ((de = readdir(dir)))
	    addhcmdnode(de->d_name, pq);
	closedir(dir);
#endif
    }
    pathchecked = pp + 1;
    return cn;
}

void fullhash()
{				/**/
    char **pq;
#if !defined(__human68k__) && !defined(__EMX__)
    DIR *dir;
    struct dirent *de;
#endif

    for (pq = pathchecked; *pq; pq++) {
#if defined(__human68k__) || defined(__EMX__)
	int st;
	char bufpq[MAXPATHLEN], *s, *sr;
#if defined(__human68k__)
	struct FILBUF attrs;
#endif
#if defined(__EMX__)
	HDIR FindHandle = HDIR_SYSTEM;
	ULONG FindCount = 1;
	FILEFINDBUF3 FindBuffer;
#endif

	if (isrelative(*pq))
	    continue;
	strcpy(bufpq,*pq);
	strEtoSK(bufpq);
	s = bufpq;
	if (*s && s[strlen(s)-1] != '/')
		strcat(s, "/");
	strcat(s, "*.*");
	if (*s == '/' && isset(REFERSYSROOT) && (sr = zgetenv("SYSROOT")))
		s = sysroot(s);
#ifdef __human68k__
	st = FILES(&attrs, s, 0x27);
	for (; st >= 0; st = NFILES( &attrs )) {
	    if (strcmp(attrs.name, "..") && strcmp(attrs.name, "."))
		addhcmdnode(strtmpSKtoE(attrs.name), pq);
	}
#elif defined(__EMX__)
	st = DosFindFirst( s, &FindHandle, 0x27, (PVOID)&FindBuffer,
			  sizeof(FindBuffer), &FindCount, FIL_STANDARD );
	for (; st == NO_ERROR; FindCount = 1, st = DosFindNext( FindHandle, (PVOID)&FindBuffer,
								sizeof(FindBuffer), &FindCount ) ) {
	    if ( strcmp( FindBuffer.achName, "..") && strcmp( FindBuffer.achName, "." ) )
		addhcmdnode( strtmpSKtoE( FindBuffer.achName ), pq );
	}
	DosFindClose( FindHandle );
#endif
#else
	if (isrelative(*pq) || !(dir = opendir(*pq)))
	    continue;
	readdir(dir);
	readdir(dir);
	while ((de = readdir(dir)))
	    addhcmdnode(de->d_name, pq);
	closedir(dir);
#endif
    }
    pathchecked = pq;
}

void execlist(list)		/**/
List list;
{
    static int donetrap;

    if (breaks)
	return;
    if (!list || list == &dummy_list)
	return;
    donetrap = 0;
    simplifyright(list);
#if defined(__EMX__)
    settyinfo( &shttyinfo2 );			/* reset tty configuration */
#endif
    switch (list->type) {
    case SYNC:
    case ASYNC:
	execlist2(list->left, list->type, !list->right);
	if (sigtrapped[SIGDEBUG])
	    dotrap(SIGDEBUG);
	if (sourcelevel < 32768 && !donetrap) {
	    if (sigtrapped[SIGZERR] && lastval) {
		dotrap(SIGZERR);
		donetrap = 1;
	    }
	    if (lastval && isset(ERREXIT)) {
		if (sigtrapped[SIGEXIT])
		    dotrap(SIGEXIT);
		exit(lastval);
	    }
	}
	if (list->right && !retflag) {
	/* errflag = 0; */
	    execlist(list->right);
	}
	break;
    }
}

void execlist2(list, type, last1)	/**/
Sublist list;
int type;
int last1;
{
    if (!list)
	return;
    switch (list->type) {
    case END:
	execpline(list, type, last1);
	break;
    case ORNEXT:
	if (!execpline(list, SYNC, 0))
	    execlist2(list->right, type, last1);
	else
	    while ((list = list->right))
		if (list->type == ANDNEXT) {
		    execlist2(list->right, type, last1);
		    return;
		}
	break;
    case ANDNEXT:
	if (execpline(list, SYNC, 0))
	    execlist2(list->right, type, last1);
	else
	    while ((list = list->right))
		if (list->type == ORNEXT) {
		    execlist2(list->right, type, last1);
		    return;
		}
	break;
    }
}

int execpline(l, how, last1)	/**/
Sublist l;
int how;
int last1;
{
    int ipipe[2], opipe[2];
    int pj = thisjob, nj;
    if (!l)
	return 0;
    ipipe[0] = ipipe[1] = opipe[0] = opipe[1] = 0;
    blockchld();
    if ((thisjob = nj = getfreejob()) == -1)
	return 1;
    initjob();
    if (how == TIMED) {
	jobtab[thisjob].stat |= STAT_TIMED;
	how = SYNC;
    }
#if !defined(__human68k__)
    if (l->flags & PFLAG_COPROC) {
	how = ASYNC;
	if (coprocin >= 0) {
	    close(coprocin);
	    close(coprocout);
	}
	mpipe(ipipe);
	mpipe(opipe);
	coprocin = ipipe[0];
	coprocout = opipe[1];
    }
#endif
    if (!pline_level++) {
	list_pipe_job = nj;
	nowait = 0;
    }
    execpline2(l->left, how, opipe[0], ipipe[1], last1);
    pline_level--;
    if (how == ASYNC) {
	if (l->flags & PFLAG_COPROC)
	    close(ipipe[1]);
	spawnjob();
	unblockchld();
	return 1;
    } else {
	Job jn = jobtab + nj;

	if (nj == list_pipe_job && list_pipe_child)
	    _exit(0);

	thisjob = nj;

	if (list_pipe)
	    jn->stat |= STAT_NOPRINT;

	if (nowait) {
	    if(!pline_level) {
		struct process *pn, *qn;

		curjob = nj;
		addproc(list_pipe_pid, list_pipe_text);

		for (pn = jobtab[jn->other].procs; pn; pn = pn->next)
		    if (WIFSTOPPED(pn->statusp))
			break;

		if (pn) {
		    for (qn = jn->procs; qn->next; qn = qn->next);
		    qn->statusp = pn->statusp;
		}

		jn->stat &= ~(STAT_DONE | STAT_NOPRINT);
		jn->stat |= STAT_STOPPED | STAT_CHANGED;
		printjob(jn, !!isset(LONGLISTJOBS));
	    }
	    else
		deletejob(jn);
	}

	for (; !nowait;) {
	    if (list_pipe_child) {
		jn->stat |= STAT_NOPRINT;
		makerunning(jn);
	    }
	    waitjobs();

	    if (list_pipe_child &&
		jn->stat & STAT_DONE &&
		lastval2 & 0200)
		killpg(mypgrp, lastval2 & ~0200);
	    if ((list_pipe || exiting) && !list_pipe_child &&
		jn->stat & STAT_STOPPED) {
		int synch[2], pid;

		pipe(synch);

		if ((pid = fork()) == -1) {
		    trashzle();
		    close(synch[0]);
		    close(synch[1]);
		    putc('\n', stderr);
		    fprintf(stderr, "zsh: job can't be suspended\n");
		    fflush(stderr);
		    makerunning(jn);
#if !defined(__EMX__)
		    killjb(jn, SIGCONT);
#endif
		    thisjob = nj;
		}
		else if (pid) {
		    char dummy;

		    list_pipe_pid = pid;
		    nowait = errflag = 1;
		    breaks = loops;
		    close(synch[1]);
		    read(synch[0], &dummy, 1);
		    close(synch[0]);
		    jobtab[list_pipe_job].other = nj;
		    jobtab[list_pipe_job].stat |= STAT_SUPERJOB;
		    jn->stat |= STAT_SUBJOB | STAT_NOPRINT;
		    jn->other = pid;
#if !defined(__EMX__)
		    killpg(jobtab[list_pipe_job].gleader, SIGSTOP);
#endif
		    break;
		}
		else {
		    close(synch[0]);
		    entersubsh2(1, 0);
		    setpgrp(0L, mypgrp = jobtab[list_pipe_job].gleader);
		    close(synch[1]);
#if !defined(__EMX__)
		    kill(getpid(), SIGSTOP);
#endif
		    list_pipe = 0;
		    list_pipe_child = 1;
		    break;
		}
	    }
	    else if (subsh && jn->stat & STAT_STOPPED)
		thisjob = nj;
	    else
		break;
	}
	unblockchld();

	if (list_pipe && (lastval & 0200) && pj >= 0 &&
	    (!(jn->stat & STAT_INUSE) || (jn->stat & STAT_DONE))) {
	    jn = jobtab + pj;
	    jn->stat |= STAT_NOPRINT;
	    killjb(jobtab + pj, lastval & ~0200);
	}
	if (list_pipe_child)
	    deletejob(jn);
	thisjob = pj;

	if (l->flags & PFLAG_NOT)
	    lastval = !lastval;

#ifdef __human68k__
	return !(lastval & 0xff);
#else
	return !lastval;
#endif
    }
}

void execpline2(pline, how, input, output, last1)	/**/
Pline pline;
int how;
int input;
int output;
int last1;
{
    int pid;
    int pipes[2];
    int oldlineno = lineno;
#ifdef __human68k__
    unsigned char *pipefile;
#endif

    if (breaks)
	return;
    if (!pline)
	return;
    lineno = pline->left->lineno;
    if (pline_level == 1)
	strcpy(list_pipe_text, getjobtext((void_ptr) pline->left));
    if (pline->type == END) {
	execcmd(pline->left, input, output, how == ASYNC, last1);
	pline->left = NULL;
    } else {
	int old_list_pipe = list_pipe;

#ifdef __human68k__
	pipefile = mpipe(pipes);
	if (!pipefile){
	    fprintf(stderr,"zsh: e|t@CI[vł܂\n");
	    fflush(stderr);
	    return;
	}
#else
	mpipe(pipes);
#endif
#ifdef __human68k__
	execcmd(pline->left, input, pipes[1], how == ASYNC, 0);
#else
	if (pline->left->type >= CURSH && how == SYNC) {

	/* if we are doing "foo | bar" where foo is a current
				shell command, do foo in a subshell and do
				the rest of the pipeline in the current shell. */

	    int synch[2];

	    pipe(synch);
	    if (!(pid = fork())) {
		close(pipes[0]);
		close(synch[0]);
		entersubsh(how == ASYNC);
		close(synch[1]);
		exiting = 1;
		execcmd(pline->left, input, pipes[1], how == ASYNC, 0);
		_exit(lastval);
	    } else if (pid == -1) {
		close(synch[0]);
		close(synch[1]);
		zerr("fork failed: %e", NULL, errno);
	    } else {
		char dummy, *text = getjobtext((void_ptr) pline->left);

		addproc(pid, text);
		close(synch[1]);
		read(synch[0], &dummy, 1);
		close(synch[0]);
	    }
	} else {
	/* otherwise just do the pipeline normally. */
	    execcmd(pline->left, input, pipes[1], how == ASYNC, 0);
	}
#endif
	pline->left = NULL;
#ifndef __human68k__
	close(pipes[1]);
#endif
	if (pline->right) {
	/* if another execpline() is invoked because the command is a list it
	   must know that we're already in a pipeline */
#ifdef __human68k__
	    lseek(pipes[0], 0, SEEK_SET);	/*	saisho ni modoru */
#endif			
	    list_pipe = 1;
	    execpline2(pline->right, how, pipes[0], output, last1);
	    list_pipe = old_list_pipe;
	    close(pipes[0]);
#ifdef __human68k__
	    unlink(pipefile);
	    free(pipefile);
#endif

	}
    }

    lineno = oldlineno;
}

/* make the argv array */

char **makecline(list)		/**/
struct lklist *list;
{
    int ct = 0;
    Lknode node;
    char **argv, **ptr;

    if (isset(XTRACE)) {
	fprintf(stderr, "%s", (prompt4) ? prompt4 : "");
	for (node = firstnode(list); node; incnode(node), ct++);
	ptr = argv = 2 + (char **)ncalloc((ct + 4) * sizeof(char *));

	for (node = firstnode(list); node; incnode(node))
	    if (*(char *)getdata(node)) {
		*ptr++ = (char *)getdata(node);
		untokenize(getdata(node));
#ifdef SJIS
		strEtoSK(getdata(node));
#endif
		fputs(getdata(node), stderr);
		if (nextnode(node))
		    fputc(' ', stderr);
	    }
	*ptr = NULL;
	fputc('\n', stderr);
	fflush(stderr);
	return (argv);
    } else {
	for (node = firstnode(list); node; incnode(node), ct++);
	ptr = argv = 2 + (char **)ncalloc((ct + 4) * sizeof(char *));

	for (node = firstnode(list); node; incnode(node))
	    if (*(char *)getdata(node)) {
		*ptr++ = (char *)getdata(node);
		untokenize(getdata(node));
#ifdef SJIS
		strEtoSK(getdata(node));
#endif
	    }
	*ptr = NULL;
	return (argv);
    }
}

/* untokenize the command line and remove null arguments */

void fixcline(l)		/**/
Lklist l;
{
    Lknode node, next;

    for (node = firstnode(l); node; node = next) {
	next = nextnode(node);
	if (!*(char *)getdata(node))
	    uremnode(l, node);
	else
	    untokenize(getdata(node));
    }
}

void untokenize(s)		/**/
char *s;
{
    for (; *s; s++)
	if (itok(*s))
	    if (*s == Nularg)
		chuck(s--);
	    else
		*s = ztokens[*s - Pound];
}

/* nonzero if we shouldn't clobber a file */

int dontclob(f)			/**/
struct redir *f;
{
    struct stat buf;

    if (unset(NOCLOBBER) || f->type & 1)
	return 0;
    if (stat(f->name, &buf) == -1)
	return 1;
    return S_ISREG(buf.st_mode);
}

/* close an multio (success) */

void closemn(mfds, fd)		/**/
struct multio **mfds;
int fd;
{
    if (mfds[fd]) {
	if (mfds[fd]->ct > 1)
	    if (mfds[fd]->rflag == 0)
		catproc(mfds[fd]);
	    else
		teeproc(mfds[fd]);
	mfds[fd] = NULL;
    }
}

/* close all the mnodes (failure) */

void closemnodes(mfds)		/**/
struct multio **mfds;
{
    int t0, t1;

    for (t0 = 0; t0 != 10; t0++)
	if (mfds[t0]) {
	    for (t1 = 0; t1 != mfds[t0]->ct; t1++)
		close(mfds[t0]->fds[t1]);
	    mfds[t0] = NULL;
	}
}

/* add a fd to an multio */
/* an multio is a list of fds associated with a certain fd.
	thus if you do "foo >bar >ble", the multio for fd 1 will have
	two fds, the result of open("bar",...), and the result of
	open("ble",....). */

void addfd(forked, save, mfds, fd1, fd2, rflag)	/**/
int forked;
int *save;
struct multio **mfds;
int fd1;
int fd2;
int rflag;
{
    int pipes[2];

    if (!mfds[fd1]) {		/* starting a new multio */
	mfds[fd1] = (struct multio *)alloc(sizeof(struct multio));

	if (!forked && fd1 != fd2 && fd1 < 10)
	    save[fd1] = movefd(fd1);
	redup(fd2, fd1);
	mfds[fd1]->ct = 1;
	mfds[fd1]->fds[0] = fd1;
	mfds[fd1]->rflag = rflag;
    } else {
	if (mfds[fd1]->rflag != rflag) {
	    zerr("file mode mismatch on fd %d", NULL, fd1);
	    return;
	}
	if (mfds[fd1]->ct == 1) {	/* split the stream */
	    mfds[fd1]->fds[0] = movefd(fd1);
	    mfds[fd1]->fds[1] = movefd(fd2);
	    mpipe(pipes);
	    mfds[fd1]->pipe = pipes[1 - rflag];
	    redup(pipes[rflag], fd1);
	    mfds[fd1]->ct = 2;
	} else			/* add another fd to an already split stream */
	    mfds[fd1]->fds[mfds[fd1]->ct++] = movefd(fd2);
    }
}

void addvars(l, export)		/**/
Lklist l;
int export;
{
    struct varasg *v;
    Lklist vl;

    while (full(l)) {
	char **arr, **ptr;

	v = (struct varasg *)ugetnode(l);
	singsub(&v->name);
	if (errflag)
	    return;
	untokenize(v->name);
	if (v->type == PMFLAG_s) {
	    vl = newlist();
	    addnode(vl, v->str);
	} else
	    vl = v->arr;
	prefork(vl, v->type ? 3 : 013);
	if (errflag)
	    return;
	postfork(vl, v->type ? 1 : 011);
	if (errflag)
	    return;
	if (v->type == PMFLAG_s && (empty(vl) || !nextnode(firstnode(vl)))) {
	    Param pm;
	    char *val;

	    if (empty(vl))
		val = ztrdup("");
	    else {
		untokenize(peekfirst(vl));
		val = ztrdup(ugetnode(vl));
	    }
	    pm = setsparam(v->name, ztrdup(val));
	    if (errflag)
		return;
	    if (export && !(pm->flags & PMFLAG_x))
		addenv(v->name, val);
	    zsfree(val);
	    continue;
	}
	ptr = arr = (char **)zalloc(sizeof(char **) * (countnodes(vl) + 1));

	while (full(vl)) {
	    char *pp;

	    pp = (char *)ugetnode(vl);
	    if (*pp) {
		*ptr = ztrdup(pp);
		untokenize(*ptr++);
	    }
	}
	*ptr = NULL;
	setaparam(v->name, arr);
	if (errflag)
	    return;
    }
}

#ifdef __human68k__
char herefilename[MAXPATHLEN];
#endif

void execcmd(cmd, input, output, bkg, last1)	/**/
Cmd cmd;
int input;
int output;
int bkg;
int last1;
{
    int type;
    long pid;
    int save[10], t0;
    struct redir *fn;
    struct multio *mfds[10];
    int fil, forked = 0, iscursh, nullexec = 0, assign = 0;
    char *text, dummy;
    Cmdnam cn1 = NULL;
#ifdef __human68k__
    Lklist args;
    int savethisjob;
    char *useherestr;
#endif

    args = cmd->args;
    for (t0 = 0; t0 != 10; t0++) {
	save[t0] = -1;
	mfds[t0] = NULL;
    }
    if ((type = cmd->type) == SIMPLE && empty(args))
	if (full(cmd->redir))
	    if (cmd->flags & CFLAG_EXEC) {
		nullexec = 1;
	    } else if (!*nullcmd) {
		zerr("redirection with no command", NULL, 0);
		errflag = lastval = 1;
		return;
	    } else if (*readnullcmd &&
		       ((Redir) peekfirst(cmd->redir))->type == READ &&
		       !nextnode(firstnode(cmd->redir))) {
		addnode(args, dupstring(readnullcmd));
	    } else
		addnode(args, dupstring(nullcmd));
	else {
	    addvars(cmd->vars, 0);
	    if (errflag)
		lastval = 1;
	    return;
	}
    if (full(args) && *(char *)peekfirst(args) == '%') {
	insnode(args, (Lknode) args, dupstring((bkg) ? "bg" : "fg"));
	bkg = 0;
    }
#ifndef __human68k__
    if (isset(AUTORESUME) && !bkg && empty(cmd->redir) && full(args) &&
	!input && type == SIMPLE && !nextnode(firstnode(args))) {
	if (unset(NOTIFY))
	    scanjobs();
	if (findjobnam(peekfirst(args)) != -1)
	    pushnode(args, dupstring("fg"));
    }
#endif
    if (jobbing) {		/* get the text associated with this command */
	text = getjobtext((void_ptr) cmd);
    } else
	text = NULL;
    if (full(args) && !(cmd->flags & CFLAG_COMMAND) && type == SIMPLE) {
	char *cmdarg = (char *)peekfirst(args);
	Cmdnam cn2 = NULL;
	int builtin = 0;

	if (!strcmp(cmdarg, "builtin") && args->first->next &&
	    (cn2 = (Cmdnam) gethnode(cmdarg, cmdnamtab)) &&
	    (cn2->flags & BUILTIN) &&
	    !(cn2->flags & EXCMD)) {
	    builtin = 1;
	    cmdarg = (char *)args->first->next->dat;
	}
	cn1 = (Cmdnam) gethnode(cmdarg, cmdnamtab);
	if (cn1 && (cn1->flags & BUILTIN) && !(cn1->flags & EXCMD))
	    assign = istypeset(cn1, NULL);
	else if (builtin)
	    assign = istypeset(NULL, cmdarg);
	if (builtin)
	    cn1 = cn2;
    }
 /* do prefork substitutions */
    prefork(args, (((type == CCASE) ? 010 : 0)
		   | (assign ? 02 : isset(MAGICEQUALSUBST))));

    zsfree(underscore);
    if (full(args) && (underscore = ztrdup((char *) getdata(lastnode(args)))))
	untokenize(underscore); 
    else
  	underscore = ztrdup("");

 /* warn about "rm *" */
    if (unset(RMSTARSILENT) && interact && isset(SHINSTDIN) &&
	type == SIMPLE && full(args) && nextnode(firstnode(args)) &&
#ifdef __human68k__
	(!stricmp(peekfirst(args), "rm") || !stricmp(peekfirst(args), "rm.x")) &&
#elif defined(__EMX__)
	(!stricmp(peekfirst(args), "rm") || !stricmp(peekfirst(args), "rm.exe")) &&
#else
	!strcmp(peekfirst(args), "rm") &&
#endif
	!(cmd->flags & CFLAG_NOGLOB)) {
	Lknode node, next;

	for (node = nextnode(firstnode(args)); node && !errflag; node = next) {
	    char *s = (char *)getdata(node);
	    int l = strlen(s);

	    next = nextnode(node);
#ifdef HAS_DRIVE
	    if ((l == 3) && s[1] == ':' && s[2] == Star) {
		char tempbuf[MAXPATHLEN];
		int drive;
		drive = toupper(*s) - 'A' + 1;
#ifdef __human68k__
		if (CURDIR(drive, tempbuf+3) < 0) {
		    ;					
#elif defined(__EMX__)
		if ( _getcwd1( tempbuf+2, drive-1+'A' ) < 0) {
		    ;					
#endif
		} else {
		    convert_backslash_to_slash(tempbuf+3);
		    *tempbuf = toupper(*s);
		    *(tempbuf+1) = ':';
		    *(tempbuf+2) = '/';
		    s = tempbuf;
		    if (s[strlen(s)-1] != '/')
			strcat(s, "/ ");
		    else 
			strcat(s, " ");
		    l = strlen(s);
		    s[l-1] = Star;
		}
	    }
#endif
	    if (s[0] == Star && !s[1]) {
		if (!checkrmall(pwd))
		    uremnode(args, node);
#ifdef HAS_DRIVE
	    } else if (((l == 2) && *s == '/' && s[1] == Star) ||
		       ((l == 4) && !strncmp(s+1, ":/", 2) && s[3] == Star)) {
		s[l-1] = 0;
		if (!checkrmall(s)) uremnode(args,node);
		s[l-1] = Star;
#endif
	    } else if (l > 2 && s[l - 2] == '/' && s[l - 1] == Star) {
		char t = s[l - 2];

		s[l - 2] = 0;
		if (!checkrmall(s))
		    uremnode(args, node);
		s[l - 2] = t;
	    }
#if defined(__EMX__)
	    settyinfo( &shttyinfo2 );		/* reset tty configuration */
#endif
	}
	if (!nextnode(firstnode(args)))
	    errflag = 1;
    }
    if (errflag) {
	lastval = 1;
	return;
    }
    if (!cn1) {
	char *s, *t;

	if (full(args) && ((char *)peekfirst(args))[0] == Inbrack &&
	    ((char *)peekfirst(args))[1] == '\0')
	    ((char *)peekfirst(args))[0] = '[';
	if (type == SIMPLE && full(args) && !(cmd->flags & CFLAG_COMMAND)) {
	    cn1 = (Cmdnam) gethnode(t = s = (char *)peekfirst(args), cmdnamtab);
	    if (!cn1 && isset(HASHCMDS) && strcmp(t, "..")) {
		while (*t && *t != '/')
		    t++;
		if (!*t)
		    cn1 = hashcmd(s, pathchecked);
	    }
	}
	if (type == SIMPLE && !cn1 && isset(AUTOCD) && isset(SHINSTDIN) &&
	    full(args) && empty(cmd->redir) &&
	    !nextnode(firstnode(args)) && (s = cancd(peekfirst(args)))) {
	    peekfirst(args) = (void_ptr) s;
	    pushnode(args, dupstring("cd"));
	    cn1 = (Cmdnam) gethnode("cd", cmdnamtab);
	}
    }
/* this is nonzero if cmd is a current shell procedure */

    iscursh = (type >= CURSH) || (type == SIMPLE && cn1 &&
				  (cn1->flags & (BUILTIN | SHFUNC)) &&
				  !(cn1->flags & EXCMD));

/* if this command is backgrounded or (this is an external
		command and we are not exec'ing it) or this is a builtin
		with output piped somewhere, then fork.  If this is the
		last stage in a subshell pipeline, don't fork, but make
		the rest of the function think we forked. */

    if (bkg || !(iscursh || (cmd->flags & CFLAG_EXEC)) ||
	(cn1 && (cn1->flags & (BUILTIN | SHFUNC)) &&
	 !(cn1->flags & EXCMD) && output)) {
	int synch[2];

	blockchld();
#ifndef __human68k__
	pipe(synch);
	pid = (last1 && execok())? 0 : phork();
	if (pid == -1) {
	    close(synch[0]);
	    close(synch[1]);
	    return;
	}
	if (pid) {
	    close(synch[1]);
            read(synch[0], &dummy, 1);
	    close(synch[0]);
	    if (pid == -1)
		zerr("%e", NULL, errno);
	    else {
		if (bkg)
		    lastpid = pid;
		else if (!jobtab[thisjob].stty_in_env && full(cmd->vars))
		    while (full(cmd->vars))	/* search for STTY=... */
			if (!strcmp(((Varasg) ugetnode(cmd->vars))->name,
				    "STTY")) {
			    jobtab[thisjob].stty_in_env = 1;
			    break;
			}
		addproc(pid, text);
	    }
	    return;
	}
	close(synch[0]);
	entersubsh(bkg);
	close(synch[1]);
	forked = 1;
#endif

#ifdef __human68k__
/*	entersubsh(bkg);shellexitĂ܂ */
#endif
#ifndef __human68k__ /* onɂƈꕔbuiltinSIGINTȂ */
	if (sigtrapped[SIGINT] == 2)
	    holdintr();
#endif
    } else if ((cmd->flags & CFLAG_EXEC) && !nullexec)
	entersubsh(bkg);

#if !defined(__human68k__) && !defined(__EMX__)
    if (bkg && isset(BGNICE))
	nice(5);
#endif

#ifdef __human68k__
    useherestr = (char *) NULL;				/*  herestrgƃS~c邽 */
    savethisjob = thisjob;
#endif
/* perform postfork substitutions */
    postfork(args, !(cmd->flags & CFLAG_NOGLOB));
#ifdef __human68k__
    thisjob = savethisjob;
#endif
    if (errflag) {
	lastval = 1;
	goto err;
    } else {
	char *s;

	while (full(args) && (s = (char *)peekfirst(args)) && !*s)
	    ugetnode(args);
    }

    if (input)			/* add pipeline input/output to mnodes */
	addfd(forked, save, mfds, 0, input, 0);
    if (output)
	addfd(forked, save, mfds, 1, output, 1);
    spawnpipes(cmd->redir);	/* do process substitutions */
    while (full(cmd->redir))
	if ((fn = (struct redir *)ugetnode(cmd->redir))->type == INPIPE) {
	    if (fn->fd2 == -1) {
		fixfds(save);
		execerr();
	    }
	    addfd(forked, save, mfds, fn->fd1, fn->fd2, 0);
	} else if (fn->type == OUTPIPE) {
	    if (fn->fd2 == -1) {
		fixfds(save);
		execerr();
	    }
	    addfd(forked, save, mfds, fn->fd1, fn->fd2, 1);
	} else {
	    if (!(fn->type == HERESTR || fn->type == CLOSE || fn->type ==
		  MERGE || fn->type == MERGEOUT))
		if (xpandredir(fn, cmd->redir))
		    continue;
	    if (errflag) {
		fixfds(save);
		execerr();
	    }
	    if (fn->type == HERESTR) {
		fil = getherestr(fn);
		if (fil == -1) {
		    fixfds(save);
		    if (errno != EINTR)
			zerr("%e", NULL, errno);
		    execerr();
		}
#ifdef __human68k__
		useherestr = ztrdup(herefilename);
#endif
		addfd(forked, save, mfds, fn->fd1, fil, 0);
	    } else if (fn->type == READ) {
#ifdef __human68k__
		fil = open(strtmpEtoSK(fn->name), O_RDONLY);
#else
		fil = open(strtmpEtoSK(fn->name), O_RDONLY);
#endif
		if (fil == -1) {
		    fixfds(save);
		    if (errno != EINTR)
			zerr("%e: %s", fn->name, errno);
		    execerr();
		}
		addfd(forked, save, mfds, fn->fd1, fil, 0);
	    } else if (fn->type == CLOSE) {
		if (!forked && fn->fd1 < 10)
		    save[fn->fd1] = movefd(fn->fd1);
		closemn(mfds, fn->fd1);
		close(fn->fd1);
	    } else if (fn->type == MERGE || fn->type == MERGEOUT) {
		if (fn->fd2 == FD_COPROC)
		    fn->fd2 = (fn->type == MERGEOUT) ? coprocout : coprocin;
		closemn(mfds, fn->fd1);
		fil = dup(fn->fd2);
		if (fil == -1) {
		    char fdstr[4];

		    fixfds(save);
		    sprintf(fdstr, "%d", fn->fd2);
		    zerr("%s: %e", fdstr, errno);
		    execerr();
		}
		addfd(forked, save, mfds, fn->fd1, fil, fn->type == MERGEOUT);
	    } else {
#ifdef __human68k__
		char *fname;
		if (isset(DEVNULLTONUL) && !strcmp(fn->name, "/dev/null"))
			fname = ztrdup("nul");
		else
			fname = strdupEtoSK(fn->name);
		if (fn->type >= APP) {
			fil = open(fname,
				(isset(NOCLOBBER) && !(fn->type & 1)) ?
				O_WRONLY|O_APPEND : O_WRONLY|O_APPEND|O_CREAT,S_IREAD|S_IWRITE);
		} else {
		/* XC1libO_EXCLȂ*/
		    if (dontclob(fn)) {
			if (access(fname, R_OK)) {
			    fil = open(fname, O_WRONLY|O_CREAT|O_TRUNC,S_IREAD|S_IWRITE);
			} else {
			    fil = -1;
			    errno = EEXIST;
			}
		    } else {
			fil = open(fname, O_WRONLY|O_CREAT|O_TRUNC,S_IREAD|S_IWRITE);
		    }
		}
		free(fname);
#elif defined(__EMX__)
		char *fname;
		if (isset(DEVNULLTONUL) && !strcmp(fn->name, "/dev/null"))
			fname = ztrdup("nul");
		else
			fname = strdupEtoSK(fn->name);
		if (fn->type >= APP)
		    fil = open(fn->name,
			       (isset(NOCLOBBER) && !(fn->type & 1)) ?
			       O_WRONLY | O_APPEND : O_WRONLY | O_APPEND | O_CREAT, 0666);
		else
		    fil = open(fn->name, dontclob(fn) ?
			       O_WRONLY | O_CREAT | O_EXCL : O_WRONLY | O_CREAT | O_TRUNC, 0666);
		free(fname);
#else
		if (fn->type >= APP)
		    fil = open(fn->name,
			       (isset(NOCLOBBER) && !(fn->type & 1)) ?
			       O_WRONLY | O_APPEND : O_WRONLY | O_APPEND | O_CREAT, 0666);
		else
		    fil = open(fn->name, dontclob(fn) ?
			       O_WRONLY | O_CREAT | O_EXCL : O_WRONLY | O_CREAT | O_TRUNC, 0666);
#endif
		if (fil == -1) {
		    fixfds(save);
		    if (errno != EINTR)
			zerr("%e: %s", fn->name, errno);
		    execerr();
		}
		addfd(forked, save, mfds, fn->fd1, fil, 1);
	    }
	}

/* we are done with redirection.  close the mnodes, spawning
		tee/cat processes as necessary. */
    for (t0 = 0; t0 != 10; t0++)
	closemn(mfds, t0);

    if (nullexec) {
	for (t0 = 0; t0 != 10; t0++)
	    if (save[t0] != -1)
		close(save[t0]);
#ifdef __human68k__
        cleartmpfile(useherestr);
#endif
	return;
    }
    if (unset(NOEXEC))
	if (type >= CURSH) {
	    static int (*func[]) _((Cmd)) =
	    {
		execcursh, exectime, execfuncdef, execfor, execwhile,
		execrepeat, execif, execcase, execselect, execcond};

	    fixcline(args);
	    lastval = (func[type - CURSH]) (cmd);
	} else if (iscursh) {	/* builtin or shell function */
#ifdef __human68k__
	    Lklist oldoldlocallist;
#endif
	    if (!cn1) {
		lastval = 1;
#ifdef __human68k__
                cleartmpfile(useherestr);
#endif
		return;
	    }
	    
#ifdef __human68k__
	    if (1) {
#else
	    if (!forked) {
#endif
		Lknode n;
		Param pm;
		char *s;

		oldlocallist = locallist;
#ifdef __human68k__
		oldoldlocallist = oldlocallist;
#endif
		locallist = newlist();
		locallevel++;
		
		for (n = firstnode(cmd->vars); n; incnode(n)) {
		    addnode(locallist,
			    dupstring(s = ((struct varasg *) getdata(n))->name));
		    
		    pm = createparam(ztrdup(s), 0);
		    pm->level = locallevel;
		}
	    }
	    
	    if (cmd->vars) {
		addvars(cmd->vars, 0);
		if (errflag) {
		    lastval = 1;
#ifdef __human68k__
                    cleartmpfile(useherestr);
#endif
		    return;
		}
	    }
	    fixcline(args);
	    if (cn1->flags & SHFUNC)
		execshfunc(cmd, cn1);
	    else {
#ifndef __human68k__
		if (forked)
		    closem();
#endif
		lastval = execbin(args, cn1);
		if (isset(PRINTEXITVALUE) && isset(SHINSTDIN) &&
#ifdef __human68k__
		    lastval && thisjob == 1) {
#else
		    lastval && !subsh) {
#endif
		    fprintf(stderr, "zsh: exit %ld\n", (long)lastval);
		}
		fflush(stdout);
		if (save[1] == -1) {
		    if (ferror(stdout)) {
			zerr("write error: %e", NULL, errno);
			clearerr(stdout);
			errflag = 0;
		    }
		} else
		    clearerr(stdout);
	    }

#ifdef __human68k__
	    if (1) {
#else
	    if (!forked) {
#endif
		char *s;

		locallevel--;

		while ((s = (char *)ugetnode(locallist))) {
		    Param pm = (Param) gethnode(s, paramtab);

		    if (pm && pm->level > locallevel)
			unsetparam(s);
		}
#ifdef __human68k__
		oldlocallist = oldoldlocallist;
#endif
		locallist = oldlocallist;
	    }
		
	} else {
	    if (cmd->flags & CFLAG_EXEC)
		setiparam("SHLVL", --shlvl);
	    if (cmd->vars) {
		addvars(cmd->vars, 1);
		if (errflag) {
		    lastval = 1;
#ifdef __human68k__
                    cleartmpfile(useherestr);
#endif
		    return;
		}
	    }
	    if (type == SIMPLE) {
#ifdef __human68k__
		lastval = execute(cmd->flags & CFLAG_DASH, args);
		if (lastval >= 0) {
		    if (isset(PRINTEXITVALUE) && isset(SHINSTDIN) &&
		    	lastval && thisjob == 1) {
		    	fprintf(stderr, "zsh: exit %ld\n", (long)lastval);
		    }
		    fflush(stdout);
/*		    lastval = 0;*/
		} else {
/*		    lastval = 127 << 8;*/
		    lastval = 255;
		}
#else
		closem();
		execute(cmd->flags & CFLAG_DASH);
#endif
	    } else		/* ( ... ) */
#ifdef __human68k__
		{
		    list_pipe = 0;
		    saveetc(thisjob);
		    savethisjob = thisjob;
		    execlist(cmd->u.list);
		    thisjob = savethisjob;
		    restoreetc(thisjob);
		}
#else
		execlist(cmd->u.list);
#endif
	}
  err:
#ifndef __human68k__
    if (forked)
	_exit(lastval);
#endif
    fixfds(save);
#ifdef __human68k__
    cleartmpfile(useherestr);
#endif
}

#ifdef __human68k__
void cleartmpfile(s)		/**/
char *s;
{
    if (s) {
	free(s);
	unlink(s);
    }
}
#endif

/* restore fds after redirecting a builtin */

void fixfds(save)		/**/
int *save;
{
    int old_errno = errno;
    int t0;

    for (t0 = 0; t0 != 10; t0++)
	if (save[t0] != -1)
	    redup(save[t0], t0);
    errno = old_errno;
}

void entersubsh2(bkg, cl)		/**/
int bkg;
int cl;
{
    if (!jobbing) {
	if (bkg) {
#ifdef __human68k__
	    sigtrapped[SIGINT_] = 2;
#else
	    sigtrapped[SIGINT] = 2;
#endif
	    sig_ignore(SIGINT);
	    sigtrapped[SIGQUIT] = 2;
	    sig_ignore(SIGQUIT);
	    if (isatty(0)) {
		close(0);
		if (open("/dev/null", O_RDWR)) {
		    zerr("can't open /dev/null: %e", NULL, errno);
		    _exit(1);
		}
	    }
	}
    } else if (thisjob != -1 && cl) {
	if (list_pipe || list_pipe_child)
	    setpgrp(0L, jobtab[list_pipe_job].gleader);
	else if (!jobtab[thisjob].gleader) {
	    jobtab[thisjob].gleader = getpid();
	    if (list_pipe_job != thisjob &&
		!jobtab[list_pipe_job].gleader)
		jobtab[list_pipe_job].gleader = jobtab[thisjob].gleader;
	    setpgrp(0L, jobtab[thisjob].gleader);
	    if (!bkg)
		attachtty(jobtab[thisjob].gleader);
	} else
	    setpgrp(0L, jobtab[thisjob].gleader);
    }
    subsh = 1;
    if (SHTTY != -1) {
	close(SHTTY);
	SHTTY = -1;
    }
#if !defined(__human68k__) && !defined(__EMX__)
    if (jobbing) {
	sig_default(SIGTTOU);
	sig_default(SIGTTIN);
	sig_default(SIGTSTP);
	sig_default(SIGPIPE);
    }
#endif
    if (interact) {
	sig_default(SIGTERM);
#ifdef __human68k__
	if (sigtrapped[SIGINT_] != 2)
#else
	if (sigtrapped[SIGINT] != 2)
#endif
	    sig_default(SIGINT);
    }
    if (sigtrapped[SIGQUIT] != 2)
	sig_default(SIGQUIT);
    opts[MONITOR] = OPT_UNSET;
    opts[USEZLE] = OPT_UNSET;
    if (cl)
	clearjobtab();
}

void entersubsh(bkg)		/**/
int bkg;
{
#ifdef __human68k__
    entersubsh2(0, 1);
#else
    entersubsh2(bkg, 1);
#endif
}

/* close all internal shell fds */

void closem()
{				/**/
    int t0;

    for (t0 = 10; t0 != NOFILE; t0++)
	close(t0);
}

/* convert here document into a here string */

char *gethere(str, typ)		/**/
char *str;
int typ;
{
    char pbuf[256];
    int qt = 0, siz = 0, l, strip = 0;
    char *s, *t, *bptr;

    for (s = str; *s; s++)
	if (INULL(*s)) {
	    *s = Nularg;
	    qt = 1;
	}
    untokenize(str);
    if (typ == HEREDOCDASH) {
	strip = 1;
	while (*str == '\t')
	    str++;
    }
    t = ztrdup("");
    for (;;) {
	char *u, *v;

	if (!hgets(pbuf, sizeof(pbuf)))
	    break;
	bptr = pbuf;
	if (strip)
	    while (*bptr == '\t')
		bptr++;
	for (u = bptr, v = str; *u != '\n' && *v; u++, v++)
	    if (*u != *v)
		break;
	if (!(*u == '\n' && !*v)) {
	    l = strlen(bptr);
	    if (!qt && l > 1 && bptr[l - 1] == '\n' && bptr[l - 2] == '\\')
		bptr[l -= 2] = '\0';
	    t = realloc(t, siz + l + 1);
	    strncpy(t + siz, bptr, l);
	    siz += l;
	} else
	    break;
    }
    t[siz] = '\0';
    if (siz && t[siz - 1] == '\n')
	t[siz - 1] = '\0';
    if (!qt)
	for (s = t; *s; s++)
	    if (*s == '$') {
		*s = Qstring;
	    } else if (*s == '`') {
		*s = Qtick;
	    } else if (*s == '(') {
		*s = Inpar;
	    } else if (*s == ')') {
		*s = Outpar;
	    } else if (*s == '\\' &&
		       (s[1] == '$' || s[1] == '`'))
		chuck(s);
    s = dupstring(t);
    zsfree(t);
    return s;
}

/* open here string fd */

int getherestr(fn)		/**/
struct redir *fn;
{
    Lklist fake;
    char *s = gettemp(), *t;
    int fd;

    fake = newlist();
    addnode(fake, fn->name);
    prefork(fake, 010);
    if (!errflag)
	postfork(fake, 011);
    if (errflag)
	return -1;
#ifdef __human68k__
    if ((fd = open(s,O_CREAT|O_WRONLY,S_IWRITE)) == -1)
#else
    if ((fd = open(s, O_CREAT | O_WRONLY, 0600)) == -1)
#endif
	return -1;
    while ((t = (char *)ugetnode(fake))) {
	untokenize(t);
	write(fd, t, strlen(t));
	if (full(fake))
	    write(fd, " ", 1);
    }
    write(fd, "\n", 1);
    close(fd);
    fd = open(s, O_RDONLY);
#ifdef __human68k__
    strcpy(herefilename, s);
#else
    unlink(s);
#endif
    return fd;
}

void catproc(mn)		/**/
struct multio *mn;
{
    int len, t0;
    char *buf;

    if (phork()) {
	for (t0 = 0; t0 != mn->ct; t0++)
	    close(mn->fds[t0]);
	close(mn->pipe);
	return;
    }
    closeallelse(mn);
    buf = (char *)zalloc(4092);
    for (t0 = 0; t0 != mn->ct; t0++)
	while ((len = read(mn->fds[t0], buf, 4092)))
	    write(mn->pipe, buf, len);
    _exit(0);
}

void teeproc(mn)		/**/
struct multio *mn;
{
    int len, t0;
    char *buf;

    if (phork()) {
	for (t0 = 0; t0 != mn->ct; t0++)
	    close(mn->fds[t0]);
	close(mn->pipe);
	return;
    }
    buf = (char *)zalloc(4092);
    closeallelse(mn);
    while ((len = read(mn->pipe, buf, 4092)) > 0)
	for (t0 = 0; t0 != mn->ct; t0++)
	    write(mn->fds[t0], buf, len);
    _exit(0);
}

void closeallelse(mn)		/**/
struct multio *mn;
{
    int t0, t1;

    for (t0 = 0; t0 != NOFILE; t0++)
	if (mn->pipe != t0) {
	    for (t1 = 0; t1 != mn->ct; t1++)
		if (mn->fds[t1] == t0)
		    break;
	    if (t1 == mn->ct)
		close(t0);
	}
}

long int zstrtol(s, t, base)	/**/
char *s;
char **t;
int base;
{
    int ret = 0;

    if (base <= 10)
	for (; *s >= '0' && *s < ('0' + base); s++)
	    ret = ret * base + *s - '0';
    else
	for (; idigit(*s) || (*s >= 'a' && *s < ('a' + base - 10))
	     || (*s >= 'A' && *s < ('A' + base - 10)); s++)
	    ret = ret * base + (idigit(*s) ? (*s - '0') : (*s & 0x1f) + 9);
    if (t)
	*t = (char *)s;
    return ret;
}

/* $(...) */

Lklist getoutput(cmd, qt)	/**/
char *cmd;
int qt;
{
    List list;
    int pipes[2];
    int pid;
#ifdef __human68k__
    char *s;
    char bufbuf[256];
    int saveerrflag;
    int savethisjob;
    Lklist retval;
#endif

    if (*cmd == '<') {
	int stream;
	char *fi, *s, x;

	for (cmd++; *cmd == ' '; cmd++);
	for (s = cmd; *s && *s != ' '; s++)
	    if (*s == '\\')
		s++;
	    else if (*s == '$')
		*s = String;
	x = *s;
	*s = '\0';
	fi = dupstring(cmd);
	*s = x;
	if (*fi == '~')
	    *fi = Tilde;
	else if (*fi == '=')
	    *fi = Equals;
	singsub(&fi);
	if (errflag)
	    return NULL;
	stream = open(fi, O_RDONLY);
	if (stream == -1) {
	    zerr("%e: %s", fi, errno);
	    return NULL;
	}
#ifdef __human68k__
	return readoutput(stream,qt,s);
#else
	return readoutput(stream, qt);
#endif
    }
#ifdef __human68k__
    saveerrflag = errflag;
    if (!(list = parselstring(cmd))) {
	return NULL;
    }
    s = gettemp();
    pipes[0] = open(s, O_CREAT | O_RDWR | O_BINARY, S_IREAD | S_IWRITE);
    if (pipes[0] == -1)
	return NULL;
    pipes[1] = movefd(1);
    redup(pipes[0], 1);
    savethisjob = thisjob;
    execlist(list);
    thisjob = savethisjob;
    popheap();
    close(1);
/*  pipes[0] = movefd(1);*/
    redup(pipes[1], 1);
    pipes[0] = open(s, O_CREAT | O_RDONLY | O_TEXT, S_IREAD);
    retval = readoutput(pipes[0],qt,s);
    lastval = cmdoutval;
    cmdoutval = 0;
    errflag = saveerrflag;
    return retval;
#else
    if (!(list = parselstring(cmd)))
	return NULL;
    mpipe(pipes);
    blockchld();
    if ((cmdoutpid = pid = phork()) > 0) {
	Lklist retval;

	popheap();
	close(pipes[1]);
	retval = readoutput(pipes[0], qt);
	chldsuspend(0);		/* unblocks */
	lastval = cmdoutval;
	cmdoutval = 0;
	return retval;
    } else if (pid == -1) {
	popheap();
	close(pipes[0]);
	close(pipes[1]);
	errflag = 1;
	cmdoutpid = 0;
	unblockchld();
	return NULL;
    }
    unblockchld();
    subsh = 1;
    close(pipes[0]);
    redup(pipes[1], 1);
    entersubsh(0);
#if !defined(__EMX__)
    sig_ignore(SIGTSTP);
#endif
    exiting = 1;
    execlist(list);
    close(1);
    _exit(lastval);
    zerr("exit returned in child!!", NULL, 0);
    kill(getpid(), SIGKILL);
    return NULL;		/* redundant but shuts up Convex cc */
#endif
}

/* read output of command substitution */

#ifdef __human68k__
Lklist readoutput(in, qt, s)
int in;
int qt;
char *s;
{
#else
Lklist readoutput(in, qt)	/**/
int in;
int qt;
{
#endif
    Lklist ret;
    char *buf, *ptr;
    int bsiz, c, cnt = 0;
    FILE *fin;
#ifdef SJIS
    char *bufE;
#endif

#ifdef __human68k__
    fin = fdopen(in,"rt");
    if (fin == 0){
	fprintf(stderr, "fdopen error: %d", errno);
	fflush(stderr);
    }
#else
    fin = fdopen(in, "r");
#endif
    ret = newlist();
    ptr = buf = (char *)ncalloc(bsiz = 64);
    if (qt) {
	*ptr++ = Nularg;
	cnt++;
    }
    while ((c = fgetc(fin)) != EOF)
	if (!qt && isep(c)) {
	    if (cnt) {
		*ptr = '\0';
		if (isset(GLOBSUBST))
		    tokenize(buf);
#ifdef SJIS
		bufE = ncalloc(bsiz * 2);
		strcpySKtoE(bufE,buf);
		addnode(ret,bufE);
#else
		addnode(ret, buf);
#endif
		ptr = buf = (char *)ncalloc(bsiz = 64);
		cnt = 0;
	    }
	} else {
	    *ptr++ = c;
	    if (++cnt == bsiz) {
		char *pp = (char *)ncalloc(bsiz *= 2);

		memcpy(pp, buf, cnt);
		ptr = (buf = pp) + cnt;
	    }
	}
    if (ptr != buf && ptr[-1] == '\n')
	ptr[-1] = '\0';
    else
	*ptr = '\0';
    if (!qt && isset(GLOBSUBST))
	tokenize(buf);
#ifdef SJIS
    if (cnt) {
	bufE = ncalloc(bsiz * 2);
	if (qt) { /* Ȃ foo="login : `date`"``̍ŏ̕ */
	    *bufE = Nularg;
	    *(bufE + 1) = 0;
	    strcpySKtoE(bufE,buf+1);
	} else {
	    strcpySKtoE(bufE,buf);
	}
	addnode(ret,bufE);
    }
#else
    if (cnt)
	addnode(ret, buf);
#endif
    fclose(fin);
#ifdef __human68k__
    unlink(s);
#endif
    return ret;
}

/* =(...) */

char *getoutputfile(cmd)	/**/
char *cmd;
{
    int pid;
    char *nam = gettemp(), *str;
    List list;
#ifdef __human68k__
    int fd,savefd,savethisjob;
#endif

    if (thisjob == -1)
	return NULL;
    for (str = cmd; *str && *str != Outpar; str++);
    if (!*str)
	zerr("oops.", NULL, 0);
    *str = '\0';
    if (!(list = parselstring(cmd)))
	return NULL;
    permalloc();
    if (!jobtab[thisjob].filelist)
	jobtab[thisjob].filelist = newlist();
    addnode(jobtab[thisjob].filelist, ztrdup(nam));
    heapalloc();
    blockchld();
#ifdef __human68k__
    savefd = movefd(1);
/*	subsh = 1;*/
/*	entersubsh(0);*/
    fd = creat(nam,S_IREAD|S_IWRITE);
    if (fd == -1)
	return NULL;
    dup2(fd, 1);
/*	exiting = 1;*/
    savethisjob = thisjob;
    execlist(list);
    thisjob = savethisjob;
    close(fd);
    close(1);
    redup(savefd, 1);
    popheap();
    return nam;	
#else
    if ((pid = cmdoutpid = phork())) {
	popheap();
	if (pid < 0)
	    unblockchld();
	else {
	    int os = jobtab[thisjob].stat;
	    waitforpid(pid);
	    cmdoutval = 0;
	    jobtab[thisjob].stat = os;
	}
	return nam;
    }
    subsh = 1;
    close(1);
    entersubsh(0);
#if !defined(__EMX__)
    sig_ignore(SIGTSTP);
#endif
    (void)creat(nam, 0666);
    exiting = 1;
    execlist(list);
    close(1);
    _exit(lastval);
    zerr("exit returned in child!!", NULL, 0);
    kill(getpid(), SIGKILL);
    return NULL;		/* redundant but shuts up Convex cc */
#endif
}

/* get a temporary named pipe */

char *namedpipe()
{				/**/
#ifdef HAS_FIFOS
    char *tnam = gettemp();

    if (mknod(tnam, 0010666, 0) < 0)
	return NULL;
    return tnam;
#else
    return NULL;
#endif
}

/* <(...) */

char *getoutproc(cmd)		/**/
char *cmd;
{
#ifndef HAS_FIFOS
    zerr("doesn't look like your system supports FIFOs.", NULL, 0);
    return NULL;
#else
    List list;
    int fd;
    char *pnam, *str;

    if (thisjob == -1)
	return NULL;
    for (str = cmd; *str && *str != Outpar; str++);
    if (!*str)
	zerr("oops.", NULL, 0);
    *str = '\0';
    pnam = namedpipe();
    if (!pnam)
	return NULL;
    permalloc();
    if (!jobtab[thisjob].filelist)
	jobtab[thisjob].filelist = newlist();
    addnode(jobtab[thisjob].filelist, ztrdup(pnam));
    heapalloc();
    if (!(list = parselstring(cmd)))
	return NULL;
    if (phork()) {
	popheap();
	return pnam;
    }
    entersubsh(1);
    closem();
    fd = open(pnam, O_WRONLY);
    if (fd == -1) {
	zerr("can't open %s: %e", pnam, errno);
	_exit(1);
    }
    redup(fd, 1);
    fd = open("/dev/null", O_RDONLY);
    redup(fd, 0);
    exiting = 1;
    execlist(list);
    close(1);
    _exit(lastval);
    return NULL;
#endif
}

/* >(...) */

char *getinproc(cmd)		/**/
char *cmd;
{
#ifndef HAS_FIFOS
    zerr("doesn't look like your system supports FIFOs.", NULL, 0);
    return NULL;
#else
    List list;
    int pid, fd;
    char *pnam, *str;

    if (thisjob == -1)
	return NULL;
    for (str = cmd; *str && *str != Outpar; str++);
    if (!*str)
	zerr("oops.", NULL, 0);
    *str = '\0';
    pnam = namedpipe();
    if (!pnam)
	return NULL;
    permalloc();
    if (!jobtab[thisjob].filelist)
	jobtab[thisjob].filelist = newlist();
    addnode(jobtab[thisjob].filelist, ztrdup(pnam));
    heapalloc();
    if (!(list = parselstring(cmd)))
	return NULL;
    if ((pid = phork())) {
	popheap();
	return pnam;
    }
    entersubsh(1);
    closem();
    fd = open(pnam, O_RDONLY);
    redup(fd, 0);
    exiting = 1;
    execlist(list);
    _exit(lastval);
    return NULL;
#endif
}

/* > >(...) (does not use named pipes) */

int getinpipe(cmd)		/**/
char *cmd;
{
    List list;
    int pipes[2];
    char *str;

    for (str = cmd; *str && *str != Outpar; str++);
    if (!*str)
	zerr("oops.", NULL, 0);
    *str = '\0';
    if (!(list = parselstring(cmd + 2)))
	return -1;
    mpipe(pipes);
    if (phork()) {
	popheap();
	close(pipes[1]);
	return pipes[0];
    }
    close(pipes[0]);
    closem();
    entersubsh(1);
    redup(pipes[1], 1);
    exiting = 1;
    execlist(list);
    _exit(lastval);
    return 0;
}

/* < <(...) */

int getoutpipe(cmd)		/**/
char *cmd;
{
    List list;
    int pipes[2];
    char *str;

    for (str = cmd; *str && *str != Outpar; str++);
    if (!*str)
	zerr("oops.", NULL, 0);
    *str = '\0';
    if (!(list = parselstring(cmd + 2)))
	return -1;
    strinend();
    mpipe(pipes);
    if (phork()) {
	popheap();
	close(pipes[0]);
	return pipes[1];
    }
    close(pipes[1]);
    entersubsh(1);
    redup(pipes[0], 0);
    closem();
    exiting = 1;
    execlist(list);
    _exit(lastval);
    return 0;
}

/* run a list, saving the current job num */

void runlist(l)			/**/
List l;
{
    int cj = thisjob;

    execlist(l);
    thisjob = cj;
}

char *gettemp()
{				/**/
    return mktemp(dyncat((tmpprefix ? tmpprefix : DEFTMPPREFIX), "XXXXXX"));
}

/* my getwd */

char *zgetwd()
{				/**/
    static char buf0[MAXPATHLEN];
#ifdef HAS_DRIVE
#ifdef __human68k__
    int drive;
    int CURDRV();
    if (getcwd(&buf0[3], MAXPATHLEN - 3) == NULL || (drive = CURDRV()) < 0)
	return ztrdup(".");
    buf0[2] = '\\';
    buf0[1] = ':';
    buf0[0] = 'A' + drive;
    convert_backslash_to_slash (buf0);
    return strdupSKtoE(buf0);
#endif
#ifdef __EMX__
    if ( _getcwd2( buf0, MAXPATHLEN ) == NULL )
	return ztrdup(".");
    convert_backslash_to_slash (buf0);
    return strdupSKtoE(buf0);
#endif
    
#else
    char buf3[MAXPATHLEN];

#ifdef apollo
    char *buf2 = buf0 + 2;	/* changed +1 to +2  RBC 17.11.91 */

#else
    char *buf2 = buf0 + 1;

#endif
    struct stat sbuf;
    struct dirent *de;
    DIR *dir;
    ino_t ino, rootino = (ino_t) ~ 0;
    dev_t dev, rootdev = (dev_t) ~ 0;

    holdintr();
    buf2[0] = '\0';
    buf0[0] = '/';
#ifdef apollo
    buf0[1] = '/';		/* added RBC 17.11.91 */
#endif
    if (stat(buf0, &sbuf) >= 0) {
	rootino = sbuf.st_ino;
	rootdev = sbuf.st_dev;
    }
    for (;;) {
	if (stat(".", &sbuf) < 0) {
	    chdir(buf0);
	    noholdintr();
	    return ztrdup(".");
	}
	ino = sbuf.st_ino;
	dev = sbuf.st_dev;
	if (stat("..", &sbuf) < 0) {
	    chdir(buf0);
	    noholdintr();
	    return ztrdup(".");
	}
	if ((sbuf.st_ino == ino && sbuf.st_dev == dev) ||
	    (ino == rootino && dev == rootdev)) {
	    chdir(buf0);
	    noholdintr();
	    return ztrdup(buf0);
	}
	dir = opendir("..");
	if (!dir) {
	    chdir(buf0);
	    noholdintr();
	    return ztrdup(".");
	}
	chdir("..");
	readdir(dir);
	readdir(dir);
	while ((de = readdir(dir)))
	    if (de->d_ino == ino) {
		lstat(de->d_name, &sbuf);
		if (sbuf.st_dev == dev)
		    goto match;
	    }
	closedir(dir);
	dir = opendir(".");
	readdir(dir);
	readdir(dir);
	while ((de = readdir(dir))) {
	    lstat(de->d_name, &sbuf);
	    if (sbuf.st_dev == dev)
		goto match;
	}
	noholdintr();
	closedir(dir);
	return ztrdup(".");
      match:
	strcpy(buf3, de->d_name);
	if (*buf2)
	    strcat(buf3, "/");
	strcat(buf3, buf2);
	strcpy(buf2, buf3);
	closedir(dir);
    }
#endif
}

/* open pipes with fds >= 10 */

#ifdef __human68k__
unsigned char *mpipe(pp)
int *pp;
{
	unsigned char *s;
	pp[0] = open(s = gettemp(), O_CREAT | O_RDWR | O_BINARY, S_IREAD | S_IWRITE);
	if (pp[0] == -1)
		return NULL;
	pp[0] = movefd(pp[0]);
	pp[1] = dup(pp[0]);
	pp[1] = movefd(pp[1]);
	return ztrdup(s);
}
#else
void mpipe(pp)		/**/
int *pp;
{
    pipe(pp);
    pp[0] = movefd(pp[0]);
    pp[1] = movefd(pp[1]);
}
#endif

/* do process substitution with redirection */

void spawnpipes(l)		/**/
Lklist l;
{
    Lknode n = firstnode(l);
    Redir f;

    for (; n; incnode(n)) {
	f = (Redir) getdata(n);
	if (f->type == OUTPIPE) {
	    char *str = f->name;

	    f->fd2 = getoutpipe(str);
	}
	if (f->type == INPIPE) {
	    char *str = f->name;

	    f->fd2 = getinpipe(str);
	}
    }
}

/* perform time ... command */

int exectime(cmd)		/**/
Cmd cmd;
{
    int jb = thisjob;
#ifdef __human68k__
    static struct timeinfo ti;
    static struct timeval tv;
#define TIMEXMAX 100
    static struct timeinfo timesave[TIMEXMAX];
#endif

    if (!cmd->u.pline) {
	shelltime();
	return 0;
    }
#ifdef __human68k__
    if (timecount == 0) {
    	setup_for_time();
    } else { /* time time Ɩ\̂ł΍ */
        timesave[timecount].ut = time_User_count;
        timesave[timecount].st = time_System_count;
	
    }
    timecount++;
    if (timecount >= TIMEXMAX) {
	timecount--;
	return 0;
    }
#endif
    execpline(cmd->u.pline, TIMED, 0);
#ifdef __human68k__
    timecount--;
    if (timecount == 0) {
    	clearup_for_time();
    	ti.ut = time_User_count;
    	ti.st = time_System_count;
    } else {
	/*v~߂Ȃ*/
    	ti.ut = time_User_count - timesave[timecount].ut;
    	ti.st = time_System_count - timesave[timecount].st;
    }
    tv.tv_sec=(ti.ut+ti.st)/100;
    tv.tv_usec=((ti.ut+ti.st) % 100)*10000;
    printtime(&tv,&ti,(char *) NULL);
#endif
    thisjob = jb;
    return lastval;
}

/* define a function */

int execfuncdef(cmd)		/**/
Cmd cmd;
{
    Cmdnam cc;
    char *s;

    permalloc();
    while ((s = (char *)ugetnode(cmd->args))) {
	cc = (Cmdnam) zalloc(sizeof *cc);
	cc->flags = SHFUNC;
	if (!cmd->u.list)
	    cc->u.list = NULL;
	else
	    cc->u.list = (List) dupstruct(cmd->u.list);
	addhnode(ztrdup(s), cc, cmdnamtab, freecmdnam);
	if (!strncmp(s, "TRAP", 4)) {
	    int t0 = getsignum(s + 4);

	    if (t0 != -1) {
		settrap(t0, cmd->u.list);
		permalloc();
	    }
	}
    }
    heapalloc();
    return 0;
}

/* evaluate a [[ ... ]] */

int execcond(cmd)		/**/
Cmd cmd;
{
    return !evalcond(cmd->u.cond);
}

void execshfunc(cmd, cn)	/**/
Cmd cmd;
Cmdnam cn;
{
    List l;

    if (errflag)
	return;
    if (!list_pipe)
	deletejob(jobtab + thisjob);
    if (!cn->u.list) {
	char *nam;

	if (!(cn->flags & PMFLAG_u))
	    return;
	if (!(l = getfpfunc(nam = (char *)peekfirst(cmd->args)))) {
	    zerr("function not found: %s", nam, 0);
	    lastval = 1;
	    return;
	}
	cn->flags &= ~PMFLAG_u;
	permalloc();
	cn->u.list = (List) dupstruct(l);
	heapalloc();
	popheap();
    }
    doshfunc(cn->u.list, cmd->args, cn->flags);
}

void doshfuncnoval(list, doshargs, flags)	/**/
List list;
Lklist doshargs;
int flags;
{
    int val = lastval;

    doshfunc(list, doshargs, flags);
    lastval = val;
}

void doshfunc(list, doshargs, flags)	/**/
List list;
Lklist doshargs;
int flags;
{
    char **tab, **x, *oargv0;
    int oxtr = opts[XTRACE], opev = opts[PRINTEXITVALUE], xexittr;
    int oldzoptind;
    Lklist olist;
    char *s;
    List xexitfn;

    pushheap();
    xexittr = sigtrapped[SIGEXIT];
    xexitfn = sigfuncs[SIGEXIT];
    tab = pparams;
    oargv0 = argzero;
    oldzoptind = zoptind;
    zoptind = 1;
    if (flags & PMFLAG_t)
	opts[XTRACE] = OPT_SET;
    opts[PRINTEXITVALUE] = OPT_UNSET;
    if (doshargs) {
	pparams = x =
	    (char **)zcalloc(((sizeof *x) * (1 + countnodes(doshargs))));
	argzero = ztrdup(ugetnode(doshargs));
	while ((*x = (char *)ugetnode(doshargs)))
	    *x = ztrdup(*x), x++;
    } else {
	pparams = (char **)zcalloc(sizeof *pparams);
	argzero = ztrdup(argzero);
    }
    permalloc();
    olist = locallist;
    locallist = newlist();
    locallevel++;
    heapalloc();
    runlist(dupstruct(list));
    locallevel--;
    while ((s = (char *)getnode(locallist))) {
	Param pm = (Param) gethnode(s, paramtab);

	if (pm && pm->level > locallevel)
	    unsetparam(s);
	zsfree(s);
    }
    zfree(locallist, sizeof(struct lklist));

    locallist = olist;
    breaks = retflag = 0;
    freearray(pparams);
    zsfree(argzero);
    zoptind = oldzoptind;
    argzero = oargv0;
    pparams = tab;
    if (sigfuncs[SIGEXIT] && sigfuncs[SIGEXIT] != xexitfn) {
	dotrap(SIGEXIT);
	freestruct(sigfuncs[SIGEXIT]);
    }
    sigtrapped[SIGEXIT] = xexittr;
    sigfuncs[SIGEXIT] = xexitfn;
    opts[XTRACE] = oxtr;
    opts[PRINTEXITVALUE] = opev;
    popheap();
#if defined(__EMX__)
    setterm();
#endif
}

/* search fpath for an undefined function */

List getfpfunc(s)		/**/
char *s;
{
    char **pp = fpath, buf[MAXPATHLEN];
    int fd;

    for (; *pp; pp++) {
#ifdef __human68k__
	if ((*pp)[strlen(*pp) -1] == '/')
	    sprintf(buf,"%s%s",*pp,s);
	else
	    sprintf(buf,"%s/%s",*pp,s);
#else
	sprintf(buf, "%s/%s", *pp, s);
#endif
	if (!access(buf, R_OK) && (fd = open(buf, O_RDONLY)) != -1) {
	    int len = lseek(fd, 0, 2);

	    if (len == -1)
		close(fd);
	    else {
		char *d;
		List r;
#ifdef __human68k__
		int readlen;
#endif

		lseek(fd, 0, 0);
		d = (char *)zcalloc(len + 1);
#ifdef __human68k__
		if ((readlen = read(fd,d,len)) < 0) {
#else
		if (read(fd, d, len) != len) {
#endif
		    zfree(d, len + 1);
		    close(fd);
		} else {
#ifdef __human68k__
		    d[readlen] = 0;
#endif
		    close(fd);
		    r = parselstring(d);
		    zfree(d, len + 1);

		    return r;
		}
	    }
	}
    }
    return NULL;
}

/* check to see if AUTOCD applies here */

extern int doprintdir;

char *cancd(s)			/**/
char *s;
{
    int nocdpath = s[0] == '.' &&
    (s[1] == '/' || !s[1] || (s[1] == '.' && (s[2] == '/' || !s[1])));
    char *t;

    if (haswilds(s)) {
	Lklist l = newlist();
	int ne = noerrs;

	noerrs = 1;
	addnode(l, dupstring(s));
	postfork(l, 1);
	if (!errflag && full(l) && !nextnode(firstnode(l)))
	    s = peekfirst(l);
	errflag = 0;
	noerrs = ne;
    }

    if (*s != '/') {
	char sbuf[MAXPATHLEN], **cp;

	if (cancd2(s))
	    return s;
	if (access(s, X_OK) == 0)
	    return NULL;
	if (!nocdpath)
	    for (cp = cdpath; *cp; cp++) {
		sprintf(sbuf, "%s/%s", *cp, s);
		if (cancd2(sbuf)) {
		    doprintdir = -1;
		    return dupstring(sbuf);
		}

	}
	if ((t = cd_able_vars(s))) {
	    if (cancd2(t)) {
		doprintdir = -1;
		return t;
	    }
	}
	return NULL;
    }
    return cancd2(s) ? s : NULL;
}

int cancd2(s)			/**/
char *s;
{
    struct stat buf;

#if defined(__human68k__) || defined(__EMX__)
    return !(stat( s, &buf) || !S_ISDIR( buf.st_mode ));
#else
    return !(access(s, X_OK) || stat(s, &buf) || !S_ISDIR(buf.st_mode));
#endif
}
