#ifndef __ctypes_h__
#define __ctypes_h__
/*
 *	ctype.h : character type check macros.
 *
 *	Copyright(C) 1989 MUKAWA,Susumu mukawa@tn-sec.ntt.junet
 *
 *		at Tue May 16 22:03:00 JST 1989
 *
 *	Little modified for zsh x680?0 by ono@tamaru.kuee.kyoto-u.ac.jp
 *
 *		at Wed Jun 9  2:38:00 JST 1993
 */

typedef	unsigned char	_UCHAR;
typedef	unsigned int	_UINT;

/*	ank character type definition values.
 */
#ifdef KCGLOBAL
_UCHAR	_cType[] = {
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,		/* 00 */
	0x20, 0x28, 0x28, 0x28, 0x28, 0x28, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,		/* 10 */
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x48, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,		/* 20 */
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84,		/* 30 */
	0x84, 0x84, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x01,		/* 40 */
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,		/* 50 */
	0x01, 0x01, 0x01, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x10, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x02,		/* 60 */
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,		/* 70 */
	0x02, 0x02, 0x02, 0x10, 0x10, 0x10, 0x10, 0x20,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,		/* 80 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,		/* 90 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,		/* a0 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,		/* b0 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,		/* c0 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,		/* d0 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,		/* e0 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,		/* f0 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

/*	kanji character(Shift-JIS) type definition values.
 */
_UCHAR	_SjcType[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,		/* 00 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,		/* 10 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,		/* 20 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,		/* 30 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,		/* 40 */
	0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
	0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,		/* 50 */
	0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
	0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,		/* 60 */
	0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
	0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,		/* 70 */
	0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00,
	0x08, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,		/* 80 */
	0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
	0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,		/* 90 */
	0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
	0x08, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x09, 0x09,		/* a0 */
	0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09,
	0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09,		/* b0 */
	0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09,
	0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09,		/* c0 */
	0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09,
	0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09,		/* d0 */
	0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09,
	0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,		/* e0 */
	0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
	0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,		/* f0 */
	0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00
};

/*	kanji character(EUC) type definition values.
 */
_UCHAR	_EjcType[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,		/* 00 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,		/* 10 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,		/* 20 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,		/* 30 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,		/* 40 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,		/* 50 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,		/* 60 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,		/* 70 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,		/* 80 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,*/
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,		/* 90 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*	0x00, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d,*/	/* a0 */
	0x02, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d,		/* a0 */
	0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d,
	0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d,		/* b0 */
	0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d,
	0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d,		/* c0 */
	0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d,
	0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d,		/* d0 */
	0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d,
	0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,		/* e0 */
	0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
	0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,		/* f0 */
	0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x00
};

/*	set bit masks for check character types.
 */
#else
_UCHAR	_cType[];
_UCHAR	_SjcType[];
_UCHAR	_EjcType[];
#endif
#define _UP	(1 << 0)	/* upper case letter	*/
#define _LOW	(1 << 1)	/* lower case letter	*/
#define _DIG	(1 << 2)	/* digit(0-9)		*/
#define _SPC	(1 << 3)	/* TAB, CR, LF,	VT, FF	*/
#define _PNC	(1 << 4)	/* punctual character	*/
#define _CTR	(1 << 5)	/* control character	*/
#define _BLK	(1 << 6)	/* space character	*/
#define _HEX	(1 << 7)	/* hexadecimal digit	*/

/*	the macro definitions of the functions.
 */
/*
#define isalpha(c)	(_cType[(_UCHAR)(c)]&(_UP|_LOW))
#define isupper(c)	(_cType[(_UCHAR)(c)]&_UP)
#define islower(c)	(_cType[(_UCHAR)(c)]&_LOW)
#define isdigit(c)	(_cType[(_UCHAR)(c)]&_DIG)
#define isxdigit(c)	(_cType[(_UCHAR)(c)]&_HEX)
#define isspace(c)	(_cType[(_UCHAR)(c)]&_SPC)
#define ispunct(c)	(_cType[(_UCHAR)(c)]&_PNC)
#define isalnum(c)	(_cType[(_UCHAR)(c)]&(_UP|_LOW|_DIG))
#define isprint(c)	(_cType[(_UCHAR)(c)]&(_BLK|_PNC|_UP|_LOW|_DIG))
#define isgraph(c)	(_cType[(_UCHAR)(c)]&(_PNC|_UP|_LOW|_DIG))
#define iscntrl(c)	(_cType[(_UCHAR)(c)]&_CTR)
#define isascii(c)	((_UINT)(c) < 0x80 )

#define _tolower(c)	((_UCHAR)(c)-'A'+'a')
#define _toupper(c)	((_UCHAR)(c)-'a'+'A')

#define toupper(c)	((islower(c)) ? _toupper(c) : (c))
#define tolower(c)	((isupper(c)) ? _tolower(c) : (c))
#define toascii(c)	((c) & 0x7f )
*/
#define	_KANA	(1 << 0)	/* Kana moji			*/
#define	_KANAP	(1 << 1)	/* Kana punctual		*/
#define	_KANAS	(1 << 1)	/* Kana 1'st byte for only EUC	*/
#define	_K1	(1 << 2)	/* Kanji first byte		*/
#define	_K2	(1 << 3)	/* Kanji second byte		*/

/* Shift-JIS kana code. */
#define	iskana(c)	(_SjcType[(_UCHAR)(c)]&(_KANA|_KANAP))
#define	iskpun(c)	(_SjcType[(_UCHAR)(c)]&_KANAP)
#define	iskmoji(c)	(_SjcType[(_UCHAR)(c)]&_KANA)

#define	isalkana(c)	(isalpha(c)||iskmoji(c))
#define	ispnkana(c)	(ispunct(c)||iskpun(c))
#define	isalnmkana(c)	(isalnum(c)||iskmoji(c))
#define	isprkana(c)	(isprint(c)||iskana(c))
#define	isgrkana(c)	(isgraph(c)||iskana(c))

/* EUC kana code. */
#define isEkana1(c)	(_EjcType[(_UCHAR)(c)]&_KANAS)
#define isEkana2(c)	(_EjcType[(_UCHAR)(c)]&_KANA)

/* Shift-JIS kanji code. */
#define	isSkanji(c)	(_SjcType[(_UCHAR)(c)]&_K1)
#define	isSkanji2(c)	(_SjcType[(_UCHAR)(c)]&_K2)

/* EUC kanji code. */
#define	isEkanji(c)	(_EjcType[(_UCHAR)(c)]&_K1)
#define	isEkanji2(c)	(_EjcType[(_UCHAR)(c)]&_K2)
#endif
